# Recurrent-Depth-PDE

A deep learning framework for modeling and solving partial differential equations (PDEs) using neural networks with a focus on recurrent architectures.

## Overview

This project provides tools for training neural networks that can predict the evolution of physical systems over time. It's particularly focused on challenging PDE systems like Burgers' equation and the Kuramoto-Sivashinsky equation.

Key features:
- Train various neural network architectures (ResNet, UNet, FNO) on time-series data
- Apply recurrent processing to improve prediction accuracy and stability
- Evaluate models using comprehensive metrics specific to PDE solutions
- Configure experiments through a flexible YAML-based system
- Track and visualize results using Weights & Biases integration

## Installation

```bash
# Clone the repository
git clone https://github.com/Hrrsmjd/recurrent-depth-pde.git
cd recurrent-depth-pde

# Create and activate conda environment
conda create --name recurrent-depth-pde python=3.10
conda activate recurrent-depth-pde

# Install dependencies
pip install -r requirements.txt
```

## Usage

### Training Models

To train a standard ResNet model:
```bash
python main.py --config=configs/base_config.yaml --set device=0 --set model.name=ResNet
```

To train a Recurrent-Depth ResNet model and override configuration parameters:
```bash
python main.py --config=configs/base_config.yaml --set device=0 --set model.name=RecurrentModel --set model.params.recurrent_k_distribution.k_bar=8.0 --set epochs=200
```

### Evaluating Models

Model evaluation happens during training, with metrics automatically logged to Weights & Biases (WandB). The evaluation process includes:

- Validation loss during training
- Trajectory prediction metrics (loss and correlation over time)
- Visualization of prediction quality

These metrics help assess how well the model performs on the validation dataset and how its predictions evolve over time.

## Project Structure

```
recurrent-depth-pde/
├── configs/                 # Configuration files for experiments
│   ├── base_config.yaml     # Base configuration with default parameters
│   └── experiments/         # Experiment-specific configurations
├── models/                  # Neural network models and components
│   ├── architectures/       # Model architectures (UNet, ResNet, FNO)
│   ├── components/          # Neural network building blocks
│   └── wrappers/            # Model wrappers (e.g., RecurrentModel)
├── trainer/                 # Training and evaluation utilities
├── utils/                   # General utilities
└── main.py                  # Main training script
```

## License

This code is private. Please do not publish or share this code.
