import torch.nn as nn

from . import register_component

@register_component("Identity")
class IdentityLayer(nn.Identity):
    """
    Identity layer.

    Args:
        dimension: Dimension for convolution operations (1, 2, or 3)
        **kwargs: Additional keyword arguments
    """
    def __init__(
            self,
            dimension: int = 1,
            **kwargs
    ):
        super().__init__()
        self.dimension = dimension
        self.kwargs = kwargs