from .utils import get_activation

_COMPONENT_REGISTRY = {}

def register_component(name: str):
    def decorator(cls):
        _COMPONENT_REGISTRY[name] = cls
        return cls
    return decorator

def get_component(name: str):
    return _COMPONENT_REGISTRY[name]

# Import all wrapper modules automatically
import os
import importlib
import pkgutil

# Automatically import all modules in this directory
for _, module_name, _ in pkgutil.iter_modules([os.path.dirname(__file__)]):
    if module_name != "__init__":  # Skip __init__.py
        importlib.import_module(f".{module_name}", package=__name__)

__all__ = [
    'get_activation',
    'get_component',
]