## Set up environment
For convenience, [Dockerfile](Docker/Dockerfile) is provided under `Docker`. 
You can use as follows:
```bash
# Build docker image
docker build -t [image tag] --build-arg USER_ID=$(id -u) --build-arg GROUP_ID=$(id -g) .

# Run docker container
docker run --gpus all -it --rm --ipc=host --ulimit memlock=-1 --ulimit stack=67108864 -v [path to the top of this git repo]:/sipbench -v [path to data]:/data [image tag]
```
Breakdown of the `docker run` command:
- `--gpus all -it --rm`: With all GPUs enabled, run an interactive session, and automatically remove the container when it exits.
- `--ipc=host --ulimit memlock=-1 --ulimit stack=67108864`: Flags recommended by NVIDIA. Unlock the resource constraint.
- `-v [path to the top of this repo]:/sipbench -v [path to data]:/data`: Mount the current dir to `/sipbench`. Mount the data directory to `/data`.

## Pretrain

```bash
accelerate launch --multi_gpu train.py -cn [specify config_name]
```

## Inference


By default, `configs/config.yaml` will be loaded for inference. You can override the config value by
```bash
python3 main.py problem=[inverse problem config name] algorithm=[algorithm config name] pretrain=[pretrained model config name]
```
You can also specify the main config file with `-cn` flag. 
```bash
python3 main.py -cn [specify config_name]
```

The structure of the inference config is explained below. 
| Key       | Description                                                       |
|-----------|----------------------------------------------------------------------------------|
| problem   | string, config name for inverse problem                                          |
| algorithm | string, config name for algorithm                                                |
| pretrain  | string, config name for pretrained model (optional if loading from .pkl)         |
| tf32      | True or False, enable TF32 mode for improved speed on Ampere generation and later|


## Pretrained models

| Problem | Training set| Pretrained diffusion model| Training config |
|---------|-------------|---------------------------| ------------- |
| Full waveform inversion| [fwi-train](https://inversebench.s3.us-east-2.amazonaws.com/fwi-train.zip) | [fwi-5m.pt](https://inversebench.s3.us-east-2.amazonaws.com/fwi-5m.pt) | [fwi](configs/pretrain/fwi.yaml)|
| Inverse Scattering| [inv-scatter-train](https://inversebench.s3.us-east-2.amazonaws.com/inv-scatter-train.zip) | [in-scatter-5m.pt](https://inversebench.s3.us-east-2.amazonaws.com/in-scatter-5m.pt) | [inv-scatter](configs/pretrain/inv-scatter.yaml)|
| 2D Navier-Stokes | [navier-stokes-train](https://inversebench.s3.us-east-2.amazonaws.com/navier-stokes-train.zip) | [ns-5m.pt](https://inversebench.s3.us-east-2.amazonaws.com/ns-5m.pt)| [Navier-Stokes](configs/pretrain/navier-stokes.yaml) |
| Black hole | Private | [blackhole.pt](https://inversebench.s3.us-east-2.amazonaws.com/bh-5m.pt) | [blackhole](configs/pretrain/blackhole.yaml)|
|MRI | [mri-train](https://inversebench.s3.us-east-2.amazonaws.com/mri.zip) | [mri.pt](https://inversebench.s3.us-east-2.amazonaws.com/mri-checkpoints.zip) | [mri](configs/pretrain/mri-knee-mvue.yaml) |



## Running Hyperparameter Sweeps with wandb

To run hyperparameter sweeps using Wandb, follow these steps:

1. Ensure you have [wandb](https://wandb.ai/site) installed. Run `wandb login` in the command line and follow the prompts to authenticate

2. Navigate to the `configs/sweep` directory, where you'll define sweep configuration files. These files define the hyperparameters to be tuned and their ranges for each specific problem and algorithm combination. See  `configs/sweep/inv-scatter/dps.yaml` for a concrete example.  
   
3. To start a sweep, use the following command:

   ```bash
   wandb sweep configs/sweep/[problem]/[algorithm].yaml
   ```

   For example, 

   ```bash
   wandb sweep configs/sweep/inv-scatter/dps.yaml
   ```

4. Wandb will generate a sweep ID in the form of `[your-entity]/[your-project]/[sweep-id]`. Use this ID to start sweep agents:

   ```bash
   wandb agent [your-entity]/[your-project]/[sweep-id] --count 10
   ```
   You can add count flag to set the maximum number of runs to try. 

5. You can start multiple agents to run the sweep in parallel by opening new terminals and running the same command `wandb agent [your-entity]/[your-project]/[sweep-id] --count 10`.
