COCO_PANOPTIC_CLASSES = ['person', 'bicycle', 'car', 'motorcycle', 'airplane', 'bus', 'train', 'truck', 'boat', 'traffic light', 'fire hydrant', 'stop sign', 'parking meter', 'bench', 'bird', 'cat', 'dog', 'horse', 'sheep', 'cow', 'elephant', 'bear', 'zebra', 'giraffe', 'backpack', 'umbrella', 'handbag', 'tie', 'suitcase', 'frisbee', 'skis', 'snowboard', 'sports ball', 'kite', 'baseball bat', 'baseball glove', 'skateboard', 'surfboard', 'tennis racket', 'bottle', 'wine glass', 'cup', 'fork', 'knife', 'spoon', 'bowl', 'banana', 'apple', 'sandwich', 'orange', 'broccoli', 'carrot', 'hot dog', 'pizza', 'donut', 'cake', 'chair', 'couch', 'potted plant', 'bed', 'dining table', 'toilet', 'tv', 'laptop', 'mouse', 'remote', 'keyboard', 'cell phone', 'microwave', 'oven', 'toaster', 'sink', 'refrigerator', 'book', 'clock', 'vase', 'scissors', 'teddy bear', 'hair drier', 'toothbrush', 'banner', 'blanket', 'bridge', 'cardboard', 'counter', 'curtain', 'door-stuff', 'floor-wood', 'flower', 'fruit', 'gravel', 'house', 'light', 'mirror-stuff', 'net', 'pillow', 'platform', 'playingfield', 'railroad', 'river', 'road', 'roof', 'sand', 'sea', 'shelf', 'snow', 'stairs', 'tent', 'towel', 'wall-brick', 'wall-stone', 'wall-tile', 'wall-wood', 'water-other', 'window-blind', 'window-other', 'tree-merged', 'fence-merged', 'ceiling-merged', 'sky-other-merged', 'cabinet-merged', 'table-merged', 'floor-other-merged', 'pavement-merged', 'mountain-merged', 'grass-merged', 'dirt-merged', 'paper-merged', 'food-other-merged', 'building-other-merged', 'rock-merged', 'wall-other-merged', 'rug-merged']

ADE_PANOPTIC_CLASSES = ['wall', 'building', 'sky', 'floor', 'tree', 'ceiling', 'road', 'bed', 'window', 'grass', 'cabinet', 'sidewalk', 'person', 'earth', 'door', 'table', 'mountain', 'plant', 'curtain', 'chair', 'car', 'water', 'painting', 'sofa', 'shelf', 'house', 'sea', 'mirror', 'rug', 'field', 'armchair', 'seat', 'fence', 'desk', 'rock', 'wardrobe', 'lamp', 'tub', 'rail', 'cushion', 'base', 'box', 'column', 'signboard', 'chest of drawers', 'counter', 'sand', 'sink', 'skyscraper', 'fireplace', 'refrigerator', 'grandstand', 'path', 'stairs', 'runway', 'case', 'pool table', 'pillow', 'screen door', 'stairway', 'river', 'bridge', 'bookcase', 'blind', 'coffee table', 'toilet', 'flower', 'book', 'hill', 'bench', 'countertop', 'stove', 'palm', 'kitchen island', 'computer', 'swivel chair', 'boat', 'bar', 'arcade machine', 'hovel', 'bus', 'towel', 'light', 'truck', 'tower', 'chandelier', 'awning', 'street lamp', 'booth', 'tv', 'airplane', 'dirt track', 'clothes', 'pole', 'land', 'bannister', 'escalator', 'ottoman', 'bottle', 'buffet', 'poster', 'stage', 'van', 'ship', 'fountain', 'conveyer belt', 'canopy', 'washer', 'plaything', 'pool', 'stool', 'barrel', 'basket', 'falls', 'tent', 'bag', 'minibike', 'cradle', 'oven', 'ball', 'food', 'step', 'tank', 'trade name', 'microwave', 'pot', 'animal', 'bicycle', 'lake', 'dishwasher', 'screen', 'blanket', 'sculpture', 'hood', 'sconce', 'vase', 'traffic light', 'tray', 'trash can', 'fan', 'pier', 'crt screen', 'plate', 'monitor', 'bulletin board', 'shower', 'radiator', 'glass', 'clock', 'flag']

ADE20K_847 = ['wall', 'building', 'sky', 'tree', 'road', 'floor', 'ceiling', 'bed', 'sidewalk', 'earth', 'cabinet', 'person', 'grass', 'windowpane', 'car', 'mountain', 'plant', 'table', 'chair', 'curtain', 'door', 'sofa', 'sea', 'painting', 'water', 'mirror', 'house', 'rug', 'shelf', 'armchair', 'fence', 'field', 'lamp', 'rock', 'seat', 'river', 'desk', 'bathtub', 'railing', 'signboard', 'cushion', 'path', 'work surface', 'stairs', 'column', 'sink', 'wardrobe', 'snow', 'refrigerator', 'base', 'bridge', 'blind', 'runway', 'cliff', 'sand', 'fireplace', 'pillow', 'screen door', 'toilet', 'skyscraper', 'grandstand', 'box', 'pool table', 'palm', 'double door', 'coffee table', 'counter', 'countertop', 'chest of drawers', 'kitchen island', 'boat', 'waterfall', 'stove', 'flower', 'bookcase', 'controls', 'book', 'stairway', 'streetlight', 'computer', 'bus', 'swivel chair', 'light', 'bench', 'case', 'towel', 'fountain', 'embankment', 'television receiver', 'van', 'hill', 'awning', 'poster', 'truck', 'airplane', 'pole', 'tower', 'court', 'ball', 'aircraft carrier', 'buffet', 'hovel', 'apparel', 'minibike', 'animal', 'chandelier', 'step', 'booth', 'bicycle', 'doorframe', 'sconce', 'pond', 'trade name', 'bannister', 'bag', 'traffic light', 'gazebo', 'escalator', 'land', 'board', 'arcade machine', 'eiderdown', 'bar', 'stall', 'playground', 'ship', 'ottoman', 'ashcan', 'bottle', 'cradle', 'pot', 'conveyer belt', 'train', 'stool', 'lake', 'tank', 'ice', 'basket', 'manhole', 'tent', 'canopy', 'microwave', 'barrel', 'dirt track', 'beam', 'dishwasher', 'plate', 'screen', 'ruins', 'washer', 'blanket', 'plaything', 'food', 'screen', 'oven', 'stage', 'beacon', 'umbrella', 'sculpture', 'aqueduct', 'container', 'scaffolding', 'hood', 'curb', 'roller coaster', 'horse', 'catwalk', 'glass', 'vase', 'central reservation', 'carousel', 'radiator', 'closet', 'machine', 'pier', 'fan', 'inflatable bounce game', 'pitch', 'paper', 'arcade', 'hot tub', 'helicopter', 'tray', 'partition', 'vineyard', 'bowl', 'bullring', 'flag', 'pot', 'footbridge', 'shower', 'bag', 'bulletin board', 'confessional booth', 'trunk', 'forest', 'elevator door', 'laptop', 'instrument panel', 'bucket', 'tapestry', 'platform', 'jacket', 'gate', 'monitor', 'telephone booth', 'spotlight', 'ring', 'control panel', 'blackboard', 'air conditioner', 'chest', 'clock', 'sand dune', 'pipe', 'vault', 'table football', 'cannon', 'swimming pool', 'fluorescent', 'statue', 'loudspeaker', 'exhibitor', 'ladder', 'carport', 'dam', 'pulpit', 'skylight', 'water tower', 'grill', 'display board', 'pane', 'rubbish', 'ice rink', 'fruit', 'patio', 'vending machine', 'telephone', 'net', 'backpack', 'jar', 'track', 'magazine', 'shutter', 'roof', 'banner', 'landfill', 'post', 'altarpiece', 'hat', 'arch', 'table game', 'bag', 'document', 'dome', 'pier', 'shanties', 'forecourt', 'crane', 'dog', 'piano', 'drawing', 'cabin', 'ad', 'amphitheater', 'monument', 'henhouse', 'cockpit', 'heater', 'windmill', 'pool', 'elevator', 'decoration', 'labyrinth', 'text', 'printer', 'mezzanine', 'mattress', 'straw', 'stalls', 'patio', 'billboard', 'bus stop', 'trouser', 'console table', 'rack', 'notebook', 'shrine', 'pantry', 'cart', 'steam shovel', 'porch', 'postbox', 'figurine', 'recycling bin', 'folding screen', 'telescope', 'deck chair', 'kennel', 'coffee maker', 'altar', 'fish', 'easel', 'artificial golf green', 'iceberg', 'candlestick', 'shower stall', 'television stand', 'wall socket', 'skeleton', 'grand piano', 'candy', 'grille door', 'pedestal', 'jersey', 'shoe', 'gravestone', 'shanty', 'structure', 'rocking chair', 'bird', 'place mat', 'tomb', 'big top', 'gas pump', 'lockers', 'cage', 'finger', 'bleachers', 'ferris wheel', 'hairdresser chair', 'mat', 'stands', 'aquarium', 'streetcar', 'napkin', 'dummy', 'booklet', 'sand trap', 'shop', 'table cloth', 'service station', 'coffin', 'drawer', 'cages', 'slot machine', 'balcony', 'volleyball court', 'table tennis', 'control table', 'shirt', 'merchandise', 'railway', 'parterre', 'chimney', 'can', 'tanks', 'fabric', 'alga', 'system', 'map', 'greenhouse', 'mug', 'barbecue', 'trailer', 'toilet tissue', 'organ', 'dishrag', 'island', 'keyboard', 'trench', 'basket', 'steering wheel', 'pitcher', 'goal', 'bread', 'beds', 'wood', 'file cabinet', 'newspaper', 'motorboat', 'rope', 'guitar', 'rubble', 'scarf', 'barrels', 'cap', 'leaves', 'control tower', 'dashboard', 'bandstand', 'lectern', 'switch', 'baseboard', 'shower room', 'smoke', 'faucet', 'bulldozer', 'saucepan', 'shops', 'meter', 'crevasse', 'gear', 'candelabrum', 'sofa bed', 'tunnel', 'pallet', 'wire', 'kettle', 'bidet', 'baby buggy', 'music stand', 'pipe', 'cup', 'parking meter', 'ice hockey rink', 'shelter', 'weeds', 'temple', 'patty', 'ski slope', 'panel', 'wallet', 'wheel', 'towel rack', 'roundabout', 'canister', 'rod', 'soap dispenser', 'bell', 'canvas', 'box office', 'teacup', 'trellis', 'workbench', 'valley', 'toaster', 'knife', 'podium', 'ramp', 'tumble dryer', 'fireplug', 'gym shoe', 'lab bench', 'equipment', 'rocky formation', 'plastic', 'calendar', 'caravan', 'check-in-desk', 'ticket counter', 'brush', 'mill', 'covered bridge', 'bowling alley', 'hanger', 'excavator', 'trestle', 'revolving door', 'blast furnace', 'scale', 'projector', 'soap', 'locker', 'tractor', 'stretcher', 'frame', 'grating', 'alembic', 'candle', 'barrier', 'cardboard', 'cave', 'puddle', 'tarp', 'price tag', 'watchtower', 'meters', 'light bulb', 'tracks', 'hair dryer', 'skirt', 'viaduct', 'paper towel', 'coat', 'sheet', 'fire extinguisher', 'water wheel', 'pottery', 'magazine rack', 'teapot', 'microphone', 'support', 'forklift', 'canyon', 'cash register', 'leaf', 'remote control', 'soap dish', 'windshield', 'cat', 'cue', 'vent', 'videos', 'shovel', 'eaves', 'antenna', 'shipyard', 'hen', 'traffic cone', 'washing machines', 'truck crane', 'cds', 'niche', 'scoreboard', 'briefcase', 'boot', 'sweater', 'hay', 'pack', 'bottle rack', 'glacier', 'pergola', 'building materials', 'television camera', 'first floor', 'rifle', 'tennis table', 'stadium', 'safety belt', 'cover', 'dish rack', 'synthesizer', 'pumpkin', 'gutter', 'fruit stand', 'ice floe', 'handle', 'wheelchair', 'mousepad', 'diploma', 'fairground ride', 'radio', 'hotplate', 'junk', 'wheelbarrow', 'stream', 'toll plaza', 'punching bag', 'trough', 'throne', 'chair desk', 'weighbridge', 'extractor fan', 'hanging clothes', 'dish', 'alarm clock', 'ski lift', 'chain', 'garage', 'mechanical shovel', 'wine rack', 'tramway', 'treadmill', 'menu', 'block', 'well', 'witness stand', 'branch', 'duck', 'casserole', 'frying pan', 'desk organizer', 'mast', 'spectacles', 'service elevator', 'dollhouse', 'hammock', 'clothes hanging', 'photocopier', 'notepad', 'golf cart', 'footpath', 'cross', 'baptismal font', 'boiler', 'skip', 'rotisserie', 'tables', 'water mill', 'helmet', 'cover curtain', 'brick', 'table runner', 'ashtray', 'street box', 'stick', 'hangers', 'cells', 'urinal', 'centerpiece', 'portable fridge', 'dvds', 'golf club', 'skirting board', 'water cooler', 'clipboard', 'camera', 'pigeonhole', 'chips', 'food processor', 'post box', 'lid', 'drum', 'blender', 'cave entrance', 'dental chair', 'obelisk', 'canoe', 'mobile', 'monitors', 'pool ball', 'cue rack', 'baggage carts', 'shore', 'fork', 'paper filer', 'bicycle rack', 'coat rack', 'garland', 'sports bag', 'fish tank', 'towel dispenser', 'carriage', 'brochure', 'plaque', 'stringer', 'iron', 'spoon', 'flag pole', 'toilet brush', 'book stand', 'water faucet', 'ticket office', 'broom', 'dvd', 'ice bucket', 'carapace', 'tureen', 'folders', 'chess', 'root', 'sewing machine', 'model', 'pen', 'violin', 'sweatshirt', 'recycling materials', 'mitten', 'chopping board', 'mask', 'log', 'mouse', 'grill', 'hole', 'target', 'trash bag', 'chalk', 'sticks', 'balloon', 'score', 'hair spray', 'roll', 'runner', 'engine', 'inflatable glove', 'games', 'pallets', 'baskets', 'coop', 'dvd player', 'rocking horse', 'buckets', 'bread rolls', 'shawl', 'watering can', 'spotlights', 'post-it', 'bowls', 'security camera', 'runner cloth', 'lock', 'alarm', 'side', 'roulette', 'bone', 'cutlery', 'pool balls', 'wheels', 'spice rack', 'plant pots', 'towel ring', 'bread box', 'video', 'funfair', 'breads', 'tripod', 'ironing board', 'skimmer', 'hollow', 'scratching post', 'tricycle', 'file box', 'mountain pass', 'tombstones', 'cooker', 'card game', 'golf bag', 'towel paper', 'chaise lounge', 'sun', 'toilet paper holder', 'rake', 'key', 'umbrella stand', 'dartboard', 'transformer', 'fireplace utensils', 'sweatshirts', 'cellular telephone', 'tallboy', 'stapler', 'sauna', 'test tube', 'palette', 'shopping carts', 'tools', 'push button', 'star', 'roof rack', 'barbed wire', 'spray', 'ear', 'sponge', 'racket', 'tins', 'eyeglasses', 'file', 'scarfs', 'sugar bowl', 'flip flop', 'headstones', 'laptop bag', 'leash', 'climbing frame', 'suit hanger', 'floor spotlight', 'plate rack', 'sewer', 'hard drive', 'sprinkler', 'tools box', 'necklace', 'bulbs', 'steel industry', 'club', 'jack', 'door bars', 'control panel', 'hairbrush', 'napkin holder', 'office', 'smoke detector', 'utensils', 'apron', 'scissors', 'terminal', 'grinder', 'entry phone', 'newspaper stand', 'pepper shaker', 'onions', 'central processing unit', 'tape', 'bat', 'coaster', 'calculator', 'potatoes', 'luggage rack', 'salt', 'street number', 'viewpoint', 'sword', 'cd', 'rowing machine', 'plug', 'andiron', 'pepper', 'tongs', 'bonfire', 'dog dish', 'belt', 'dumbbells', 'videocassette recorder', 'hook', 'envelopes', 'shower faucet', 'watch', 'padlock', 'swimming pool ladder', 'spanners', 'gravy boat', 'notice board', 'trash bags', 'fire alarm', 'ladle', 'stethoscope', 'rocket', 'funnel', 'bowling pins', 'valve', 'thermometer', 'cups', 'spice jar', 'night light', 'soaps', 'games table', 'slotted spoon', 'reel', 'scourer', 'sleeping robe', 'desk mat', 'dumbbell', 'hammer', 'tie', 'typewriter', 'shaker', 'cheese dish', 'sea star', 'racquet', 'butane gas cylinder', 'paper weight', 'shaving brush', 'sunglasses', 'gear shift', 'towel rail', 'adding machine']

SUN_RGBD_37 = ['wall', 'floor', 'cabinet', 'bed', 'chair', 'sofa', 'table', 'door', 'window', 'bookshelf', 'picture', 'counter', 'blinds', 'desk', 'shelves', 'curtain', 'dresser', 'pillow', 'mirror', 'floor mat', 'clothes', 'ceiling', 'books', 'refridgerator', 'television', 'paper', 'towel', 'shower curtain', 'box', 'whiteboard', 'person', 'night stand', 'toilet', 'sink', 'lamp', 'bathtub', 'bag']

SCAN_37 = ['wall', 'floor', 'cabinet', 'bed', 'chair', 'sofa', 'table', 'door', 'window', 'bookshelf', 'picture', 'counter', 'blinds', 'desk', 'shelves', 'curtain', 'dresser', 'pillow', 'mirror', 'floor mat', 'clothes', 'ceiling', 'books', 'refridgerator', 'television', 'paper', 'towel', 'shower curtain', 'box', 'whiteboard', 'person', 'night stand', 'toilet', 'sink', 'lamp', 'bathtub', 'bag']
SCAN_40 = ['wall', 'floor', 'cabinet', 'bed', 'chair', 'sofa', 'table', 'door', 'window', 'bookshelf', 'picture', 'counter', 'blinds', 'desk', 'shelves', 'curtain', 'dresser', 'pillow', 'mirror', 'floor mat', 'clothes', 'ceiling', 'books', 'refridgerator', 'television', 'paper', 'towel', 'shower curtain', 'box', 'whiteboard', 'person', 'night stand', 'toilet', 'sink', 'lamp', 'bathtub', 'bag', 'otherstructure', 'otherfurniture', 'otherprop']
SCAN_20 = ["wall", "floor", "cabinet", "bed", "chair", "sofa", "table", "door", "window", "bookshelf", "picture", "counter", "desk", "curtain", "refrigerator", "shower curtain", "toilet", "sink", "bathtub", "otherfurniture"]

CITYSCAPES = ['road', 'sidewalk', 'building', 'wall', 'fence', 'pole', 'traffic light', 'traffic sign', 'vegetation', 'terrain', 'sky', 'person', 'rider', 'car', 'truck', 'bus', 'train', 'motorcycle', 'bicycle']
CITYSCAPES_THING = ["person", "rider", "car", "truck", "bus", "train", "motorcycle", "bicycle"]

BDD_SEM = ["road", "sidewalk", "building", "wall", "fence", "pole", "traffic light", "traffic sign", "vegetation", "terrain", "sky", "person", "rider", "car", "truck", "bus", "train", "motorcycle", "bicycle"]
BDD_PANO = ['dynamic', 'ego vehicle', 'ground', 'static', 'parking', 'rail track', 'road', 'sidewalk', 'bridge', 'building', 'fence', 'garage', 'guard rail', 'tunnel', 'wall', 'banner', 'billboard', 'lane divider', 'parking sign', 'pole', 'polegroup', 'street light', 'traffic cone', 'traffic device', 'traffic light', 'traffic sign', 'traffic sign frame', 'terrain', 'vegetation', 'sky', 'person', 'rider', 'bicycle', 'bus', 'car', 'caravan', 'motorcycle', 'trailer', 'train', 'truck']

IMAGENET_CLASSES = ["tench", "goldfish", "great white shark", "tiger shark", "hammerhead shark", "electric ray", "stingray", "rooster", "hen", "ostrich", "brambling", "goldfinch", "house finch", "junco", "indigo bunting", "American robin", "bulbul", "jay", "magpie", "chickadee", "American dipper", "kite (bird of prey)", "bald eagle", "vulture", "great grey owl", "fire salamander", "smooth newt", "newt", "spotted salamander", "axolotl", "American bullfrog", "tree frog", "tailed frog", "loggerhead sea turtle", "leatherback sea turtle", "mud turtle", "terrapin", "box turtle", "banded gecko", "green iguana", "Carolina anole", "desert grassland whiptail lizard", "agama", "frilled-necked lizard", "alligator lizard", "Gila monster", "European green lizard", "chameleon", "Komodo dragon", "Nile crocodile", "American alligator", "triceratops", "worm snake", "ring-necked snake", "eastern hog-nosed snake", "smooth green snake", "kingsnake", "garter snake", "water snake", "vine snake", "night snake", "boa constrictor", "African rock python", "Indian cobra", "green mamba", "sea snake", "Saharan horned viper", "eastern diamondback rattlesnake", "sidewinder rattlesnake", "trilobite", "harvestman", "scorpion", "yellow garden spider", "barn spider", "European garden spider", "southern black widow", "tarantula", "wolf spider", "tick", "centipede", "black grouse", "ptarmigan", "ruffed grouse", "prairie grouse", "peafowl", "quail", "partridge", "african grey parrot", "macaw", "sulphur-crested cockatoo", "lorikeet", "coucal", "bee eater", "hornbill", "hummingbird", "jacamar", "toucan", "duck", "red-breasted merganser", "goose", "black swan", "tusker", "echidna", "platypus", "wallaby", "koala", "wombat", "jellyfish", "sea anemone", "brain coral", "flatworm", "nematode", "conch", "snail", "slug", "sea slug", "chiton", "chambered nautilus", "Dungeness crab", "rock crab", "fiddler crab", "red king crab", "American lobster", "spiny lobster", "crayfish", "hermit crab", "isopod", "white stork", "black stork", "spoonbill", "flamingo", "little blue heron", "great egret", "bittern bird", "crane bird", "limpkin", "common gallinule", "American coot", "bustard", "ruddy turnstone", "dunlin", "common redshank", "dowitcher", "oystercatcher", "pelican", "king penguin", "albatross", "grey whale", "killer whale", "dugong", "sea lion", "Chihuahua", "Japanese Chin", "Maltese", "Pekingese", "Shih Tzu", "King Charles Spaniel", "Papillon", "toy terrier", "Rhodesian Ridgeback", "Afghan Hound", "Basset Hound", "Beagle", "Bloodhound", "Bluetick Coonhound", "Black and Tan Coonhound", "Treeing Walker Coonhound", "English foxhound", "Redbone Coonhound", "borzoi", "Irish Wolfhound", "Italian Greyhound", "Whippet", "Ibizan Hound", "Norwegian Elkhound", "Otterhound", "Saluki", "Scottish Deerhound", "Weimaraner", "Staffordshire Bull Terrier", "American Staffordshire Terrier", "Bedlington Terrier", "Border Terrier", "Kerry Blue Terrier", "Irish Terrier", "Norfolk Terrier", "Norwich Terrier", "Yorkshire Terrier", "Wire Fox Terrier", "Lakeland Terrier", "Sealyham Terrier", "Airedale Terrier", "Cairn Terrier", "Australian Terrier", "Dandie Dinmont Terrier", "Boston Terrier", "Miniature Schnauzer", "Giant Schnauzer", "Standard Schnauzer", "Scottish Terrier", "Tibetan Terrier", "Australian Silky Terrier", "Soft-coated Wheaten Terrier", "West Highland White Terrier", "Lhasa Apso", "Flat-Coated Retriever", "Curly-coated Retriever", "Golden Retriever", "Labrador Retriever", "Chesapeake Bay Retriever", "German Shorthaired Pointer", "Vizsla", "English Setter", "Irish Setter", "Gordon Setter", "Brittany dog", "Clumber Spaniel", "English Springer Spaniel", "Welsh Springer Spaniel", "Cocker Spaniel", "Sussex Spaniel", "Irish Water Spaniel", "Kuvasz", "Schipperke", "Groenendael dog", "Malinois", "Briard", "Australian Kelpie", "Komondor", "Old English Sheepdog", "Shetland Sheepdog", "collie", "Border Collie", "Bouvier des Flandres dog", "Rottweiler", "German Shepherd Dog", "Dobermann", "Miniature Pinscher", "Greater Swiss Mountain Dog", "Bernese Mountain Dog", "Appenzeller Sennenhund", "Entlebucher Sennenhund", "Boxer", "Bullmastiff", "Tibetan Mastiff", "French Bulldog", "Great Dane", "St. Bernard", "husky", "Alaskan Malamute", "Siberian Husky", "Dalmatian", "Affenpinscher", "Basenji", "pug", "Leonberger", "Newfoundland dog", "Great Pyrenees dog", "Samoyed", "Pomeranian", "Chow Chow", "Keeshond", "brussels griffon", "Pembroke Welsh Corgi", "Cardigan Welsh Corgi", "Toy Poodle", "Miniature Poodle", "Standard Poodle", "Mexican hairless dog (xoloitzcuintli)", "grey wolf", "Alaskan tundra wolf", "red wolf or maned wolf", "coyote", "dingo", "dhole", "African wild dog", "hyena", "red fox", "kit fox", "Arctic fox", "grey fox", "tabby cat", "tiger cat", "Persian cat", "Siamese cat", "Egyptian Mau", "cougar", "lynx", "leopard", "snow leopard", "jaguar", "lion", "tiger", "cheetah", "brown bear", "American black bear", "polar bear", "sloth bear", "mongoose", "meerkat", "tiger beetle", "ladybug", "ground beetle", "longhorn beetle", "leaf beetle", "dung beetle", "rhinoceros beetle", "weevil", "fly", "bee", "ant", "grasshopper", "cricket insect", "stick insect", "cockroach", "praying mantis", "cicada", "leafhopper", "lacewing", "dragonfly", "damselfly", "red admiral butterfly", "ringlet butterfly", "monarch butterfly", "small white butterfly", "sulphur butterfly", "gossamer-winged butterfly", "starfish", "sea urchin", "sea cucumber", "cottontail rabbit", "hare", "Angora rabbit", "hamster", "porcupine", "fox squirrel", "marmot", "beaver", "guinea pig", "common sorrel horse", "zebra", "pig", "wild boar", "warthog", "hippopotamus", "ox", "water buffalo", "bison", "ram (adult male sheep)", "bighorn sheep", "Alpine ibex", "hartebeest", "impala (antelope)", "gazelle", "arabian camel", "llama", "weasel", "mink", "European polecat", "black-footed ferret", "otter", "skunk", "badger", "armadillo", "three-toed sloth", "orangutan", "gorilla", "chimpanzee", "gibbon", "siamang", "guenon", "patas monkey", "baboon", "macaque", "langur", "black-and-white colobus", "proboscis monkey", "marmoset", "white-headed capuchin", "howler monkey", "titi monkey", "Geoffroy's spider monkey", "common squirrel monkey", "ring-tailed lemur", "indri", "Asian elephant", "African bush elephant", "red panda", "giant panda", "snoek fish", "eel", "silver salmon", "rock beauty fish", "clownfish", "sturgeon", "gar fish", "lionfish", "pufferfish", "abacus", "abaya", "academic gown", "accordion", "acoustic guitar", "aircraft carrier", "airliner", "airship", "altar", "ambulance", "amphibious vehicle", "analog clock", "apiary", "apron", "trash can", "assault rifle", "backpack", "bakery", "balance beam", "balloon", "ballpoint pen", "Band-Aid", "banjo", "baluster / handrail", "barbell", "barber chair", "barbershop", "barn", "barometer", "barrel", "wheelbarrow", "baseball", "basketball", "bassinet", "bassoon", "swimming cap", "bath towel", "bathtub", "station wagon", "lighthouse", "beaker", "military hat (bearskin or shako)", "beer bottle", "beer glass", "bell tower", "baby bib", "tandem bicycle", "bikini", "ring binder", "binoculars", "birdhouse", "boathouse", "bobsleigh", "bolo tie", "poke bonnet", "bookcase", "bookstore", "bottle cap", "hunting bow", "bow tie", "brass memorial plaque", "bra", "breakwater", "breastplate", "broom", "bucket", "buckle", "bulletproof vest", "high-speed train", "butcher shop", "taxicab", "cauldron", "candle", "cannon", "canoe", "can opener", "cardigan", "car mirror", "carousel", "tool kit", "cardboard box / carton", "car wheel", "automated teller machine", "cassette", "cassette player", "castle", "catamaran", "CD player", "cello", "mobile phone", "chain", "chain-link fence", "chain mail", "chainsaw", "storage chest", "chiffonier", "bell or wind chime", "china cabinet", "Christmas stocking", "church", "movie theater", "cleaver", "cliff dwelling", "cloak", "clogs", "cocktail shaker", "coffee mug", "coffeemaker", "spiral or coil", "combination lock", "computer keyboard", "candy store", "container ship", "convertible", "corkscrew", "cornet", "cowboy boot", "cowboy hat", "cradle", "construction crane", "crash helmet", "crate", "infant bed", "Crock Pot", "croquet ball", "crutch", "cuirass", "dam", "desk", "desktop computer", "rotary dial telephone", "diaper", "digital clock", "digital watch", "dining table", "dishcloth", "dishwasher", "disc brake", "dock", "dog sled", "dome", "doormat", "drilling rig", "drum", "drumstick", "dumbbell", "Dutch oven", "electric fan", "electric guitar", "electric locomotive", "entertainment center", "envelope", "espresso machine", "face powder", "feather boa", "filing cabinet", "fireboat", "fire truck", "fire screen", "flagpole", "flute", "folding chair", "football helmet", "forklift", "fountain", "fountain pen", "four-poster bed", "freight car", "French horn", "frying pan", "fur coat", "garbage truck", "gas mask or respirator", "gas pump", "goblet", "go-kart", "golf ball", "golf cart", "gondola", "gong", "gown", "grand piano", "greenhouse", "radiator grille", "grocery store", "guillotine", "hair clip", "hair spray", "half-track", "hammer", "hamper", "hair dryer", "hand-held computer", "handkerchief", "hard disk drive", "harmonica", "harp", "combine harvester", "hatchet", "holster", "home theater", "honeycomb", "hook", "hoop skirt", "gymnastic horizontal bar", "horse-drawn vehicle", "hourglass", "iPod", "clothes iron", "carved pumpkin", "jeans", "jeep", "T-shirt", "jigsaw puzzle", "rickshaw", "joystick", "kimono", "knee pad", "knot", "lab coat", "ladle", "lampshade", "laptop computer", "lawn mower", "lens cap", "letter opener", "library", "lifeboat", "lighter", "limousine", "ocean liner", "lipstick", "slip-on shoe", "lotion", "music speaker", "loupe magnifying glass", "sawmill", "magnetic compass", "messenger bag", "mailbox", "tights", "one-piece bathing suit", "manhole cover", "maraca", "marimba", "mask", "matchstick", "maypole", "maze", "measuring cup", "medicine cabinet", "megalith", "microphone", "microwave oven", "military uniform", "milk can", "minibus", "miniskirt", "minivan", "missile", "mitten", "mixing bowl", "mobile home", "ford model t", "modem", "monastery", "monitor", "moped", "mortar and pestle", "graduation cap", "mosque", "mosquito net", "vespa", "mountain bike", "tent", "computer mouse", "mousetrap", "moving van", "muzzle", "metal nail", "neck brace", "necklace", "baby pacifier", "notebook computer", "obelisk", "oboe", "ocarina", "odometer", "oil filter", "pipe organ", "oscilloscope", "overskirt", "bullock cart", "oxygen mask", "product packet / packaging", "paddle", "paddle wheel", "padlock", "paintbrush", "pajamas", "palace", "pan flute", "paper towel", "parachute", "parallel bars", "park bench", "parking meter", "railroad car", "patio", "payphone", "pedestal", "pencil case", "pencil sharpener", "perfume", "Petri dish", "photocopier", "plectrum", "Pickelhaube", "picket fence", "pickup truck", "pier", "piggy bank", "pill bottle", "pillow", "ping-pong ball", "pinwheel", "pirate ship", "drink pitcher", "block plane", "planetarium", "plastic bag", "plate rack", "farm plow", "plunger", "Polaroid camera", "pole", "police van", "poncho", "pool table", "soda bottle", "plant pot", "potter's wheel", "power drill", "prayer rug", "printer", "prison", "projectile", "projector", "hockey puck", "punching bag", "purse", "quill", "quilt", "race car", "racket", "radiator", "radio", "radio telescope", "rain barrel", "recreational vehicle", "fishing casting reel", "reflex camera", "refrigerator", "remote control", "restaurant", "revolver", "rifle", "rocking chair", "rotisserie", "eraser", "rugby ball", "ruler measuring stick", "sneaker", "safe", "safety pin", "salt shaker", "sandal", "sarong", "saxophone", "scabbard", "weighing scale", "school bus", "schooner", "scoreboard", "CRT monitor", "screw", "screwdriver", "seat belt", "sewing machine", "shield", "shoe store", "shoji screen / room divider", "shopping basket", "shopping cart", "shovel", "shower cap", "shower curtain", "ski", "balaclava ski mask", "sleeping bag", "slide rule", "sliding door", "slot machine", "snorkel", "snowmobile", "snowplow", "soap dispenser", "soccer ball", "sock", "solar thermal collector", "sombrero", "soup bowl", "keyboard space bar", "space heater", "space shuttle", "spatula", "motorboat", "spider web", "spindle", "sports car", "spotlight", "stage", "steam locomotive", "through arch bridge", "steel drum", "stethoscope", "scarf", "stone wall", "stopwatch", "stove", "strainer", "tram", "stretcher", "couch", "stupa", "submarine", "suit", "sundial", "sunglasses", "dark glasses", "sunscreen", "suspension bridge", "mop", "sweatshirt", "swim trunks / shorts", "swing", "electrical switch", "syringe", "table lamp", "tank", "tape player", "teapot", "teddy bear", "television", "tennis ball", "thatched roof", "front curtain", "thimble", "threshing machine", "throne", "tile roof", "toaster", "tobacco shop", "toilet seat", "torch", "totem pole", "tow truck", "toy store", "tractor", "semi-trailer truck", "tray", "trench coat", "tricycle", "trimaran", "tripod", "triumphal arch", "trolleybus", "trombone", "hot tub", "turnstile", "typewriter keyboard", "umbrella", "unicycle", "upright piano", "vacuum cleaner", "vase", "vaulted or arched ceiling", "velvet fabric", "vending machine", "vestment", "viaduct", "violin", "volleyball", "waffle iron", "wall clock", "wallet", "wardrobe", "military aircraft", "sink", "washing machine", "water bottle", "water jug", "water tower", "whiskey jug", "whistle", "hair wig", "window screen", "window shade", "Windsor tie", "wine bottle", "airplane wing", "wok", "wooden spoon", "wool", "split-rail fence", "shipwreck", "sailboat", "yurt", "website", "comic book", "crossword", "traffic or street sign", "traffic light", "dust jacket", "menu", "plate", "guacamole", "consomme", "hot pot", "trifle", "ice cream", "popsicle", "baguette", "bagel", "pretzel", "cheeseburger", "hot dog", "mashed potatoes", "cabbage", "broccoli", "cauliflower", "zucchini", "spaghetti squash", "acorn squash", "butternut squash", "cucumber", "artichoke", "bell pepper", "cardoon", "mushroom", "Granny Smith apple", "strawberry", "orange", "lemon", "fig", "pineapple", "banana", "jackfruit", "cherimoya (custard apple)", "pomegranate", "hay", "carbonara", "chocolate syrup", "dough", "meatloaf", "pizza", "pot pie", "burrito", "red wine", "espresso", "tea cup", "eggnog", "mountain", "bubble", "cliff", "coral reef", "geyser", "lakeshore", "promontory", "sandbar", "beach", "valley", "volcano", "baseball player", "bridegroom", "scuba diver", "rapeseed", "daisy", "yellow lady's slipper", "corn", "acorn", "rose hip", "horse chestnut seed", "coral fungus", "agaric", "gyromitra", "stinkhorn mushroom", "earth star fungus", "hen of the woods mushroom", "bolete", "corn cob", "toilet paper"]

IMAGENET_FOLDER_NAMES = ['n01440764', 'n01443537', 'n01484850', 'n01491361', 'n01494475', 'n01496331', 'n01498041', 'n01514668', 'n01514859', 'n01518878', 'n01530575', 'n01531178', 'n01532829', 'n01534433', 'n01537544', 'n01558993', 'n01560419', 'n01580077', 'n01582220', 'n01592084', 'n01601694', 'n01608432', 'n01614925', 'n01616318', 'n01622779', 'n01629819', 'n01630670', 'n01631663', 'n01632458', 'n01632777', 'n01641577', 'n01644373', 'n01644900', 'n01664065', 'n01665541', 'n01667114', 'n01667778', 'n01669191', 'n01675722', 'n01677366', 'n01682714', 'n01685808', 'n01687978', 'n01688243', 'n01689811', 'n01692333', 'n01693334', 'n01694178', 'n01695060', 'n01697457', 'n01698640', 'n01704323', 'n01728572', 'n01728920', 'n01729322', 'n01729977', 'n01734418', 'n01735189', 'n01737021', 'n01739381', 'n01740131', 'n01742172', 'n01744401', 'n01748264', 'n01749939', 'n01751748', 'n01753488', 'n01755581', 'n01756291', 'n01768244', 'n01770081', 'n01770393', 'n01773157', 'n01773549', 'n01773797', 'n01774384', 'n01774750', 'n01775062', 'n01776313', 'n01784675', 'n01795545', 'n01796340', 'n01797886', 'n01798484', 'n01806143', 'n01806567', 'n01807496', 'n01817953', 'n01818515', 'n01819313', 'n01820546', 'n01824575', 'n01828970', 'n01829413', 'n01833805', 'n01843065', 'n01843383', 'n01847000', 'n01855032', 'n01855672', 'n01860187', 'n01871265', 'n01872401', 'n01873310', 'n01877812', 'n01882714', 'n01883070', 'n01910747', 'n01914609', 'n01917289', 'n01924916', 'n01930112', 'n01943899', 'n01944390', 'n01945685', 'n01950731', 'n01955084', 'n01968897', 'n01978287', 'n01978455', 'n01980166', 'n01981276', 'n01983481', 'n01984695', 'n01985128', 'n01986214', 'n01990800', 'n02002556', 'n02002724', 'n02006656', 'n02007558', 'n02009229', 'n02009912', 'n02011460', 'n02012849', 'n02013706', 'n02017213', 'n02018207', 'n02018795', 'n02025239', 'n02027492', 'n02028035', 'n02033041', 'n02037110', 'n02051845', 'n02056570', 'n02058221', 'n02066245', 'n02071294', 'n02074367', 'n02077923', 'n02085620', 'n02085782', 'n02085936', 'n02086079', 'n02086240', 'n02086646', 'n02086910', 'n02087046', 'n02087394', 'n02088094', 'n02088238', 'n02088364', 'n02088466', 'n02088632', 'n02089078', 'n02089867', 'n02089973', 'n02090379', 'n02090622', 'n02090721', 'n02091032', 'n02091134', 'n02091244', 'n02091467', 'n02091635', 'n02091831', 'n02092002', 'n02092339', 'n02093256', 'n02093428', 'n02093647', 'n02093754', 'n02093859', 'n02093991', 'n02094114', 'n02094258', 'n02094433', 'n02095314', 'n02095570', 'n02095889', 'n02096051', 'n02096177', 'n02096294', 'n02096437', 'n02096585', 'n02097047', 'n02097130', 'n02097209', 'n02097298', 'n02097474', 'n02097658', 'n02098105', 'n02098286', 'n02098413', 'n02099267', 'n02099429', 'n02099601', 'n02099712', 'n02099849', 'n02100236', 'n02100583', 'n02100735', 'n02100877', 'n02101006', 'n02101388', 'n02101556', 'n02102040', 'n02102177', 'n02102318', 'n02102480', 'n02102973', 'n02104029', 'n02104365', 'n02105056', 'n02105162', 'n02105251', 'n02105412', 'n02105505', 'n02105641', 'n02105855', 'n02106030', 'n02106166', 'n02106382', 'n02106550', 'n02106662', 'n02107142', 'n02107312', 'n02107574', 'n02107683', 'n02107908', 'n02108000', 'n02108089', 'n02108422', 'n02108551', 'n02108915', 'n02109047', 'n02109525', 'n02109961', 'n02110063', 'n02110185', 'n02110341', 'n02110627', 'n02110806', 'n02110958', 'n02111129', 'n02111277', 'n02111500', 'n02111889', 'n02112018', 'n02112137', 'n02112350', 'n02112706', 'n02113023', 'n02113186', 'n02113624', 'n02113712', 'n02113799', 'n02113978', 'n02114367', 'n02114548', 'n02114712', 'n02114855', 'n02115641', 'n02115913', 'n02116738', 'n02117135', 'n02119022', 'n02119789', 'n02120079', 'n02120505', 'n02123045', 'n02123159', 'n02123394', 'n02123597', 'n02124075', 'n02125311', 'n02127052', 'n02128385', 'n02128757', 'n02128925', 'n02129165', 'n02129604', 'n02130308', 'n02132136', 'n02133161', 'n02134084', 'n02134418', 'n02137549', 'n02138441', 'n02165105', 'n02165456', 'n02167151', 'n02168699', 'n02169497', 'n02172182', 'n02174001', 'n02177972', 'n02190166', 'n02206856', 'n02219486', 'n02226429', 'n02229544', 'n02231487', 'n02233338', 'n02236044', 'n02256656', 'n02259212', 'n02264363', 'n02268443', 'n02268853', 'n02276258', 'n02277742', 'n02279972', 'n02280649', 'n02281406', 'n02281787', 'n02317335', 'n02319095', 'n02321529', 'n02325366', 'n02326432', 'n02328150', 'n02342885', 'n02346627', 'n02356798', 'n02361337', 'n02363005', 'n02364673', 'n02389026', 'n02391049', 'n02395406', 'n02396427', 'n02397096', 'n02398521', 'n02403003', 'n02408429', 'n02410509', 'n02412080', 'n02415577', 'n02417914', 'n02422106', 'n02422699', 'n02423022', 'n02437312', 'n02437616', 'n02441942', 'n02442845', 'n02443114', 'n02443484', 'n02444819', 'n02445715', 'n02447366', 'n02454379', 'n02457408', 'n02480495', 'n02480855', 'n02481823', 'n02483362', 'n02483708', 'n02484975', 'n02486261', 'n02486410', 'n02487347', 'n02488291', 'n02488702', 'n02489166', 'n02490219', 'n02492035', 'n02492660', 'n02493509', 'n02493793', 'n02494079', 'n02497673', 'n02500267', 'n02504013', 'n02504458', 'n02509815', 'n02510455', 'n02514041', 'n02526121', 'n02536864', 'n02606052', 'n02607072', 'n02640242', 'n02641379', 'n02643566', 'n02655020', 'n02666196', 'n02667093', 'n02669723', 'n02672831', 'n02676566', 'n02687172', 'n02690373', 'n02692877', 'n02699494', 'n02701002', 'n02704792', 'n02708093', 'n02727426', 'n02730930', 'n02747177', 'n02749479', 'n02769748', 'n02776631', 'n02777292', 'n02782093', 'n02783161', 'n02786058', 'n02787622', 'n02788148', 'n02790996', 'n02791124', 'n02791270', 'n02793495', 'n02794156', 'n02795169', 'n02797295', 'n02799071', 'n02802426', 'n02804414', 'n02804610', 'n02807133', 'n02808304', 'n02808440', 'n02814533', 'n02814860', 'n02815834', 'n02817516', 'n02823428', 'n02823750', 'n02825657', 'n02834397', 'n02835271', 'n02837789', 'n02840245', 'n02841315', 'n02843684', 'n02859443', 'n02860847', 'n02865351', 'n02869837', 'n02870880', 'n02871525', 'n02877765', 'n02879718', 'n02883205', 'n02892201', 'n02892767', 'n02894605', 'n02895154', 'n02906734', 'n02909870', 'n02910353', 'n02916936', 'n02917067', 'n02927161', 'n02930766', 'n02939185', 'n02948072', 'n02950826', 'n02951358', 'n02951585', 'n02963159', 'n02965783', 'n02966193', 'n02966687', 'n02971356', 'n02974003', 'n02977058', 'n02978881', 'n02979186', 'n02980441', 'n02981792', 'n02988304', 'n02992211', 'n02992529', 'n02999410', 'n03000134', 'n03000247', 'n03000684', 'n03014705', 'n03016953', 'n03017168', 'n03018349', 'n03026506', 'n03028079', 'n03032252', 'n03041632', 'n03042490', 'n03045698', 'n03047690', 'n03062245', 'n03063599', 'n03063689', 'n03065424', 'n03075370', 'n03085013', 'n03089624', 'n03095699', 'n03100240', 'n03109150', 'n03110669', 'n03124043', 'n03124170', 'n03125729', 'n03126707', 'n03127747', 'n03127925', 'n03131574', 'n03133878', 'n03134739', 'n03141823', 'n03146219', 'n03160309', 'n03179701', 'n03180011', 'n03187595', 'n03188531', 'n03196217', 'n03197337', 'n03201208', 'n03207743', 'n03207941', 'n03208938', 'n03216828', 'n03218198', 'n03220513', 'n03223299', 'n03240683', 'n03249569', 'n03250847', 'n03255030', 'n03259280', 'n03271574', 'n03272010', 'n03272562', 'n03290653', 'n03291819', 'n03297495', 'n03314780', 'n03325584', 'n03337140', 'n03344393', 'n03345487', 'n03347037', 'n03355925', 'n03372029', 'n03376595', 'n03379051', 'n03384352', 'n03388043', 'n03388183', 'n03388549', 'n03393912', 'n03394916', 'n03400231', 'n03404251', 'n03417042', 'n03424325', 'n03425413', 'n03443371', 'n03444034', 'n03445777', 'n03445924', 'n03447447', 'n03447721', 'n03450230', 'n03452741', 'n03457902', 'n03459775', 'n03461385', 'n03467068', 'n03476684', 'n03476991', 'n03478589', 'n03481172', 'n03482405', 'n03483316', 'n03485407', 'n03485794', 'n03492542', 'n03494278', 'n03495258', 'n03496892', 'n03498962', 'n03527444', 'n03529860', 'n03530642', 'n03532672', 'n03534580', 'n03535780', 'n03538406', 'n03544143', 'n03584254', 'n03584829', 'n03590841', 'n03594734', 'n03594945', 'n03595614', 'n03598930', 'n03599486', 'n03602883', 'n03617480', 'n03623198', 'n03627232', 'n03630383', 'n03633091', 'n03637318', 'n03642806', 'n03649909', 'n03657121', 'n03658185', 'n03661043', 'n03662601', 'n03666591', 'n03670208', 'n03673027', 'n03676483', 'n03680355', 'n03690938', 'n03691459', 'n03692522', 'n03697007', 'n03706229', 'n03709823', 'n03710193', 'n03710637', 'n03710721', 'n03717622', 'n03720891', 'n03721384', 'n03724870', 'n03729826', 'n03733131', 'n03733281', 'n03733805', 'n03742115', 'n03743016', 'n03759954', 'n03761084', 'n03763968', 'n03764736', 'n03769881', 'n03770439', 'n03770679', 'n03773504', 'n03775071', 'n03775546', 'n03776460', 'n03777568', 'n03777754', 'n03781244', 'n03782006', 'n03785016', 'n03786901', 'n03787032', 'n03788195', 'n03788365', 'n03791053', 'n03792782', 'n03792972', 'n03793489', 'n03794056', 'n03796401', 'n03803284', 'n03804744', 'n03814639', 'n03814906', 'n03825788', 'n03832673', 'n03837869', 'n03838899', 'n03840681', 'n03841143', 'n03843555', 'n03854065', 'n03857828', 'n03866082', 'n03868242', 'n03868863', 'n03871628', 'n03873416', 'n03874293', 'n03874599', 'n03876231', 'n03877472', 'n03877845', 'n03884397', 'n03887697', 'n03888257', 'n03888605', 'n03891251', 'n03891332', 'n03895866', 'n03899768', 'n03902125', 'n03903868', 'n03908618', 'n03908714', 'n03916031', 'n03920288', 'n03924679', 'n03929660', 'n03929855', 'n03930313', 'n03930630', 'n03933933', 'n03935335', 'n03937543', 'n03938244', 'n03942813', 'n03944341', 'n03947888', 'n03950228', 'n03954731', 'n03956157', 'n03958227', 'n03961711', 'n03967562', 'n03970156', 'n03976467', 'n03976657', 'n03977966', 'n03980874', 'n03982430', 'n03983396', 'n03991062', 'n03992509', 'n03995372', 'n03998194', 'n04004767', 'n04005630', 'n04008634', 'n04009552', 'n04019541', 'n04023962', 'n04026417', 'n04033901', 'n04033995', 'n04037443', 'n04039381', 'n04040759', 'n04041544', 'n04044716', 'n04049303', 'n04065272', 'n04067472', 'n04069434', 'n04070727', 'n04074963', 'n04081281', 'n04086273', 'n04090263', 'n04099969', 'n04111531', 'n04116512', 'n04118538', 'n04118776', 'n04120489', 'n04125021', 'n04127249', 'n04131690', 'n04133789', 'n04136333', 'n04141076', 'n04141327', 'n04141975', 'n04146614', 'n04147183', 'n04149813', 'n04152593', 'n04153751', 'n04154565', 'n04162706', 'n04179913', 'n04192698', 'n04200800', 'n04201297', 'n04204238', 'n04204347', 'n04208210', 'n04209133', 'n04209239', 'n04228054', 'n04229816', 'n04235860', 'n04238763', 'n04239074', 'n04243546', 'n04251144', 'n04252077', 'n04252225', 'n04254120', 'n04254680', 'n04254777', 'n04258138', 'n04259630', 'n04263257', 'n04264628', 'n04265275', 'n04266014', 'n04270147', 'n04273569', 'n04275548', 'n04277352', 'n04285008', 'n04286575', 'n04296562', 'n04310018', 'n04311004', 'n04311174', 'n04317175', 'n04325704', 'n04326547', 'n04328186', 'n04330267', 'n04332243', 'n04335435', 'n04336792', 'n04344873', 'n04346328', 'n04347754', 'n04350905', 'n04355338', 'n04355933', 'n04356056', 'n04357314', 'n04366367', 'n04367480', 'n04370456', 'n04371430', 'n04371774', 'n04372370', 'n04376876', 'n04380533', 'n04389033', 'n04392985', 'n04398044', 'n04399382', 'n04404412', 'n04409515', 'n04417672', 'n04418357', 'n04423845', 'n04428191', 'n04429376', 'n04435653', 'n04442312', 'n04443257', 'n04447861', 'n04456115', 'n04458633', 'n04461696', 'n04462240', 'n04465501', 'n04467665', 'n04476259', 'n04479046', 'n04482393', 'n04483307', 'n04485082', 'n04486054', 'n04487081', 'n04487394', 'n04493381', 'n04501370', 'n04505470', 'n04507155', 'n04509417', 'n04515003', 'n04517823', 'n04522168', 'n04523525', 'n04525038', 'n04525305', 'n04532106', 'n04532670', 'n04536866', 'n04540053', 'n04542943', 'n04548280', 'n04548362', 'n04550184', 'n04552348', 'n04553703', 'n04554684', 'n04557648', 'n04560804', 'n04562935', 'n04579145', 'n04579432', 'n04584207', 'n04589890', 'n04590129', 'n04591157', 'n04591713', 'n04592741', 'n04596742', 'n04597913', 'n04599235', 'n04604644', 'n04606251', 'n04612504', 'n04613696', 'n06359193', 'n06596364', 'n06785654', 'n06794110', 'n06874185', 'n07248320', 'n07565083', 'n07579787', 'n07583066', 'n07584110', 'n07590611', 'n07613480', 'n07614500', 'n07615774', 'n07684084', 'n07693725', 'n07695742', 'n07697313', 'n07697537', 'n07711569', 'n07714571', 'n07714990', 'n07715103', 'n07716358', 'n07716906', 'n07717410', 'n07717556', 'n07718472', 'n07718747', 'n07720875', 'n07730033', 'n07734744', 'n07742313', 'n07745940', 'n07747607', 'n07749582', 'n07753113', 'n07753275', 'n07753592', 'n07754684', 'n07760859', 'n07768694', 'n07802026', 'n07831146', 'n07836838', 'n07860988', 'n07871810', 'n07873807', 'n07875152', 'n07880968', 'n07892512', 'n07920052', 'n07930864', 'n07932039', 'n09193705', 'n09229709', 'n09246464', 'n09256479', 'n09288635', 'n09332890', 'n09399592', 'n09421951', 'n09428293', 'n09468604', 'n09472597', 'n09835506', 'n10148035', 'n10565667', 'n11879895', 'n11939491', 'n12057211', 'n12144580', 'n12267677', 'n12620546', 'n12768682', 'n12985857', 'n12998815', 'n13037406', 'n13040303', 'n13044778', 'n13052670', 'n13054560', 'n13133613', 'n15075141']

IMAGENET_DEFAULT_TEMPLATES = [
    '{}.',
    'a bad photo of a {}.',
    'a photo of many {}.',
    'a sculpture of a {}.',
    'a photo of the hard to see {}.',
    'a low resolution photo of the {}.',
    'a rendering of a {}.',
    'graffiti of a {}.',
    'a bad photo of the {}.',
    'a cropped photo of the {}.',
    'a tattoo of a {}.',
    'the embroidered {}.',
    'a photo of a hard to see {}.',
    'a bright photo of a {}.',
    'a photo of a clean {}.',
    'a photo of a dirty {}.',
    'a dark photo of the {}.',
    'a drawing of a {}.',
    'a photo of my {}.',
    'the plastic {}.',
    'a photo of the cool {}.',
    'a close-up photo of a {}.',
    'a black and white photo of the {}.',
    'a painting of the {}.',
    'a painting of a {}.',
    'a pixelated photo of the {}.',
    'a sculpture of the {}.',
    'a bright photo of the {}.',
    'a cropped photo of a {}.',
    'a plastic {}.',
    'a photo of the dirty {}.',
    'a jpeg corrupted photo of a {}.',
    'a blurry photo of the {}.',
    'a photo of the {}.',
    'a good photo of the {}.',
    'a rendering of the {}.',
    'a {} in a video game.',
    'a photo of one {}.',
    'a doodle of a {}.',
    'a close-up photo of the {}.',
    'a photo of a {}.',
    'the origami {}.',
    'the {} in a video game.',
    'a sketch of a {}.',
    'a doodle of the {}.',
    'a origami {}.',
    'a low resolution photo of a {}.',
    'the toy {}.',
    'a rendition of the {}.',
    'a photo of the clean {}.',
    'a photo of a large {}.',
    'a rendition of a {}.',
    'a photo of a nice {}.',
    'a photo of a weird {}.',
    'a blurry photo of a {}.',
    'a cartoon {}.',
    'art of a {}.',
    'a sketch of the {}.',
    'a embroidered {}.',
    'a pixelated photo of a {}.',
    'itap of the {}.',
    'a jpeg corrupted photo of the {}.',
    'a good photo of a {}.',
    'a plushie {}.',
    'a photo of the nice {}.',
    'a photo of the small {}.',
    'a photo of the weird {}.',
    'the cartoon {}.',
    'art of the {}.',
    'a drawing of the {}.',
    'a photo of the large {}.',
    'a black and white photo of a {}.',
    'the plushie {}.',
    'a dark photo of a {}.',
    'itap of a {}.',
    'graffiti of the {}.',
    'a toy {}.',
    'itap of my {}.',
    'a photo of a cool {}.',
    'a photo of a small {}.',
    'a tattoo of the {}.',
]

IMAGENET_SIMPLE_TEMPLATES = [
    'a photo of {}.',
]

PASCAL_CLASSES = [
    "aeroplane", "bicycle", "bird", "boat", "bottle", "bus", "car", "cat",
    "chair", "cow", "diningtable", "dog", "horse", "motorbike", "person",
    "pottedplant", "sheep", "sofa", "train", "tvmonitor"
]

COCO_DESCRIPTION = ['The individual in question, who shall remain unnamed, possesses a vibrant personality, exuding warmth and charisma, with an infectious laugh that lights up the room, a keen intellect that sparks engaging conversations, and a genuine kindness that endears them to everyone they encounter, all wrapped up in a unique and unforgettable presence.', 'A two-wheeled, human-powered vehicle with a frame that connects the wheels, pedals, and handlebars, allowing the rider to sit on a saddle, propel themselves forward by pushing the pedals with their feet, and steer by turning the handlebars, providing an efficient, environmentally friendly, and healthy mode of transportation and recreation.', 'A sleek, four-wheeled, gasoline or electric-powered vehicle with a metal body, designed for the transportation of people and goods, featuring comfortable seating, a powerful engine, and various technological advancements for safety and convenience, such as airbags, GPS navigation, and climate control, all while providing a sense of freedom and independence to its driver and passengers.', 'A two-wheeled motorized vehicle with an engine, typically featuring a fuel tank, a seat for the rider, handlebars for steering, and various controls for acceleration, braking, and shifting gears, providing an exhilarating and efficient mode of transportation that allows for easy maneuverability and a sense of freedom as one navigates through traffic and open roads.', 'An elongated, streamlined, metal structure with wings extending from its sides, powered by jet engines or propellers, designed to transport passengers and cargo through the sky at high speeds and altitudes, while being controlled by a team of pilots in a cockpit at the front, and offering a range of amenities and services to ensure a comfortable journey for those on board.', 'A large, rectangular, wheeled vehicle, typically painted in bright colors, designed to transport numerous passengers along a predetermined route, with multiple stops for boarding and disembarking, often powered by diesel or electricity, and operated by a single driver who collects fares and ensures the safety and comfort of those on board.', 'A mode of transportation consisting of a series of connected vehicles that run along a track, powered by an engine, often used for carrying passengers and cargo over long distances, providing a comfortable and efficient means of travel while emitting a rhythmic chugging sound as it traverses the countryside.', 'A large, heavy-duty vehicle with a powerful engine, designed for transporting goods and materials over long distances, often featuring a cab for the driver and a separate compartment or trailer for cargo, and commonly seen on highways and construction sites.', "A sleek, streamlined vessel with a sturdy hull, designed to glide gracefully across the water's surface, propelled by wind filling its billowing sails or the churning force of a motor, providing a means of transportation, recreation, or livelihood for those who traverse the vast expanse of oceans, lakes, and rivers.", 'A three-colored, vertically arranged signaling device typically found at road intersections, which uses the colors red, yellow, and green to indicate when vehicles should stop, slow down, or proceed, respectively, in order to maintain an orderly and safe flow of traffic.', 'A bright red, cylindrical, metal apparatus, typically found on sidewalks in urban areas, connected to a vast network of underground water pipes, designed to provide firefighters with a quick and efficient means of accessing high-pressure water to extinguish blazes in nearby buildings and structures.', 'A red octagonal traffic control device with a white border and bold white letters instructing drivers to halt their vehicles completely before proceeding with caution at an intersection, ensuring the safety and proper flow of traffic.', 'A device typically found on the side of the road, designed to collect payment from drivers in exchange for a temporary permit to park their vehicles in a designated spot, often requiring the insertion of coins or the use of a credit card, and displaying the remaining time allowed for the vehicle to remain in the space on a small screen or dial.', 'A long, flat, sturdy surface, typically made of wood or metal, supported by legs or a frame, and designed for multiple people to sit on simultaneously, often found in parks, gardens, and other public spaces for relaxation and socialization.', 'A creature with feathers, wings, and a beak, often capable of melodious songs and remarkable aerial acrobatics, which lays eggs, builds nests, and can be found in a diverse array of environments, from dense forests to bustling cities, and is known for its incredible diversity in size, color, and behavior, with some species even possessing the ability to mimic human speech.', 'A small, domesticated, carnivorous mammal with soft fur, a short snout, and retractable claws, known for its agility, playfulness, and ability to hunt vermin, often kept as a household pet or used to control pests on farms, and characterized by its distinctive meowing, purring, and grooming behaviors, as well as its tendency to sleep for long periods and display a wide range of personalities and temperaments.', 'A four-legged, furry mammal with a wagging tail, floppy ears, and a keen sense of smell, often kept as a loyal and affectionate companion or trained to assist humans in various tasks such as hunting, herding, and providing assistance to those with disabilities.', 'A large, four-legged mammal with a flowing mane and tail, known for its grace, strength, and speed, often used for riding, racing, and pulling carriages, and historically employed in warfare, agriculture, and transportation, while also being a symbol of nobility and freedom in various cultures.', 'These fluffy, woolly creatures, often found grazing in meadows and fields, are known for their gentle nature, their bleating sounds, and their ability to provide humans with warm, soft fibers for clothing and blankets, as well as delicious meat and milk, while also being a symbol of peace and tranquility in various cultures.', 'A large, domesticated mammal with a stocky body, cloven hooves, and a broad, flat snout, typically found on farms and grasslands, known for its ability to produce milk and serve as a source of meat, leather, and other byproducts, while also being revered in some cultures for its gentle nature and religious significance.', 'The enormous, gray-skinned mammal, native to Africa and Asia, is characterized by its long, curved tusks, prehensile trunk, fan-like ears, and thick, pillar-like legs, which support its massive body as it roams the savannah or jungle, consuming vast quantities of vegetation and water daily, while living in tight-knit, matriarchal social groups.', 'A large, powerful mammal with thick fur, sharp claws, and strong limbs, known for its ability to climb trees, swim, and hibernate during winter months, while primarily feeding on plants, insects, fish, and smaller animals, and often considered a symbol of strength and wilderness in various cultures.', 'A zebra is an African equine mammal characterized by its distinctive black and white striped coat, which serves as a camouflage mechanism in the wild, and is known for its social nature, living in groups called harems, while also being a primary prey for predators such as lions and hyenas.', 'A towering, long-necked creature with a distinctive spotted coat, large eyes, and elongated legs, gracefully roaming the African savannah, browsing on the highest leaves of acacia trees, and possessing a unique, prehensile tongue that can stretch up to 18 inches, enabling it to reach even the most elusive foliage.', "A portable, often rectangular or oval-shaped bag, typically made of durable fabric or materials, featuring adjustable shoulder straps and multiple compartments, designed to be carried on one's back for the purpose of holding and organizing various items, such as books, clothing, or camping gear, while traveling, hiking, or engaging in other outdoor activities.", 'An umbrella is a portable, collapsible canopy mounted on a central rod, typically made of metal and plastic, designed to protect a person from rain or sunlight by extending its waterproof or sun-resistant fabric cover above their head, and often featuring a curved handle for easy carrying and a mechanism for opening and closing the canopy with ease.', "A stylish and functional accessory, often adorned with intricate designs or elegant simplicity, that serves as a portable storage solution for essential items such as a wallet, keys, phone, and makeup, while simultaneously elevating the overall aesthetic of one's outfit and expressing one's personal fashion sense.", 'A strip of fabric, often made of silk or polyester, that is worn around the neck, under the collar of a shirt, and knotted at the throat, typically by men as part of formal or professional attire, and serves as a decorative accessory that comes in various colors, patterns, and styles, such as the Windsor or four-in-hand knot, and is often used to convey a sense of sophistication, elegance, or adherence to a dress code.', 'A rectangular, portable container, often made of hard plastic or fabric, featuring a handle and sometimes wheels, designed to hold clothing, toiletries, and other personal belongings while traveling, and typically secured with a zipper, lock, or combination of both.', 'A round, flat, plastic disc that is thrown and caught by players in a variety of games and sports, often played outdoors in parks or on the beach, requiring skill, precision, and teamwork as it soars gracefully through the air, sometimes over long distances, and can be enjoyed by people of all ages and skill levels.', 'A pair of long, narrow, flat, and typically lightweight pieces of material, often made from wood, plastic, or metal, designed to be attached to the bottom of boots, allowing the wearer to glide smoothly and swiftly over snow-covered terrain, often used for recreational or competitive purposes in various winter sports such as downhill racing, cross-country, and freestyle jumping.', 'A popular winter sport that involves descending a snow-covered slope on a flat, elongated board with bindings for attaching boots, while performing various tricks and maneuvers, often at high speeds, and requiring a combination of balance, agility, and control.', 'A spherical object, often made of leather or rubber, designed for various athletic activities, which typically involves players propelling it through the air, across the ground, or into a goal using their hands, feet, or other body parts, while adhering to a specific set of rules and regulations, with the ultimate objective of scoring points and achieving victory over the opposing team.', 'A lightweight, often colorful, object made of fabric or paper, attached to a frame and flown in the air by means of a long string, typically enjoyed by children and adults alike on windy days, soaring gracefully in the sky while being controlled from the ground.', 'A cylindrical, smooth, elongated piece of wood or metal, tapered at one end and wider at the other, designed to be gripped by the hands and swung with force to strike a small, spherical object thrown by an opposing player in a popular outdoor sport that involves running around a diamond-shaped field and scoring points by touching a series of four bases.', 'A baseball glove is a large, padded, leather mitt worn on one hand, typically featuring a webbed design between the thumb and index finger, and used by players in the sport of baseball to catch and field the ball with ease and protection.', 'A skateboard is a narrow, flat, elongated platform with four wheels attached to its underside, typically used for performing tricks, cruising, or commuting, and is propelled by the rider pushing off the ground with one foot while the other remains on the board, allowing for a unique mode of transportation and expression of creativity through various stunts and maneuvers.', 'A long, narrow, and lightweight plank, typically made of foam and fiberglass, designed to be buoyant and ridden by individuals who balance themselves on top of it while gliding across the surface of ocean waves, engaging in a thrilling water sport that requires skill, agility, and a deep connection with the natural power of the sea.', 'A piece of sports equipment consisting of an oval or circular frame with a tightly interlaced network of strings, a long handle, and a padded grip, designed to be held by the hand and used to strike a small, hollow rubber ball covered in felt, known as a tennis ball, back and forth across a net on a rectangular court during a competitive or recreational game of tennis.', 'A transparent, cylindrical container made of glass or plastic, with a narrow neck and often a cap or cork, typically used for holding and preserving liquids such as water, beverages, or condiments.', 'A delicate, transparent, and often stemmed vessel, typically made of glass or crystal, with a rounded bowl tapering to a narrow opening at the top, designed to hold and enhance the aroma, flavor, and appearance of various types of fermented grape beverages, allowing for an optimal tasting experience.', 'A small, round, typically cylindrical container with a handle, often made of ceramic, glass, or plastic, designed for holding and consuming hot or cold beverages such as tea, coffee, or water, and sometimes featuring a saucer beneath it to catch any spills or drips.', 'A fork is a utensil consisting of a handle with several narrow tines on one end, typically used for holding, lifting, or spearing solid food items while eating or for serving various dishes, and is commonly found alongside a knife and spoon as part of a standard table setting.', 'A sharp, slender, metallic utensil with a handle, primarily used for cutting, slicing, or spreading food items, and often found in kitchens and dining settings, serving as an essential tool for meal preparation and consumption.', "A spoon is a small, shallow, oval or round-shaped utensil with a long handle, typically made of metal, wood, or plastic, used for stirring, serving, and consuming various types of food, such as soups, cereals, and desserts, by scooping up a small portion and conveying it to one's mouth.", 'A rounded, deep, open-top container, often made of materials such as ceramic, glass, or plastic, which is primarily used for holding and serving food, mixing ingredients, or displaying decorative items, and typically comes in various sizes and designs to suit different purposes.', 'A tropical, elongated, yellow-skinned fruit with a soft, sweet, and creamy interior, rich in potassium and dietary fiber, often used in smoothies, baked goods, and as a popular snack, which when peeled reveals a curved, easily digestible and nutritious treat that is enjoyed by people and animals alike.', 'A smooth, round, and firm fruit with a shiny skin that comes in various shades of red, green, or yellow, possessing a sweet or tart flavor, a crisp texture, and a core containing small, dark seeds, which grows on deciduous trees and is often used in cooking, baking, or eaten raw as a healthy snack.', 'A delicious, portable, and convenient meal consisting of various ingredients such as meats, cheeses, vegetables, and spreads, all nestled between two slices of bread, which can be toasted or untoasted, and often cut into halves or quarters for easy consumption.', 'A vibrant, warm hue that evokes feelings of energy and happiness, often associated with the fiery orb that sets in the evening sky, the sweet, tangy citrus fruit bursting with juice, or the brilliant display of leaves in autumn, this color is a lively and invigorating presence in the world around us.', 'Broccoli is a cruciferous vegetable with a thick, edible stalk and a dense, tree-like cluster of tiny green buds at the top, which is high in vitamins, minerals, and antioxidants, and is often steamed, roasted, or eaten raw in salads, stir-fries, and various other dishes for its delicious taste and numerous health benefits.', 'A long, slender, tapering, orange-hued root vegetable with a green leafy top, often consumed raw or cooked, boasting a mildly sweet, earthy flavor and a satisfying crunch, packed with vitamins and nutrients, particularly known for its high content of beta-carotene, which contributes to its vibrant color and supports eye health.', 'A popular American snack consisting of a cooked sausage, traditionally made from beef or pork, encased in a soft, elongated bun and often garnished with various condiments such as mustard, ketchup, onions, mayonnaise, relish, sauerkraut, or cheese, which is typically enjoyed at picnics, barbecues, and sporting events.', 'A delicious, mouthwatering Italian dish consisting of a round, flat base made from wheat-based dough, topped with a rich tomato sauce, a variety of melted cheeses, and an assortment of flavorful ingredients such as vegetables, meats, and herbs, all baked together to create a perfect harmony of flavors and textures that is enjoyed by people all around the world.', 'A round, sweet, deep-fried pastry with a hole in the center, often covered in glaze, icing, or powdered sugar, and sometimes filled with various flavors of cream, fruit, or chocolate, which is a popular breakfast or dessert treat enjoyed by people of all ages.', "A delectable, sweet, and often layered dessert, typically made from a combination of flour, sugar, eggs, and butter, then baked and adorned with various flavors of frosting or icing, and sometimes embellished with fruit, chocolate, or other confections, providing a delightful treat for celebrations, gatherings, or simply indulging one's taste buds.", 'A piece of furniture, typically composed of a sturdy frame with four legs, a backrest, and a cushioned or solid surface, designed to accommodate a single person in a seated position, providing comfort and support while engaging in activities such as eating, working, or conversing with others.', 'A comfortable, cushioned piece of furniture designed for seating multiple people, often found in living rooms and featuring a backrest, armrests, and a sturdy frame, typically upholstered in fabric or leather and used for relaxation, conversation, or watching television.', "A verdant, leafy organism, nestled within a compact, ornamental container, often adorning indoor spaces, providing a touch of nature's beauty and serenity, while simultaneously purifying the air and fostering a sense of well-being for those in its presence.", 'A cozy, cushioned, and comfortable piece of furniture, often adorned with soft sheets, warm blankets, and plush pillows, providing a welcoming and restful sanctuary for slumber, relaxation, and rejuvenation after a long day.', 'A large, rectangular piece of furniture, typically made of wood or glass, with four sturdy legs at each corner, designed to accommodate multiple people who gather around it to enjoy meals, engage in conversation, or partake in various activities such as board games or paperwork, often accompanied by matching chairs and adorned with a decorative centerpiece, placemats, and cutlery.', 'A porcelain fixture, typically found in a bathroom, which is connected to a plumbing system and designed for the disposal of human waste, featuring a comfortable seat, a flushing mechanism, and a drain to whisk away the waste into a sewer or septic system, ensuring cleanliness and hygiene in the household.', 'A rectangular electronic device, often mounted on walls or placed on stands, which receives audiovisual signals and displays moving images and sound, allowing people to watch their favorite shows, movies, and other forms of entertainment or informational content, while also serving as a central hub for various streaming platforms and applications.', 'A portable, compact personal computer with a clamshell design, featuring a thin screen attached to a keyboard, often equipped with a touchpad or trackpad for navigation, and powered by a rechargeable battery, enabling users to work, browse the internet, or play multimedia content on-the-go.', 'A small, furry, four-legged creature with beady eyes, large ears, and a long, thin tail, known for its ability to squeeze through tight spaces, its propensity to nibble on various items, and its role as a common household pest or adorable pet, depending on the species.', 'A small, handheld device with multiple buttons, typically used to control electronic appliances such as televisions, audio systems, and air conditioners from a distance, allowing the user to adjust settings, change channels, or manipulate volume levels without having to physically interact with the appliance itself.', 'A flat, rectangular device with numerous small, spring-loaded buttons, each bearing a letter, number, or symbol, which, when pressed, transmits a corresponding signal to a computer or other electronic device, enabling the user to input text, commands, or data.', 'A portable, handheld electronic device that allows users to make and receive calls, send text messages, access the internet, take photos, and utilize various applications for communication, entertainment, and productivity, all while being connected to a wireless network.', 'A compact kitchen appliance that utilizes electromagnetic waves to rapidly heat and cook food, often featuring a rotating plate to ensure even distribution of warmth, and equipped with various settings to accommodate different types of dishes and cooking times, providing a convenient and efficient method for meal preparation.', 'An oven is a kitchen appliance with a thermally insulated chamber designed for cooking, baking, roasting, and heating various types of food by producing and maintaining a consistent temperature, often featuring adjustable settings, a timer, and sometimes a fan to circulate hot air for even cooking results.', 'A compact, electric kitchen appliance with a built-in heating element, designed to brown and crisp slices of bread by exposing them to radiant heat, which typically features adjustable settings for varying degrees of doneness and a spring-loaded mechanism that pops the finished product up for easy retrieval.', 'A basin with a faucet and a drain, typically found in kitchens and bathrooms, used for washing hands, dishes, and other items, while the water flows out through the drain, preventing any overflow or flooding.', 'A large, insulated, electric-powered appliance with a cooling system that maintains a consistently low temperature, typically divided into two compartments for preserving perishable food items, one for chilling and the other for freezing, and often featuring adjustable shelves, door storage, and crisper drawers for organizing and extending the freshness of fruits, vegetables, dairy products, meats, and other perishables.', "A bound collection of pages filled with written or printed works, often consisting of text and illustrations, which serves as a source of knowledge, entertainment, or inspiration, and is typically organized into chapters or sections, with a cover to protect its contents and a spine that displays the title and author's name.", 'A circular, wall-mounted or free-standing device with numbered markings and moving hands that indicate the hours, minutes, and sometimes seconds, enabling people to keep track of the passage of time throughout the day.', 'An elegant, often decorative container, typically made of glass, porcelain, or ceramic, with a narrow neck and a wider body, designed to hold and display fresh or dried flowers, enhancing the beauty of any space with its intricate patterns and vibrant colors.', 'A handheld tool with two sharp, metal blades that pivot around a central point, designed to cut through various materials such as paper, fabric, or hair by opening and closing the blades with the fingers, typically using the thumb and middle or ring finger in the two round, plastic-coated holes at the end of each handle.', 'A soft, cuddly, plush toy often made of fabric or fur, resembling a cute, endearing, and huggable bear, with round, button-like eyes, a small, stitched nose, and short limbs, frequently given as a gift to children or loved ones for comfort, companionship, and to evoke feelings of warmth, love, and security.', "A compact, handheld electrical device that utilizes a heating element and a fan to emit a stream of hot air, allowing for the rapid evaporation of moisture from wet locks, thus expediting the process of drying and styling one's tresses.", "A slender, elongated instrument with a handle on one end and a cluster of bristles on the other, designed to be used in conjunction with toothpaste to clean and maintain the health of one's teeth and gums through the process of scrubbing and massaging the surfaces and crevices within the oral cavity.", 'A large, rectangular piece of fabric, often adorned with symbols, images, or text, designed to be hung or carried on a pole during events, demonstrations, or celebrations, serving as a prominent and eye-catching display of a message, cause, or affiliation.', "A large, soft, rectangular piece of fabric, often made from materials such as cotton, wool, or fleece, designed to provide warmth and comfort by covering one's body, especially while sleeping or resting on a bed, couch, or other furniture.", 'A bridge is a structure built to span a physical obstacle, such as a body of water, valley, or road, without closing the way underneath, typically designed for the passage of pedestrians, vehicles, or both, and often supported by abutments or piers on either side, providing a safe and efficient means of transportation and connectivity between two points.', 'Cardboard is a versatile, lightweight, and durable material made from layers of paper pulp that are compressed together, often used for packaging, crafting, and creating temporary structures due to its affordability, recyclability, and ease of cutting and folding.', 'A flat surface, typically waist-high, where transactions occur or items are displayed, often found in retail establishments, kitchens, and laboratories, providing a convenient area for conducting business, preparing food, or conducting experiments.', 'A floor-length piece of fabric, often adorned with intricate patterns or designs, that hangs gracefully from a rod above a window or door, providing privacy, insulation, and a touch of elegance to a room while also controlling the amount of light that enters.', 'The rectangular wooden entrance barrier, adorned with a brass handle and hinges, stands tall and sturdy, acting as a gateway between rooms, providing privacy and security while also allowing passage when swung open on its axis.', 'The surface beneath our feet, composed of sturdy, polished planks derived from trees, often found in homes and buildings, providing a warm, natural, and elegant foundation for walking, standing, and placing furniture upon.', 'A delicate, vibrant, and fragrant bloom, often used as a symbol of love, friendship, and celebration, with an array of colors, shapes, and sizes, that grows on a slender stem, surrounded by green leaves, and brings beauty, joy, and a sense of serenity to gardens, bouquets, and various special occasions.', 'A delectable, juicy, and refreshing natural treat, bursting with vibrant colors and tantalizing flavors, ranging from the sweetest nectar to the tangiest zing, encased in a delicate skin or rind, and often filled with tiny seeds, providing essential vitamins, minerals, and antioxidants, while delighting the senses and nourishing the body.', 'A mixture of small, loose, rounded or angular fragments of rock, often found on roads, driveways, and pathways, providing a stable, permeable surface that allows for efficient drainage and prevents erosion, while also serving as a cost-effective and low-maintenance alternative to paved surfaces.', 'A dwelling with a sturdy foundation, walls made of brick or wood, a sloping roof to protect from the elements, windows to let in light and air, a welcoming entrance, and multiple rooms designed for various activities such as cooking, eating, sleeping, and socializing, all surrounded by a well-tended garden or yard, providing a sanctuary and refuge for its inhabitants.', 'A radiant, ethereal, and luminous form of energy that illuminates our surroundings, enables us to perceive colors and shapes, and is responsible for the sustenance of life on Earth, as it emanates from the sun and other celestial bodies, and can be artificially produced by various sources such as lamps, candles, and fire, creating a warm, inviting, and vibrant atmosphere that dispels darkness and shadows, and has been a symbol of hope, knowledge, and enlightenment throughout human history.', 'A reflective surface, typically made of glass with a polished metal backing, that allows light to bounce off it and form an image of whatever is in front of it, often used for personal grooming, interior decoration, or scientific purposes, and can create the illusion of a larger space when strategically placed within a room.', 'A net is an interwoven or interconnected system of fibers, threads, or wires, typically arranged in a grid-like pattern, used for various purposes such as catching fish, supporting plants, or providing a barrier in sports like volleyball and tennis.', "A soft, cushioned rectangular or square-shaped object, often filled with feathers, foam, or synthetic materials, designed to provide comfort and support for one's head and neck while sleeping, lying down, or sitting, and typically encased in a removable, washable cover.", 'A platform is a raised, level surface that serves as a base or support for various activities, events, or structures, often providing stability, accessibility, and visibility to the people or objects placed upon it, while also enabling interaction, collaboration, and engagement among its users.', 'A vast expanse of level ground, often covered in grass or artificial turf, where various sports and recreational activities take place, typically marked with lines or boundaries to indicate specific areas for different games, such as soccer, football, or baseball, and surrounded by seating for spectators to watch and cheer on their favorite teams.', 'A mode of transportation consisting of a series of connected, parallel metal tracks upon which trains, powered by steam, diesel, or electricity, travel long distances while carrying passengers and cargo, often crossing vast landscapes and connecting cities, towns, and industries, and playing a significant role in the economic and social development of many countries.', 'A winding, meandering body of flowing water, bordered by lush vegetation and teeming with aquatic life, that courses through the landscape, carving out valleys and shaping the earth, providing sustenance to countless species and serving as a vital source of hydration, transportation, and recreation for human civilizations throughout history.', 'A long, winding stretch of pavement, flanked by trees and dotted with streetlights, meanders through the landscape, providing a pathway for vehicles and pedestrians to traverse the terrain, connecting cities, towns, and villages, while facilitating the flow of traffic and commerce.', 'The topmost covering of a building, typically made of various materials such as shingles, metal, or tiles, designed to provide protection from the elements, including rain, snow, and sunlight, while also providing insulation and structural support, often sloping or pitched to allow for proper drainage and to prevent the accumulation of debris.', "A seemingly infinite collection of minuscule, irregularly shaped particles, often found on beaches and deserts, that are typically composed of silica or other minerals, which can be soft and warm to the touch when sun-kissed, yet abrasive and coarse when gathered in one's hand, and are known to shift and flow with the whims of the wind, creating undulating dunes and patterns that are both mesmerizing and ever-changing.", "The vast expanse of shimmering, undulating water stretches out to the horizon, its surface dotted with white-capped waves that dance and frolic beneath an endless sky, while beneath its depths lies a mysterious, hidden world teeming with life and secrets waiting to be discovered, a realm where the sun's rays filter through the blue-green blanket, casting a dappled light on the countless creatures that call this boundless, ever-changing, and awe-inspiring aquatic domain their home.", 'A long, flat, horizontal surface, typically made of wood, metal, or glass, that is elevated and supported by brackets, designed for the purpose of holding, displaying, or storing various items such as books, decorative objects, or kitchenware, and often found mounted on walls or as part of a larger furniture piece like a bookcase or cupboard.', 'A delicate, crystalline blanket of frozen water vapor gently descends from the heavens, transforming the landscape into a serene, monochromatic wonderland, where each unique flake contributes to the soft, powdery layer that muffles sound and sparkles enchantingly in the pale winter sunlight.', 'A series of ascending or descending steps, typically constructed of wood, stone, or metal, that provide a means for individuals to move between different levels or floors within a building, often accompanied by a railing or banister for support and safety, and sometimes featuring a landing or platform at intervals to break up the climb or descent.', 'A portable shelter made of fabric or other pliable material, supported by poles and ropes, often used for camping or temporary outdoor events, providing protection from the elements and a cozy space to sleep or gather.', "A rectangular piece of absorbent fabric, often made from cotton or a blend of materials, that is designed to effectively soak up moisture from one's body or hands, and is commonly used after bathing, showering, or swimming, as well as for drying dishes and other household tasks.", 'A rectangular block made of clay, concrete, or other durable material, typically reddish-brown in color, which is used as a primary building component for constructing sturdy, long-lasting structures, and is often laid in horizontal rows using mortar to bind them together, creating a visually appealing pattern that provides both strength and aesthetic appeal.', 'A wall-stone is a solid, durable, and often rectangular-shaped piece of rock or mineral material, typically used in the construction of sturdy barriers, enclosures, or partitions, providing support, protection, and aesthetic appeal to various architectural structures, such as buildings, houses, and gardens.', 'A flat, square or rectangular piece of ceramic, porcelain, glass, or stone material, often adorned with intricate patterns or designs, that is affixed to a vertical surface, such as the interior or exterior of a building, to provide both a decorative and protective layer against moisture, dirt, and wear.', 'A sturdy, natural material derived from the trunks of trees, often used as a building component for structures or as a decorative element in interior design, providing a warm, rustic aesthetic while also offering insulation and support.', "A transparent, tasteless, odorless, and nearly colorless chemical substance, which is the main constituent of Earth's streams, lakes, and oceans, and the fluids of most living organisms, is essential for all known forms of life, even though it provides no calories or organic nutrients, and is vital for many natural and industrial processes, including being a universal solvent for thousands of compounds, and is known by its chemical formula, H2O.", 'A window-blind is a type of covering for windows that consists of horizontal or vertical slats, which can be adjusted to control the amount of light and visibility, and can be made from various materials such as wood, plastic, or metal, and is often used for privacy, insulation, and decoration purposes.', 'A transparent glass pane, often framed and set into a wall, that allows light to enter and people to see through while keeping the elements out, and can be opened or closed to regulate airflow and temperature within a room.', 'A tall, perennial, woody plant with a single, elongated trunk supporting a network of branches and leaves, providing shade, oxygen, and habitat for various creatures, while also serving as a vital component in the ecosystem and a source of timber, paper, and other essential products for human use.', 'A fence is a barrier or enclosure typically made of wood, metal, or wire, which serves to define a boundary, provide security, or prevent unwanted access to a specific area, such as a yard, garden, or property, and can be found in various heights, styles, and materials depending on its intended purpose and the aesthetic preferences of the owner.', 'The upper interior surface of a room, typically adorned with light fixtures and often painted or decorated, which forms a barrier between the living space and the floor above or the roof structure, providing both insulation and soundproofing.', 'The vast expanse above us, an ever-changing canvas of brilliant hues and patterns, is filled with the radiant light of the sun during the day, and at night, it transforms into a mesmerizing tapestry of twinkling stars, glowing planets, and the ethereal glow of the moon, all of which inspire wonder and awe in those who gaze upon it.', 'A large, rectangular piece of furniture, typically made of wood or metal, featuring shelves, drawers, or compartments enclosed by doors, and often used for storing items such as dishes, clothes, or documents, providing an organized and aesthetically pleasing storage solution within a room.', 'A flat, elevated surface, typically supported by four legs, used for placing objects upon, working, eating meals, or holding discussions, and often found in kitchens, dining rooms, offices, and various other settings.', 'The flat, horizontal surface beneath our feet that extends throughout the interior of a building or room, providing support and stability for furniture and people, and often composed of materials such as wood, concrete, or tile, is known as the foundational structure that separates different levels of a construction.', 'A flat, hard surface, typically composed of concrete or asphalt, that forms the ground covering for roads, sidewalks, and other outdoor areas, providing a stable and durable foundation for vehicles and pedestrians to traverse with ease and safety.', 'A vast, majestic landform characterized by its towering peaks, steep slopes, and rugged terrain, often capped with snow or shrouded in clouds, providing a breathtaking backdrop for diverse ecosystems, challenging hiking trails, and awe-inspiring vistas that draw adventurers and nature lovers from around the world.', 'A lush, verdant expanse of slender, green blades, rooted in rich soil, swaying gently in the breeze, providing a soft, cushioned surface for bare feet to tread upon, and a habitat for countless insects and small creatures, while releasing a fresh, earthy scent when cut or crushed.', 'A fine-grained, loose, and often dark brown or black substance composed of disintegrated rock, decomposed organic matter, and various minerals, which serves as a natural medium for the growth of plants and is commonly found covering the ground or accumulating in crevices, depressions, and other low-lying areas.', 'A thin, flat, flexible material made from wood pulp or other fibrous substances, often used for writing, drawing, or printing on, and commonly found in various sizes and colors, serving as a primary medium for communication, documentation, and artistic expression.', 'A scrumptious, mouthwatering medley of flavors and textures, expertly combined to create a harmonious symphony of taste that dances on the tongue, tantalizing the taste buds with its rich, savory, and sweet notes, while the aroma wafts through the air, enticing the senses and evoking a sense of comfort and satisfaction.', 'This towering structure, with its many floors and vast windows, stands tall amidst the cityscape, providing shelter and space for countless individuals and businesses, while its architectural design and grandeur never cease to amaze those who pass by or enter its magnificent doors.', "A naturally occurring, solid aggregate of minerals and mineraloids, often found in the Earth's crust, varying in size from tiny pebbles to massive formations, and exhibiting a wide range of colors, textures, and compositions, which has been utilized by humans throughout history for construction, tools, and artistic expression.", 'A vertical, flat, and often rectangular structure made of various materials such as brick, stone, or wood, which serves as a barrier, divider, or support, and is typically found in buildings, houses, and other constructions, providing protection, privacy, and insulation.', 'A plush, intricately designed floor covering, often made from wool or synthetic fibers, that adds warmth, comfort, and style to a room while also providing a soft surface to walk or sit on.']
