function [regret, regrets, N, N0, N1] = FRG_TSwA(T, T_range, mu, c)
% Fixed-Regret Thompson Sampling with Abstention (or FRG-TSWA)

K = length(mu);
N = zeros(K, 1);
N0 = zeros(K, 1);
N1 = zeros(K, 1);
mu_hat = zeros(K, 1);
mu1 = mu(1);
a = zeros(K, 1);
regret = 0;
regrets = [];

for t = 1 : K
    mu_hat(t) = mu(t) + randn;
    N(t) = N(t) + 1;
    if sqrt(K/t) >= c
        regret = regret + c;
        N1(t) = N1(t) + 1;
    else
        regret = regret + mu1 - mu_hat(t);
        N0(t) = N0(t) + 1;
    end
end

for t = (K + 1) : T
    for i = 1 : K
        if rand < 1 / K
            a(i) = mu_hat(i) + randn / sqrt(N(i));
        else
            a(i) = mu_hat(i);
        end
    end
    [~, At] = max(a);
    abstain = max(mu_hat - sqrt((6 * log(t) + 2 * max(log(c), 0)) ./ N)) - mu_hat(At) >= c;
    % if t >= 500 && At ~= 1 && abstain == 0
    %     abstain
    %     max(mu_hat - sqrt((6 * log(t) + 2 * max(log(c), 0)) ./ N))- mu_hat(At)
    % end
    abstain = (sqrt(K/t) >= c) | abstain;
    sample = mu(At) + randn;
    mu_hat(At) = (mu_hat(At) * N(At) + sample) / (N(At) + 1);
    N(At) = N(At) + 1;
    if abstain
        regret = regret + c;
        N1(At) = N1(At) + 1;
    else
        regret = regret + mu1 - sample;
        %regret = regret + mu1 - mu(At);
        N0(At) = N0(At) + 1;
    end
    if ismember(t, T_range)
        regrets = [regrets, regret];
    end
end
end









