repeat_num = 2000;
instance = 2;

if instance == 1
    mu = [1; 0.7 * ones(6, 1)];  c = 0.1;
elseif instance == 2
    mu = [1; 0.7 * ones(3, 1); 0.5 * ones(3, 1); 0.3 * ones(3, 1)]; c = 0.1;
end


T = 20000;
T_range = [100, 1000, 2000: 2000: T];

regrets_result = zeros(2, length(T_range));
std_result = zeros(2, length(T_range));

regret_results1 = zeros(repeat_num, length(T_range));
regret_results2 = zeros(repeat_num, length(T_range));
parfor jj = 1 : repeat_num
    rng(jj);
    [~, regret_results1(jj, :),~,~,~] = FRG_TSwA(T, T_range, mu, c);
    rng(jj);
    [~, regret_results2(jj, :),~,~,~] = FRG_TSwA(T, T_range, mu, inf);
    [jj]
end


regrets_result(1, :) = mean(regret_results1);
std_result(1, :) = std(regret_results1);
regrets_result(2, :) = mean(regret_results2);
std_result(2, :) = std(regret_results2);


Delta = mu(1) - mu(2:end);
complexity = min(Delta, c) ./ (Delta .^2);
complexity = 2 * sum(complexity);
Lower_Bound = complexity * log(T_range);



figure('Position',[0 0 450 300]);
set(gcf,'PaperPositionMode','auto');
markers = {'x', 'o', '+', 'none', '.', '*', 's'};
for i = 1 : 2
    errorbar(T_range, regrets_result(i, :), std_result(i, :)/sqrt(repeat_num), 'Linewidth', 1.2, 'Marker', markers{i});
    hold on;
end
grid;
i = 3;
plot(T_range, Lower_Bound,  'Marker', markers{i});
xlabel('$T$', 'FontSize', 16, 'Interpreter', 'latex');
ylabel('$R$', 'FontSize', 16, 'Interpreter',' latex');
legend('FRG-TSwA','Less-Exploring TS', 'Asymp. Lower Bound', 'FontSize', 14, 'Location', 'best');
%set(gca,'Xscale','log')

save(['FRG_main1_Instance',num2str(instance), '.mat']);
