clear;

repeat_num = 2000; 
instance = 2;

if instance == 1
    mu = [1; 0.7 * ones(6, 1)];  c_range = [0.1:0.05:0.5]; 
elseif instance == 2
    mu = [1; 0.7 * ones(3, 1); 0.5 * ones(3, 1); 0.3 * ones(3, 1)]; c_range = 0.1:0.05:0.8;
end

T = 10000;
T_range = [1000, 5000];


regret_result =  zeros(length(c_range), 1);
std_result = zeros(length(c_range), 1);


for ii = 1 : length(c_range)
    c = c_range(ii);
    regret_results = zeros(repeat_num, 1);
    parfor jj = 1 : repeat_num
        rng(jj);
        regret_results(jj) = FRG_TSwA(T, T_range, mu, c);
        [c, jj]
    end
    regret_result(ii) = mean(regret_results);
    std_result(ii) = std(regret_results);
end


figure('Position',[0 0 450*2 300*2]);
set(gcf,'PaperPositionMode','auto');
markers = {'x', 'o', '+', 'none', '.', '*', 's'};
for i = 1 : 1
    errorbar(c_range, regret_result(:, i), std_result(:, i)/sqrt(repeat_num), 'Linewidth', 1.2, 'Marker', markers{i});
    hold on;
end
grid;
% plot(c_range, no_abstain * ones(length(c_range), 1));
xlabel('$c$', 'FontSize', 16, 'Interpreter', 'latex');
ylabel('regret', 'FontSize', 16, 'Interpreter',' latex');

save(['FRG_main2_Instance',num2str(instance), '.mat']);

