function [regret, regrets, N, N0, N1] = FRW_UCBwA(T, T_range, mu, c)
% Fixed-Reward Algorithm with Abstention (or FRW-ALGWA)
% Base Algorithm: KL-UCB++



K = length(mu);
N = zeros(K, 1);
N0 = zeros(K, 1);
N1 = zeros(K, 1);
mu_hat = zeros(K, 1);
mu1 = max(mu(1), c);
a = zeros(K, 1);
regret = 0;
regrets = [];


log_plus = @(x) max(log(x), 0);
g = @(n) log_plus((T ./ (K .* n)) .* (log_plus((T ./ (K .* n))).^2 + 1));



for t = 1 : K
    mu_hat(t) = mu(t) + randn;
    N(t) = N(t) + 1;
    regret = regret + mu1 - mu_hat(t);
    N0(t) = N0(t) + 1;

end

for t = (K + 1) : T
    for i = 1 : K
            a(i) = mu_hat(i) + sqrt(2 * g(N(i)) / N(i));
    end
    [~, At] = max(a);
    abstain = mu_hat(At) <= c;
    % if t >= 500 && At ~= 1 && abstain == 0
    %     abstain
    %     max(mu_hat - sqrt((6 * log(t) + 2 * max(log(K * c), 0)) ./ N))- mu_hat(At)
    % end
    sample = mu(At) + randn;
    mu_hat(At) = (mu_hat(At) * N(At) + sample) / (N(At) + 1);
    N(At) = N(At) + 1;
    if abstain
        regret = regret + mu1 - c;
        N1(At) = N1(At) + 1;
    else
        regret = regret + mu1 - sample;
        %regret = regret + mu1 - mu(At);
        N0(At) = N0(At) + 1;
    end

    if ismember(t, T_range)
        regrets = [regrets, regret];
    end
end
end









