clear;
close all;

load FRG_main2_Instance1.mat
figure('Position',[0 0 300 250]);
set(gcf,'PaperPositionMode','auto');
LineStyles = {'-', '-', '-', '-'};
markers = {'.', 'none','none', 's', 'none', '+', '.', '*', 's'}; 
markers_size = {12, 6, 6};
widths = {1, 1, 0.8};
colors = {'#00693E', '#C04000', 'yellow','cyan'};
for i = 1 : 1
    h{i} = errorbar(c_range, regret_result(:, i), std_result(:, i)/sqrt(repeat_num), 'CapSize', 4, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
    hold on;
end
grid;
ax = gca;
ax.FontSize = 13;
%xlim([1 10.2]);
%xticks([25 100 500 1000 2000]);
%xticklabels({'25','10^2', '5\times10^2', '10^3', '2\times10^3'});
xlabel('$c$', 'FontSize', 16, 'Interpreter', 'latex');
ylabel('Regret', 'FontSize', 16, 'Interpreter',' none', 'fontname','Times New Roman');
saveas(gcf,['FRG_main2_Instance',num2str(instance), '.eps'],'epsc');

%%
clear;
close all;

load FRG_main2_Instance2.mat
figure('Position',[0 0 300 250]);
set(gcf,'PaperPositionMode','auto');
LineStyles = {'-', '-', '-', '-'};
markers = {'.', 'none','none', 's', 'none', '+', '.', '*', 's'}; 
markers_size = {12, 6, 6};
widths = {1, 1, 0.8};
colors = {'#00693E', '#C04000', 'yellow','cyan'};
for i = 1 : 1
    h{i} = errorbar(c_range, regret_result(:, i), std_result(:, i)/sqrt(repeat_num), 'CapSize', 4, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
    hold on;
end
grid;
ax = gca;
ax.FontSize = 13;
xlim([0.1 0.8]);
%xticks([25 100 500 1000 2000]);
%xticklabels({'25','10^2', '5\times10^2', '10^3', '2\times10^3'});
xlabel('$c$', 'FontSize', 16, 'Interpreter', 'latex');
ylabel('Regret', 'FontSize', 16, 'Interpreter',' none', 'fontname','Times New Roman');
saveas(gcf,['FRG_main2_Instance',num2str(instance), '.eps'],'epsc');
