clear;
close all;

load FRW_main1_Instance1.mat
figure('Position',[0 0 300*1.6 250*1.6]);
set(gcf,'PaperPositionMode','auto');
LineStyles = {'-', '-', '-', '-', '-'};
markers = {'.', 'none','*', 's', 'none', '+', '.', '*', 's'}; 
markers_size = {8, 6, 6, 4, 6};
widths = {1, 1, 1, 1, 0.8};
colors = {'#00693E', '#C04000','cyan', 'blue', 'yellow'};
for i = 1 : 4
    h{i} = errorbar(T_range, regrets_result(i, :), std_result(i, :)/sqrt(repeat_num), 'CapSize', 4, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
    hold on;
end
grid;
ax = gca;
ax.FontSize = 13;
%xlim([1 10.2]);
%xticks([25 100 500 1000 2000]);
%xticklabels({'25','10^2', '5\times10^2', '10^3', '2\times10^3'});
i = 5;
h{5} = plot(T_range, Lower_Bound, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
legend([h{1}, h{2}, h{3}, h{4}, h{5}], 'FRW-TSwA', 'FRW-UCBwA','Less-Exploring TS', 'KL-UCB⁺⁺', 'Asymp. Lower Bound', 'FontSize', 15, 'Interpreter','tex', 'Location', 'southeast','fontname','Times New Roman');
xlabel('$T$', 'FontSize', 15, 'Interpreter', 'latex');
ylabel('Regret', 'FontSize', 18, 'Interpreter',' tex', 'fontname','Times New Roman');
saveas(gcf,['FRW_main1_Instance',num2str(instance), '.eps'],'epsc');


%%
clear;
close all;

load FRW_main1_Instance2.mat
figure('Position',[0 0 300*1.6 250*1.6]);
set(gcf,'PaperPositionMode','auto');
LineStyles = {'-', '-', '-', '-', '-'};
markers = {'.', 'none','*', 's', 'none', '+', '.', '*', 's'}; 
markers_size = {8, 6, 6, 5, 6};
widths = {1, 1, 1, 1, 0.8};
colors = {'#00693E', '#C04000','cyan', 'blue', 'yellow'};
for i = 1 : 4
    h{i} = errorbar(T_range, regrets_result(i, :), std_result(i, :)/sqrt(repeat_num), 'CapSize', 4, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
    hold on;
end
grid;
ax = gca;
ax.FontSize = 13;
%xlim([1 10.2]);
%xticks([25 100 500 1000 2000]);
%xticklabels({'25','10^2', '5\times10^2', '10^3', '2\times10^3'});
i = 5;
h{5} = plot(T_range, Lower_Bound, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
xlabel('$T$', 'FontSize', 15, 'Interpreter', 'latex');
ylabel('Regret', 'FontSize', 18, 'Interpreter',' tex', 'fontname','Times New Roman');
saveas(gcf,['FRW_main1_Instance',num2str(instance), '.eps'],'epsc');


