clear;
close all;

load FRW_main2_Instance1.mat
figure('Position',[0 0 300*1.6 250*1.6]);
set(gcf,'PaperPositionMode','auto');
LineStyles = {'-', '-', '-', '-', '-'};
markers = {'.', 'none','*', 's', 'none', '+', '.', '*', 's'}; 
markers_size = {8, 6, 6, 5, 6};
widths = {1, 1, 1, 1, 0.8};
colors = {'#00693E', '#C04000', 'yellow','cyan'};
for i = 1 : 2
    h{i} = errorbar(c_range, regret_result(:, i), std_result(:, i)/sqrt(repeat_num), 'CapSize', 4, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
    hold on;
end
grid;
ax = gca;
ax.FontSize = 13;
%xlim([1 10.2]);
%xticks([0.5:0.1:1.2]);
%xticklabels({'25','10^2', '5\times10^2', '10^3', '2\times10^3'});
legend([h{1}, h{2}], 'FRW-TSwA', 'FRW-UCBwA', 'FontSize', 18, 'Interpreter','tex', 'Location', 'southwest','fontname','Times New Roman');
xlabel('$c$', 'FontSize', 15, 'Interpreter', 'latex');
ylabel('Regret', 'FontSize', 18, 'Interpreter',' none', 'fontname','Times New Roman');
saveas(gcf,['FRW_main2_Instance',num2str(instance), '.eps'],'epsc');

%%

clear;
close all;

load FRW_main2_Instance2.mat
figure('Position',[0 0 300*1.6 250*1.6]);
set(gcf,'PaperPositionMode','auto');
LineStyles = {'-', '-', '-', '-', '-'};
markers = {'.', 'none','*', 's', 'none', '+', '.', '*', 's'}; 
markers_size = {8, 6, 6, 5, 6};
widths = {1, 1, 1, 1, 0.8};
colors = {'#00693E', '#C04000', 'yellow','cyan'};
for i = 1 : 2
    h{i} = errorbar(c_range, regret_result(:, i), std_result(:, i)/sqrt(repeat_num), 'CapSize', 4, 'Linewidth', widths{i}, 'LineStyle', LineStyles{i}, 'Marker', markers{i},'MarkerSize', markers_size{i});
    hold on;
end
grid;
ax = gca;
ax.FontSize = 13;
%xlim([1 10.2]);
%xticks([0.5:0.1:0.9]);
%xticklabels({'25','10^2', '5\times10^2', '10^3', '2\times10^3'});
xlabel('$c$', 'FontSize', 15, 'Interpreter', 'latex');
ylabel('Regret', 'FontSize', 18, 'Interpreter',' none', 'fontname','Times New Roman');
saveas(gcf,['FRW_main2_Instance',num2str(instance), '.eps'],'epsc');
