cd /.../.../.../fastchat/
mkdir /.../.../.../model/
mkdir /.../.../.../lora/
hdfs dfs -get ....../home/.../.../user/.../debug/gemma-2b/deepseek-coder-1.3b-base /.../.../.../model/
hdfs dfs -get ....../home/.../.../user/.../metadata/generate/.../filter_empty/..._final.parquet.jsonl /.../.../.../




if [ -z "$LORAFILE" ]; then
  echo "LORAFILE is not defined. Setting default value: "
  LORAFILE=""
  LOAD_PEFT_PATH=""
else
  echo "Downloading LORAFILE: ${LORAFILE}"
  hdfs dfs -get ${LORAFILE} /.../.../.../lora/
  LOAD_PEFT_PATH=$(ls -d /.../.../.../lora/*/)
fi

echo "LOAD_PEFT_PATH = ${LOAD_PEFT_PATH}"


pip3 install trl==0.9.6

if [ -z "$CODEFILE" ]; then
  echo "CODEFILE is not defined. Setting default value: code.dpo.fromlora.py."
  CODEFILE="code.dpo.fromlora.py"
fi


if [ -z "$RUN_CMD" ]; then
  echo "RUN_CMD is not defined. Setting default value."
  RUN_CMD="python3"
fi

echo "Debug: OTHER value is: '$OTHER'"
if [ -n "${OTHER+x}" ]; then
    echo "OTHER is defined. Using its value."
    read -ra OTHER_ARGS <<< "$OTHER"
else
    echo "OTHER is not defined. Initializing as empty array."
    OTHER_ARGS=()
fi
if [ ${
    echo "No additional arguments provided."
else
    echo "Additional arguments: ${OTHER[*]}"
fi

echo "Running command: $RUN_CMD fastchat/train/${CODEFILE}"
$RUN_CMD fastchat/train/${CODEFILE} \
    --dataset_name=/.../.../.../..._final.parquet.jsonl \
    --my_task_name="deepseek-coder-1.3b-base-code-dpo-fromlora" \
    --model_name_or_path=/.../.../.../model/deepseek-coder-1.3b-base \
    --load_lora_local_path=${LOAD_PEFT_PATH} \
    --per_device_train_batch_size 1 \
    --learning_rate 1e-6 \
    --gradient_accumulation_steps 8 \
    --logging_steps 10 \
    --do_eval=True \
    --evaluation_strategy="steps" \
    --eval_steps 300 \
    --output_dir="codedpo_epoch10" \
    --warmup_steps 150 \
    --report_to wandb \
    --logging_first_step \
    --no_remove_unused_columns \
    --bf16 \
    --num_train_epochs=10  \
    --max_prompt_length=512 \
    --max_length=2048 ${OTHER[@]} 2>&1 | tee code.dpo.run.log




