import os
import re

valid_extensions = ['.sh', '.py']

processed_files = []
def remove_comments(file_path):
    try:
        with open(file_path, 'r', encoding='utf-8') as file:
            content = file.readlines()
        new_content = []

        for line in content:
            stripped_line = line.strip()
            if stripped_line.startswith('#'):
                continue

            line = re.sub(r'#.*', '', line)

            new_content.append(line.rstrip() + '\n')

        with open(file_path, 'w', encoding='utf-8') as file:
            file.writelines(new_content)

        processed_files.append(file_path)
        print(f"Processed: {file_path}")

    except Exception as e:
        print(f"Error processing {file_path}: {e}")

def traverse_and_process(root_dir):
    for root, dirs, files in os.walk(root_dir):
        if '.git' in dirs:
            dirs.remove('.git')

        for file in files:
            file_path = os.path.join(root, file)
            if any(file.endswith(ext) for ext in valid_extensions):
                remove_comments(file_path)

if __name__ == "__main__":
    root_directory = ''
    traverse_and_process(root_directory)
    if processed_files:
        print("\nFiles processed:")
        for file in processed_files:
            print(file)
    else:
        print("No files were processed.")
