# PC++: Binarizing Vision Transformers with Generalized Conditional Gradient

* requirement: pytorch 1.7.1, timm 0.6.1

Here we provide the training and evaluation code for ProxConnect++ algorithms in both fine-tuning and end-to-end training on CIFAR-10/100 and ImageNet.

We evaluate two kinds of vision transformer models: DeiT (without knowledge distillation) and ViT.

Models are built based on timm implementation on vision transformers. We keep the original code from Facebook for running such methods.


### Exemples of command lines

note that we always use main_prox++.py file for all experiments, which will automatically train and evaluate the model.

(1) fine-tuning tasks

example: if we are running PC on CIFAR-10 for DeiT-B:

``` python

$ python main_prox++.py --method='PC' --model='deit_base_patch16_224' --finetune='https://dl.fbaipublicfiles.com/deit/deit_base_patch16_224-b5f2ef4d.pth' --batch-size=100 --lr 0.001 --epoch=100 --min-lr 1e-6 --output_dir 'directory to store your results'  --data-set 'CIFAR10' --data-path 'your data path'

```

(2) end-to-end training tasks

example: if we are running BNN+ on ImageNet for DeiT-B

``` python

$ python main_prox++.py --method='BNN+' --model='deit_base_patch16_224' --batch-size=100 --lr 0.001 --epoch=100 --min-lr 1e-6 --output_dir 'directory to store your results'  --data-set 'IMNET' --data-path 'your data path'

```



