import torch.nn as nn

class Prunable(nn.Module):
    def __init__(self, module):
        """
        :param torch.nn.Module module: Prunable module.
        """
        super().__init__()
        self._module = module

    @property
    def module(self):
        return self._module

    def forward(self, *args, **kwargs):
        return self._module(*args, **kwargs)
