import time

import cas_dt
import main

def cross_validation(sample,label,file_name,thres=0.8):
    cutoff = int(len(sample) * thres)
    interval = len(sample) - cutoff
    print "cutoff", cutoff
    print "current file",file_name


    training_set0 = sample[:cutoff]
    testing_set0 = sample[cutoff:]
    training_label0 = label[:cutoff]
    testing_label0 = label[cutoff:]
    
    start = time.time()
    clf_buffer = cas_dt.cascading_dt_training(training_set0,training_label0)
    main.cas_test(clf_buffer,testing_set0,testing_label0,start)
    
    start = time.time()
    clf = cas_dt.decision_tree(training_set0,training_label0)
    main.test(clf,testing_set0,testing_label0,start)
    
    start = time.time()
    clf = cas_dt.decision_tree(training_set0,training_label0,2)
    main.test(clf,testing_set0,testing_label0,start)


    training_set1 = sample[:(len(sample) - interval*2)] + sample[len(sample) - interval*1:]
    testing_set1 = sample[(len(sample) - interval*2):(len(sample) - interval*1)]
    training_label1 = label[:(len(sample) - interval*2)] + label[len(sample) - interval*1:]
    testing_label1 = label[(len(sample) - interval*2):(len(sample) - interval*1)]
    
    start = time.time()    
    clf_buffer = cas_dt.cascading_dt_training(training_set1,training_label1)
    main.cas_test(clf_buffer,testing_set1,testing_label1,start)
    
    start = time.time()
    clf = cas_dt.decision_tree(training_set1,training_label1)
    main.test(clf,testing_set1,testing_label1,start)
    
    start = time.time()
    clf = cas_dt.decision_tree(training_set1,training_label1,2)
    main.test(clf,testing_set1,testing_label1,start)
    
    
    
    training_set1 = sample[:(len(sample) - interval*3)] + sample[len(sample) - interval*2:]
    testing_set1 = sample[(len(sample) - interval*3):(len(sample) - interval*2)]
    training_label1 = label[:(len(sample) - interval*3)] + label[len(sample) - interval*2:]
    testing_label1 = label[(len(sample) - interval*3):(len(sample) - interval*2)]
    
    start = time.time()    
    clf_buffer = cas_dt.cascading_dt_training(training_set1,training_label1)
    main.cas_test(clf_buffer,testing_set1,testing_label1,start)

    start = time.time()
    clf = cas_dt.decision_tree(training_set1,training_label1)
    main.test(clf,testing_set1,testing_label1,start)
    
    start = time.time()
    clf = cas_dt.decision_tree(training_set1,training_label1,2)
    main.test(clf,testing_set1,testing_label1,start)
    

    training_set1 = sample[:(len(sample) - interval*4)] + sample[len(sample) - interval*3:]
    testing_set1 = sample[(len(sample) - interval*4):(len(sample) - interval*3)]
    training_label1 = label[:(len(sample) - interval*4)] + label[len(sample) - interval*3:]
    testing_label1 = label[(len(sample) - interval*4):(len(sample) - interval*3)]
    start = time.time()    
    clf_buffer = cas_dt.cascading_dt_training(training_set1,training_label1)
    main.cas_test(clf_buffer,testing_set1,testing_label1,start)
    
    start = time.time()
    clf = cas_dt.decision_tree(training_set1,training_label1)
    main.test(clf,testing_set1,testing_label1,start)

    start = time.time()
    clf = cas_dt.decision_tree(training_set1,training_label1,2)
    main.test(clf,testing_set1,testing_label1,start)


    
    training_set2 = sample[interval:]
    testing_set2 = sample[:interval]
    training_label2 = label[interval:]
    testing_label2 = label[:interval]
    
    start = time.time()           
    clf_buffer = cas_dt.cascading_dt_training(training_set2,training_label2)
    main.cas_test(clf_buffer,testing_set2,testing_label2,start)

    start = time.time()
    clf = cas_dt.decision_tree(training_set2,training_label2)
    main.test(clf,testing_set2,testing_label2,start)

    start = time.time()
    clf = cas_dt.decision_tree(training_set2,training_label2,2)
    main.test(clf,testing_set2,testing_label2,start)
