(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    411650,       6886]
NotebookOptionsPosition[    407409,       6807]
NotebookOutlinePosition[    407817,       6823]
CellTagsIndexPosition[    407774,       6820]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "4", ",", "3"}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.915777337517582*^9, 3.9157773452356205`*^9}, {
  3.915777549352072*^9, 3.915777572771406*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"cf053ff2-817a-484c-963d-f130e2bd0d68"],

Cell[BoxData[
 RowBox[{
  RowBox[{"relu", "[", "x_", "]"}], ":=", 
  RowBox[{"Max", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "x"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.915777502120985*^9, 3.915777519252323*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"5c2e3a53-edda-ea41-a39f-05f00495a98f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"t_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "t"}], "+", 
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"[", "3", "]"}], "]"}], "s"}]}]}]], "Input",
 CellChangeTimes->{{3.9157772713501644`*^9, 3.9157773072845993`*^9}, {
  3.915777347987154*^9, 3.915777356334095*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"b4aa38f3-10e8-d540-82c9-a73544e5a8fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"t", ",", "s"}], "]"}], ",", 
     RowBox[{"relu", "[", 
      RowBox[{"f", "[", 
       RowBox[{"t", ",", "s"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.915777310736372*^9, 3.9157773263515053`*^9}, {
  3.915777522827511*^9, 3.915777565542572*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"1cce3096-0e19-ae4a-ae3b-a7215f973478"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJzFnXu8HUWV70/eCQmQBxAIrwDHyDgOIjCZwQ9jbRUwR9HLOHMdxRfDAL44
mEFGGa9KLo6Oo6Bw8DqAr0xkuCiKmSiHRxi6PSIaE2QngdDJCaGTdJJO2Akn
DwOBkH0PXeu3KuvXuy76+dz53P3PTn9Tp3f1r6tWrVpdtfqkSz7xrstGdnV1
7ZjY1TVq+Pukp97x03b72QTfD02+al27fVJ6+dULb+3vfUb5jf2H3NI7ODP9
4cRp83oHNysfuO/87/f3npjuWPAPl3f3bFB+6ehrjurrPj69rDrPoPKxF/7g
X3oHZ0j5Fcrv/Naa/XP6jhY+oPxtWybO7e45Ku2SD3jrjL/Y2G5PQ3kH/vXP
X/nuwf4pOL/yS77hbu4dPAz1UX7HHy/4x+6eQ1B/5c8MjL54sH8Mrlf56y76
8Pl93SOgj/LNG25+b1/3PtRb+dwp753V1TWk1wNdj73h9j/q6w4643v1ZZ95
pN0+UXUG/x//cdfZg/3Hq87gx7+09kf9vceqzuDJnMNm9nUfozqDex2OUp3B
R+dzx/b0HaE6g3t9pqrO4DfuuGN1u3246gz+xBcnpP29E1Vn8BnHX3FH7+BY
1Rn8gz/77fXdPSNVZ/Bz//WSzf29L6J+ypf98tU/7e7ZpTqD/6hc3T64/UG/
ayY8eXV3z0zVGfzmDz79/u6eE1RnfP/pDyc32+1jVWfwJ3/3prcM9h+jOoP/
45s+2d/fO111Bj+uur9Hqs7gD2VPfLt3cKrqDH5x97jJPX2TVWdwf18mqc7g
PZ9e2Wq3x6nO4F87bPbK/t5RqjP47W9//ScH+19CPZS/9jN7XU/fHtUZ/CN/
+eljrgz9XPnQ/WOXzTqof0KnH1T/f4LqDH7B35y7e07fcaozuP+ekdrjDdKu
pqvO4Ge8IbtgsP9I1Rnctze1A8o/vfwNZ/Z1T1Gd7XkOVZ1t+QmqM/iDH/nO
MT19o1VncDmt6gz+L6f9clnv4F7VGfzkB444897Qz5Vfetobb31VsIPKr57+
4zNPOch+QY+/E7sKncFhV6EzuLWrG5TDruIY39aurlD+NWNXB5TDrkJncGtX
Bxz4NrGr0BkcdhU6g28RuwqdwWFXoTN43r5m2b3BDirvur7oOjmME8pbv7x7
8xUH2XdcN+yqbc8rklTsqm3PK8iublAOu2rb8wqyqyuUW7s6oBx21bbnFckx
xq6iPa9Qu2rb8wq1q7Y9r0h+K3bVtucVyY/Frtr2vGK4/c+/98uvvfkh255X
JGd+YMqjp4RxVPnkeb84Zvj8pPNAskrsqtV5QO2q1XlAxs0jSeeB5D/Frlqd
B5IPGbu6Qrm1qwPKYVetzgPJDcauQueBZIHYVavzQPLHYletzgNqV63OA8k2
satW54HkmXLL5feEcVT55f+69ZiD/Azlf/Sd16U3de9TnXEdsKvQGfxMsavQ
GdzaVbV3XbCr2q/kY+3qCio/QXUGh13t6vxRnQFgV6EzeLfYVegMfoXYVegM
PlfsKnQGv/O0C7oO8jOULysvPnP4d1Vn8Dc/8K3L2+02t2cHu0rt2W0Xu0rt
2Vl/Vduz+1vrryr/d2NXtT07a1e1PTvYVWrPztpVbc8OdpXas9sodpXas9v1
VW9XqT27bWJXqT273rP67pjTt4fbs9s05tHVa/pf4vbs7n7mC18a7ncNss9u
lNhVss8OdpXss7vJ2FW1z478VeXWrqp9dtauqn1254tdJfvsrF1V++xgV8k+
D7evvLKrZJ/d68Sukn12h4ldJfvsvvSXBy4Yrg/pvMJde9NxjeH6N8g+uze8
cP97h6+3Qf6Gg10lf8PBXyV/w1m7qv6Gm2P9VeXXG7uq/oazdlX9DQd/FTqD
W7uq/oYrxa6Sv+FKsavkb7hLxK6Sv+FOFbtK/oa78M/u2XdT94gG+Rtu0vx3
TRvujw3yN9yvxg+9drj/Unve4GBXyX92Z4ldJf/ZXWPsqvrPjvxV5W3/SWx7
3uCsXVX/2c0Su2rb8wZn7Wro97Cr5D+7O8Sukv/sfiN2lfxn9yaxq+Q/u7Xn
PbNsTt/oBvnP7pa7v7z5pu4J1J43uL+ePqtrWLcGzQfdxWJXaT7o4K/SfJDs
avCDTrP+qvLC2FWdD7orjV0N4zz8Veis49L1B9vVgaCH2FXorOcXu0rzQbWr
0AUcdpXmg+5jf33S/OF+2qD5oJv1nw/dP6dvUoPmg25o6t1b5/RNblB8wz0u
dpXiGw5xAIpvkF3V+IYjf1X5MmNXNb7hfmTsqsY3Xh6373vZrkJn8NONXdX4
hjtc7Cp0BoddpfiG+7zYVegMDrtK8Q2395K/+eSwPqozvhct3XP98DjVoPiG
mz2j56+GxzXVGf//VrGrFK9z8FcpXkd2VeMl7jXWX1V+qbGrYZ6aG7uq8QC1
q9BZz2PsapiHwV+FzuCwqxSvU7sKncFhVyle577w9zecP9zfVWfwmb1Hnj7s
d6nO+P7cScWDw35a4+FTr5012L89wfeqf3syb7dnptAffPs7J47u6TsplWMH
/t2Pp1f0de9UXcB/Peb8O/q6tyZ0fvf633xvSX/vOD6/u6HyDyfw+d2P3vKT
n7fbU1BPrf87f/XZTw2P11p/nO9//90bF/f3hnqC475TeYf4J9XfrfnOUeP7
uqc1dl23+YrewR0Jvt+2+van29eelMqxA//yQ9f39PQNJVTePTj/7PcN9o/j
8u4bi3qSdju0c/zdqp+88e+7l4Tz4//hX6Ec6gv/Dcf4ux996HMb5vSF+uM8
fh50EpdP/vqIz/5jT18rofq4bS/M/7fewfFcH+mv0xq+9Q8l9rura+1wYw7z
r8Dvexnr/Cvwb3T39IX5V+BPV+cZrPFvVuVX1PhtFR+ocf9Z+CDzr/jyjvnX
/Plr/Elfnxq/0de/xn/mr7fGM69PjctxjCdW16Azc+jMHDozh87MoTNz6Mzc
fxY+yBw6M4fOzKEzc+jMHDozh86d6zkU44ltp0Fn5jhmDp2ZQ2fm0Jk5dGYO
nZlDZ+bQmTl0Zg6dmUNn5tC5cz2HYjyx/T7ozBx/zxzHzKEzc+jMHDozh87M
oTNz6MwcOjOHzsyhM3Po3LmeQ8q/TPbL2tGgM3PozBznZY5j5tCZOXRmDp2Z
Q2fm0Jk5dGYOnZlDZ+bQGXyOHSeULyL7bseloDNz6MwcOjPH7zHHMXPozBw6
M4fOzKEzc+jMHDozh87MoTP4tXYcVe7Pu0t1tuN80Jk5dGYOnZlDZ+aoB3Mc
M4fOzKEzc+jMHDozh87MoTP4/fL30Bm8VYVJnlWdwYcn+8P/2Ef+B/wm9usC
t/Y9cGunArf9LXDbPgK31xm4PQ7c+nWBW78ucOvXBW79uoUPXi1/b/26hQ/+
RvS1ft3CB39cldurOoO/5ONUqrOtb9CZOXRmDp2ZQ2fm0Jk5dGaOejPHMXPo
zBw6g79bvqEz+J2iL3QGP+7lr749qjP4pS8X639JdQZfU5Ub1YDO9v4HnZlD
Z+bQmTl0Zg6dmUNn5tCZOa6HOY6ZQ2fwL4i+0Nnen12qM/iK6u9fVJ3Bb6i+
R0JP5fdUfz9Wdbb9KejMHDozh87MoTNz6MwcOjOHzsyhM3NcJ/iD8v0kfQ+J
XYXO4G8Suwqdwc+t+IgGdAb/SNWex6jO4P68h6jO1j4FnZlDZ+bQmTl0Zm7H
4w01nZlDZ+bQGRx2FTqDLyNdwH8idhXH+H5e7Cp0Bp9Z2Y3RqjO413+C6gx+
RaX/oaqztfdBZ+bQmTl0Zg6dmUNn5tCZOXQGv5DsMvgd1M/BYVehM/hlYleh
i22/oxo4xveLlfzjVGfwE6vzT1KdwavT9k1Wne34GXRmDp2ZQ2fm0Jk5dGYO
nZlDZ/B5NG6B/4vYVegMDrsKna19HdmAzuCLxK5CL/BV1fdE1RnfL1T6H646
g99UnXeq6oz/Z52ZU7yupjNzitfVdGZO8TrXNHZX43XSr58lf2LInSd2leJ1
7q1iVyleJ/16TIPidWpXKV4n7fSwBsXr5DxTVGf7fUTD//92N6tq34X6596/
3upGVke5cpQHv7P6vaUO5R+o6rEq6arqucid7M/rNvpyep79lU5PuwW+nHKU
B/+mP5+0r1XuOjkvnwf8+1IflF8px5Pl/1fS/+M8+HucDxzlwb8tf4f6ob58
HvBb5O9RHjpBH+gCXXGeK/1xgu8u8xmqcfx9pHyNo/zbfH1qnONgqDe3E7S3
WPuJxX9Qfq7ogN/l8tCR2yHaP3PUhznqw/ET/C7a7dHye/hdbc/0u8xRPhY3
QPkbpf2gPrj/a6V9oZ1xf4EdiPWj2Pwa5dEOUU+Uf5fYqUXUrnEe2CXmtv/U
56EoP6Njvwrl0b+4X8NOMkd9mKM+PI/D9aL82aI76oPfP0rK4RjfXB/mOI7N
a/D/t5Adw3dO9ovt0lfo/oCjfMz/R/n5dD0o/x45L+4T2z3cJ+YoH/OTUX6m
1A/15PJol2w/0S6Zoz7MUR/2M1dSe3+D3HfUB/1vMo1Pap+pPsxRPuZ3ofyN
1K9gb0rRCXaZ7b//DNU47Ahz2J1YeTlf7bpQfqHoZe3LkJsr9xXl8H2gqv+U
hv29Ieeb19SGHW/C80EqXxsXYuMR7PbD0n6hL677ym47H8N93kB2Fe00kfOg
n6DfXCXfKIf2w/1Uny+RfUR7mCvnIR34/qqec6rrmdbwp9vhnqr+sVH8qAXu
69X3NndVVf4p1efj1fEm91D1d48k1/hv8SvXu0X+75MfnuLP4+eRq93S6vyL
tT7eb31M/x/nQTmcb76cB+fF7+M8qAeuY56cB8ef8OVp3Gy5t/vzK/dxxy3u
Al8f5dAB/EKpH8qfWp3v8WSe1BP1G139dVPPs9rrq7qB4zqf8eetlQe/WH73
Y/5+SLtZoDr4efzj7m65fnDoC476ozzuA3TGMf4f58Hf43zgS6leXB58rpRD
vXF9KI/rhK7guO/g0AHlcX+gP/TFfcZ5cD/QLrhfoP3Pp/YT8zO5naDf4veh
J+5vzJ/h+4VxBDrjPNA5Nj6ybrb9BTsAe4vrS+X89/rjBN8oj3LMcV7uX7gf
3L9gp5ijfOy5JPcL6Il29AjZEe4X8D+Yo3wsbs/tGfqj3f5afhftk9uz/yx8
kDnKs/8Afbl9wr4wxzG+fXgvxDH4fqE/qJ0nzvMgjBOx8hgX5kr7xX3keRDK
g2NejPbK4ws4twf0u9h4BJ3AoS9z3FfcB+a4b+Dob1weHO3q42QH0V4wHqG9
8TwC5cFnyTfsL4+b4NxuYU9i4yy+weF/MMf1oJ8xZ78a9eby4Gj/sNuql9w3
tB/oy/42yoOj/cAusD8Azv0LdjLmP6D9gsNfZW77YfAnwUdUR6Vy2w/r/hj+
rvqZvmkNKl+ztzE7jP61R9olzgt7m8t9Bkd/h78NfbnfQS8e76Avc9sOFj6I
eR/GNW63aH88DqJ9Mkf7RjvE+TGu8X3H/eXxEfeXOXSP2WG+j9QeXCVX7zSd
p0D/eVJvjIOwY41TbPuGbtfJ9aH/oH+Mkf4Pjnb9HdEX4x10gv8A/aHbP8k3
9MV9G01+JOwc5vWoH9oF/C5cP7d/lOP4Fe47xzdwv3j+i2Nc7/tEX9xv8Gmi
I34X9uBUsb+wk7iuD8p50N7AEZ9BPWGnT5fz4Py4L0vlfuA+gr9D/g7ngc7L
pDyuH/xCKY/rRTu9Xa4T7RXX9X7UQ64L9x/PszBeoP4XS3lcJ98XtA/maG/c
32Hn+T6inzNHu+J+jd/j+475NnP4t537b0vzWqw8cvk5fd0z0y5pl1jH7fdj
nqjc5rs4QXhB5Y9XbssfJzyn8scqt+VnCM+o/DHKbfmjhTe1vN+nP125LY98
KSmVP1K5LY+8H6mz9Zmi3JafjN/V8j5vyeHKUd7nf5iE66LyE5Xb8uOhG5Uf
p9yWxz7igsqPUm7Ld+G+a3m/76adgKO831+2T3iLyj+n3JbfCa55P/x+SbSr
kjjaT0Ec7SQnjvaQEcd9bxLX+0sceUhSze/h8xscqvfR8gl6vywfo/fFcuw7
LpTPq/ZJvaA6W75L9dT96KecPW+Ozr9bum/J7++AbiVx6FYQh245ceiWEYdu
TeKqG3H0i1TzePh98dCtqdzvN4FuGXHoliv3+6Cwv7ggvlv1BPf7KzernuCn
fv8Lj/5M460t3e/l7STsVUkcdqkgDvuTE4edyYhPUz0tVzuj3NsZ5BVJneVj
VU/LR6qe4L6/70+gp+V7VE9w33+3qp7gfp/gCtUTfP55T112n45vLd0n5/ff
QbeSOHQriEO3nDh0y4hDt6Zy3w5VN+KHqJ7gfj8mdGsq9+32pQR6gvv2+TvV
k/ZfUvtcIe1wFbXPFYnfR4x5QEv5t7763y4PfnBL9xeeP+5bHx3sh24lcehW
EIduOXHolin3+9B1/FLudcY4lRLHeAQ9B0TnA4nVE3wv6TkgOm8nPQeSS01+
jUK51w3xg1K53we3gfQckPw5O1XPLvOB3SuJw+4VxGH3cuKwexlxjPtN4hjf
U+IYx1Py555XPS0fUj0tz1XPro4ffs6Xq550ftWT6sPt0z3w/KXfDH5USRy6
FcShm7ZP98mdS17bE/wl4tCtSVx1U351xeHnaPuUvB87uX1KnooN3D5lv/8i
bp+6/xl6gkt75vYp+zH3cvsUfoDtp1wXdCuJQze1n3Jd8Fty4uq3EMf42ySO
8Vftp3us0gd+i9pPJ/aK9Fwhug2Qnisk7wGeq6v9dJeavDNqP0XP35Ge4C+R
nshbMrIBPXGf/mTbab8I/omO7+6ixz/wpZfzS0BPy6FbTlz9FuLQTcd397M7
F0+6V/0WHd/dPRXfrXqCy3iqeoLL+OugJ7iM16onuIzvqqfl+1VPcPEfoBtx
rN9W/1P6C8bZkjjG2YL4WNXTcvVblN9WtSv4Lep/Snvbo3qC//n07y0Lz7HV
/3Ti7znbPpF/Y7PqafOd7Kb2Cf4itc8N0g5HNGz7BMc67RZxrCvW+ZFr3Lvz
6eCflMShW0Ecuun8yM27cmNykN+i/NqK/0711DwbTz1ybchzovMjN/qBG9pX
qt+i8yMn8xHVU3/Xz19UT8tfUD3BZX7UgJ6WQ7eSuOpGHOuxNe4h/Q7+SUlc
58XKff4c+C05cfVblD+2YMcZa9Vv0fiD+7eq/w6qnuBXbf3KR05Qv0XjCdJ/
d6qelu9TPcFl/t6AnpaPVj0tH696Wo511zp/l/6Odde679+9+rYvnh38k5I4
xlmNF7l3njXxk8FvyYmr36L8Wx85anPwWzTOM3z9N057dODbD0FPzcdw2soz
D+hzYI3bSP6Q51RPy9uqJ7jESVRPy8epnpZPVD0tx/pq+Jny3QjxN5+fqCV+
eIiz+XxG271fvT3E084U/9jOT7Pk2cqe7PDzl/dhnoV+vUPiG5gvoB1Kvt8l
GgdzJ1f1f8bHx64Nca2nqnxD6E8YHzNpl9slD4SOj5JvaHvi88CMxXVJHpkd
ic9bAntVuqWV/d2RvL4a1w6oXj7fzZak8g+XhHiR/Q5xSK9nmbz1ZT1nh3ij
13MrzUMz0XOr1/P2ED/0em6T+WCIE3o9t3k9p4Y4oddli8yjQ7zIt4ctEn8L
8SKvJ+wQ9Mkxfoue0KcQPbcmB05+2d5Cn9L5PJLbkqMb/z6rvzfE33yevm2i
55Dq+eUqv9WGpPIbp0K3UnTemNxf+eHQDX6cfM+DbrnoXNA8NJO8sZuk3UK3
pui8KXm8arch/ubHwc3Sbjn+tkHyNmMchP+zUXSGbui/G0VnHQclT1aR+PYF
3QrReVPi80E9p3p6nTcl7Upn1U103pycMe9t77hicIPqeWvlf6xNKn/yfSFe
NOUDX7n15edZ3j8P8SKfX2ydtOcQL7LfIf7mdc69zrND/M3rvF7ac4i/eX9i
vbTnEH/zOqyV/4duTfdX1fU+JTpjHMzEH1on8R/EgXPJR/Z0stDEews5fy7x
jSHV0//9+uTXE2/76T26bqIlOq9PhqYvGXFu38Oqp88LvNLP028P8SLv/z3u
dR4M8aKplc5PJNX8bip0y0XnVYmdh2aJ+Z4H3aDnamnPqpu0zzViB9Cv4Z+v
lDgbdGuKDo9LvAK6ZaLzE4nPN6jjIOY/FCcvROcnE59/b6Pqef9XV91603A9
L6oq+ojq6fv5muSKcukt3+hervPHdy//abtnWN/5g88/2789xIvOv/qPLr9y
+O99nnboViSzK795ibRn6JYnPq/o0sTOQzPR/1FpzzpeJPY7xN+8zsul3Yb4
m9ftYWmf0K0p+jwi/f151fO+SoclMn/aqXr6/HpLk/0nHxwnL9z/Wv7zy9cM
1zO9+ryzvj78d9Dzn67+s0cPtB9Lzl7+2mUjNJ7Scg9U51+efLSat25WPRte
gKSa380O8aIPnvfYgVf3LPA694Z40QnL//2W+3vvkvYc4kWII9h5aJbMqe5L
v9wX6NYU/Rf7dt6nuqlf6Z8zh/ibzz/YJ+02xIs8XyA671Q9/bzorgR2EXr6
8ouSbhMnL9w7P3DLy2uikkOuPrb9VP+jOn/8k6rc4sT7w5tUz0lbr7ztpXaS
eH9vl+op3B3x6MBxXfNCvEjOI/PoEC96h/9d59tziBdJPd2jZh6aSXz/LjmP
jiNSfoHEN1Q34X0SL0K/RvwN37tUT7kvDuMb9JT76G6Rdgc9Ea+83cTJC3e8
byfuT6v+t0n1lHbl/mc1X9O4pXuzb4fuw9V8JMTfpN16HZaEeJG0c69zF+K9
RfINXz+ZB0G3PJF+RPPQLJF+JzpDt6bY/UdEZ9UtkX4tOof4m9gBme9vVj3p
W/UUO+PO8PZJ549il9y3TZy8EB2XyHXtVD3F7kk8QXVzYidlvtxWPcWuun9+
OW/bVOhWJmKH5TzQrUjEbrtTq3kQ4uQYF1fRPDRLZFxwb6p01nFEdHtc9FHd
xN6tdP3VefAcFvGNNc7b7+Wqp4xr4g9ifUFG34XqKeOms3HyQvR/Qu7786qn
jMvup1V9VDcn47iUx3yqlci4L+05xIvET3CHfe6Ym/u6oVshOuQS59Hn3aLz
0zQPzUTndaIzdGuKzk+566rfVd3k/Gul/exSPcWPcu9/4OTb3jrcLqye6+GH
qo7ip0m8cUj1tN/Pq57iBzpv59uqp/iNwlU3J36m9K8QfxO/1O350I9b3T3Q
rRSdN4nO0K2AfRedoVsuOhRyP6Eb5uMbZZ6OeC/imRslHqK6yfxogxtTxZG2
UPvc7B6t7s8G1VPspntHNb4PqZ4yj5B8v8+pjjLvkLypB6j94hu6lZIvdaPE
yVU3J/Mg0Rl5ElqJzJvEroZ4kcyzRGddXyE6bxWdoVuO56bu2BfOmPUqjZNn
icz73FlVP92teso80X27inuUqqfMK933qvFiJcXftkme1SHVU+atMh99TvWU
ea7EeQ6onjIvFj1HNqCjzKMlbyp0K539Vt1E5y2ic4i//XOVH/ZZt+bNbzr/
3t4QL5L5vrSfEC+S+IDbmly0uqcPuuWi83Y3smpXu1VPiT+42Xsuu+BtfaXq
KfEKt+r9nz3j7bpOEfGiZ9z4xRc89vyw3wE9JR4i85UQL5L4icQtD6ieEm8R
XaFbLsfbKU5eiM7bRWfELUvRuSU613RL3vaTT5zWVyBe1HLgb//M5z45XE/1
//F3ft17WG9j/39cSuX99zyN7+H8rnof0JIpyhHXknVQWk+s//nUrd/d+XI+
WPDO+RJxf3gdbxkpX0TKF5HyeaR8HimfRcpnkfLNSPlmpHwaKZ9GyuNTK+86
c87HEMpH6h85TzNSPouUzyLl80j5PFK+iJQvIuXLSPkyUr4VKd+KlY/kzywj
vIjwPMKzCG9GeBrhnG9Dy0fyZzYjPIvwPMKLCC8jvBXJk1lGeBHheYRnEd6M
8DTCOU+Jlo/kT2hGeBbheYQXEd6K5L0sI7yI8DzCswhvRnga4ZzHRcvX9k3I
+SM8i/A8wluRfJVlhBcRnkd4FuHNCE8jnPPZaPlango5f4RnEZ5HeEv5iWYf
RSuSf7KM8CLC8wjPIrwZ4WmEc74fLV/LsyHnj/AswvMIb1F+S14nxvkkywgv
IjyP8CzCmxGeRjg+tfIucv4IzyK8VO7zRyEvaEu533/wnOrWOT9kGeFFhOcR
nkV4M8LTCOc8oFq+tj9Lzh/hufLHZN+JXJfyj8j+GtGB8q6F9WCWh/VgnfNA
lhFeRHge4VmENyM8jXDOn6rla3la5PwRnin/oeznkforf9z7caozuN/fE9aJ
WR7Widm8lCMbwiN5IMsILyI8j/AswpsRnsZ4Lf+MnEf5F42umfI3m/1DufKT
qvEirBOzPKwTs3kWVTfiIU7VOd9jGeFFhOcRnkV4M8JT3ff3c7Mfq6l8odk3
mTmbby+sB7M8rAez+SHDejDLw3owy8N6sM75G8sILyI8j/AswlPK9xjWd9n8
r2F9l+VhfRc48uxBH8vD+i7Lw/ouy0OcpHP+nzLCiwjPIzyL8JC/4cumfaW6
n/Vc4z80iYd1XOB+n2RYx2V5WMdleVjHZXlYx2XzOoZ1XP6b91+XEV5EeB7h
GvfAPmz6f86DmNLx86obnV/qnxGHPjlx6FMQhz4lcdaH9weUSSVjH/Mi8fmD
OO9fjvxONT/Z3w/et95M/DjEPE18fupniXd1+TxQzFPJD1WP/5zSsf6Z9Kta
/V3n+sO+cT3Rf5kjHrilpqf91vOLzsxz0XlrTc/qZ/uZN0XnbTU9/TDFvKtr
TSSetqZj/ZuSZ4R5JjrX6u86178QnZljvOB6Ik5Vj6t4nTfW9LTfWh/RmXmW
VLh7U01PrzPzNKmK99TjVP2ROFV/x/o3JV8A1z8TnZnnrnP9C9GZ69lKXl2V
X1vTzefteaqmm88vsa6mm/3WeoqezJui5/qabj4/GfOurr5IPKq7Y/2brrdj
/TPRuVZ/0fPpmj7rqj9YWdPH5316vKaPr/8TNX3u7bX75aU+if3W+os+qyPt
ak1Nn8FI3GmwY/2bohvXPxPdavUX3bj+reQ11Xkerunj9+s/UtPH59NbUtPH
99OlNX28no/W9LHfer2i2/JI+6nHnbo71r8p18v1z6Qf1eovOnP9WzKOLJd4
WFg3lfofrunm81QsqOm2oTr/XTXdfLx0UU03bw/7a7p5nRfXdLPf4dMXiTvd
2LH+mC9w/TPJu831b0nei0TWa4V1UD5PDZ5H4lMmPl/EYuJF8lN/vTV/zNdn
EXH4sXcRx/xoAfFUeB/x2IfXR+n55TkL1z93fVLPQTP/KiVvyQLJoxbWOy2S
+vj7HNY7+Tjd8ppu+ymPk/8U4o89WtNtjakHPpn4G0tqukl/qekm/Yu56+lY
T17vpL8r1/+o5MsJ652gV7eZlxVazusd1juJXZK8fWG906lST/87Yb2Tz++0
pqan79era3r6ceTJmp79Jl6j1yX+wxM1PcU+1/QUe17Ts69jPZtir1bL/P2V
1zvJOCX3J6x3knFNfiesd5JxUHQO652eknreXJUP6518e1tf09PXkzn8Xp4v
5aIz5wfOROd1NT3FH6jpJv6GzBPDuibxT8TPDeuaXiX18Tq98rom8ZfkfGFd
k/hXwsO6Jq/nWqkXx4vqcQ+v56aabuLv1XSz/SToJv5kpF3hPRVhnZL4vdLv
wjol8ZPl/8M6Jfyuvz+vvE5J/HbRO6xTEj9f8vKGdUq+fttq+sh8IWL3ttb0
mWPigEEHmR/J+BbWF8l8StpJWF8k8y+57rC+COf35xvZwPXL/E7s2SuvL5L5
o+gT4j+eP1vTQfLC1XTw/ZN5jnz+tfFO5oMS1wpxnqfkd33+p7Be6D75Xe+n
hPVC+F3fD6BDjvzE8v9hvZC/39ulP4X1Qv76oYfqIPep/lx+Tsd5R+mu6Thf
KCXP1urkLVX/+NU54KeJ/7zQ5DdDXjH2Vwt3UcRvXNTRfyskX1d/crUZnwt3
yr3ej3qXGTeG9ezoz+SST3GRu8uM55mbLePjueQ3yTyiNu70m/6PD8Ypzn/Q
lP7I7UrbZ80PzCJ8tPwd8591jFe0XN4xLtGKrtO4ouP8vZTz8Py6Vcv3i/Kx
9Qyd57+FSzvOQ8taflT8Lvhc45+WsfUA0v7XJH9p/KyW2yTzwTvN/SwkPvZk
rZ6f6jgfLDX/2+ndtv3Hnr+jvH1PTSl55h5Ljq6Om8p/I/Mv5LvzPJe8djzP
ymvvoUB9OvNS+Y+MXxbeQ/F946dnbnXH+VRWy9vcJddxYcd5RLOW39XW8y6x
c5u0Pn3SP6fL+IDrXSr9Ge8Hwfk5nx7qCX6Nvz69rkvFjkwnP0vmy7VxcGVH
/xN5qevP4/g9EfjEntPZ9+RAf8wj1tbs0sc6+pMh/y6Xjz3/QvlLzH1rir/N
flEz+WhHvyuNvCci5P8+zs9rz8H1Pinn/yL5KV6ezfI8BfcrlXn0FnkvYfAH
V8m4fJ25vqb4dZz/sJnc0NEvSjWP4hvNfLcZfe6D8vPNfU7ld59xr5F6g68W
P2GGuZ8tmZ/Wnzf1yLjP/Osd/ZZm5L0Vuq61dr0of71p7yEv+s+9fZL7FV8n
LOOX9wcPWidsfxf5t/V5U81Owp7/muIAsKvfNe0hV3vyC1M+vF/mP6QdyfVq
/tFl1P/wPHGubW963+82dkvjFcmV1cDxk3PAfRwnfdDyTOw/x2cyt7ZjnKfp
GjJvRX5s1H+m2Kkpxt9pyTjOfl3Lvabj+Fu6d4lfx/xk8euaNK7J/FDic6xD
bZ2Ymyr6fdNcXyb+w8Pu16b+TXmuzPN9jdO6x/z4fA50OK6zPdT5prVjGj+v
9d+ZHe0Vnq+x3UiTmWYcCnyRzI8eOuVgu5HqPMtyrO/dQf2rrOWPhZ7I+ztk
zpNHxt9M88eSzpq3+QbTPuvv+8D5/fe8s5dX9RzU9rzA2Mfwu7F1U/y+APBF
4oedbvy0VNsdx5M6v0eg5R7056m1/wMdnxPV8/mD+3nN2qScc3A8pCXrgdYl
penH8J/r8ybOw+8/ueY9ZrtxlbTXu8jv6uwvZbU89v7TlPfIcpyzWctjj8/X
Iv0C9WLS2X9Afv3Nmm8cHHGPger3V6L/yjqx2jqTSNwmja1L0fzztn/V87Tb
61n44PdMv2tKPmiO3+pzkBrn/MzCo/WM5GHWdjLf3M+Q5xz56sF9e+hLTjX2
L7yf8Uvkt2o+f5o3iX+Z/L3x40q3QdrnUWZeW+r532LiQ7Az68R/gz/SVH/y
d6b+TXe52IGzZHwDv1L4BYaHPOF/QeX9+zvXu98ae1Dq/OV6005LN+pef70f
Mtebi13l53p5Lb836hPjt8l8s4s+fRF7eETPwfYlfL7yf5131J9HnNJxPMrE
P+c4XrOWJxz8RWqfNl9py+fnPHZmiv1d4HM+vbLVdielmo9Y+BNfnJD2bz8+
RV5d8Gof5+3HpsgPa87/vmNS5DkFr/bDTZ2eIl8n+Ad/9tvru5cgPwA+4lfO
m4ry6l8vePvrPzk4ezLOr9zvu52Y2nyNLckXOg71V+73PY9MNd+Z8LvK1e3u
nv2azwv8TNnXafUsJf/NCaRn6fW8dibpWXo9e48jPUvJnzGD9Cwln+p00hP5
pY4kPUuvZw/yweKD9SpTSE/kBzqU9CxFz/GkZyl6jiY9S8lj0U6snmXyo0rP
vaRnKfk3th2U/8vzF4666bKRB+V597zwOs8+nnQukht33LG6fe2JpHMh7XYG
6VxIuz2adC6k3R5FOkveqalHkM6FtFvkDcAH8bTDSedCdD6EdC6Sr1Q6jyGd
C9F5BOlciM77SOdCdB4inYtkRbVPdi3pXCRH3774o3uH/XmrM/KQHUs6517n
9vGkcy7t+RjSOZf2PJ10zjXfuNU5TxZX7Xkq6ZxLe0Y+EHwwD5pEOuei8zjS
GXmDRpLOueRh3p9YnZEXZzfpnCfvqfJJFKRznvi8HYtI5zwZX+VBeZp0lvxk
s2eQzpm05+NI50za83TSWfJy3X4k6ZxJe55GOmde56lTSGfko0IeJHwQb5hA
Omei82jSGXmD2onVOROd95LOyIuzjXTOkoULPty+uXs56Zwlp1d5X1Y6q3Mm
eVCeIZ2Rn+xo0rkp7XkG6dyU9nwU6Yw8UkeQzk1pz1NIZ5Q/nHRuis7Iu4IP
4jRjSedmcl6l8wjSuSk67yOdm6LzEOk8fL3lu5atHfZPrc7NpPEPfzty4bC/
anVuJj6/zSbSuZm8ucrPsZt0TqU9TyedU2nPx5DOqbTnI0hnySN1+1TSOZX2
PJl0Rt6pSaRzKjpjXzw+WBc0inROxT7sT6zOqei8m3ROJZ/WJtI5TRqVg9JP
OqfJhVV+o3Wkcyp5KYZI51R03sc6+zwEs49gnZ3X+SjW2Xmdp7DOkrfjcNZZ
8qMcwjpL3o6xrLPkOUA+ZNVZruOFhHSW/ChDrLPkVVrHOrsLfeI2RzpLnrBN
jnSW/HO7WWfJk7OfdZbjkQ2yG5LvYSrbDa9z+wi2G17n3slsN6Tek9huiM7j
2G6IzqPYbkieCeT7xQfPmfaQzk3J67OJdG66mVU+qsVsN5zPF/UU6Yy8d0Ok
c1N03sd2Q45HNMhuiM5jSGfJXzJ7Co+D0p6n8Tgo9TiUx0Gp9wQeB0Xn0TwO
is5dPA6Kzs+Rzlhf1CKdM8lTtZJ0Rh675ZQ/HvkXt5HOmei8l3TOROc26Yw8
waNJZ+TLHE86I3/w4ezXSXuewn6d1OMQ9uuk3mPZr0N+bPbrpLzaAeVe552k
c1i/TH6du1rywJFfhzygpHOu+b3Jr5Py+0lnXK/aAeX+eBzpjPzBE0ln5GOe
xPMUac+TeZ4ivzuOdEbe8VE8T5H8+S8lVmeU30M6F5LPpp7v4QVZr0rzFLdO
8mbRPEWOh2rvQ/DH+0hnlB/RoHmKXO8Y0hm6HUI6Ix/zYaQz8ltP4Hm3m1kd
H8rzbvnd0aQz8rh38bxbdH6OdC7doORLpnm36Mbr0LEOIrx/Ahz5nGjeLcd7
SWfk72+Tzig/mnTG9Y4nnaHboaRzKXZgMumMfOFjOS4k5x9BerYk//ELCcWF
HPJ5UlxIdMtJz5bb3PR5E62e+hyA9Gy5T1X2ZDfp2XLbq+P9pGdL7NXIBsWF
5O/HkZ643omkZ0vGr8mkZ0v6+9QG8lwLl/jVCSnyNYNX5bYfmyLvMPhmyZeL
/LnglR/1vukp8sCC//Fn9rqeqUemyGcKjryRyCMJfkp13kkp8iGCf0TypCGv
H7iPj41KkZ8OPG9fs+zeYbuEPGt6nirOs0fzhYFvuH/sslnDdgn5qaUden36
Z6STJc8yuC93dIp8weBbJM8t8t6Cez9zWnqx5G8Fr/TpmyI6IA6N+NWYFPkK
wZHHDHn3wH0c4HnNHwf+8/bOWz4xuEPzoIHfWSXgXi15urFeqpD2MD1FvmPw
at43PD+SfJfKkW92puSfBfftYXKKvIrgPZUu+zU/IPjyKo/rbs1zB/4f1bx7
k1zXDuVHH/j6rz47PK/5suRf9jyX+zUtRR5hcD9vnZJead+rk+B9Ihi3wf38
dHtC7zlJ3FcfWDp3+PeQJw78nGreuhT5Q+G/aXwY+XbBER9Gnj7wzdUF3aX5
5sAvqfJDIg8p9plgPj4hRR46cO+fbNM8+56n7qbKDhyRIo88uLcbU1PkQwf/
QXV8eIq83uDejiG+HfIFIu838iyDe/92ZIp8weDe73oR+ZoduNdxPfJiK5/r
A3OaNxP8N5LvEfkfwX09dmkeQ/D/Xt2/FzUfH7g/HtlAPn3R0+vWnpwiLzz4
ZfKeAuQ3B/e6jU/XmnEY4+7oFPmmwS+XPN7Im2zL70XecNxft0bytiJPKPha
aQfId2nP/5yO8+D+uKuB/IPg4p80Zkq+e2mH4v8ckiJvO/hlMi4j/zg4xmXk
0QbHuIx80OCXy7iMPKfgn5bxFPk6wXfIeIq8k+DIl4j8ieDPyniK/PKe5+Kn
jUrte/OQN/0A8hQr9/3/d8gHrdzn692K9xaof+6bbVcDeTDB/fWMaSCfI/hZ
8r6eN0t+ds+Rr30f8ikrRz78CyVfNvhf+TgP3lehfqzEoxrIFwnujyc1kK/c
89J9oTreIvHOxcovl/zwyC8J7o8Pa4yXfNyet1z5JycvHT3cz5BfUnhyyTfc
zb3HnpSS35J85qu/PmPEsL2n8vL3h/BzQ7mPh6Q0vrtfnHrtrGH71rD5+Hj9
81CN2/XNgdt1HoHb9QGB2/W7gdv8UFwf5EUK3K6DCdzmtQncrgcN3K63CNyu
MwjcrlMM3OrJ+9CHatzqWUb0LCN6lhE9y4ieXB/oWUb0LCN6lhE9y4ieZUTP
MqJnGdGT18MP1bjVs4joWUT0LCJ6FhE9uT7Qs4joWUT0LCJ6FhE9i4ieRUQ3
Xpc4VONWtzyiWx7RLY/olkd04/pAtzyiWx7RLY/olkd0yyP68L74oRq3+mQR
fbKIPllEnyyiD9cH+mQRfbKIPllEnyyiT+C2P2aJX9CI9fhDVJ7zuvJ++aEa
t3o2I3o2I3o2I3o2I3pyfaBnM6JnM6JnM6JnM6Jn4LafNpNfyjo0q3Mzudis
mxqi8+whnXkf/VCNW53TiM5pROc0onMa0ZnrA53TiM5pROc0onMa0TmN6Jwm
82XdnNU5Tfw+5Vo+JDnPC5E8xWw3eN99PU+05aH875dfOJT//fLnhvK/X97Y
UP73y6Mayv9++UNZn1fKmxnK/375IkP5WD7Ezvt/6utr58nf87rSprQbaleS
T3K34/0qvl3t5fYm++KRx4/3hyC/FuflGkX+eey904GTXY20n2aknTQj7aEZ
ue9cH7Wryskeyr6KIdKzKXruY3sox8hfF/ZD+++xpA+/f7v+Xm4axyP6ZBF9
sog+WUQfro+O48ppXJZ1vtscjcui217SLXMfrnRrk27Ib4f8bGHfvP+eQLrV
8sTVOPmHEd3yiG55RLc8olse0Qf5MneTPrnos5/0QR7EkQ2rD/L84b2inF9h
EunD+1aGapzmHRF9iog+RUSfIqJP4DS/kPXOaymvK/KzDlHeUuQZ3Ud6Is/c
iAbNL0TPMaQn8iMib8CQcv99OOlZe799jdO8OKJnGdGzjOjJv6vzX9kf9hjt
q0Ge4G2kJ/La7iU9kZ+1TXoin9xo0hN5+8aTnsgriTwDQ8r99xSO20R0a0V0
a0V0a0V0C5ziM67h8wQ4qyfyLW0kPVuyn2A36Yl8wPtJT+y3G9mg+IzoOY70
xH79iaSnnGc29lEOKa++5iEOFp4DWj3rcS2bzy5wm8ctcJu/LHCbnytwm18p
cJsnKHCb74bjWvX4lc1jwvGrZyM8PAcEn+v3k9S4zVsX+OLqdx+p8fmy/4T5
+WY/SuA2j09JOmyqcZufJXCbr4TjcuE5ILjNuxe45IGqcZ/f4a4a97c9PAe0
17Wpxm0eGY53hed94DbPXeB9sr+Iua9PeN5nrzc81/PXs9TZfHkcJ+mvcZsP
rkm/G57T4T7ZPKrBz7f5QAPvN/008G7TTwMfNP2Uyz9c4zYPXeA9pp8G3mf6
aepu8bprHihwqbfmPwL3+412aT4gcL/P7EXNgwPuj0c2ZB8+dKbr3Vjjvab/
NkmHx2u83/Rf9vMX1HiP6b9N7HvWvFfgaAe9pv82Nd/RTab/Ih9SV+M+03+R
B0jzNqMdUv3X1Xiv6deB2zyMgWemX2ekW3hO1yPjXY/p15nUf7/mbwLHeGfz
JSGP0bgG1t95ntN1rarxNdYOUPtcVONkB+S+dDVsvirklxrTIPsg7XtCw+Z5
Kej84bmbPx7X8PqE527+eFIDeZc8Rx6mwxrn2/JqT8619VT+MbJj88WO2X19
meaZsfv6suQ4f6OczcfBdgz7REM8qi8Sl0BeJDm//v9VYif4viAPC/gt/n5L
3oX+ms7I38Qc+V/AJ/v9mpr/BXyWt++6fxX6Iz8V9q+Cz/HlnM27VHue6Jif
ZO8vjXfba9zmBQj3neYjyu0+zNrzI+X7JX+CzVMQ2g/NKyO/myf3vOT3m9v2
nEm+ltzZfCKZ7LfdJH6x2gc9v83zEtqbzavSTP5U7KnY81p5m6cmjZw/TWZK
u5TxsVY+lmeH8+B8V9pJn/H/w8fuy43F8QK3v8s8xOt+LffjMquD+40f/2j/
eRin7L7fwCnO794v50U+I88z6T/r3DdM/wr9mp7XKLd5B7KIDpk7W/yMRRG7
7T/6HE35gkh5y2PxhFzySy2ScenRWvn3Wb9Xuc2fWsh+802iX8gz936xs8g/
63np3il+w0KxK+DvEfuLfF7g+F3k82Ju83OF+SzyAoOfX32n7oxXmXmZu0j8
Nps/LpzH5o/jPHVDNY78aMyR3wfcz1unNqw9zJNU2qvlmTzX2OCs3Wsmp4ue
9NxE8t9scmQfJL/Fk5RXq+lulP5j223pnNgf265a7mLpJ33G7hUyzvaJfxf2
vb5H+g/5G2p/kH+K+VzTrjK3VsazPhpPPyD5QHy/3qK64Tz3GH87S94p5yW/
NBmQPDk2L1iwk9YPDBz+Pvh/yvXul3gJ+FUyHg0a+xM+z5O9xcfm92m6eZI3
spu59DfkCYJuOM9IuT9yX5Qjv4M/Cv3rOvIHxotf8ec27qHlzzV2I/B+48+H
dmLbc/DTrN3OHPL22Lwt4b7b9hn8Gc7PMlfsb+d8c6g/5jUp6QC7wXFjXR+i
3Pbf4J8g34rUn8brlvKGtO/+iH9yfqQfdc4ThPajfqzbKPl5kO8JfK34BzZP
X9Ch14yPgc807TBwm08njL/0/D0ybuYRXriR0r4XmfYZ9L/KjDuFu1iO74nE
haS2pGfurB/F9ws82JmbzHw/cHq+o/ytZr6M9jlA7T/oace70E8XRcZHWiem
nPMM4r1L9FzezRV7a+tTyHvitiB/md4v5Mu3+X1yd5/5+6Ga/h83djjo81Dk
upAvTOqZPCLjjc2LlCa91fEaZ+NvaXKu+F13m3EwF79lO8Wxc31v1yDN1yRO
R/rk7k7htp+mydEyz7H50UIeSjsuZ+Lvrsd7R2r6/NSMO4Hb/KGhf9F6GOXI
R8w6H+LL1fhkv95VjlvJlVPeO6tr3uRU1seivOSRODGV9bR63/1+ksNSWX+r
/OmTF10w/KuprNdFv5Z8ICfI+UvlPh/IsamsB1Z7++49rWtf3p8u64eV+336
41JZb6zc/+6oVNYno/9LnoHjpD5blft6zJD6FMr99R4t6//Vjsl+9gmprK9W
7us5Buuxlft6dqWyflv5Q+ddeuuwl5DIeu8E9x15gWR9uPIZkhdI1pMrR14g
WX+uHHmBZL26tivk85H17cqRz0fWwyu/W/L5yPp55bMln4+st1f+eVn/LOvz
pT7ICzEjlfX8yv39OFqud5Py6noHj5TrXa/cX+c04auV+/s1Re5XyNvq963o
/gXlXocu7HdQ7verPJfI/gjlF1X7lVqyL2+j8lVVfpjHJW/JFuWHrXjqrBeH
+4Ps15B6pkm1D2Q28jlsU+7zDCBvRlgP5tvDEansH1Hu8zkg38sa5T4/yWTR
Z7lyr9tE7GdRe+X344zE/hflvj28KNcb4gy+Pe9KZH+N8rdW+4U2yH0P/vNZ
fsOY5CEJdvKbVX9ej/0+yt9S9ZOdst8C9gf7SrBPCvYHfBv2H6H9uwv+5tzd
c6ZOxX4l5b7eh2N/k7Mc/TvMU2SfmOyfUHsi+0Qmy343tSfOHx+K/VnK/fF4
7OfS8WVm1T+XSrsL446v3yon+8WUH17Vb7s73O8vU3/JHx8u++y2KvfHh0g9
Nyn3x9j3lCv3+3NHYH+c+gkX+I1qTvbTKZc8HrL/6Qnl03zeD6n/OuX+eL+T
/X06Hvn+OUn2RW5T7o/HY/+gcn88CvsNlb+u2od5IJH9icr9PpffJbKfEeOU
W1Tt11vtzvP7H5X7/ZA7nOyXVO6Pn3dT/P5K5f66umS/asjD54/HNGRfp9Sn
Jfk0xmAfqHJ/PAL7RpX/oBpv9iWyz1T56dXxkFzvcuWt0y768Pl9axPZx4rx
3V1etb/NTva9Kv9hZef3ONknq/yk6vglJ/tqlS+r7OeohuzDVe6Px2HfrnJ/
PKkxJPNm4ern+GlZ8DfAmza+pNy+x4ifOwd/w56/rPGFNq6u3L4PKfADJg8r
lw/+hq3P1hr39Slq3L6nKnD7HqbA+63fq7xt4g+B2/drBj9TnnPVuI+Tb6px
iZ/UuH2fVkY6LKlxOw/lOE/wH2z9t9W4xH9q3Nd/fYSvrnH73q8m6fxIjVPc
hu5XGPftebbVuJ9/1deB2/cgcvk1Ne6va3mN2/eWcRzs4Rr37SeMy77d73Sd
36saez9o7D2Xsfc4xt5fGHtvX+y9dCFvPo7xHAjvrQHH++Xt+1/DfMq+py1w
+15Yfr5c1rjNex442Q3lZDfo/EWNkx3QuLN9Hy3HtbbWuH0/KD8Xzmv8StN/
8X6w3TKfDuO+P95P78EN81D7PteS6rmpxu37ewJfbPpp6RZLnGiW6aelvvdt
romzlVLPrgbeOwXuj8c07PtmQlz0JtN/W1T/9TW+yPTHlsN7IU81/RH5uffo
e9TA/Tq2l/Q9Ybb8KL/s76Bx2R+Pwzo65f54UmPQXG+wY2819iTU376nIYzj
bRMnz4iH+ZHEIzR/Mf/uVyTe4494f0r9eX0fxYdvlHKLjA6pPGfcou/F4et6
zozvIV7XkDiTXJcbKePZdRQ3mxyJe/62Ou/gObafhs8Bo2fwK6y9ypNfVuVW
nmN1yGVdceHs8/c0+by0q5PM845wX/BeK3/E629hx5BP+ITU1g/8uBT1s3xG
an8P/GjhTeJHpai35chvDPuL9oZ8mxnxCaiPct/+RqP+VB7590oqvw/2DvrI
97F0veDH0PWCT6frBT+Srhcc+YdxXeBj6brAR9J1lfIe1f10X8H3ULsHx/ly
e93zUP+MOOrfJI76p8SR7zesq/S/e4DGFfC9VH9wfo5bJCNN/TK6Dm0/xKdS
PcGRL5efF/A6+Jz+rkV8Hu1jlHrNw/lTqi/ac1jvNMqUazlbHu0D/4/fQX7U
sG7Tnhf6pf49Ldq/SuW+ntCnII7655aH/kgc/bFJfExq6y/10f6I/q7vweDr
lvxgev+oPL/XFDysV7N8L/0/ON5XCH1QL7TngvhhwnPiuC8Z8bG4XuLo13p/
ne3XuL6me8nMh3Nnz1OSDpr3kv4ffD/poPVp2OvF70+k6wVH/lhur6PoesFh
B7RfOGsHwrpN/72Lrgv8BboucOxTaxEf07D1Rx5F1DMj3qb+hno9T/XHe5B4
P5Keh+qJ82B9bIv4+IatD94Ls4/qA76T6lNIf9HxjPTDfqsW8YkNe/5Szr+F
zl/Kexp1XKfrO6xhy7ecjQdp//Tj77WwMxwXOjG15cHR75rE1R5CB7HDx6e2
HDjGd7Y7aOdN4trOiaP94HfRvuAv8XgLf4njQvCXUB/w8VQfcPg5GfEu4bly
fx+RrxX1xDiF+pTEUZ+COPw3igvp+KJ2Wf4f9r9JHPY/I/4C2wE53kX9i/wU
vS60y2PousDh5xTE4efkxNVPI45xAdcLDnveJF6z53K8h66X/Uded8rjfFPi
NhgXdNyX+4LrLYnjegviuN6cOK5Xx31pV9ofyU6gH0EfcNj/JvG9pA/ND8K4
L7/L69qDfyHXS1znA8R3kW6ol/q3znKaL6G+qk+IC1l92F9h/yCDn0P1wXXD
TpbEJwnneBHshtoT+b5F3wNlOY+7OeKAVB/oqH4scfiBBXHYgRBf8vrAXqkd
Fh0y0p3vX/D7xH+g60D5A1R/fb821R98LNUfHP1a54NS/xetHVS+u9YeR5jz
sd+2h64LfD9dl9anYa9T69+w1wW9ME6pvXR2XpYT30vX1SIdw/g/2pQL/rf4
J3S94PvoenF++G85cfhv3A7C+8Etx75d7k/41J9D2fLMuf/zeXhfQ/05lD0/
c/Y38GF/g383j/wu8/pzKFsf5uxvcH2Y5xFO/katnsyLCK8/h7L1Z87+Btef
Obdrridz9h+4nszZf+D6M2f/gevPnMb9Wv2ZFxGeR3gW4Tzu48PjvpaP8Fca
l/nD/RAf7if4cLvEh9uB1jPCud7KXWdey7NAdgqf59m+0v+TvxHOH+HsP3B5
5vXnTfa84Lx/rIicnzn7A/jUnzf5zyuP+/77Dx33uZ7MedznejL//zW+x/a5
8LjP18Wc45p8XeC76LrAX6Dr+q8ax9nvrl1XxI4xzyK8GeE8D+FP7TwRu8XP
L7SeEc7PL/Dh+K6WR/uM6MCcn19o/SOcn1/wp3Z+15nzcw18iggvI7y+X1XO
D3sSud6a3xXhaYRrfSPXxbyI8Pr+Wf9pRTg/78CHn3fgw887+FPzD11nzs9B
uJ45vT+dnoPU6hMbb2PlY+Nwzf+h36/ZaS4vxzxulxFeRDg/H8GH50Ncb+Yc
v+BPrZ7O8j/0uQY+/FwDH36ugQ/HLfDh5xpa7wjXv+P6OMv/Xz2/wIefX+DD
zy+0fhGeRriej3/XWf5f91yD6hHh/FwDH37Ohk94riGgYev5hz/X6Fyfmj9J
Or3S84vY8wh8+O84vopPiCt6v47jaLV4nrbDtonH8nMSrkds3K/NT5W3zfqV
EAeeKr9v6xmbP9bmd5F2HNpBU9a3dJnf4Q8/z8Wn5veT/uxv5qTnloju+HCc
lz/Mw/OszuVLZ9cfcxyMz9Nys039Qlz3JrN+KDz3t+s188h9Ce3uOjPOZhGd
Y3HdWDycn7Pw78bsP+tWH3f/Dw0Y8tc=
    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwtmWXAVNUWhkf2dg7sUUApCbETuzGu3Y3diphIIxio2N3d2EV3l4B0d6eA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            "]], Polygon3DBox[CompressedData["
1:eJwtmgXYVcUWhrfM8G/PDxZgoSCoVxS7u/t67e5uBbu7uzuxuwsQaSUkLEpS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            "]], Polygon3DBox[CompressedData["
1:eJwt13f8T+UCB/Dj97O3zOx5FSLjJiszW4SyE8reDSqhW6FL9Lrmzbr3ImVV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            "]]},
          Annotation[#, "Charting`Private`Tag$5136#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwtm3XcFcUXxt93vbt39o6tGBgIFmAAgqgopaggEhIGChYGgtiBqAgIKkqD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            "]], Polygon3DBox[CompressedData["
1:eJwtm3e81UQbhG8OSUhyUQREmkjviBRRKR+KVKmKFJEqvdgRFVERQREVUUBF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            "]], Polygon3DBox[CompressedData["
1:eJwt13e8j3Ufx/Ef+R2/c47VbaRy6ETJOEjl0OGQsoq47TIqMpLSoDSEjOgW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            "]], Polygon3DBox[{{2614, 1455, 1274, 1273, 1712, 2470}}]},
          Annotation[#, "Charting`Private`Tag$5136#2"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[
           0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
          "Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0TkyBVEUBuCLZx43gJLzNoANIJIhEyEg9IQCxQrIzXNEWQA2YJ7n8RlK
mUV8t0pV//V19b19Tve5Ve09zd0ZIYR++ZR4/yqXspITQhnXWcktJuMa6+M+
NsV3ckNoYxm7WMk+JjnEeo6wiZNs4zK7uMYr3vJbNuVdHmU0S0+OcZvj3OEE
dznJPU5xn9M84AwPOcsjzvGY8zzhAk+5yDP2JkK454+cy4c8yYDv2ojrXGUH
l9jCCTZwmLUcZDVTLGcnS9jKX3Nq5AvrYg/WcIMVvLDvml9SKm/yEOeRqUY8
FxbHubAozp2FsR4L+Mz8ODPmMU0lwx21CDfMjnNmIvajXw9ndIWUh+n/8/8D
GGVPHg==
        "]]}, 
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0k1LVGEYBuDHcXRmdm7EQDduTCSQKKfUUhcpqFBQ/gAbd0FKLUVMRTRC
dBDRXYHi10JxV0Hu3GV+VNrHH2gVrdz06XVocXM99+E97znv4dQWhu4OlkTE
nKynIn7yCb+7+C0TkeMZL7A0G3GRFcyzhp1sYB+bOcBu9shj8wDHOcQiR/iC
T7nNRe6yJxdxyXNfyr6+ynZpKot4p+d5wGs85HUeJc8qj2i07pUc6w/Y69pl
vk/eyboPbGGrfDTf4Alv8pRt/MR2fmYHv/C2fa7Y57V81dfYITve+a2+zDdc
4Ban+JzDnONDjvE+++WRuYuF5By8x3reSr6H828m503Ws1o/Mw+a67ik75nz
UqVX6j+4oWe5ktwrC+mIjD7PchZZxlmmOcNSPmOK05ySEvMkgxP8ZxzjX47y
D0f4m8P8xTu+z9XU///mHKtARkU=
        "]]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1719, 2017, 943, 1718, 2667, 1926, 1720, 2668, 1927, 1721, 
        2669, 1928, 1722, 2670, 1929, 1723, 2671, 1930, 1724, 2672, 1931, 
        1725, 2474, 2757, 1726, 2673, 1932, 1727, 2674, 1933, 1728, 2675, 
        1934, 1729, 2676, 1935, 1730, 2677, 1936, 1731, 1139, 1937, 2018}], 
       Line3DBox[{1733, 2475, 2758, 1732, 957, 1734, 2678, 1938, 1735, 2679, 
        1939, 1736, 2680, 1940, 1737, 2681, 1941, 1738, 2682, 1942, 1739, 
        2476, 2759, 1740, 2477, 2760, 1741, 2683, 1943, 1742, 2684, 1944, 
        1743, 2685, 1945, 1744, 2686, 1946, 1745, 2687, 1947, 1746}], 
       Line3DBox[{1748, 2478, 2761, 1747, 2479, 2762, 1749, 972, 1750, 2688, 
        1948, 1751, 2689, 1949, 1752, 2690, 1950, 1753, 2691, 1951, 1754, 
        2480, 2763, 1755, 2481, 2764, 1756, 2482, 2765, 1757, 2692, 1952, 
        1758, 2693, 1953, 1759, 2694, 1954, 1760, 2695, 1955, 1761}], 
       Line3DBox[{1763, 2483, 2766, 1762, 2484, 2767, 1764, 2485, 2768, 1765, 
        987, 1766, 2696, 1956, 1767, 2697, 1957, 1768, 2698, 1958, 1769, 2486,
         2769, 1770, 2487, 2770, 1771, 2488, 2771, 1772, 2489, 2772, 1773, 
        2699, 1959, 1774, 2700, 1960, 1775, 2701, 1961, 1776}], 
       Line3DBox[{1778, 2490, 2773, 1777, 2491, 2774, 1779, 2492, 2775, 1780, 
        2493, 2776, 1781, 1002, 1782, 2702, 1962, 1783, 2703, 1963, 1784, 
        2494, 2777, 1785, 2495, 2778, 1786, 2496, 2779, 1787, 2497, 2780, 
        1788, 2498, 2781, 1789, 2704, 1964, 1790, 2705, 1965, 1791}], 
       Line3DBox[{1793, 2499, 2782, 1792, 2500, 2783, 1794, 2501, 2784, 1795, 
        2502, 2785, 1796, 2503, 2786, 1797, 1017, 1798, 2706, 1966, 1799, 
        2504, 2787, 1800, 2505, 2788, 1801, 2506, 2789, 1802, 2507, 2790, 
        1803, 2508, 2791, 1804, 2509, 2792, 1805, 2707, 1967, 1806}], 
       Line3DBox[{106, 832, 107, 833, 108, 834, 109, 835, 110, 836, 111, 837, 
        112, 838, 113, 839, 114, 840, 115, 841, 116, 842, 117, 843, 118, 844, 
        119, 845, 120}], 
       Line3DBox[{1808, 2510, 2793, 1807, 2511, 2794, 1809, 2512, 2795, 1810, 
        2513, 2796, 1811, 2514, 2797, 1812, 2515, 2798, 1813, 1032, 1814, 
        2516, 2799, 1815, 2517, 2800, 1816, 2518, 2801, 1817, 2519, 2802, 
        1818, 2520, 2803, 1819, 2521, 2804, 1820, 2522, 2805, 1821}], 
       Line3DBox[{1823, 2708, 1968, 1822, 2709, 1969, 1824, 2710, 1970, 1825, 
        2711, 1971, 1826, 2712, 1972, 1827, 2713, 1973, 1828, 2714, 1974, 
        1829, 1047, 1830, 2715, 1975, 1831, 2716, 1976, 1832, 2717, 1977, 
        1833, 2718, 1978, 1834, 2719, 1979, 1835, 2720, 1980, 1836}], 
       Line3DBox[{1838, 2523, 2806, 1837, 2721, 1981, 1839, 2722, 1982, 1840, 
        2723, 1983, 1841, 2724, 1984, 1842, 2725, 1985, 1843, 2726, 1986, 
        1844, 2524, 2807, 1845, 1062, 1846, 2727, 1987, 1847, 2728, 1988, 
        1848, 2729, 1989, 1849, 2730, 1990, 1850, 2731, 1991, 1851}], 
       Line3DBox[{1853, 2525, 2808, 1852, 2526, 2809, 1854, 2732, 1992, 1855, 
        2733, 1993, 1856, 2734, 1994, 1857, 2735, 1995, 1858, 2736, 1996, 
        1859, 2527, 2810, 1860, 2528, 2811, 1861, 1077, 1862, 2737, 1997, 
        1863, 2738, 1998, 1864, 2739, 1999, 1865, 2740, 2000, 1866}], 
       Line3DBox[{1868, 2529, 2812, 1867, 2530, 2813, 1869, 2531, 2814, 1870, 
        2741, 2001, 1871, 2742, 2002, 1872, 2743, 2003, 1873, 2744, 2004, 
        1874, 2532, 2815, 1875, 2533, 2816, 1876, 2534, 2817, 1877, 1092, 
        1878, 2745, 2005, 1879, 2746, 2006, 1880, 2747, 2007, 1881}], 
       Line3DBox[{1883, 2535, 2818, 1882, 2536, 2819, 1884, 2537, 2820, 1885, 
        2538, 2821, 1886, 2748, 2008, 1887, 2749, 2009, 1888, 2750, 2010, 
        1889, 2539, 2822, 1890, 2540, 2823, 1891, 2541, 2824, 1892, 2542, 
        2825, 1893, 1107, 1894, 2751, 2011, 1895, 2752, 2012, 1896}], 
       Line3DBox[{1898, 2543, 2826, 1897, 2544, 2827, 1899, 2545, 2828, 1900, 
        2546, 2829, 1901, 2547, 2830, 1902, 2753, 2013, 1903, 2754, 2014, 
        1904, 2548, 2831, 1905, 2549, 2832, 1906, 2550, 2833, 1907, 2551, 
        2834, 1908, 2552, 2835, 1909, 1122, 1910, 2755, 2015, 1911}], 
       Line3DBox[{1925, 2021, 1141, 1924, 2846, 2563, 1923, 2845, 2562, 1922, 
        2844, 2561, 1921, 2843, 2560, 1920, 2842, 2559, 1919, 2841, 2558, 
        1918, 2016, 2756, 1917, 2840, 2557, 1916, 2839, 2556, 1915, 2838, 
        2555, 1914, 2837, 2554, 1913, 2836, 2553, 1912, 1140, 2019, 2020}], 
       Line3DBox[{2023, 2324, 1345, 2022, 2930, 2225, 2024, 2931, 2226, 2025, 
        2932, 2227, 2026, 2933, 2228, 2027, 2934, 2229, 2028, 2935, 2230, 
        2029, 2936, 2564, 2847, 2030, 2937, 2231, 2031, 2938, 2232, 2032, 
        2939, 2233, 2033, 2940, 2234, 2034, 2941, 2235, 2035, 2647, 3024, 
        2236, 2325}], 
       Line3DBox[{2037, 2565, 2848, 2036, 1360, 2038, 2942, 2237, 2039, 2943, 
        2238, 2040, 2944, 2239, 2041, 2945, 2240, 2042, 2946, 2241, 2043, 
        2947, 2566, 2849, 2044, 2567, 2850, 2045, 2948, 2242, 2046, 2949, 
        2243, 2047, 2950, 2244, 2048, 2951, 2245, 2049, 2952, 2326, 2327, 
        2439, 2246, 2455}], 
       Line3DBox[{2051, 2568, 2851, 2050, 2569, 2852, 2052, 1375, 2053, 2953, 
        2247, 2054, 2954, 2248, 2055, 2955, 2249, 2056, 2956, 2250, 2057, 
        2957, 2570, 2853, 2058, 2571, 2854, 2059, 2572, 2855, 2060, 2958, 
        2251, 2061, 2959, 2252, 2062, 2960, 2328, 2330, 2253, 2329, 2661, 
        2961, 2307, 2422, 2389, 2412, 2390, 2331}], 
       Line3DBox[{2064, 2573, 2856, 2063, 2574, 2857, 2065, 2575, 2858, 2066, 
        1389, 2067, 2962, 2254, 2068, 2963, 2255, 2069, 2964, 2256, 2070, 
        2965, 2576, 2859, 2071, 2577, 2860, 2072, 2578, 2861, 2073, 2579, 
        2862, 2074, 2966, 2332, 2441, 2257, 2333, 2425, 2967, 2308, 2426, 
        2391, 2423, 2392, 2334, 2662, 2968, 2424, 2309, 2381, 2258, 2440}], 
       Line3DBox[{2076, 2580, 2863, 2075, 2581, 2864, 2077, 2582, 2865, 2078, 
        2583, 2866, 2079, 1402, 2080, 2969, 2259, 2081, 2970, 2260, 2082, 
        2971, 2584, 2867, 2083, 2585, 2868, 2084, 2586, 2869, 2085, 2468, 
        3051, 2665, 2086, 2469, 2648, 3025, 2442, 2337, 2456, 2443, 2444, 
        2395, 3045, 2310, 2413, 2311, 2396, 2087, 3026, 2335, 2382, 2336, 
        2088}], Line3DBox[{2090, 2587, 2870, 2089, 2588, 2871, 2091, 2589, 
        2872, 2092, 2590, 2873, 2093, 2591, 2874, 2094, 1415, 2095, 2972, 
        2261, 2096, 2973, 2592, 2875, 2097, 2593, 2876, 2098, 2594, 2877, 
        2099, 2340, 3028, 2650, 2100, 2645, 3019, 2338, 2312, 2397, 2101, 
        2649, 3027, 2383, 2339, 2102, 2974, 2262, 2103}], 
       Line3DBox[{2105, 2595, 2878, 2104, 2596, 2879, 2106, 2597, 2880, 2107, 
        2598, 2881, 2108, 2599, 2882, 2109, 2600, 2883, 2110, 1429, 2111, 
        2975, 2601, 2884, 2112, 2602, 2885, 2113, 2343, 3029, 2651, 2114, 
        2313, 2341, 3046, 2399, 2398, 2115, 2400, 2401, 3020, 2342, 2460, 
        2459, 2116, 2466, 3050, 2664, 2465, 2458, 2117, 2603, 2886, 2118}], 
       Line3DBox[{2122, 2976, 2263, 2120, 2977, 2264, 2124, 2978, 2265, 2126, 
        2979, 2266, 2128, 2980, 2267, 2130, 2981, 2268, 2132, 2982, 2269, 
        2134, 2983, 1443, 2136, 2347, 2446, 3033, 2270, 2348, 2430, 2432, 
        2431, 2349, 2656, 3048, 2419, 2271, 2451, 2428, 2429, 2385, 3021, 
        2272, 2384, 2654, 3035, 2273, 2141, 2984, 2274, 2143, 2985, 2275, 
        2145}], Line3DBox[{2144, 2896, 2612, 2142, 2895, 2611, 2140, 2350, 
        2450, 3034, 2653, 2139, 2417, 2445, 3031, 2659, 2345, 2403, 2427, 
        2402, 2138, 2418, 3030, 2660, 2344, 2314, 2137, 2652, 3032, 2346, 
        2135, 2894, 1442, 2133, 2893, 2610, 2131, 2892, 2609, 2129, 2891, 
        2608, 2127, 2890, 2607, 2125, 2889, 2606, 2123, 2888, 2605, 2119, 
        2887, 2604, 2121}], 
       Line3DBox[{2147, 2613, 2897, 2146, 2986, 2276, 2148, 2987, 2277, 2149, 
        2988, 2278, 2150, 2989, 2279, 2151, 2990, 2280, 2152, 2991, 2281, 
        2153, 2992, 2470, 2614, 3052, 2471, 2352, 2353, 2433, 1456, 2434, 
        2404, 2405, 2386, 3022, 2282, 2354, 2351, 3036, 2283, 2154, 2993, 
        2284, 2155, 2994, 2285, 2156, 2995, 2286, 2157}], 
       Line3DBox[{2159, 2615, 2898, 2158, 2616, 2899, 2160, 2996, 2287, 2161, 
        2997, 2288, 2162, 2998, 2289, 2163, 2999, 2290, 2164, 3000, 2291, 
        2165, 3001, 2356, 2358, 2617, 3037, 2357, 2406, 2315, 2414, 2393, 
        3044, 2657, 2359, 2355, 2467, 1471, 2166, 3002, 2292, 2167, 3003, 
        2293, 2168, 3004, 2294, 2169, 3005, 2295, 2170}], 
       Line3DBox[{2172, 2618, 2900, 2171, 2619, 2901, 2173, 2620, 2902, 2174, 
        3006, 2296, 2175, 3007, 2297, 2176, 3008, 2298, 2177, 3009, 2360, 
        2362, 2299, 2361, 1675, 2316, 2435, 2394, 2415, 3047, 2658, 2364, 
        2453, 2454, 2317, 2464, 2463, 3049, 2663, 2462, 2461, 2621, 2903, 
        2178, 1485, 2179, 3010, 2300, 2180, 3011, 2301, 2181, 3012, 2302, 
        2182}], Line3DBox[{2184, 2622, 2904, 2183, 2623, 2905, 2185, 2624, 
        2906, 2186, 2625, 2907, 2187, 3013, 2303, 2188, 3014, 2365, 2366, 
        2189, 3038, 2318, 2363, 2319, 2437, 2420, 2421, 3039, 2407, 2438, 
        2320, 2436, 2321, 1659, 2190, 2367, 2452, 2368, 2908, 2191, 2626, 
        2909, 2192, 2627, 2910, 2193, 1498, 2194, 3015, 2304, 2195, 3016, 
        2305, 2196}], 
       Line3DBox[{2198, 2628, 2911, 2197, 2629, 2912, 2199, 2630, 2913, 2200, 
        2631, 2914, 2201, 2666, 3053, 2472, 2202, 2473, 3054, 2371, 2447, 
        2372, 2457, 2448, 2449, 3040, 2408, 2322, 2416, 2323, 2409, 2203, 
        3041, 2369, 2387, 2370, 2915, 2204, 2632, 2916, 2205, 2633, 2917, 
        2206, 2634, 2918, 2207, 2635, 2919, 2208, 1510, 2209, 3017, 2306, 
        2210}], Line3DBox[{2224, 2380, 1612, 2223, 2929, 2644, 2222, 2928, 
        2643, 2221, 2927, 2642, 2220, 2926, 2641, 2219, 2925, 2640, 2218, 
        2924, 2639, 3018, 2217, 2375, 2388, 2374, 3043, 2216, 2410, 2411, 
        2373, 3023, 2646, 2215, 2379, 3042, 2655, 2214, 2923, 2638, 2213, 
        2922, 2637, 2212, 2921, 2636, 2211, 2920, 2377, 2376, 2378}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{736, 944, 2667, 737, 957, 763, 2762, 971, 777, 2767, 985, 
        791, 2774, 999, 805, 2783, 1013, 819, 2794, 1027, 833, 1041, 2709, 
        847, 1055, 2721, 861, 2809, 1069, 875, 2813, 1083, 889, 2819, 1097, 
        903, 2827, 1111, 917, 2836, 1125, 931}], 
       Line3DBox[{738, 945, 2668, 739, 958, 2678, 764, 972, 778, 2768, 986, 
        792, 2775, 1000, 806, 2784, 1014, 820, 2795, 1028, 834, 1042, 2710, 
        848, 1056, 2722, 862, 1070, 2732, 876, 2814, 1084, 890, 2820, 1098, 
        904, 2828, 1112, 918, 2837, 1126, 932}], 
       Line3DBox[{740, 946, 2669, 741, 959, 2679, 765, 973, 2688, 779, 987, 
        793, 2776, 1001, 807, 2785, 1015, 821, 2796, 1029, 835, 1043, 2711, 
        849, 1057, 2723, 863, 1071, 2733, 877, 1085, 2741, 891, 2821, 1099, 
        905, 2829, 1113, 919, 2838, 1127, 933}], 
       Line3DBox[{742, 947, 2670, 743, 960, 2680, 766, 974, 2689, 780, 988, 
        2696, 794, 1002, 808, 2786, 1016, 822, 2797, 1030, 836, 1044, 2712, 
        850, 1058, 2724, 864, 1072, 2734, 878, 1086, 2742, 892, 1100, 2748, 
        906, 2830, 1114, 920, 2839, 1128, 934}], 
       Line3DBox[{744, 948, 2671, 745, 961, 2681, 767, 975, 2690, 781, 989, 
        2697, 795, 1003, 2702, 809, 1017, 823, 2798, 1031, 837, 1045, 2713, 
        851, 1059, 2725, 865, 1073, 2735, 879, 1087, 2743, 893, 1101, 2749, 
        907, 1115, 2753, 921, 2840, 1129, 935}], 
       Line3DBox[{746, 949, 2672, 747, 962, 2682, 768, 976, 2691, 782, 990, 
        2698, 796, 1004, 2703, 810, 1018, 2706, 824, 1032, 838, 1046, 2714, 
        852, 1060, 2726, 866, 1074, 2736, 880, 1088, 2744, 894, 1102, 2750, 
        908, 1116, 2754, 922, 1130, 2756, 936}], 
       Line3DBox[{8, 1725, 23, 1739, 38, 1754, 53, 1769, 68, 1784, 83, 1799, 
        98, 1814, 113, 1829, 128, 1844, 143, 1859, 158, 1874, 173, 1889, 188, 
        1904, 203, 1918, 218}], 
       Line3DBox[{748, 2757, 950, 749, 2759, 963, 769, 2763, 977, 783, 2769, 
        991, 797, 2777, 1005, 811, 2787, 1019, 825, 2799, 1033, 839, 1047, 
        853, 2807, 1061, 867, 2810, 1075, 881, 2815, 1089, 895, 2822, 1103, 
        909, 2831, 1117, 923, 2841, 1131, 937}], 
       Line3DBox[{750, 951, 2673, 751, 2760, 964, 770, 2764, 978, 784, 2770, 
        992, 798, 2778, 1006, 812, 2788, 1020, 826, 2800, 1034, 840, 1048, 
        2715, 854, 1062, 868, 2811, 1076, 882, 2816, 1090, 896, 2823, 1104, 
        910, 2832, 1118, 924, 2842, 1132, 938}], 
       Line3DBox[{752, 952, 2674, 753, 965, 2683, 771, 2765, 979, 785, 2771, 
        993, 799, 2779, 1007, 813, 2789, 1021, 827, 2801, 1035, 841, 1049, 
        2716, 855, 1063, 2727, 869, 1077, 883, 2817, 1091, 897, 2824, 1105, 
        911, 2833, 1119, 925, 2843, 1133, 939}], 
       Line3DBox[{754, 953, 2675, 755, 966, 2684, 772, 980, 2692, 786, 2772, 
        994, 800, 2780, 1008, 814, 2790, 1022, 828, 2802, 1036, 842, 1050, 
        2717, 856, 1064, 2728, 870, 1078, 2737, 884, 1092, 898, 2825, 1106, 
        912, 2834, 1120, 926, 2844, 1134, 940}], 
       Line3DBox[{756, 954, 2676, 757, 967, 2685, 773, 981, 2693, 787, 995, 
        2699, 801, 2781, 1009, 815, 2791, 1023, 829, 2803, 1037, 843, 1051, 
        2718, 857, 1065, 2729, 871, 1079, 2738, 885, 1093, 2745, 899, 1107, 
        913, 2835, 1121, 927, 2845, 1135, 941}], 
       Line3DBox[{758, 955, 2677, 759, 968, 2686, 774, 982, 2694, 788, 996, 
        2700, 802, 1010, 2704, 816, 2792, 1024, 830, 2804, 1038, 844, 1052, 
        2719, 858, 1066, 2730, 872, 1080, 2739, 886, 1094, 2746, 900, 1108, 
        2751, 914, 1122, 928, 2846, 1136, 942}], 
       Line3DBox[{760, 1138, 1139, 761, 969, 2687, 775, 983, 2695, 789, 997, 
        2701, 803, 1011, 2705, 817, 1025, 2707, 831, 2805, 1039, 845, 1053, 
        2720, 859, 1067, 2731, 873, 1081, 2740, 887, 1095, 2747, 901, 1109, 
        2752, 915, 1123, 2755, 929, 1141, 1142, 1143}], 
       Line3DBox[{930, 1124, 1140, 916, 1110, 2826, 902, 1096, 2818, 888, 
        1082, 2812, 874, 1068, 2808, 860, 1054, 2806, 846, 2708, 1040, 832, 
        1026, 2793, 818, 1012, 2782, 804, 998, 2773, 790, 984, 2766, 776, 970,
         2761, 762, 956, 2758, 735, 943, 1137, 1144}], 
       Line3DBox[{1146, 1346, 2930, 1147, 1360, 1175, 2852, 1374, 1189, 2857, 
        1387, 1202, 2864, 1399, 1214, 2871, 1411, 1227, 2879, 1424, 1240, 
        2888, 1436, 2977, 1253, 1449, 2986, 1267, 2899, 1463, 1282, 2901, 
        1477, 1296, 2905, 1490, 1309, 2912, 1502, 1321, 2921, 1513, 1334}], 
       Line3DBox[{1148, 1347, 2931, 1149, 1361, 2942, 1176, 1375, 1190, 2858, 
        1388, 1203, 2865, 1400, 1215, 2872, 1412, 1228, 2880, 1425, 1241, 
        2889, 1437, 2978, 1254, 1450, 2987, 1268, 1464, 2996, 1283, 2902, 
        1478, 1297, 2906, 1491, 1310, 2913, 1503, 1322, 2922, 1514, 1335}], 
       Line3DBox[{1150, 1348, 2932, 1151, 1362, 2943, 1177, 1376, 2953, 1191, 
        1389, 1204, 2866, 1401, 1216, 2873, 1413, 1229, 2881, 1426, 1242, 
        2890, 1438, 2979, 1255, 1451, 2988, 1269, 1465, 2997, 1284, 1479, 
        3006, 1298, 2907, 1492, 1311, 2914, 1504, 1323, 2923, 1515, 1336}], 
       Line3DBox[{1152, 1349, 2933, 1153, 1363, 2944, 1178, 1377, 2954, 1192, 
        1390, 2962, 1205, 1402, 1217, 2874, 1414, 1230, 2882, 1427, 1243, 
        2891, 1439, 2980, 1256, 1452, 2989, 1270, 1466, 2998, 1285, 1480, 
        3007, 1299, 1493, 3013, 1312, 3053, 1714, 1715, 1324, 3042, 1606, 
        1607, 1609}], 
       Line3DBox[{1154, 1350, 2934, 1155, 1364, 2945, 1179, 1378, 2955, 1193, 
        1391, 2963, 1206, 1403, 2969, 1218, 1415, 1231, 2883, 1428, 1244, 
        2892, 1440, 2981, 1257, 1453, 2990, 1271, 1467, 2999, 1286, 1481, 
        3008, 1300, 1590, 3014, 1591, 1688, 1717, 1598, 3054, 1716, 1599, 
        1601, 3023, 1538, 1608, 1539, 1652, 1647, 1611}], 
       Line3DBox[{1156, 1351, 2935, 1157, 1365, 2946, 1180, 1379, 2956, 1194, 
        1392, 2964, 1207, 1404, 2970, 1219, 1416, 2972, 1232, 1429, 1245, 
        2893, 1441, 2982, 1258, 1454, 2991, 1272, 1468, 3000, 1287, 1585, 
        3009, 1586, 1588, 1537, 3038, 1592, 1680, 1679, 1681, 1643, 1689, 
        3040, 1644, 1600, 1646, 1682, 1645, 1622, 1603, 3043, 1610, 1604, 
        1337}], Line3DBox[{1158, 1352, 2936, 1160, 1366, 2947, 1181, 1380, 
        2957, 1195, 1393, 2965, 1208, 1405, 2971, 1220, 1417, 2973, 1233, 
        1430, 2975, 1246, 1442, 2983, 1259, 1710, 2992, 1712, 1273, 1579, 
        3001, 1581, 1583, 1536, 1587, 1675, 1674, 1676, 1641, 1660, 3039, 
        1642, 1593, 1678, 1694, 1677, 1621, 1595, 3041, 1602, 1597, 1325, 
        1516, 3018, 1338}], 
       Line3DBox[{1162, 1354, 2937, 1163, 2850, 1368, 1183, 2854, 1382, 1197, 
        2860, 1395, 1210, 2868, 1407, 1222, 2876, 1419, 1235, 2885, 1432, 
        1248, 3032, 1571, 1572, 1444, 3033, 1261, 1685, 1687, 1686, 1576, 
        1672, 1673, 1456, 1275, 1637, 1638, 1584, 3044, 1627, 1470, 1289, 
        1700, 1701, 1699, 3049, 1703, 1483, 1302, 1594, 2908, 1495, 1314, 
        2916, 1506, 1327, 2925, 1518, 1340}], 
       Line3DBox[{1164, 1355, 2938, 1165, 1369, 2948, 1184, 2855, 1383, 1198, 
        2861, 1396, 1211, 2869, 1408, 1223, 2877, 1420, 1236, 3029, 1569, 
        1570, 1433, 1249, 3030, 1655, 1533, 1670, 1625, 1671, 1626, 3048, 
        1656, 1636, 1651, 1535, 1577, 1457, 3022, 1276, 1578, 1471, 1290, 
        1698, 2903, 1484, 1303, 2909, 1496, 1315, 2917, 1507, 1328, 2926, 
        1519, 1341}], 
       Line3DBox[{1166, 1356, 2939, 1167, 1370, 2949, 1185, 1384, 2958, 1199, 
        2862, 1397, 1212, 3051, 1706, 1707, 1409, 1224, 3028, 1564, 1565, 
        1421, 1237, 1634, 3046, 1530, 1650, 1623, 1668, 1624, 1684, 3031, 
        1654, 1669, 1534, 1618, 1445, 3021, 1262, 1575, 1458, 3036, 1277, 
        1472, 3002, 1291, 1485, 1304, 2910, 1497, 1316, 2918, 1508, 1329, 
        2927, 1520, 1342}], 
       Line3DBox[{1168, 1357, 2940, 1169, 1371, 2950, 1186, 1385, 2959, 1200, 
        1550, 2966, 1551, 1683, 1709, 3025, 1557, 1708, 1558, 1560, 3019, 
        1528, 1566, 1529, 1649, 1633, 1568, 1635, 3020, 1531, 1693, 1532, 
        1702, 1692, 1691, 3034, 1573, 1619, 1574, 3035, 1263, 1459, 2993, 
        1278, 1473, 3003, 1292, 1486, 3010, 1305, 1498, 1317, 2919, 1509, 
        1330, 2928, 1521, 1343}], 
       Line3DBox[{1170, 1358, 2941, 1171, 1372, 2951, 1187, 1546, 2960, 1547, 
        1549, 1524, 1552, 2967, 1525, 1667, 1666, 1554, 1631, 1648, 1526, 
        3045, 1559, 1527, 1632, 1617, 3027, 1562, 1567, 1563, 1704, 3050, 
        1705, 1695, 1697, 1696, 1250, 2895, 1446, 2984, 1264, 1460, 2994, 
        1279, 1474, 3004, 1293, 1487, 3011, 1306, 1499, 3015, 1318, 1510, 
        1331, 2929, 1522, 1344}], 
       Line3DBox[{1172, 1541, 1542, 3024, 1173, 1543, 2952, 1544, 1545, 1523, 
        1548, 2961, 1662, 1661, 1663, 1629, 1653, 1630, 1553, 2968, 1665, 
        1690, 1664, 1616, 1555, 3026, 1561, 1556, 1225, 1422, 2974, 1238, 
        2886, 1434, 1251, 2896, 1447, 2985, 1265, 1461, 2995, 1280, 1475, 
        3005, 1294, 1488, 3012, 1307, 1500, 3016, 1319, 1511, 3017, 1332, 
        1612, 1613, 1614}], 
       Line3DBox[{1333, 1512, 2920, 1605, 1320, 1501, 2911, 1308, 1489, 2904, 
        1295, 1476, 2900, 1281, 1462, 2898, 1266, 1448, 2897, 1252, 2976, 
        1435, 2887, 1239, 1423, 2878, 1226, 1410, 2870, 1213, 1398, 2863, 
        1201, 1386, 2856, 1188, 1373, 2851, 1174, 1359, 2848, 1145, 1345, 
        1540, 1615}], 
       Line3DBox[{1339, 1517, 2924, 1326, 1505, 2915, 1596, 1313, 1494, 1620, 
        1659, 1658, 1301, 1482, 1628, 3047, 1589, 1640, 1657, 1639, 1288, 
        1469, 3037, 1582, 1580, 1274, 1455, 3052, 1713, 1711, 1260, 1443, 
        2894, 1247, 1431, 2884, 1234, 1418, 2875, 1221, 1406, 2867, 1209, 
        1394, 2859, 1196, 1381, 2853, 1182, 1367, 2849, 1161, 1353, 2847, 
        1159}]}, {}, {}, {}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzt3X1olVUAx/HLdG1sQYGIFrPSWpKy6C+xN24G1cASHeiG0h86Yitbe3Gb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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{384.00677241901184`, 184.31790299227256`},
  ImageSizeRaw->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {-8.999998999999999, 5.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{0.9235287177912108, -3.1942818049255743`, 0.6274220733575889},
  ViewVertical->{-0.05149934813419784, 0.1781248677399412, 
   0.9826593248091534}]], "Output",
 CellChangeTimes->{
  3.9157773268226376`*^9, 3.915777357703535*^9, {3.915777531640896*^9, 
   3.9157775750051155`*^9}, 3.9157779875405464`*^9, 3.915852526023477*^9, 
   3.925815313821966*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"d1335857-f34e-e248-87c1-7ac8e3c7ede3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", " ", "=", " ", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"a", "[", 
     RowBox[{"[", "2", "]"}], "]"}], "]"}], "+", " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"a", "[", 
     RowBox[{"[", "3", "]"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.915777407731264*^9, 3.915777413331753*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"c4bcae3e-c77e-e64e-9ed5-895de3c8db23"],

Cell[BoxData["7"], "Output",
 CellChangeTimes->{
  3.915777413819217*^9, {3.915777983297062*^9, 3.915777987575716*^9}, 
   3.915852526050316*^9, 3.9258153200875683`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"a3e23f2f-1cac-f84d-864d-b98c3a156d0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.915777976194828*^9, 3.915777977043146*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"8b6b6852-d85d-464d-b4c6-8fbe9d377436"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellChangeTimes->{{3.9157779779700184`*^9, 3.91577798758687*^9}, 
   3.9158525260706797`*^9, 3.92581532120109*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"739c232f-167a-3c45-962f-ab5aa06f9b04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"M", " ", "=", " ", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "+", "S"}]}]], "Input",
 CellChangeTimes->{{3.915777364683105*^9, 3.9157774171526546`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"4aa6fa1d-4438-274f-b1cb-2ee4a1d3b761"],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{{3.915777401545452*^9, 3.915777417686943*^9}, {
   3.9157779851833267`*^9, 3.91577798758687*^9}, 3.915852526075706*^9, 
   3.925815322200098*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"9ac6e441-e080-e349-b262-4c59b6630ea5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"B", " ", "=", " ", 
   RowBox[{"M", "/", "2"}]}], ";", " ", 
  RowBox[{"c", " ", "=", " ", 
   RowBox[{"M", "/", 
    RowBox[{"(", 
     RowBox[{"6", "S"}], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.915777745324705*^9, 3.915777760378784*^9}, {
  3.915777879516497*^9, 3.91577788247266*^9}, {3.925816224209133*^9, 
  3.925816224248699*^9}, {3.925816258154545*^9, 3.92581627426248*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"79382ef7-c92f-454d-b758-90c97aa96267"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"t_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"B", "+", 
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "t"}], " ", "+", " ", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"[", "3", "]"}], "]"}], "s"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.915777772486887*^9, 3.915777794773081*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"901f65e6-0759-e147-8193-091ccb4b26fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"relu", "[", 
      RowBox[{"f", "[", 
       RowBox[{"t", ",", "s"}], "]"}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"t", ",", "s"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.915777804374485*^9, 3.915777806470356*^9}, 
   3.9157778560730305`*^9, {3.915778010786541*^9, 3.9157780621981373`*^9}, {
   3.9258153613681507`*^9, 3.9258153627886868`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"9a58861d-cce7-f748-a5a4-2226439acdcc"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyEfQm8jcX//7EvWVOJr2wJlewKLXNkLxURKiRlqZAQJXQppVBcZGuxdKVQ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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1nHXAFUXbxs/Z5exhlmdEQECQsAUUJSx8ERDsBBUVVECUlBKUUFHBwBax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            "]], Polygon3DBox[CompressedData["
1:eJwtnAW0HUUWRfu9l+5PN/+jwd3d3RPcgrtDcHeXAMHdbQg2uLu7+6CDu8MM
gzvM3pxei+LX7aqutqpb55x7X6baYpc1du4WRTHZoKLgv+LAuihO4++EVVHM
P1AUh2Ofiz059kLYh2GfY3/sBbG3bopioFMUf5VFcR72obSfTfuktC+APV8f
4/SK4hWOncmxb+m/Dxf8Hft06jPSf27q/+L88em/HX1LygB91mLcA2g/lfYJ
OHc+2u+h7TzaDqHtfcrJHF+Bv7tSNqG+KuVT+u+DfSn1Wbj+j7ZRzsGek/EW
pn056scw3leeQ9t4jPkf6q9XOfdnyrvU16f8RP9ZKcval+u/QN9Pad+Xcg3H
jubvmpTTqd9M+Sf1sSk7Uf+EZ3yD/t9in0J9FY8x1ujY51IfxP1wuLie5+9x
PztUeZ+7cWwYx/po53BxE/WKypvYh2Kv377vEnt07BuwB2Fvz/kN5+/BsR84
tgX3O4jSdPOcy9P+Hm27Ub+E+jDKpdQvo9xK/eD+oriP+iPUL2C8hTj3dc79
hmOrUCquR5fiRsYuaV+cm+9xfEv6X4S9Cf2vof9W9FmJ47djn4a9A/XXKA9j
/4K9LvV3KDdy3vlej/IU9eso5/qtOnnG5Rl/ZeorcXwHxt+cv+sy9r2ORX05
xjuJ8bbEvrrI+b6f87BvoL4d519A/Sbq/+D80+h/Tjff+DHKVtg3Yp/POath
L4V9Avbm7Tvci+c9hr9jcv4cnL8v9vHY42DPjT2c8f/C3qx9X7vwdxzOXYQy
GXPvXsYbxXiHYb9FGUz/X+m/Ef1Oov+ujDfS+YA9G/ZQ+m9N/w59d3ce0H4E
7f20z077Vfw9qpM559w7h/6X0v8S7EcpJ9L/CvrPTNti3i9/p+rkHfuuF6X/
ffR/G3s5yjTcz3j8PYlzpqb+PH1ecGzsKahvSv8FKUtxbDTKndTP4Pw9XB+U
ZbjeGvT9jG81Cdc7v5tv4rc4lPbLqf/JsSOpf0Y5A/sT1z/1wynbcI0+/j7Z
zqFNKetxbhd7OPXH6f8b/dfDfo+yIXaP0sexFbGvoM/gTvzBldT3o3xV5B1d
TX14L3PYuTuWc456P+U/HS8Sn6BvWMR3xvdambZrOf4Mx/bk2JE834X8nYZ+
C/N8R2FfhD0t9iLYq9H/pW6ebSRlHeyTsaelvizltibzoWbsK+l/K/ZitI/P
+fNgv0f/MShf06fL8RWob8vfmbCPpZzJ9W7kenPRfwn67419LPZY+jLsDjZD
F9fw/jvY+2Afhz027XNhz0PjRYx3nOtPX0X7xbRP51zQXzfxn2/ptwbyre+h
/+udfPOD9aH8/TfnXMA19uD8M6kPcHxn+i9G/4e7+TZ/r1PsY7DXob4o/c6g
/w38nZP+i9P/AP7O0MnzHUR9G/ofSP9JsdfQn9P/KtcibcfT/1X+fsDx1Smz
8yxPYD9EfQHnEPXL/ObYS1NOoN7j/Fo/wL12Of9Rjo3AfsD1Tn1expi3lzk/
I/XBdJ6E9vvoPwb9J8OeDvsx7HGx/8Lejr6jXGvYD3Duj1x7SY79QHnTsShP
dfLOxqP/pJx/P+ePOZA9yb1pF8rFVda96/8M7GupT8r7f5r6c9Qvpv8djPVO
N2O7Rx7nvGvnovvJuIw/sf6P8Qfo/y+O3UL/uygv+s5c9/S/mz6zVJnfx9F2
eDd74YOM/1M37+sX+2F/2E19TMoB2NdjP0f9v52shUMpP3WyJi6mfT/s/k6O
vYU9PuV53wXlNDaHg2if0vnbH998FOXPTnz0l9SPof/c1P/SL1V5v9tTLhBj
eI/d+Jpt/db0/bmbtfQH5T7sz7qpT0M5rInvcD2/1mQPcy8b5nx0P+M9Xe46
pEyJfTfnrs8YSzinKUdyzkveO22X8D4X4P0uybt7i/Mmwp4EexrsR7DHHsj+
7rdwz7yF+ky0z4P9Au0T0L4m4+3UyR7boT4z7fNSf5H2CWk/j3O2oP0fzn+O
LUj7UrS/TX3idj9dqBMfOHGT/c79xf1giyrf5g7Kq518o6N4lmexP+7Ep74r
durl23V815zzCvXbqS/Muz2Wv093s/duRGma9n7od/ZAMIHY4I8i8/VAyovY
H/q+qN+pL2b8RTu5B/31n/RdRBDJ+G/TNgHl5U72GK+5bi/P5L1MzPNOTdeH
ed6xuN5JXP9/9m39j3vvEZRfO9mDX9CPdeIf/UZ/jQbu4Pyr+N9fzK9xGG8i
7Huw+zm/H3tc7NuwR8P+g/5cvrgC+w/6L8L97NDLt3e9nF1lb3mD8lIVfLZZ
Jz5F3+K73Y/+X3Xyjkdn/HEY71axmevVb8LxO51j1KemfWban6Z9PNqnwp4J
+ynswdj/Zrx9e/n+jnkDzz87f0eIfWgfoP9g+t9O/xp7UuxpsR/FHgd7S57h
/taXXTgQPKdv+Y0+G1P/nlJhD6J8R/1MrnVBN3vt465xxhufvncy3uicPwb2
eNh3YDfYuzdZe1uLEQWmtDNMcbUvXf/IseFUl8TeHnupJmvpCY4t2AR/b9qJ
zzqW+racfzRtPeo7iXf4e00nGO/6Fn9+7PvEvpf6G+JjfQH3vQDf6rfR/t6m
i8u53u88+6HOLQ58Tp/v3WPo8wz2R53g9QspO+obOPa/Kn334pwvOjlnMe5x
QfcpOQX1fzoH6LMrfeb0es7HXubkv6n/OVp40ZVc/0+ufzV9J+kFO+jzl+Kc
73rBujNQP63KXjUxZdcy9ySXGNnLva5SBlc6x8T/2zPmjc4fcfBA9s4RlO86
2UNv5/heReaYc+1uyij5APY9VZ59H8b+spN3sDjXmLSXtf8B7a/yd2/sszvp
Iwdbm7879sLN3I8fdz1y7EkxMv0P7ga7jaC8Qn1P+p7eyTu8iz5f0v/m9vre
j3X37914tp16wZhiS338JdR/Z4z9O+FM32LP1ItPkRP9wvnz0T6vGJ7zvxZn
c3whfXyVd/7DoKxpv4X9xarz0/5blTn5y6DMYefq1uJy2hYVQ/N8N/MNF6b+
F8evoO9tXHt6yhQc+7oIfjy4kznp3DyCMa7j+FTt99iB6/9TPul3G8iYjj1z
N+vrPcpv+grGXKwv3PVayl1FOKxY9WrKikUwqxhMX3p/L9jsUu5vMo7/17Uq
v+M6c1NW8xm5l+W4/pzUJ+LYyrQvgz27cxd7ReydsS/H3h9774HsWfNQX73I
XiYm/G1Q1rxYUS54DeWwIpzwU/ouTtkUe2nalxCncvwJ9/sqmGtx+j/RDRZz
j5q3DOZ379qJ619GfT+O7UXbjtiXYu+LvSf2N5w7o3tUJxzSOeJcWYYy2G9J
27fdYL9B3WDwJXrBLGIXOcgw7Ju64SZ/8fdKOUCLQUaj/0rUN6WU1D+lzzjU
xxZLO9e5n1XEn1x3Q+7nXI6f3gv3c05+rL8Ur1M+rIKRxErfUebqyzP77F0x
C/Y6jLeqeJzxNmK8FcVk3VzTa29G++a0D6F924FwoiWob1aEK23an3ftO9/G
+cS4V/Xy7GKm7Wg/i/YdaN99ID5EXzIb7ePqT/uDv7fn+G60z8Q9LcP523SD
Z7eh/Qzat6N9V/25vKGbNfYr9QU5Phf1exjzfTkb52yAvWE3e9AmnL8J5y9G
29acvzH2xtiLYm+FvRH2Ru732Ftib4i9IfbC2MOxN8DeAHshtQfsb8VIjD0n
5Szq3zHfv+pGCziO+rL0n4P+E9J/JfcT7Bnk13J/7JWxF5N/Oad9l9gTYv/F
nF4aewvGONVncY9pgrFmKoOpxF7fOi5lF+w1sRfn/Amo/8H5Sw0Es81YBvOJ
5dyzp8ZeqMhevgL955cLc2wV2lbBXkL+hL2m3x97AewpsVfFXgl7Qf2Ha1h+
hD0W9tdcb8mBcIzxymAEuYeaTl8ZzqDW4x48Zpk9373ZPXqsMpzEvVvM0Y89
VREsIuYZF3vGIlhoSb7nB71oPdP2BQMNlMFcYqNb3PcpU+ou62hOnTIYSi1K
zjI+9ixFuIwaT1mGI6n9iEnGKIOJxSpqTr0ynEQtSs7lt/EbycV+acIR5AYv
Ux/G+1ictmn1IfRdFXsI9vTYa2EPwZ5C34S9DPai2Lj94nfGHIr9J8fXoxzC
seGMvzzt81GfnGPDxEuU1anvKx6ifY4m+oc6yGnydfov7dygz9p+a8q61A/m
2Bb0nwp7HeyDsDfHnhJ7bewD3bOxh/bn3fkOl6VtcjE/9f05tgntk2Gvgb0f
9kbYU2CvhX0A9qZ+H86fnvrYHFvOe8VeRq6GvQ720v35ln7TFVq9507nYid6
xhq0L4s9K+3rqiewlibrRTsQc69F+zDa56B9g4FgTufi33OS6z9f5l37zmeo
o7nOgD20iBYrJp9YH1EEq2/dH/y2iWuItofK7EV/70l1MIbc74ZusIecebIy
nEcuvRXnH+W3KKMXiGEnLcOZxLZyqknKaMByrcspL1FfgnEPo+1Unu39bjCU
mt26/dkb3SM3pv3LKtrtYDEh9Z3rfMtaX0775/rtXjCPe/6dLX92zjv37275
unPcuX5Xqwc4p53b9/hNi6xR1+pOdebGaIw/s/tdnbnRp58byJzbDvunMnNx
KO/k6V40jFeqYESxonvGZ9g71JkbFfUZ6b99nblU2hd7a+y9hZvY02FvVQcP
drCnxX6G+b2JewfjToN9Ge0vur/Qfqh8lbZZe8EcYq47Wr7kGnWtPtLylcGt
nnComLnInuDe8BTnHtCNNiAnc43oS/8os3ZcIzu7PsusHef4jti/lpn7roHt
sX8uszaGMOZjvWjy71RZMzvQ/kuZteQa2wn7tzJrT3H8vSLcRr1ePuHaGoQ9
PfaztG/G/U3NuLNinyLe7UZPUFdYkONLc729O8H3W1XhNmqOao9ndaP5/q31
irk59gP1d4vo/erxu+uLxcxyBfq+1Q33UHNduxcNUO1PzCe+V9uvO9HfT+0P
vlSbPNf9oheNT21PTe7ibjQztTIx9sHUx1VTcX5w7JJuNEk1BzH8DTz/22IJ
xjtaX80zDZGTUyZsn089/g4xZpVv6reVg6odydvkb8vR/8syHOtX6jt3wr2W
7EWDVntW472Wc96g/5JiY8Z6gve9Pv0nEidhz8/fR7vRVmej/i/at8Q+g7FH
urc2wS//0MdTP4SxB1MmFfNybGvqC/eCB8WFrpU/1Gg6WTPbYy/SS3xFTfU6
7udNzluK+zmS8a/Hfkvsin0U9k1qu93weXm9fEJ8PTnlMOobcF+H65u70efF
ujP3omWLedUIvhsUjq924Br9VG7Yy9o9VlzDOdPRd9YqGFGs+G4389nn9vnX
pCwgp+fvLL3EqsTAl5XBAmKC0Xkf+3G9R6ifWsbfyXG/oX3sItx3esafQf7a
Cx7fn/anaDuzzPcY3p+9zj1Pfq1e+2oRzWRkFcwqdn28G/8zhhyU+uaU0fsS
V1m5fVdqIee5N/hscuUqfNHYnRhOLKe/dV46P42XnSBX7kZvE5Ovz/2sRfv8
cgruZz3sNbHnw94E+3ue+axetIgRag0cn18uSJ81XOPyEez/FNEvZ1AfYdwf
qV+uv2G8LWgbSr/t3HuxV8aeHXt97H2xH8Y+pYz/OwD7aeyzysyX2+vgPzmR
3OiWVm+RY8o1+5rED4wjqD/vxbF7sI8TI2DvgX0r9pHu6di7Yd+MPdI9X7yN
fQv2EWIC7AvqfC/nwtX6c46fgr2qPpX3vyf9b8M+SowhnuDYxt28A9/F1Zy/
bru2rx2I5vXToNyzWli3L2P5TQeo39bqO3JiufHh/dGD1YXV94xPOfflTH30
P7XO8zmXT5dv9If/jhBDuZ5avcs56dwc0iS+qih0lvtLq7e5Zlw7t7Z6kvfo
vR5IeUbfVWZ9Tsc1p+1lTbm2+lr+tnI3MZKD6P8s/c8p499GNsEXe9D3WOy9
ab+X9uPFgNijuN5anDsF514jH6B9G/0B7Tti72M8E/sE7BE+P/a12Idg74N9
utiH89emzM811uPYg1X40f5ce412f/tfy4f+xiTUHy2CVbwH78VrXFRnjjhX
vMcL6/jI07AfK+I7t2kSixtFmb/JPXlv99N+Mf0X4donYj+g768zh53L+gj3
9vc550L1GO53LerPcuzHIjHqsbBPFM9WOTYm9mlNtKRjOedj6ke4DzHe87Qv
0uQd+66fK7K3+I38Vn4DfatrxrXjN9T36nP0Pa4p9wbjK+qR4nFx+T5N9h6/
wa5NMInYRJ87oj8an1qfMXL1872a6EnqSsfR96Am+k5TRd/0+YzN/UwZu0mc
xHjJx0X0feNX+u1CTaHJnjOePL2bvUiNcrsq+7Ha5a+UD3vJLXiF+nxN4lFq
X2fQ92ju8XaGO1oOMBBMIbZwzZ7Yn/wBtVZjOONx7gnie8793uUmFmlSX4Ax
N2+iGakdXcqxY+toImojaibHY89GnynoO1wto8mcdG66Bk+r42P0NfqI8+po
LGotaj4n1PEx+hp90rl1NCC1IGPAxoJPHkgc1Xjqcf2JYZnTIL4xtrV6k7iM
8Zkz1G+bxEPFZ+Zn6DP0HfpjYwWbYff6gh/uMZ+BsnEn53juvk3wldhj1EB8
or5Rn3i2fMxvViYmaGzwd3zYN66vdj90DjgX1DeP4H4HceyjIjkN69bxASdV
wQv6hnvr7B3fUfqxl2ziO/Wh8zbxYfqy68VXdb6p3/YO7IObaChqKWouI4xN
MPYeZWK+xn7lPHKfY4rkAshh5DJyImOh+mx9t3PmH3U0G7Ubc2DMhVGDUYtR
szlY7Mo17+pEw52uSZ6F+RbLF4kHPlQlt8EcB/UZMa/Y1znn3DtlIDhLvHUo
72c82najnEz7/mJnxryykzVVqY24h1WJqY70/jl2dScxpQmbcGK5se/jpDp7
wP5VfKR7w6b6jE72ROfnQpSHqJ+s/6Xf+tgHdpJzsW67/sRA7nknc3/rNMmT
cc9w77iccw7qJAfGeO1GTXRm8wVmabIGn66SD+LadP5+hF3yPcdvkjNhDNX3
NUcd//YmbaPEcE362FeNX63fHBBzQcwRMN4wD8dGb/dX58o5lP5ujp3dxL+K
hcXEP1DfhXJtJz5Cfz0a1xyjxSprVsFzq1eJUYjX9L/rVckxmqbOfL6vSvxR
X+f8dS+bBPuw/mAMsYb83ti3/mTtKvlG49fR/6/rhAOuqmbSJJdGbuP6vZTy
QhGsdkiLkcRK6oVXNcnJebZK/M3YonPYuT5Glbl9TJNYmDGco5rkyJgrI95e
qUn8zfjoLC2e1CcbezKeflC7nxxZhZO4f5gD45w2vm1ujBq6sY0Limjr82L3
M3+HcX/f1Nljl6NttjJ7r/lXxjGMIZm/pb5gLGOSFgPoUx6oEm/T1zxat1pV
GW1NPfC0TvjUXLQ9VEdvUUNTS3ugbrW1MlqWORmNGnc3uRqXYX9RJb45tEkM
W41fbd/Y9qW0f1IlHjtRk5iCsQX3u5XqxPAm7Ut+grG9B+tWuyuj7YnhxHLy
tcdovwp7bOzzxJz0vb9utbUy2t19davdldH+zBFwDxRvr9AEU47TFwwn1jS+
IK+csZN4rTFVY6vukYe2/tq8AmPUxqq7TbRT5/wh7gWUM6mfRdmqiUb6R6vn
jV0Hw4vlxfjL1dkPFlC7cj33RxNWG1YzXq2OJqw2rGa8ah2MLlYfhr1EHY1Y
rVgNeVgdzUrtSs1+aB2NXa1dzWepOpq52vlmRfRcMZlatZq6WE2NWq1aDXv1
OvEN4yHGK9Tf1YzUjoyPGO8wJmBsQE1/yTp6sXr95thr1eEwcpm1sZev8839
9vPgbz5qkmOzU5mcSHNvFmj338tb/2+O5AHtfmzupDlDh7X7n7lE5vDs2O4X
5vaYY3kg9pVFci83H0hMy3juNU32pxEtPnA9mYO2c5kcTXPT5IByQTUStRJz
Jvcqk7N0QLv+9mz3t5P6k+O5d5mcIHM/zUly/3O9mqtkztOh7f7pfqhGtVmZ
HCS1K/XYlcvkK25ZJ+Zh7EOOtnadeJb6ovq68Sg1XvXHoUXiW+qR6o3qf+qP
asJqw2rs89bR2NXah2DPV0ezVbtdBnvhOpqp2umy2IvUiREYK1BjnruOJqw2
rIY/K/ZcTXLbzAnZQXzYRMfRZxg/UMNXy1cvnb2O5q/2r8Y/Wx1NXz11oXb/
GacJNhUDdVq8qcayJccO6U/MTr1UPVW9VU1bbXtK7Anq+Eh9pWvO/dj4+w2d
YFxzg+Qwcplt6b9hnRxIObuYaJImHFgurKazTh0fqi91fzyqPzFCY4XGWKat
oxmrHetzF62jQatFG3OZoo6mrbY9VRF91xiLWqGaofEF9V99kT5JfViNWq16
piL6sjEbYzdq2FPWiekY21Evnr5OvrC5nSOwJ2+icW7a4iu1z+lbvHV0O39X
bJKXqQZwNfVp3eM7yambivq5lDHVnyjniUWb5FqKKUqxbJPcB3NcxK8zNdlL
JugEf70jBmQtL0vZkPpPXHMy2ibvBI+8XSeXV81V7VUfr69XYzM/Z9kmeYjG
EC9rglf99uZg+H2maKIdHtAJPhK/nVgl/+rNFp/tWeWaMzdZQ64lc4B9P2qG
aofmN3p/qzXJexKTic3eaJJLZ87gp85ln68bfe2f8hPKF0X0tBOpX0iZUP2O
clGTnGT3ejU2c5XHbZJ3IGc8tUl+6LidaJgbuB824Q7m7xq/W68JFhUDigXr
JlzBfE/1HfnQCZ1oqmO0+OKMKvuTubnmMJvn65xwbrjnuPes0PI5Ndk9XR/q
+0009s3L5Diqvcvp5Ha7t/N/R/fkTnJYZ2+S43h4mRxKcx+NIRlLqovEp4yH
fdPqfcbTjNF93epvxsfMWTyx5efyFTGB2MAcqA+b8JkTWv4vv5ijxf9iLLGW
Ob3blMlhN9dXDX+jMjm9avtq+BuWyQF2fhlT2KJMjrGxBmMYw7FPKBLbMAd4
2zI5+uYGy08r9v8Vu9HCnb9iaTnlrE1ygI9u+Yl8cMhA+L98X31h5SZcWAx8
uXikTq6neM98nht9Zve7TvQCNR81VPObxfPyAbXC2SgLN8lhMK/TOWlugzmr
J5XRM85s+YVak/rp3O18lvvKQeWi6h/ntPqDeoh8QG5ufsox/cHv07tWOsHr
2zbRUi5o55P+3bHVvE6pg6nF1sYA52wyJ52bF3ajRT5ct9p4mVjqGnzX47vJ
fzPH84Mma0dN+ucme7p7+yRVuN5PVWLb5qyoL8vx5brTV+H+1zfJbTnR/ZX6
I020YTWr55toFGoVW1Fe9H4oq6v3daKXv1AHu4hhzO34V534pTFuY93qf+YT
L97qiXJBfZtzdKsynFatYeIqXNe55L2sps/sC4eXyw9v8c0L2E8W0bC9n5so
C3aToyaefbGOnmsOiLkgnuO5X5TBSifT5zX6z9ZL/pT6nLmow9vnFSubj+N+
5r7m+7BNTf25Jjk95vZM1Em+wi5lYgf6R/2kMQqxqjleF6lPN9EuflAjbqIB
qqF6zVHt8/hu1VDVUp+vkxtgzH+ClpuYfyUn373M84rdzYm6scke716/YRXu
6Xx4hme7mTKM+uN1sIsYxtjpdU3yj8RsYreV3fOxl6Xc1UQjUAucr4p24P1/
7rMz3nvUP62jhaqJ3t9EozDf+fEq2oVr2LU8UxWt57k62EqMZSz3JfqPw1iv
mGNI/fj+PItr0rX5dPs8Yhhjw2qUankLVtEu1VMm1/eV4bfyC7Vr5+yjjHdl
k7lpTsntTTiu/EvNUe77TB3uaw6FuRSvuh7VeikXU/+sji/crPVXalhqWzNW
0bbkY+rAvoMHaL+jSXxLn6RveqpOvN8Ys7HmJ+vEmo0pG1t+ok5s2ZiysWXP
NzdRjfdO6ov7/bvJWTX/T03mUrFOFa1GjC3WXoE+91G/t0l9ecoKdTir3PXU
Fk/L0Y0PqwHK3dX01OJmqKL1PVa3XL5MboV8z3Xn+nuofR/67pHt/vB1nTZ9
gL7g6SZa1uStvn1FndisMTj1ZDmYWPvzMtzsIv6+VsSnDFW3q8MN5ChyFX2+
vnjRKnuBGFDu9l4ZbPhlHS7iHuZe9lUdbiNHkauIseVC75bB3vKhD4vkWsmN
/1uHy8pJ5CZyKrngR2W4lhzXvcx34LuQ08nVPi7D9S4s86395kOqcDS53Sdl
uJvxaX3RnJTDq3AAueg7ZbjBt3W4jJxH7vNjHe1LTiW3knPIJd8ow0XULtzb
5lX/qILJxcoPlMHqb9XRrt3z3Pvc/41/mWugViBHkau+Voa7qAWpZc7HeEdX
LQfB/ncZbvId9iVFOJfca2T7vvRtYkH1MLGnmE38+jcHpv5hGW78Qx1uKKeU
W8qJ5K6vl+FKrlvX7/ftnPy+DveUk8pN5dxy7Q/KcPE/sB8sske7V//ezg8x
j9hHzjIE+7kyXEYMLzd7tgy2d147v39sfYD5x+ZGboW9VBnOJVd7qQwXc780
Fms+hvlg4kexsZrglE3iBTtXwdzmNojBpuT8m8tgM/UV89TMV3tKrKd/6Saf
ce0m2pdcwd9zmS/3TZXcvhWL5AN/IQYpgqHEUk82Gcs15doS77sWzanw+uo1
E/RlT3T/eLlKLoH8y3xxOZLc5sEy3EnOI1d8ogwXkhPJJZ8sw5XkkHLVl8tw
SzmmXOyVMtzT/Ubu9moZrilGVXu5tgx2laPJZR8vW+5Wh7vdVUar+bmOtiBn
l7vL2eRid5fhcr/V0XrFhGJDOaFc+ZkyXPGkdn7tU0Ub/hX7piIYWiz9Z53Y
kRhS//FLHWytpqG2MVVfcjFdM8Z9RvYnNmXMwdjDivrnbvbIa5tojWI3c5z8
/aQa0PbUvyqjDYlPp+6G08htPmr9hxj57/ybJnmTat5q38YsjF2YY+JvTfXn
5jv+3O7HezaJLbjn7yGWF/N2wlGM1+jD9GXmj45qoocZW1IzVzv/sA42l4PI
RcRP+kM1MLUw8ajcRs1Y7Vj9W6zsHHWuLtAk79icBPHxLnViZ8bQxIdyGLnM
92W4/VlNYjdTtvxSjiHXmL1KbGOxdr4YQziA9o/r4DtxntxhgzrasRqy8bjB
fcGezmfjndrGPsXU4/bl+zn33ZPMp12/Tu65moS/B3gX+8giHEYuc36Td+U3
9du+V4fLy+Hl8moW++gfymgZL9XR1tTYzI39Xx0tSs1J7UkNVixrPEN+vzfl
9k44nfEM9V9jS8YYj2RufVIn90tNYNp2v3Y/m6vdv9WI1Yp9Bp9Fvi+X9jfE
X1N/u4mWeqJ5I9TXq+O7HqH9v01iKt6LGFs9zHiB3GPqli/J8eX6p1TRZt6v
o42paaht6H/8LYIxCfOL726CBcXAt1D/oA6XVVNTWzNGYKzAZ/bZX62TH2aO
oflRn9fhfnJKuaV6hL8V+rOKFm08SBwrnjXWZDxErGMM0FiKeruxbd+Re/8r
dfLNzFk0P2uavmAzMY75IUN6yaky3mDcQT3B37Gqsai1vNXE925Pny/Ew020
7SEt3jqlP7FyY+DGwtUM1A5u7CUX+Mo6uf5yDPG2es8c3WgUahX+pmt/c6S7
+a2X+OuiIhqmWubEfcFC5qyNKqOPn1rlNyzqZz6PuS7Gb43j+v79rdL6RfC4
mrT5Z/8po1V7PX9L9rx5LU1iUMaijNkbuzfGbyx8oSqxf/UOc1nUmNSaxARi
A+fkBU006J3o/3UZbdp8FrnNHK2epf7u73bVINUijdf4O1h/03Z4k/wuuYuY
Tjx0fh0uLCeQG6ghqSWd529AqL9cR/tVAzb/8PUmv516gfZvmuhV+hI1M7Uz
Ofaz9F+4Si6CMWa/17xVYs/Gk36ocs/eu5qu+tR3ZbReNXjzAb8po837W6+d
GPuDIjEnYwDmA/63TGzgnTrah5qH2ocxJGNJakxTt/zC2JU5Y+aOvVYn39Ic
XPMB/Y2evwPzmXw29St/R2Ju4xFNfo+kdmHMyniWv/Xbo5tcs79/81cnX9Oc
XPMT1XB27QbTie2W7+U3MCPaOW7M2nyiuavEso2xm4sxT5XYuzEA/wEFMbBY
+Hh9kPy1l3xnY/jmgsxWJbb/ep38VHOMzZdUT3utXVvG9sxVVOtS8xJnvNHu
D+Yom2/pb1d3Uwsr8hvWpZvkVpsjYzx8UF+4ihqk+X3/B3+DxWE=
            "]], Polygon3DBox[CompressedData["
1:eJwt1wncTmUexvFjeV+8WbMWoexCZZlCSEKRfWtQoWQnEsrWqMiSLIUiIjJM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            "]], 
           Polygon3DBox[{{2781, 864, 632, 1640, 1682, 2633}, {2703, 1756, 
            1836, 823, 728, 2704}}]},
          Annotation[#, "Charting`Private`Tag$13874#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwtmXnAVsP7xh/18kzNe8YWZUmiTSpJUfYlaaUSKhQpEhUKyZJ9379aZcvS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            "]], Polygon3DBox[CompressedData["
1:eJwtmmXAHEUWRT9goBq6Etzd3d0Wd3d31+Du7izu7u4E12DBQ7Dg7h7c9py9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            "]], Polygon3DBox[CompressedData["
1:eJwt13fcjeUfB/CD5PDwGJVVWalQVqVoUsmeUUhFKZKMUIjiZxdFPzs7O+uR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            "]]},
          Annotation[#, "Charting`Private`Tag$13874#2"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[
           0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
          "Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {
      {GrayLevel[0], 
       Line3DBox[{400, 1, 360, 241, 2300, 16, 2314, 31, 2328, 46, 2341, 61, 
        2355, 76, 2368, 90, 2382, 105, 2397, 120, 2409, 135, 2420, 149, 2431, 
        164, 2443, 179, 2457, 194, 2618, 301, 416, 208, 398, 320, 1435, 209, 
        1436, 210, 1437, 211, 1438, 212, 1667, 304, 417, 213, 822}], 
       Line3DBox[{1264, 2, 1672, 309, 400}], Line3DBox[{1266, 3, 1264}], 
       Line3DBox[{1268, 4, 1266}], Line3DBox[{1270, 5, 1268}], 
       Line3DBox[{1272, 6, 1270}], Line3DBox[{1274, 7, 1272}], 
       Line3DBox[{1276, 8, 1274}], Line3DBox[{1278, 9, 1276}], 
       Line3DBox[{1280, 10, 1278}], Line3DBox[{1282, 11, 1280}], 
       Line3DBox[{1284, 12, 1282}], Line3DBox[{1286, 13, 1284}], 
       Line3DBox[{1288, 14, 1286}], Line3DBox[{401, 15, 396, 310, 1288}], 
       Line3DBox[{311, 30, 2572, 243, 401}], 
       Line3DBox[{348, 45, 426, 2620, 311}], 
       Line3DBox[{2353, 60, 342, 2579, 249, 858}], 
       Line3DBox[{2366, 75, 402, 2353}], Line3DBox[{2380, 89, 579, 2366}], 
       Line3DBox[{2395, 104, 581, 2380}], Line3DBox[{2407, 119, 2395}], 
       Line3DBox[{2418, 134, 2407}], Line3DBox[{2429, 148, 2418}], 
       Line3DBox[{2441, 163, 2429}], Line3DBox[{2455, 178, 2441}], 
       Line3DBox[{2468, 193, 2455}], 
       Line3DBox[{306, 214, 1439, 215, 1440, 216, 1441, 217, 1442, 218, 1443, 
        219, 1444, 220, 1445, 221, 1671, 308, 418, 222, 399, 321, 2481, 207, 
        2468}], Line3DBox[{306, 511, 746}], Line3DBox[{348, 650}]}, 
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0r1LFHAYwPHn9EJJN00tTbtriMYcNJpqEJGQy0ONCD0oqKnrH1AoxMmG
aKwhGnWIxhrEMa3ztRfkkDQX7XXU7uqqjzh8+Tzj83tJ3bibzSciYlLfkhF7
1RE7XFflaMQR1tVFNPIET/MsO3mel9jLKxxmjrd4W3nzBMf5iA/4jE/4gjOc
4yteqI/Y4A/N64s+61htxAKb+IbNfMsWFniciwe7cYmtXGYbT2rF3M5VdnCN
p/iOKb5nmh9Y4if+1Ed91baKdnzNAl9yltN8zsd8yik+5Bjv857umG9ylIPM
sIcX2cVzPMP0wXnYwG73UOR3JbWrLeVqIqo5wipeZ4LXGLzKf95uiH+Z5YAq
5gz/sJ+/eZll9rHEXv5iD/dZdg+bycP/8B9xCEoh
        "]]}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{2300, 2571, 1446, 2299, 3324, 2482, 2301, 3325, 2483, 2302, 
        3326, 2484, 2303, 3327, 2485, 2304, 3328, 2486, 2305, 3329, 2487, 
        2306, 3132, 3393, 2307, 3330, 2488, 2308, 3331, 2489, 2309, 3332, 
        2490, 2310, 3333, 2491, 2311, 3334, 2492, 2312, 1619, 2493, 2572}], 
       Line3DBox[{2314, 3133, 3394, 2313, 1460, 2315, 3335, 2494, 2316, 3336, 
        2495, 2317, 3337, 2496, 2318, 3338, 2497, 2319, 3339, 2498, 2320, 
        3134, 3395, 2321, 3135, 3396, 2322, 3340, 2499, 2323, 3341, 2500, 
        2324, 3342, 2501, 2325, 3343, 2502, 2326, 3469, 2573, 2574, 2656, 
        2657, 2620}], 
       Line3DBox[{2328, 3136, 3397, 2327, 3137, 3398, 2329, 1474, 2330, 3344, 
        2503, 2331, 3345, 2504, 2332, 3346, 2505, 2333, 3347, 2506, 2334, 
        3138, 3399, 2335, 3139, 3400, 2336, 3140, 3401, 2337, 3348, 2507, 
        2338, 3349, 2508, 2339, 3470, 2575, 2577, 2509, 2576, 3204, 3481, 
        2559, 2642, 2698, 2699, 2803}], 
       Line3DBox[{2341, 3141, 3402, 2340, 3142, 3403, 2342, 3143, 3404, 2343, 
        1487, 2344, 3350, 2510, 2345, 3351, 2511, 2346, 3352, 2512, 2347, 
        3144, 3405, 2348, 3145, 3406, 2349, 3146, 3407, 2350, 3147, 3408, 
        2351, 3471, 2580, 2581, 2352, 3465, 2560, 2578, 2561, 2643, 2638, 
        2639, 2708, 2802}], 
       Line3DBox[{2353, 2658, 2563, 2666, 2562, 2687, 2644, 2785, 2805}], 
       Line3DBox[{2355, 3148, 3409, 2354, 3149, 3410, 2356, 3150, 3411, 2357, 
        3151, 3412, 2358, 1499, 2359, 3353, 2513, 2360, 3354, 2514, 2361, 
        3152, 3413, 2362, 3153, 3414, 2363, 3154, 3415, 2364, 2682, 3416, 
        3207, 2365, 2683, 3198, 3487, 2659, 2584, 2670, 2660, 2661, 2629, 
        2689, 3492, 2703, 2704, 2775, 2811}], 
       Line3DBox[{2366, 2583, 2621, 2582, 3472, 3211, 2711, 2726, 2630, 2714, 
        2715, 2716, 2771, 2792}], 
       Line3DBox[{2368, 3155, 3417, 2367, 3156, 3418, 2369, 3157, 3419, 2370, 
        3158, 3420, 2371, 3159, 3421, 2372, 1511, 2373, 3355, 2515, 2374, 
        3160, 3422, 2375, 3161, 3423, 2376, 2748, 3424, 3213, 2377, 2749, 
        2750, 2732, 3425, 2734, 2733, 2378, 2717, 2718, 3493, 2585, 2788}], 
       Line3DBox[{2380, 2746, 2747, 2740, 2739, 3496, 2379, 2586, 2622, 3489, 
        2691, 2696, 2690, 2776, 2800}], 
       Line3DBox[{105, 1349, 106, 1350, 107, 1351, 108, 1352, 109, 1353, 110, 
        1354, 111, 1355, 112, 1356, 113, 1357, 114, 267, 1358, 115, 373, 
        2793}], Line3DBox[{2382, 3162, 3426, 2381, 3163, 3427, 2383, 3164, 
        3428, 2384, 3165, 3429, 2385, 3166, 3430, 2386, 3167, 3431, 2387, 
        1522, 2388, 3168, 3432, 2389, 3169, 3433, 2390, 2589, 3434, 3199, 
        2391, 2564, 2587, 3435, 2632, 2631, 2392, 2798}], 
       Line3DBox[{2395, 3436, 3170, 2394, 2672, 2679, 3206, 3486, 2680, 2393, 
        2673, 2674, 2588, 3490, 2633, 2781, 2797}], 
       Line3DBox[{2397, 3356, 2516, 2396, 3357, 2517, 2398, 3358, 2518, 2399, 
        3359, 2519, 2400, 3360, 2520, 2401, 3361, 2521, 2402, 3362, 2522, 
        2403, 1534, 2404, 2590, 2662, 3483, 2523, 2591, 2647, 2649, 2648, 
        2592, 3201, 3473, 2779, 2795}], 
       Line3DBox[{119, 1360, 118, 1359, 117, 420, 1715, 116, 408, 491, 2796}],
        Line3DBox[{2407, 2527, 3365, 2406, 2526, 3364, 2405, 2525, 2764, 3363,
         3200, 2623, 2524, 3479, 2624, 2646, 2728, 2645, 2780, 2794}], 
       Line3DBox[{2409, 3171, 3437, 2408, 3366, 2528, 2410, 3367, 2529, 2411, 
        3368, 2530, 2412, 3369, 2531, 2413, 3370, 2532, 2414, 3371, 2533, 
        2415, 2684, 2735, 3172, 3488, 2685, 2594, 2595, 2650, 3218, 3482, 
        2651, 2782, 2799}], 
       Line3DBox[{2418, 2538, 3374, 2417, 2537, 3373, 2416, 2536, 2765, 3372, 
        3214, 2751, 2535, 2752, 3497, 2742, 2593, 2596, 2534, 2719, 3494, 
        2625, 2787}], 
       Line3DBox[{2420, 3173, 3438, 2419, 3174, 3439, 2421, 3375, 2539, 2422, 
        3376, 2540, 2423, 3377, 2541, 2424, 3378, 2542, 2425, 3498, 2754, 
        2543, 2755, 2598, 2600, 2729, 2743, 2730, 3495, 2599, 2731, 2634, 
        2720, 2721, 2722, 2774, 2807}], 
       Line3DBox[{2429, 2547, 3382, 2428, 2546, 3381, 2427, 2545, 3380, 3215, 
        2753, 2544, 3379, 2741, 2426, 1557, 2681, 2597, 2601, 3202, 3466, 
        2692, 2628, 2700, 2772, 2809}], 
       Line3DBox[{2431, 3175, 3440, 2430, 3176, 3441, 2432, 3177, 3442, 2433, 
        3383, 2548, 2434, 3384, 2549, 2435, 3385, 2550, 2436, 3474, 2602, 
        2604, 2551, 2603, 2652, 2565, 2653, 2701, 2702, 2637, 2786, 2808}], 
       Line3DBox[{2441, 2554, 3388, 2440, 2553, 3387, 2439, 2552, 3386, 2438, 
        1570, 2437, 3485, 3178, 2675, 2676, 3205, 3467, 2677, 2678, 2566, 
        2669, 2668, 2606, 3210, 3219}], 
       Line3DBox[{2443, 3179, 3443, 2442, 3180, 3444, 2444, 3181, 3445, 2445, 
        3182, 3446, 2446, 3389, 2555, 2447, 3475, 2607, 2608, 2448, 3468, 
        2567, 2605, 2568, 2655, 2640, 2641, 2709, 2784, 2710, 2806}], 
       Line3DBox[{2455, 2557, 3391, 2454, 2556, 3390, 2453, 1583, 2452, 3448, 
        3184, 2451, 3447, 3183, 2450, 3476, 2610, 2667, 2609, 2449, 3203, 
        3480, 2570, 2654, 2569, 2688, 2804}], 
       Line3DBox[{2457, 3185, 3449, 2456, 3186, 3450, 2458, 3187, 3451, 2459, 
        3188, 3452, 2460, 3208, 3453, 2686, 2461, 3209, 3477, 2613, 2663, 
        2614, 2671, 2664, 2665, 3484, 2635, 2693, 2705, 2790}], 
       Line3DBox[{2468, 2558, 3392, 2467, 1595, 2466, 3456, 3191, 2465, 3455, 
        3190, 2464, 3454, 3189, 2463, 3499, 2757, 2766, 2756, 2767, 2462, 
        3500, 2763, 2612, 2626, 2611, 2712, 2713, 2727, 2636, 2723, 2724, 
        2773, 2810}], 
       Line3DBox[{2481, 2619, 1669, 2480, 3464, 3197, 2479, 3463, 3196, 2478, 
        3462, 3195, 2477, 3461, 3194, 2476, 3216, 3460, 2768, 2770, 2769, 
        2475, 3501, 2758, 2759, 2745, 2744, 2474, 2616, 2627, 2695, 2697, 
        2694, 3491, 2777, 2801}], Line3DBox[{2579, 2706, 2783, 2707, 2789}], 
       Line3DBox[{2618, 2617, 1663, 2469, 3192, 3457, 2470, 3193, 3458, 2471, 
        3217, 3459, 2760, 2472, 2761, 2762, 3502, 2736, 2738, 2737, 2473, 
        3212, 3478, 2725, 2615, 2778, 2791}], 
       Line3DBox[{2813, 3126, 2083, 2812, 3608, 3035, 2814, 3609, 3036, 2815, 
        3610, 3037, 2816, 3611, 3038, 2817, 3612, 3039, 2818, 3613, 3040, 
        2819, 3614, 3220, 3503, 2820, 3615, 3041, 2821, 3616, 3042, 2822, 
        3617, 3043, 2823, 3618, 3044, 2824, 3619, 3045, 2825, 3323, 3712, 
        3046, 3127}], 
       Line3DBox[{2827, 3221, 3504, 2826, 2098, 2828, 3620, 3047, 2829, 3621, 
        3048, 2830, 3622, 3049, 2831, 3623, 3050, 2832, 3624, 3051, 2833, 
        3625, 3222, 3505, 2834, 3223, 3506, 2835, 3626, 3052, 2836, 3627, 
        3053, 2837, 3628, 3054, 2838, 3629, 3055, 2839, 3630, 3056, 2840}], 
       Line3DBox[{2842, 3224, 3507, 2841, 3225, 3508, 2843, 2114, 2844, 3631, 
        3057, 2845, 3632, 3058, 2846, 3633, 3059, 2847, 3634, 3060, 2848, 
        3635, 3226, 3509, 2849, 3227, 3510, 2850, 3228, 3511, 2851, 3636, 
        3061, 2852, 3637, 3062, 2853, 3638, 3063, 2854, 3639, 3064, 2855}], 
       Line3DBox[{2857, 3229, 3512, 2856, 3230, 3513, 2858, 3231, 3514, 2859, 
        2130, 2860, 3640, 3065, 2861, 3641, 3066, 2862, 3642, 3067, 2863, 
        3643, 3232, 3515, 2864, 3233, 3516, 2865, 3234, 3517, 2866, 3235, 
        3518, 2867, 3644, 3068, 2868, 3645, 3069, 2869, 3646, 3070, 2870}], 
       Line3DBox[{2872, 3236, 3519, 2871, 3237, 3520, 2873, 3238, 3521, 2874, 
        3239, 3522, 2875, 2146, 2876, 3647, 3071, 2877, 3648, 3072, 2878, 
        3649, 3240, 3523, 2879, 3241, 3524, 2880, 3242, 3525, 2881, 3243, 
        3526, 2882, 3244, 3527, 2883, 3650, 3073, 2884, 3651, 3074, 2885}], 
       Line3DBox[{2887, 3245, 3528, 2886, 3246, 3529, 2888, 3247, 3530, 2889, 
        3248, 3531, 2890, 3249, 3532, 2891, 2162, 2892, 3652, 3075, 2893, 
        3653, 3250, 3533, 2894, 3251, 3534, 2895, 3252, 3535, 2896, 3253, 
        3536, 2897, 3254, 3537, 2898, 3255, 3538, 2899, 3654, 3076, 2900}], 
       Line3DBox[{2902, 3256, 3539, 2901, 3257, 3540, 2903, 3258, 3541, 2904, 
        3259, 3542, 2905, 3260, 3543, 2906, 3261, 3544, 2907, 2178, 2908, 
        3655, 3262, 3545, 2909, 3263, 3546, 2910, 3264, 3547, 2911, 3265, 
        3548, 2912, 3266, 3549, 2913, 3267, 3550, 2914, 3268, 3551, 2915}], 
       Line3DBox[{2919, 3656, 3077, 2917, 3657, 3078, 2921, 3658, 3079, 2923, 
        3659, 3080, 2925, 3660, 3081, 2927, 3661, 3082, 2929, 3662, 3083, 
        2931, 3663, 2195, 2933, 3664, 3084, 2935, 3665, 3085, 2937, 3666, 
        3086, 2939, 3667, 3087, 2941, 3668, 3088, 2943, 3669, 3089, 2945}], 
       Line3DBox[{2944, 3565, 3281, 2942, 3564, 3280, 2940, 3563, 3279, 2938, 
        3562, 3278, 2936, 3561, 3277, 2934, 3560, 3276, 2932, 3559, 2194, 
        2930, 3558, 3275, 2928, 3557, 3274, 2926, 3556, 3273, 2924, 3555, 
        3272, 2922, 3554, 3271, 2920, 3553, 3270, 2916, 3552, 3269, 2918}], 
       Line3DBox[{2947, 3282, 3566, 2946, 3670, 3090, 2948, 3671, 3091, 2949, 
        3672, 3092, 2950, 3673, 3093, 2951, 3674, 3094, 2952, 3675, 3095, 
        2953, 3676, 3283, 3567, 2954, 2211, 2955, 3677, 3096, 2956, 3678, 
        3097, 2957, 3679, 3098, 2958, 3680, 3099, 2959, 3681, 3100, 2960}], 
       Line3DBox[{2962, 3284, 3568, 2961, 3285, 3569, 2963, 3682, 3101, 2964, 
        3683, 3102, 2965, 3684, 3103, 2966, 3685, 3104, 2967, 3686, 3105, 
        2968, 3687, 3286, 3570, 2969, 3287, 3571, 2970, 2227, 2971, 3688, 
        3106, 2972, 3689, 3107, 2973, 3690, 3108, 2974, 3691, 3109, 2975}], 
       Line3DBox[{2977, 3288, 3572, 2976, 3289, 3573, 2978, 3290, 3574, 2979, 
        3692, 3110, 2980, 3693, 3111, 2981, 3694, 3112, 2982, 3695, 3113, 
        2983, 3696, 3291, 3575, 2984, 3292, 3576, 2985, 3293, 3577, 2986, 
        2243, 2987, 3697, 3114, 2988, 3698, 3115, 2989, 3699, 3116, 2990}], 
       Line3DBox[{2992, 3294, 3578, 2991, 3295, 3579, 2993, 3296, 3580, 2994, 
        3297, 3581, 2995, 3700, 3117, 2996, 3701, 3118, 2997, 3702, 3119, 
        2998, 3703, 3298, 3582, 2999, 3299, 3583, 3000, 3300, 3584, 3001, 
        3301, 3585, 3002, 2259, 3003, 3704, 3120, 3004, 3705, 3121, 3005}], 
       Line3DBox[{3007, 3302, 3586, 3006, 3303, 3587, 3008, 3304, 3588, 3009, 
        3305, 3589, 3010, 3306, 3590, 3011, 3706, 3122, 3012, 3707, 3123, 
        3013, 3708, 3307, 3591, 3014, 3308, 3592, 3015, 3309, 3593, 3016, 
        3310, 3594, 3017, 3311, 3595, 3018, 2275, 3019, 3709, 3124, 3020}], 
       Line3DBox[{3034, 3131, 2295, 3033, 3607, 3322, 3032, 3606, 3321, 3031, 
        3605, 3320, 3030, 3604, 3319, 3029, 3603, 3318, 3028, 3602, 3317, 
        3711, 3027, 3125, 3710, 3026, 3601, 3316, 3025, 3600, 3315, 3024, 
        3599, 3314, 3023, 3598, 3313, 3022, 3597, 3312, 3021, 3596, 3129, 
        3128, 3130}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1264, 1447, 3324, 1265, 1460, 1291, 3398, 1473, 1304, 3403, 
        1485, 1316, 3410, 1496, 1327, 3418, 1507, 1338, 3427, 1517, 1350, 
        1528, 3357, 1362, 1540, 3366, 1374, 3439, 1550, 1386, 3441, 1562, 
        1400, 3444, 1575, 1413, 3450, 1587, 1425, 3457, 1598, 1436}], 
       Line3DBox[{1266, 1448, 3325, 1267, 1461, 3335, 1292, 1474, 1305, 3404, 
        1486, 1317, 3411, 1497, 1328, 3419, 1508, 1339, 3428, 1518, 1351, 
        1529, 3358, 1363, 1541, 3367, 1375, 1551, 3375, 1387, 3442, 1563, 
        1401, 3445, 1576, 1414, 3451, 1588, 1426, 3458, 1599, 1437}], 
       Line3DBox[{1268, 1449, 3326, 1269, 1462, 3336, 1293, 1475, 3344, 1306, 
        1487, 1318, 3412, 1498, 1329, 3420, 1509, 1340, 3429, 1519, 1352, 
        1530, 3359, 1364, 1542, 3368, 1376, 1552, 3376, 1388, 1564, 3383, 
        1402, 3446, 1577, 1415, 3452, 1589, 1427, 3459, 1817, 1818, 1438}], 
       Line3DBox[{1270, 1450, 3327, 1271, 1463, 3337, 1294, 1476, 3345, 1307, 
        1488, 3350, 1319, 1499, 1330, 3421, 1510, 1341, 3430, 1520, 1353, 
        1531, 3360, 1365, 1543, 3369, 1377, 1553, 3377, 1389, 1565, 3384, 
        1403, 1578, 3389, 1416, 3453, 1735, 1736, 1788, 1820, 3502, 1664, 
        1819, 1665, 1667}], 
       Line3DBox[{1272, 1451, 3328, 1273, 1464, 3338, 1295, 1477, 3346, 1308, 
        1489, 3351, 1320, 1500, 3353, 1331, 1511, 1342, 3431, 1521, 1354, 
        1532, 3361, 1366, 1544, 3370, 1378, 1554, 3378, 1390, 1566, 3385, 
        1404, 1655, 3475, 1656, 1713, 1738, 1739, 3477, 1737, 1659, 1661, 
        3478, 1774, 1789, 1775, 1666, 1783, 1687, 1778, 1686, 1845}], 
       Line3DBox[{1274, 1452, 3329, 1275, 1465, 3339, 1296, 1478, 3347, 1309, 
        1490, 3352, 1321, 1501, 3354, 1332, 1512, 3355, 1343, 1522, 1355, 
        1533, 3362, 1367, 1545, 3371, 1379, 1808, 3498, 1809, 1391, 1652, 
        3474, 1653, 1654, 1616, 3468, 1657, 1707, 1706, 1708, 1684, 1714, 
        3484, 1685, 1660, 1751, 1752, 1843}], 
       Line3DBox[{8, 2306, 23, 2320, 38, 2334, 53, 2347, 68, 2361, 83, 2374, 
        97, 2388, 112, 2403, 127, 2415, 142, 593, 2755, 156, 286, 2603, 171, 
        356, 2641, 291, 958}], 
       Line3DBox[{1276, 3393, 1453, 1277, 3395, 1466, 1297, 3399, 1479, 1310, 
        3405, 1491, 1322, 3413, 1502, 1333, 3422, 1513, 1344, 3432, 1523, 
        1356, 1534, 1368, 1733, 1734, 3488, 1546, 1380, 1785, 1787, 1786, 
        1650, 1781, 3495, 1782, 1555, 1392, 1683, 1838, 1750, 1842, 1749, 
        1857}], Line3DBox[{1278, 1454, 3330, 1279, 3396, 1467, 1298, 3400, 
        1480, 1311, 3406, 1492, 1323, 3414, 1503, 1334, 3423, 1514, 1345, 
        3433, 1524, 1357, 1643, 1644, 1535, 3483, 1369, 1710, 1712, 1711, 
        1648, 1704, 1705, 3482, 1833, 1832, 1844}], 
       Line3DBox[{1280, 1455, 3331, 1281, 1468, 3340, 1299, 3401, 1481, 1312, 
        3407, 1493, 1324, 3415, 1504, 1335, 3424, 1795, 1796, 1515, 1346, 
        3434, 1641, 1642, 1525, 1358, 1690, 1614, 1702, 1677, 1703, 1678, 
        3473, 1837, 1846}], 
       Line3DBox[{1282, 1456, 3332, 1283, 1469, 3341, 1300, 1482, 3348, 1313, 
        3408, 1494, 1325, 3416, 1729, 1730, 1505, 1336, 1784, 3425, 1638, 
        1793, 1779, 1780, 1347, 1681, 3435, 1611, 1688, 1747, 1748, 1700, 
        1840, 1848}], 
       Line3DBox[{1284, 1457, 3333, 1285, 1470, 3342, 1301, 1483, 3349, 1314, 
        1627, 3471, 1628, 1709, 1732, 3487, 1632, 1731, 1633, 1634, 1766, 
        3493, 1609, 1767, 1610, 1829, 1768, 1831, 1859}], 
       Line3DBox[{1286, 1458, 3334, 1287, 1471, 3343, 1302, 1623, 3470, 1624, 
        1626, 1607, 3465, 1629, 1608, 1699, 1698, 1630, 1680, 1836, 1756, 
        3492, 1757, 1830, 1740, 1855}], 
       Line3DBox[{1288, 1618, 1619, 1289, 1620, 3469, 1621, 1622, 1606, 1625, 
        3481, 1694, 1693, 1695, 1834, 1689, 1835, 1841, 1758, 1856}], 
       Line3DBox[{1435, 1597, 1663, 1424, 1586, 3449, 1412, 1574, 3443, 1399, 
        1561, 3440, 1385, 1549, 3438, 1373, 1539, 3437, 1361, 3356, 1527, 
        1349, 1516, 3426, 1337, 1506, 3417, 1326, 1495, 3409, 1315, 1484, 
        3402, 1303, 1472, 3397, 1290, 1459, 3394, 1263, 1446, 1617, 1672}], 
       Line3DBox[{215, 2474, 200, 298, 2713, 524, 186, 853}], 
       Line3DBox[{1439, 1662, 1668, 1745, 1755, 3491, 1744, 1746, 1851}], 
       Line3DBox[{1440, 1600, 1814, 1816, 3501, 1815, 1428, 1590, 1812, 1811, 
        1823, 3500, 1822, 1417, 1579, 1676, 3480, 1692, 1691, 1405, 1567, 
        1743, 1761, 1760, 1853}], 
       Line3DBox[{1441, 1601, 1813, 3460, 1429, 1591, 3499, 1810, 1418, 1580, 
        3476, 1658, 1406, 1568, 1726, 3467, 1722, 1724, 1723, 1393, 1556, 
        1679, 3466, 1651, 1762, 1854}], 
       Line3DBox[{1442, 1602, 3461, 1430, 1592, 3454, 1419, 1581, 3447, 1407, 
        1569, 3485, 1721, 1394, 1557, 1649, 1381, 1770, 3494, 1769, 1771, 
        1773, 1772, 1828, 1858}], 
       Line3DBox[{1443, 1603, 3462, 1431, 1593, 3455, 1420, 1582, 3448, 1408, 
        1570, 1395, 3379, 1558, 1805, 1794, 1807, 1382, 1802, 3497, 1801, 
        1799, 1647, 1821, 1370, 3479, 1536, 1674, 1615, 1701, 1753, 1759, 
        1852}], Line3DBox[{1444, 1604, 3463, 1432, 1594, 3456, 1421, 1583, 
        1409, 3386, 1571, 1396, 3380, 1804, 1806, 1803, 1827, 1826, 3372, 
        1798, 1800, 1797, 1825, 1824, 3363, 1646, 1675, 1645, 1715, 1716, 
        1725, 1613, 1717, 1612, 1742, 3490, 1682, 1640, 1849}], 
       Line3DBox[{1445, 1605, 3464, 1433, 1595, 1422, 3390, 1584, 1410, 3387, 
        1572, 1397, 3381, 1559, 1383, 3373, 1547, 1371, 3364, 1537, 1359, 
        1719, 1720, 1718, 1728, 3486, 1727, 1637, 1639, 1636, 3489, 1741, 
        1673, 1850}], 
       Line3DBox[{1671, 1670, 1669, 1434, 3392, 1596, 1423, 3391, 1585, 1411, 
        3388, 1573, 1398, 3382, 1560, 1384, 3374, 1548, 1372, 3365, 1538, 
        1360, 1526, 3436, 1348, 1791, 3496, 1790, 1792, 1631, 1635, 3472, 
        1764, 1765, 1763, 1777, 1776, 1696, 1839, 1697, 1754, 1847}], 
       Line3DBox[{1861, 2084, 3608, 1862, 2098, 1890, 3508, 2113, 1905, 3513, 
        2128, 1920, 3520, 2143, 1935, 3529, 2158, 1950, 3540, 2173, 1965, 
        3553, 2188, 3657, 1980, 2203, 3670, 1995, 3569, 2218, 2010, 3573, 
        2233, 2025, 3579, 2248, 2040, 3587, 2263, 2055, 3597, 2278, 2070}], 
       Line3DBox[{1863, 2085, 3609, 1864, 2099, 3620, 1891, 2114, 1906, 3514, 
        2129, 1921, 3521, 2144, 1936, 3530, 2159, 1951, 3541, 2174, 1966, 
        3554, 2189, 3658, 1981, 2204, 3671, 1996, 2219, 3682, 2011, 3574, 
        2234, 2026, 3580, 2249, 2041, 3588, 2264, 2056, 3598, 2279, 2071}], 
       Line3DBox[{1865, 2086, 3610, 1866, 2100, 3621, 1892, 2115, 3631, 1907, 
        2130, 1922, 3522, 2145, 1937, 3531, 2160, 1952, 3542, 2175, 1967, 
        3555, 2190, 3659, 1982, 2205, 3672, 1997, 2220, 3683, 2012, 2235, 
        3692, 2027, 3581, 2250, 2042, 3589, 2265, 2057, 3599, 2280, 2072}], 
       Line3DBox[{1867, 2087, 3611, 1868, 2101, 3622, 1893, 2116, 3632, 1908, 
        2131, 3640, 1923, 2146, 1938, 3532, 2161, 1953, 3543, 2176, 1968, 
        3556, 2191, 3660, 1983, 2206, 3673, 1998, 2221, 3684, 2013, 2236, 
        3693, 2028, 2251, 3700, 2043, 3590, 2266, 2058, 3600, 2281, 2073}], 
       Line3DBox[{1869, 2088, 3612, 1870, 2102, 3623, 1894, 2117, 3633, 1909, 
        2132, 3641, 1924, 2147, 3647, 1939, 2162, 1954, 3544, 2177, 1969, 
        3557, 2192, 3661, 1984, 2207, 3674, 1999, 2222, 3685, 2014, 2237, 
        3694, 2029, 2252, 3701, 2044, 2267, 3706, 2059, 3601, 2282, 2074}], 
       Line3DBox[{1871, 2089, 3613, 1872, 2103, 3624, 1895, 2118, 3634, 1910, 
        2133, 3642, 1925, 2148, 3648, 1940, 2163, 3652, 1955, 2178, 1970, 
        3558, 2193, 3662, 1985, 2208, 3675, 2000, 2223, 3686, 2015, 2238, 
        3695, 2030, 2253, 3702, 2045, 2268, 3707, 2060, 2283, 3710, 2075}], 
       Line3DBox[{1873, 2090, 3614, 1875, 2104, 3625, 1896, 2119, 3635, 1911, 
        2134, 3643, 1926, 2149, 3649, 1941, 2164, 3653, 1956, 2179, 3655, 
        1971, 2194, 3663, 1986, 2209, 3676, 2001, 2224, 3687, 2016, 2239, 
        3696, 2031, 2254, 3703, 2046, 2269, 3708, 2061, 2284, 3711, 2076}], 
       Line3DBox[{1877, 2092, 3615, 1878, 3506, 2106, 1898, 3510, 2121, 1913, 
        3516, 2136, 1928, 3524, 2151, 1943, 3534, 2166, 1958, 3546, 2181, 
        1973, 3560, 2196, 3664, 1988, 2211, 2003, 3571, 2226, 2018, 3576, 
        2241, 2033, 3583, 2256, 2048, 3592, 2271, 2063, 3603, 2286, 2078}], 
       Line3DBox[{1879, 2093, 3616, 1880, 2107, 3626, 1899, 3511, 2122, 1914, 
        3517, 2137, 1929, 3525, 2152, 1944, 3535, 2167, 1959, 3547, 2182, 
        1974, 3561, 2197, 3665, 1989, 2212, 3677, 2004, 2227, 2019, 3577, 
        2242, 2034, 3584, 2257, 2049, 3593, 2272, 2064, 3604, 2287, 2079}], 
       Line3DBox[{1881, 2094, 3617, 1882, 2108, 3627, 1900, 2123, 3636, 1915, 
        3518, 2138, 1930, 3526, 2153, 1945, 3536, 2168, 1960, 3548, 2183, 
        1975, 3562, 2198, 3666, 1990, 2213, 3678, 2005, 2228, 3688, 2020, 
        2243, 2035, 3585, 2258, 2050, 3594, 2273, 2065, 3605, 2288, 2080}], 
       Line3DBox[{1883, 2095, 3618, 1884, 2109, 3628, 1901, 2124, 3637, 1916, 
        2139, 3644, 1931, 3527, 2154, 1946, 3537, 2169, 1961, 3549, 2184, 
        1976, 3563, 2199, 3667, 1991, 2214, 3679, 2006, 2229, 3689, 2021, 
        2244, 3697, 2036, 2259, 2051, 3595, 2274, 2066, 3606, 2289, 2081}], 
       Line3DBox[{1885, 2096, 3619, 1886, 2110, 3629, 1902, 2125, 3638, 1917, 
        2140, 3645, 1932, 2155, 3650, 1947, 3538, 2170, 1962, 3550, 2185, 
        1977, 3564, 2200, 3668, 1992, 2215, 3680, 2007, 2230, 3690, 2022, 
        2245, 3698, 2037, 2260, 3704, 2052, 2275, 2067, 3607, 2290, 2082}], 
       Line3DBox[{1887, 2292, 2293, 3712, 1888, 2111, 3630, 1903, 2126, 3639, 
        1918, 2141, 3646, 1933, 2156, 3651, 1948, 2171, 3654, 1963, 3551, 
        2186, 1978, 3565, 2201, 3669, 1993, 2216, 3681, 2008, 2231, 3691, 
        2023, 2246, 3699, 2038, 2261, 3705, 2053, 2276, 3709, 2068, 2295, 
        2296, 2297}], 
       Line3DBox[{2069, 2277, 3596, 2294, 2054, 2262, 3586, 2039, 2247, 3578, 
        2024, 2232, 3572, 2009, 2217, 3568, 1994, 2202, 3566, 1979, 3656, 
        2187, 3552, 1964, 2172, 3539, 1949, 2157, 3528, 1934, 2142, 3519, 
        1919, 2127, 3512, 1904, 2112, 3507, 1889, 2097, 3504, 1860, 2083, 
        2291, 2298}], 
       Line3DBox[{2077, 2285, 3602, 2062, 2270, 3591, 2047, 2255, 3582, 2032, 
        2240, 3575, 2017, 2225, 3570, 2002, 2210, 3567, 1987, 2195, 3559, 
        1972, 2180, 3545, 1957, 2165, 3533, 1942, 2150, 3523, 1927, 2135, 
        3515, 1912, 2120, 3509, 1897, 2105, 3505, 1876, 2091, 3503, 
        1874}]}, {}, {}, {}, {}, {}}},
    VertexNormals->CompressedData["
1:eJztnXl0VjUWwAstUMpOaakspWUVwYJlEYRSRPaxUDbXUShYFR0GFIo6yoig
skORRRYRERRQqkgBceAIKJRl2AY8FpDBBQUBlTIOYNk6k/S+OTbj/b7mefMl
r833T09/J+cmuUlu8pLcm9jBw/umlgwKChpbMSgoOOh/v7EF/+YkWm655ZZb
Hhhea3SflAE1Tm+eE3UtdMuhbzbn/7/LuHJ6hWP6tHp2x60+abmsPq2efXMq
fVo953PV+ixuerb6pOW69FlU9WyaPr2uZ9P05nU9m6Yfq08zuWo9UMm35Ska
XJceVOerq91Ny5dKvlfqW9zypZLvlfqaZrdNWw/oKqcuPXg9vWlyvJKvaXaA
ipvWf4pqvsWt/1j9+K6X1Q9tvbyy/vGKfKryeIVb/XiLq24vXVzX94vNV295
dKXXxU2zJ6ZxXXq28s3sD5brHRe2PGb2B136sZyW61rvmSbHjndbLy/WK0B6
E3450rw2yH8F5LcB+TWAzwMeA7w68EXAKwKfCvxq9XzeEnhV4K9B+of8lL8S
pF8O6atA+kjgC4XyYHJKQ/q1kD4I0tcBvhj4M2m+5XSD9H+E9FFu9Q9yNgnl
OZ6Wz88Cz/FTHozXBflTQE4cyA8HngE83aV8p90ngZywp/LllBDq5ZS/PvAX
gQ/xo7eOkD4F0t/tJ73TH5ZA+gt+6lUZ0i+F9PEg3+knmcBrE48vr/AD0A/L
3JCvh0ku+4ksLwv6Xw36LyPYDae9ygeoXRpDvpMh309AD02AvwC8rp/yxEH6
5yB9Q0gfAzxdsGPRwGcDvw759gWeDPw08BHAI4B/B3K+h3b8CvjxtN+2n/X9
lD8C0r8O6WMhfTng7wKPlLTDIX7S1xT04OitulCeXD/905HjzJuNC5mvk74Z
pK8ntNePkG9L4KOAN0XmzRqjC9rDqcBDhfloJvCawMVxURJ4XUFOvJCvU/4E
Id9pwEsJ4+sl4MOfcje+woT5JSxA47S20C79NNvtG6E846E8jaA8UcK4c9Yz
K2GcNgF72wd4AqR/FNLXAe6MR2e++yWtYDsuE+zGv0D+HuDVQE4jSP+0Y9+A
xwr90GnHTsDvAT57dMH+/2RUwfVeeeCrhH5OpWenPF1B/gjot7cC/yvwx4jn
r22gz4rQXmfSCq4f1grjiypfp5+vBPnl0gqO9wnADxPn66zr9jl2DPK9AHr4
AnhHYj0PgXxvAfkPQL3aAB8GPBF4A2FdehPwhsI8Hqj1AxV/CcqfB99Tr/op
v2N/nPW2v++jCGGcOuOlqTCObvIjx1nnOHbvgJ/+4NiZGYKdcdYniwS7J6av
aGg7/hPK+TK010Yo5y2CvXXm65LANwL/GfRWUVj33imsE9IFe9tE4KNAjjN+
1wO/A9KnCuOr3eiC+Trzy1+ADwTeDPhWYR3rrEOSgIcCXyesP8+A3TgBfBHw
CpB+A/A04Gch/X7g40H+k5C+FvAHBT0463NnvXcS5GQDfwS4s68yEfga4Jcg
/S5h3dUB0qcC72xoP7S8UHxswb/69vN1pbfcHTdtH9i0flVU6+t1PZtWTiy9
Lm7a+DWNU+nNNDmWm8ntuC7anKp9Lbe8KHHTxqnl1h5a/v8844EvytVpfnRz
7w9COlVfdmhz7k3hf+/3/NnEIymxYYwPOP50L8a3RNyxyxfH5FDJx/i4e+dU
YLz7i+mtGL+l44k9vrjqfGX1Mz14aBDj9TM+voPxnPNj9rqRMzivbknGa43t
eSvjjcv02k9ZXyo9qOaq+zNW34S3Vl+M/i//6dmQtoxH79vwj0DoWXW+qvVs
Wn112RNddtW0+upqd9PsaqXI0rGMrzwZ8gfGD04Ytq0o23PTxrtX6iub3jQ9
61qnqdZzUe1vXqmvtas230D2c9l+RdUPTbOrGFddX1390LR+rnr+Mk3Pptlz
qvWYV9rFtHyp7LCu/Uyq8au6nNi+pdf7G5WdDPrNn/b7opZbbrnllltuuQLu
516EMeVUzV3eGzGm/FSc+F6NMfWS5QG6d2RMfWW5ofe4rH48ojfT9KBLP6bV
1+rBzPFiueWWW2655cWZF7d52a5b8nlRra9dx+rVg1f0Zpoe7HdiYPRQVOul
Sz+ycnTVq7hxr4wjWflOXL4PgFPHZTWtvlTpdXFd/ZBKPlV5dPUfXfOUaXJM
415Z/6jOl0p+ceOmrWO9zk1rX9O4rD7FdyjqIfxGP3Kcd5ScuPGBepdBtX5M
s/NeH3deKb+1S7TctO8y1eX0Oi+qepOtV1HVQy68O5AFPLiY2jGv23PZ8jv7
cs77g86+HPaOmPNOivMOWrjL/ib7nposLwXynfdH/L2/c6hXdgnmD/jOsAnc
L7Lq/ObcL/Io+AneBX6CW8FPsFvPzDKMh/Xdzf1P9+7ps5vxxMWtuP9mfKfV
XRkvVS/VJ38P/D2Twd/zMvh7TozLK834+nnL2/+6PB0QOb0fqluK8SdOXElk
/M0fyvosv2o+7WhD7tc5eUZGG8ZP3DZ8jxs5mH/o/Ps3lGd8z4Ld7Rif2+oK
19vfjv+J62fmptgujK9qsHi3L65aD9sGXuf80I4O3Rl/IKaJz3yxemHp+y+5
h/N195y5k/FHo8b4LA/WD7F8T8/JC2G8UYljrRl/fEDmPsYf/mzqFeZvO2l2
SgfGQwct3E+pN6w8Rx7tmsfyrZK3gcf1OrXhe57vNPBrrgd+zefBr5mqPLJ6
xvj7gn+3M95N0zM27kR75finU5UHs4f7v5rB00ccup/b20o1P3SlZ1l7oto+
LDvWg+db8e1TvH27N5/A8x2ExK/LPXv5GusPn8dUvp3xqyum7nOTb5Ny9wUz
3ilrCbfPS9/N4nLa74oNZXxn1wxur2oe3E5qJ7+ffrQS449/tTCJ8S5rKuzk
893zjaMZX5w6krdvetvQ7YHQP9ZPsHahmgd7Hxx6lbVj6b824nzZY+MPMB5b
M5u3+/C2w7h9/s7lvInNO1Tzsi671xXWXWWFdZdpepaNs+TYt2qFtG+69Cw7
j6hed2F6w/S8s920XFbfy1fn8P4wuFY0jxOyNr4LXz9v2l6zB+NHxg9yNd6x
+qqeX57rOyKK9/8hyXx9Un5RQhbjFzbOimB87Dcfc7671+Esnet/2fWwaXYP
mxdUr4tMm19k5/GUX65xvaUMDONygh9asdONnrFxTTVfy+oZK8/9+zfewHjW
7bm8P1xaNX+Hm/Eo259VzyOq9Uw1vzjfg3WF70Gq9bNqPbd948tqjN/c+LWE
X8svefrOmozP+fZrnm/vs28GZJ1M9Z1CZZ+9st6g6icY/3ODD6synpZyM7fD
E4NG7vDVTyIXdOHffc3ikvm4iIdyyu4Xye5Pqu6fmP5V9wdsX0h2fxjrz7Nr
H+bjaEqHHD6+tldpfUCnvcX231SXh2r/zSv7nFh/Vr3Pie2/Uc1rWL1U61nW
bmDzGlW+2P6b7D6n7Hy9fOITfL74+rUfb2Ocen+PSv9U67TQGg9y+WfK1uHt
OCVhJZefJewDpMA+gOrvUNP2OTG7h8nx+v6baXqm2n/D6kulZ9l8ZfffVJdH
9fyCfe/rsp8Yp9rnlC2P6u9Q0/Y5MbtHlS+2/6Z6n1OXXZXdf/u0XMMqjL/1
cefOnH8yNCDzuOw+p+w40rX/Jvt9vQLmwSSYB6+4/I7Qtc+J7b+Ztk6W3eek
On+hOs/C+jO2f6V6P62w38XO+c6M99P5PtjFpdv4vbttszb5tIfY9x2VPp9s
eoyvG1uMG8bXmRlLo3i7Z0rO+1g5qe5nWm655ZZ7nXvdX0AXt3pzx03zb/I6
94ofmS5u9ZPPi5sevO53ScWLql8qFTfNj9Ur+jRNP6bpzTQ9eEVvlltueeB5
cbMnxc2uer1eqstpmh5U56tajmn9n4p7RW9U/V82X9XllJWja5xSyVedr1fm
BdPGhVe4afpULUcXN228qOZeGe+6uGl21TS7ZJp+qLhXvkdk4yGbtl5VzU1b
53hlHJmmH9V6pqqXV7hp61XT2tG0cVdU9eN1rlpvuuSrTu+sW+YWMn0cpB8O
6be61E9ZkLMK5NzqR44Tf/hVSF+H2L7Jll+1/BiQMwPkRIOcl4DnVc/nrxLb
k2ogfznkm5Xmrl53V3qDx0/u+XME9wN6bO7F34wX6i+eAJYe85fXFddFdb5Y
/BAqfV7+ZANPnxCcx+t1DvyGUhX7yWL6VJ2v6jgYPWJ2cD4qaS/3r1lf+7zP
+nZ4a/VFVt9zz4a0ZbzOvg0B8YOW9fen4p+C39lBwe+MKt4IVt/BiuN4YH5h
sv56VOXpc1trHr/32PHr3G/RiXdBpWfMXw/jWHwq1f7gquMUnUHG0UfgD/uK
4A8r638ny3882bgW41X3Lef5nr0wOSD+71g/l60vll52/tVlV1X7pVLNI1h6
1fXC8sXWIbrmfap2l43LgeV7aFM0j5fSPjST+wVXq/5OQOK/ydZXdfti8rtJ
xsmRjfMQLPih9yKOt4nl6/hxxwt+3Krz1fUOgq54C4WNP3bNZfwxjFPFC5KN
e4PVF4uDoVrP2PqcKp7Prg+TqjP+zLqeHRl3G49Ftr10xc+RzdeJGz9FiBsf
Ixk3jCouDZV+MDlY3CQq/WP2E7O3sus3qvgtsus6LA6PbDxDqvUkVh5sveTE
ZRokxGX6vfGytgBvEb2M28+c1rP4d33fG4/wdmmK7FsOIIpnq+t7BOMfIfGg
pgt6/hb0TBWHMxnirZXyE29tC3F9wxee4/2qSUR7Hk81oU0rXq/DyP6DE49x
RCHtaoxketn66oozjPE2iteBWFypNZL7FZjeqL5HVM+Puur1g6Z9Kl3617Uv
KsvHIOtALL6f7vi64j429r2gOl6iavnYPC67ny/7XY+lx/Zpqc6jLbfc8t/P
vX7fUlf5Tbu/6pX7cqbdi9Z1b1a2Xrry1dWO4SAnA+Skw30zbB2yT3IfA1u3
OPdzRgr3c1Tvr1Ldu6D6TsHetcHujYjveYUE6D0v2XpdhvOabOG8Zim0VyU/
90NOBugdK7fndOK9KTHO83t+zgex74hc5Hz2ING5s+p9SEd+uCAfO3cW6xUO
9aJ6b0XX/RPV8qnqRVV+zA5nE41r7DwU23/A6rUS0vcS3kF4FnmvWbU+/b0r
UUHQp/iORjy8o0F1TwCzb+I7ZTVcvlPm737aRmEfw3knaLJwD1n1uZV4jjaT
+F0wLN/7+l3h9e02qTNvx7tTK7my87LrQMsttzzw3DR/xuJWL9P2VVSXU5d8
yy23vPhwax/yuVfsp2n237Q4Bqa1oy79U8kxTW+66ovFraLKV7UeVI87bH9j
ypzYsozPqDqL78/8NDLE534Utj/Wn+jeLyYf3b8VznFKEZ/jyL7DXthzqKlw
DoW9R6n63AGrF3a+gJ1DZS5pzd8JTerWgu+/fZfbhPPIBV34/fBmccn8nm2L
AN2jo9oPH5MxjJ+bjJo2mZ8LDHx9mc97wrLvZVO9X0/lNyGrHyzeAvYePXYO
ZZreVPsdqNYnli+VvyrWXidOZ19n5ewf9jk/15ifOcrV+RR2/oXli50Xt0/r
UZHxBQmZ/HznHMxrsu+Yy/YT2XO0HXAO9TacQzWHc6h2SPlV98M1ZYP5+VS9
FWEdCtOvMDnYuRsWJwSbX6jmQey+N1ZfzJ+C6l73vyNn8vE+tHwun19qJyfy
+o4dl8318/WSJdyvM/HS+b2+1gmV7zrD1xXN58Xy+/bdntjNeSKyLpoYl8fn
6/XzlrdnvOr85lx+1Ih7OZ/XuB/Xf62Z40jna8xPCmsXqnwxPWDrzBRk/TYd
+m393+k3hMVvWas4jkp0rRd4fYfF3MvXn+fit7qad2TzjYB1YJyidSBmV58q
0ZXHbVs890Ve32lXU135uVP5B2F25pRiv91Lj2zkdqz/kW18/lqUE+nzPga2
rqDyq43vns7t1cvt0vPj6WW3Je3n2L0L1f5f2DxYZfsX/Pt66w1tub3tf2qO
q/7/cHIS99MvkxTJ7djK5Q24X5Vqv+9AfV+I86NsPK4hyxqEM97yrso9Gf+8
1CmtfmcYx9rrszZfRnL7v+URbifXPdhyp69+q8sPGusPWPlV+5HJfkdQ388U
9S/LMfn/AW6aHsY=
     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{738.3188871305385, 260.},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {0., 4.999999}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{0.6949576741239921, -3.2490556659831356`, 0.6408362587424721},
  ViewVertical->{-0.03961241787848134, 0.185195380299389, 
   0.981903013268411}]], "Output",
 CellChangeTimes->{
  3.9157778069259453`*^9, {3.915777856465561*^9, 3.9157778849421597`*^9}, 
   3.9157779876499805`*^9, {3.915778028825727*^9, 3.9157780626699905`*^9}, 
   3.915852526197202*^9, 3.9258153273401337`*^9, {3.925815357484646*^9, 
   3.9258153633422832`*^9}, 3.925816228740553*^9, {3.9258162596917534`*^9, 
   3.9258162757984943`*^9}},
 CellLabel->"Out[26]=",ExpressionUUID->"669b1e29-d748-ed4b-ab42-900718c87197"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"err", " ", "=", " ", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"B", "-", 
     RowBox[{"c", " ", 
      RowBox[{"a", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], "//", "N"}]}]], "Input",
 CellChangeTimes->{{3.9157797877877216`*^9, 3.915779810109432*^9}, {
  3.925816251663761*^9, 3.9258162524486713`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"7c24f9cc-d083-2f4b-82de-a4c415016d24"],

Cell[BoxData["2.738095238095238`"], "Output",
 CellChangeTimes->{{3.915779790448005*^9, 3.9157798108114166`*^9}, 
   3.915852526228483*^9, {3.9258162359562187`*^9, 3.9258162762565346`*^9}},
 CellLabel->"Out[27]=",ExpressionUUID->"fb00aae0-b4fc-b94f-86cc-58ecc3872307"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"relu", "[", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}], "]"}], "-", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9258163669022045`*^9, 3.925816373966221*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"42c7ee89-4eb7-6944-bc2e-fd00928c5ec3"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["5", "3"]}]], "Output",
 CellChangeTimes->{3.9258163744396667`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"06cb79d7-cad8-6b48-ae75-8b7120d0ca20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"relu", "[", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
  RowBox[{"g", "[", 
   RowBox[{"1", ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.925816379645027*^9, 3.9258163826294136`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"1dcdeaa5-8dc8-3040-be58-64649ed4b1e7"],

Cell[BoxData[
 FractionBox["5", "3"]], "Output",
 CellChangeTimes->{3.9258163829744587`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"1c6ba8c5-80ea-d942-8f5b-05777e0a8329"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"t_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"t", ",", "s"}], "]"}], "-", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"err", "-", 
      RowBox[{"M", "/", "3"}]}], ")"}], "/", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.915778645313005*^9, 3.9157786629033623`*^9}, {
  3.915778722306061*^9, 3.91577873443696*^9}, {3.915779818696371*^9, 
  3.915779819010875*^9}, {3.925816609854599*^9, 3.925816613679207*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"f236c92d-2db0-2141-8c4c-61088b4c01be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"relu", "[", 
      RowBox[{"f", "[", 
       RowBox[{"t", ",", "s"}], "]"}], "]"}], ",", 
     RowBox[{"h", "[", 
      RowBox[{"t", ",", "s"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.915778742355608*^9, 3.915778745877568*^9}, 
   3.915852523067795*^9},
 CellLabel->"In[37]:=",ExpressionUUID->"eecfdc7a-6878-e147-a03b-368943a8e7f0"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx8XQmcjdX7v/Z9iSJSliZUslNUzrVTKqL4lS1lKUtCSGiIqCgG2VosDQrF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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1nHXAFUXbxs/Z5exhlmdEQECQsAUUJSx8ERDsBBUVVECUlBKUUFHBwBax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            "]], Polygon3DBox[CompressedData["
1:eJwtnAW0HUUWRfu9l+5PN/+jwd3d3RPcgrtDcHeXAMHdbQg2uLu7+6CDu8MM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            "]], Polygon3DBox[CompressedData["
1:eJwt1wncTmUexvFjeV+8WbMWoexCZZlCSEKRfWtQoWQnEsrWqMiSLIUiIjJM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            "]], 
           Polygon3DBox[{{2781, 864, 632, 1640, 1682, 2633}, {2703, 1756, 
            1836, 823, 728, 2704}}]},
          Annotation[#, "Charting`Private`Tag$18322#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, 
      {RGBColor[0.368417, 0.506779, 0.709798], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJwtmXnAVsP7xh/18kzNe8YWZUmiTSpJUfYlaaUSKhQpEhUKyZJ9379aZcvS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            "]], Polygon3DBox[CompressedData["
1:eJwtmmXAHEUWRT9goBq6Etzd3d0Wd3d31+Du7izu7u4E12DBQ7Dg7h7c9py9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            "]], Polygon3DBox[CompressedData["
1:eJwt13fcjeUfB/CD5PDwGJVVWalQVqVoUsmeUUhFKZKMUIjiZxdFPzs7O+uR
mb1HHqPsQsoekQrJ6H29zv3H5/W6vu/zvc59n/uc+7ruU/CNNnVbp43FYjsk
vYzKHItVisdiLTLEYu/Igiyx2KWkWKw6e09d4JZY7F51Tn3j2CrWgfVjWdlw
dsacrupuksyGsdOsi/ojGcKKsTrm1pU5XhvPXmZ91X3kieRYbAJrwPqpH3eM
Uubewcaylaw968uysKHslPfppO4s2dgIdpZ9rP5EcrHxbLW5Hc3tzzKzIeyk
vg/UH0puNomt19dJ3wCWnY1k5/R1V/eQJDaYHWfvq9tLDvYVW2ZuW3N7sZIs
lf3OJrKF7HY2hq1g77M+7G72DdvKurMh7Ce2kv3Cjshlx8rHZrJUdQ99Q/Xl
Z7PYNvY/NowVYLPZdtaTDWf3sAVsD+vPxrBCbD7bzfqx0awgm8N2sF5sBLuL
TWObWVc2iBVmC9le9ikby4qyFeww+z+byvawuWwn+0Eu+hwZeTqv/8X/ln/1
XJWLxoVkl9f26bmXLVLvM+8zNo7dx5ayn9kgNokVYcvZIfYlm8LuZ8vYQTaY
TWY/sglsDVsr553LbWw0W65up6+3vjPsILvBbkoGv8nSbDe7pJ6ub7m+X9k2
dp5dkBveLwMbyH41bqnnXYmzz9lvrJX6PcnIvmBHWWt1G0nPPgvfOWumfktu
ZQPYEdZC/Y7kZVPYRsfs4lw+Z5nYIHZMX1t1OynG1gXTN0LfTJaHTWYbWGc2
kD3MfmbXWQpbz0qxXeH7YdPYMvYQ+4ldY3PZOvY3O8uySLLkcK0eZBuMT+gb
pW+2vgfY+nDPsJFsFruTTWWb2EfsC1acfR/uXzaezWcl2NZwD7IJbAGbyBqy
/mHNYKXZHNaGjQvrC6vMvmaN2KfsSfZQdK3DNd8SXbMazvkH41HGW/R109cz
WjvCGrIzWgPq6/tTXdH4bX159eVXX5Tn2VssD8un/tmc1ewP9jWbxv6Q51gz
lpvdrU6j7102gD3Dng997ATLFc6HbWNn2WF11rCOsQ3R7/RQdN3D9e/q/H5n
R4yzy1p9m/SdZ7+G70bWsc0sLWulHui45VlFdoEdZznDvc5S2Tn2izpbuG/Y
RraC9VLPN/dbqeS4y1kPlqJupq+RvlWsD1vIWrDXojU6rNXbov2hrrmHwv1q
XE3fv+lck2g9DutyarTG10lO3L8T44l1JKwnjVlHPR1ka7Se12YrjXsbL9DT
3HFfDetpWLNYRXbFMW5kStwj4V75PlrPayYn9q6wh+2I9pF6yYm9K+xh26N9
7kW2zLi78Vzv96ZjNPT6UvYJm8PeYA3YwbBmsSrsquPGwm8jrG2sEvuH3XQu
F809yXLL9+Zu1/MnO6XOE/YGtoPdlDfVvcwty56K1pOwrmyO1pTqzi+dcXvj
Ifoq66vh9WPsB5Y2fHdsCTvKdqrTyLdsMfuN7VDHZB5bxP6SF9TNvd+drID6
pL59LC5L2Sr2r9RXf6CvGCupviavhN8nK8keUV+WGqw1K8juU/8jL7IOrAgr
rr4q9VhHVpSVUF+XxqwbK8XKqG/Iq+xjVpo9qr4iNVkbVojdrz7hnPeyDPId
W8GOsz3qW2UJWxmt7dvjifU/7AMfuqaX2O8sX9gf9e2K1r9z6rvlLvlE3xV2
wbhA+K3q2xM+G/tDXVB+ZHtZjDVT9/b+5djT4bqw8yx/2DPZ7nDt2Wl1Xkll
O6Png1XxxL4T9p+2jnuK7WcZZZm+1fpOswPqTGGPY2vCb5KtUV80bxKbzlaz
vmxReP5jr7NDbCO7zGawuewXtpn9w2ayFHaYbWJX2DdsDjvCtrCrbBabx9ay
/uEas3dZU7aXzQv7JRvCRkZ7XNjrNkZ7aVWfbZrx28bD9A2VCmwWe4+NUdc2
t5I5S1g3Nos1YfXZVNaUDWbPs8fZXNaWjWcvsipsOmvOhrMq7Bm2gHVi01gj
VpvNYC3YCFaVlWczWUs2ilVnzyYlnncfCGtIOIbkc85l2BmWWVbp+1HfI+yo
Or0sZluTEp/3rXjimTg8G6+1r89mrdlYdR19L+j7hr3DRrJqrEK0Pvdkk9hk
2W/uQtaZTVe/oq+OvkWsC5sR1lJWl33FqrDO7AFWkI1mVVkX9iArxMaxOqwH
e4QVY5PZ6+wL9ix7jE1ir7HPw3fGyiYl/mtUZp3CfSUPuy5jWW3WPdT6iugb
w2qFe4o9xIomJf4vvBRPzAvzl/ps89mHbKq6ob5a+r5lH7AprAGrGe5VqcZa
sfyssHqevo7xxHUK16uic5nCmrBB6uf0lYv6OsQTv73wG0x13BTWjk1Q19NX
Vd8wVjae+L7D956i7xgvxV7NkHjuDc+/J+RhVpnFWZZwH0kRVoNdsy+kDfeb
FGW12HWWTr3LMaaz/WyAuV+y3WwGO8AGssFh75YnWSOWjd2hXqOvX/idsZas
SXi2kCdYA5aV3a5uLm/L+uiZtLLrss7407Bu6mul742kxPNteM7dFD3jVtO3
z3ix8Ul9X+mb4PX9bAk7xUaz8UmJ59vwnLshesatYu4B4++MT+sbo29iUuI/
REo88T8o/B9qHp5z+FOssTq7vpzqW/R9xEazWqweOy9Ps9dYDpYr7HlSkr3C
0rJ49L2Viyf++4b/wEUdYwQrz9qq79GXV99IVoG1Y4VZnrAPhns4rFMsI0tW
L9bXlc1kr7OXwr4qJVhDloZlUH+n72M2mzVlL4e1Ux5k9dlN33l69QV5hjVh
t+nLrT4jj7HaLDPLrh7u/R5nLdldLAcbykqzpux2lsROSZnwrMAysaxhz5Pi
7GUWY7eG/UMeZTVZEsumLps5sU+G/fKSlFP/B3ZKR+E=
            "]]},
          Annotation[#, "Charting`Private`Tag$18322#2"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[
           0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
          "Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[
           0.15473514000000002`, 0.21284718000000002`, 0.29811516000000005`], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}, {}}, {
      {GrayLevel[0], 
       Line3DBox[{400, 1, 360, 241, 2300, 16, 2314, 31, 2328, 46, 2341, 61, 
        2355, 76, 2368, 90, 2382, 105, 2397, 120, 2409, 135, 2420, 149, 2431, 
        164, 2443, 179, 2457, 194, 2618, 301, 416, 208, 398, 320, 1435, 209, 
        1436, 210, 1437, 211, 1438, 212, 1667, 304, 417, 213, 822}], 
       Line3DBox[{1264, 2, 1672, 309, 400}], Line3DBox[{1266, 3, 1264}], 
       Line3DBox[{1268, 4, 1266}], Line3DBox[{1270, 5, 1268}], 
       Line3DBox[{1272, 6, 1270}], Line3DBox[{1274, 7, 1272}], 
       Line3DBox[{1276, 8, 1274}], Line3DBox[{1278, 9, 1276}], 
       Line3DBox[{1280, 10, 1278}], Line3DBox[{1282, 11, 1280}], 
       Line3DBox[{1284, 12, 1282}], Line3DBox[{1286, 13, 1284}], 
       Line3DBox[{1288, 14, 1286}], Line3DBox[{401, 15, 396, 310, 1288}], 
       Line3DBox[{311, 30, 2572, 243, 401}], 
       Line3DBox[{348, 45, 426, 2620, 311}], 
       Line3DBox[{2353, 60, 342, 2579, 249, 858}], 
       Line3DBox[{2366, 75, 402, 2353}], Line3DBox[{2380, 89, 579, 2366}], 
       Line3DBox[{2395, 104, 581, 2380}], Line3DBox[{2407, 119, 2395}], 
       Line3DBox[{2418, 134, 2407}], Line3DBox[{2429, 148, 2418}], 
       Line3DBox[{2441, 163, 2429}], Line3DBox[{2455, 178, 2441}], 
       Line3DBox[{2468, 193, 2455}], 
       Line3DBox[{306, 214, 1439, 215, 1440, 216, 1441, 217, 1442, 218, 1443, 
        219, 1444, 220, 1445, 221, 1671, 308, 418, 222, 399, 321, 2481, 207, 
        2468}], Line3DBox[{306, 511, 746}], Line3DBox[{348, 650}]}, 
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0r1LFHAYwPHn9EJJN00tTbtriMYcNJpqEJGQy0ONCD0oqKnrH1AoxMmG
aKwhGnWIxhrEMa3ztRfkkDQX7XXU7uqqjzh8+Tzj83tJ3bibzSciYlLfkhF7
1RE7XFflaMQR1tVFNPIET/MsO3mel9jLKxxmjrd4W3nzBMf5iA/4jE/4gjOc
4yteqI/Y4A/N64s+61htxAKb+IbNfMsWFniciwe7cYmtXGYbT2rF3M5VdnCN
p/iOKb5nmh9Y4if+1Ed91baKdnzNAl9yltN8zsd8yik+5Bjv857umG9ylIPM
sIcX2cVzPMP0wXnYwG73UOR3JbWrLeVqIqo5wipeZ4LXGLzKf95uiH+Z5YAq
5gz/sJ+/eZll9rHEXv5iD/dZdg+bycP/8B9xCEoh
        "]]}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{2300, 2571, 1446, 2299, 3324, 2482, 2301, 3325, 2483, 2302, 
        3326, 2484, 2303, 3327, 2485, 2304, 3328, 2486, 2305, 3329, 2487, 
        2306, 3132, 3393, 2307, 3330, 2488, 2308, 3331, 2489, 2309, 3332, 
        2490, 2310, 3333, 2491, 2311, 3334, 2492, 2312, 1619, 2493, 2572}], 
       Line3DBox[{2314, 3133, 3394, 2313, 1460, 2315, 3335, 2494, 2316, 3336, 
        2495, 2317, 3337, 2496, 2318, 3338, 2497, 2319, 3339, 2498, 2320, 
        3134, 3395, 2321, 3135, 3396, 2322, 3340, 2499, 2323, 3341, 2500, 
        2324, 3342, 2501, 2325, 3343, 2502, 2326, 3469, 2573, 2574, 2656, 
        2657, 2620}], 
       Line3DBox[{2328, 3136, 3397, 2327, 3137, 3398, 2329, 1474, 2330, 3344, 
        2503, 2331, 3345, 2504, 2332, 3346, 2505, 2333, 3347, 2506, 2334, 
        3138, 3399, 2335, 3139, 3400, 2336, 3140, 3401, 2337, 3348, 2507, 
        2338, 3349, 2508, 2339, 3470, 2575, 2577, 2509, 2576, 3204, 3481, 
        2559, 2642, 2698, 2699, 2803}], 
       Line3DBox[{2341, 3141, 3402, 2340, 3142, 3403, 2342, 3143, 3404, 2343, 
        1487, 2344, 3350, 2510, 2345, 3351, 2511, 2346, 3352, 2512, 2347, 
        3144, 3405, 2348, 3145, 3406, 2349, 3146, 3407, 2350, 3147, 3408, 
        2351, 3471, 2580, 2581, 2352, 3465, 2560, 2578, 2561, 2643, 2638, 
        2639, 2708, 2802}], 
       Line3DBox[{2353, 2658, 2563, 2666, 2562, 2687, 2644, 2785, 2805}], 
       Line3DBox[{2355, 3148, 3409, 2354, 3149, 3410, 2356, 3150, 3411, 2357, 
        3151, 3412, 2358, 1499, 2359, 3353, 2513, 2360, 3354, 2514, 2361, 
        3152, 3413, 2362, 3153, 3414, 2363, 3154, 3415, 2364, 2682, 3416, 
        3207, 2365, 2683, 3198, 3487, 2659, 2584, 2670, 2660, 2661, 2629, 
        2689, 3492, 2703, 2704, 2775, 2811}], 
       Line3DBox[{2366, 2583, 2621, 2582, 3472, 3211, 2711, 2726, 2630, 2714, 
        2715, 2716, 2771, 2792}], 
       Line3DBox[{2368, 3155, 3417, 2367, 3156, 3418, 2369, 3157, 3419, 2370, 
        3158, 3420, 2371, 3159, 3421, 2372, 1511, 2373, 3355, 2515, 2374, 
        3160, 3422, 2375, 3161, 3423, 2376, 2748, 3424, 3213, 2377, 2749, 
        2750, 2732, 3425, 2734, 2733, 2378, 2717, 2718, 3493, 2585, 2788}], 
       Line3DBox[{2380, 2746, 2747, 2740, 2739, 3496, 2379, 2586, 2622, 3489, 
        2691, 2696, 2690, 2776, 2800}], 
       Line3DBox[{105, 1349, 106, 1350, 107, 1351, 108, 1352, 109, 1353, 110, 
        1354, 111, 1355, 112, 1356, 113, 1357, 114, 267, 1358, 115, 373, 
        2793}], Line3DBox[{2382, 3162, 3426, 2381, 3163, 3427, 2383, 3164, 
        3428, 2384, 3165, 3429, 2385, 3166, 3430, 2386, 3167, 3431, 2387, 
        1522, 2388, 3168, 3432, 2389, 3169, 3433, 2390, 2589, 3434, 3199, 
        2391, 2564, 2587, 3435, 2632, 2631, 2392, 2798}], 
       Line3DBox[{2395, 3436, 3170, 2394, 2672, 2679, 3206, 3486, 2680, 2393, 
        2673, 2674, 2588, 3490, 2633, 2781, 2797}], 
       Line3DBox[{2397, 3356, 2516, 2396, 3357, 2517, 2398, 3358, 2518, 2399, 
        3359, 2519, 2400, 3360, 2520, 2401, 3361, 2521, 2402, 3362, 2522, 
        2403, 1534, 2404, 2590, 2662, 3483, 2523, 2591, 2647, 2649, 2648, 
        2592, 3201, 3473, 2779, 2795}], 
       Line3DBox[{119, 1360, 118, 1359, 117, 420, 1715, 116, 408, 491, 2796}],
        Line3DBox[{2407, 2527, 3365, 2406, 2526, 3364, 2405, 2525, 2764, 3363,
         3200, 2623, 2524, 3479, 2624, 2646, 2728, 2645, 2780, 2794}], 
       Line3DBox[{2409, 3171, 3437, 2408, 3366, 2528, 2410, 3367, 2529, 2411, 
        3368, 2530, 2412, 3369, 2531, 2413, 3370, 2532, 2414, 3371, 2533, 
        2415, 2684, 2735, 3172, 3488, 2685, 2594, 2595, 2650, 3218, 3482, 
        2651, 2782, 2799}], 
       Line3DBox[{2418, 2538, 3374, 2417, 2537, 3373, 2416, 2536, 2765, 3372, 
        3214, 2751, 2535, 2752, 3497, 2742, 2593, 2596, 2534, 2719, 3494, 
        2625, 2787}], 
       Line3DBox[{2420, 3173, 3438, 2419, 3174, 3439, 2421, 3375, 2539, 2422, 
        3376, 2540, 2423, 3377, 2541, 2424, 3378, 2542, 2425, 3498, 2754, 
        2543, 2755, 2598, 2600, 2729, 2743, 2730, 3495, 2599, 2731, 2634, 
        2720, 2721, 2722, 2774, 2807}], 
       Line3DBox[{2429, 2547, 3382, 2428, 2546, 3381, 2427, 2545, 3380, 3215, 
        2753, 2544, 3379, 2741, 2426, 1557, 2681, 2597, 2601, 3202, 3466, 
        2692, 2628, 2700, 2772, 2809}], 
       Line3DBox[{2431, 3175, 3440, 2430, 3176, 3441, 2432, 3177, 3442, 2433, 
        3383, 2548, 2434, 3384, 2549, 2435, 3385, 2550, 2436, 3474, 2602, 
        2604, 2551, 2603, 2652, 2565, 2653, 2701, 2702, 2637, 2786, 2808}], 
       Line3DBox[{2441, 2554, 3388, 2440, 2553, 3387, 2439, 2552, 3386, 2438, 
        1570, 2437, 3485, 3178, 2675, 2676, 3205, 3467, 2677, 2678, 2566, 
        2669, 2668, 2606, 3210, 3219}], 
       Line3DBox[{2443, 3179, 3443, 2442, 3180, 3444, 2444, 3181, 3445, 2445, 
        3182, 3446, 2446, 3389, 2555, 2447, 3475, 2607, 2608, 2448, 3468, 
        2567, 2605, 2568, 2655, 2640, 2641, 2709, 2784, 2710, 2806}], 
       Line3DBox[{2455, 2557, 3391, 2454, 2556, 3390, 2453, 1583, 2452, 3448, 
        3184, 2451, 3447, 3183, 2450, 3476, 2610, 2667, 2609, 2449, 3203, 
        3480, 2570, 2654, 2569, 2688, 2804}], 
       Line3DBox[{2457, 3185, 3449, 2456, 3186, 3450, 2458, 3187, 3451, 2459, 
        3188, 3452, 2460, 3208, 3453, 2686, 2461, 3209, 3477, 2613, 2663, 
        2614, 2671, 2664, 2665, 3484, 2635, 2693, 2705, 2790}], 
       Line3DBox[{2468, 2558, 3392, 2467, 1595, 2466, 3456, 3191, 2465, 3455, 
        3190, 2464, 3454, 3189, 2463, 3499, 2757, 2766, 2756, 2767, 2462, 
        3500, 2763, 2612, 2626, 2611, 2712, 2713, 2727, 2636, 2723, 2724, 
        2773, 2810}], 
       Line3DBox[{2481, 2619, 1669, 2480, 3464, 3197, 2479, 3463, 3196, 2478, 
        3462, 3195, 2477, 3461, 3194, 2476, 3216, 3460, 2768, 2770, 2769, 
        2475, 3501, 2758, 2759, 2745, 2744, 2474, 2616, 2627, 2695, 2697, 
        2694, 3491, 2777, 2801}], Line3DBox[{2579, 2706, 2783, 2707, 2789}], 
       Line3DBox[{2618, 2617, 1663, 2469, 3192, 3457, 2470, 3193, 3458, 2471, 
        3217, 3459, 2760, 2472, 2761, 2762, 3502, 2736, 2738, 2737, 2473, 
        3212, 3478, 2725, 2615, 2778, 2791}], 
       Line3DBox[{2813, 3126, 2083, 2812, 3608, 3035, 2814, 3609, 3036, 2815, 
        3610, 3037, 2816, 3611, 3038, 2817, 3612, 3039, 2818, 3613, 3040, 
        2819, 3614, 3220, 3503, 2820, 3615, 3041, 2821, 3616, 3042, 2822, 
        3617, 3043, 2823, 3618, 3044, 2824, 3619, 3045, 2825, 3323, 3712, 
        3046, 3127}], 
       Line3DBox[{2827, 3221, 3504, 2826, 2098, 2828, 3620, 3047, 2829, 3621, 
        3048, 2830, 3622, 3049, 2831, 3623, 3050, 2832, 3624, 3051, 2833, 
        3625, 3222, 3505, 2834, 3223, 3506, 2835, 3626, 3052, 2836, 3627, 
        3053, 2837, 3628, 3054, 2838, 3629, 3055, 2839, 3630, 3056, 2840}], 
       Line3DBox[{2842, 3224, 3507, 2841, 3225, 3508, 2843, 2114, 2844, 3631, 
        3057, 2845, 3632, 3058, 2846, 3633, 3059, 2847, 3634, 3060, 2848, 
        3635, 3226, 3509, 2849, 3227, 3510, 2850, 3228, 3511, 2851, 3636, 
        3061, 2852, 3637, 3062, 2853, 3638, 3063, 2854, 3639, 3064, 2855}], 
       Line3DBox[{2857, 3229, 3512, 2856, 3230, 3513, 2858, 3231, 3514, 2859, 
        2130, 2860, 3640, 3065, 2861, 3641, 3066, 2862, 3642, 3067, 2863, 
        3643, 3232, 3515, 2864, 3233, 3516, 2865, 3234, 3517, 2866, 3235, 
        3518, 2867, 3644, 3068, 2868, 3645, 3069, 2869, 3646, 3070, 2870}], 
       Line3DBox[{2872, 3236, 3519, 2871, 3237, 3520, 2873, 3238, 3521, 2874, 
        3239, 3522, 2875, 2146, 2876, 3647, 3071, 2877, 3648, 3072, 2878, 
        3649, 3240, 3523, 2879, 3241, 3524, 2880, 3242, 3525, 2881, 3243, 
        3526, 2882, 3244, 3527, 2883, 3650, 3073, 2884, 3651, 3074, 2885}], 
       Line3DBox[{2887, 3245, 3528, 2886, 3246, 3529, 2888, 3247, 3530, 2889, 
        3248, 3531, 2890, 3249, 3532, 2891, 2162, 2892, 3652, 3075, 2893, 
        3653, 3250, 3533, 2894, 3251, 3534, 2895, 3252, 3535, 2896, 3253, 
        3536, 2897, 3254, 3537, 2898, 3255, 3538, 2899, 3654, 3076, 2900}], 
       Line3DBox[{2902, 3256, 3539, 2901, 3257, 3540, 2903, 3258, 3541, 2904, 
        3259, 3542, 2905, 3260, 3543, 2906, 3261, 3544, 2907, 2178, 2908, 
        3655, 3262, 3545, 2909, 3263, 3546, 2910, 3264, 3547, 2911, 3265, 
        3548, 2912, 3266, 3549, 2913, 3267, 3550, 2914, 3268, 3551, 2915}], 
       Line3DBox[{2919, 3656, 3077, 2917, 3657, 3078, 2921, 3658, 3079, 2923, 
        3659, 3080, 2925, 3660, 3081, 2927, 3661, 3082, 2929, 3662, 3083, 
        2931, 3663, 2195, 2933, 3664, 3084, 2935, 3665, 3085, 2937, 3666, 
        3086, 2939, 3667, 3087, 2941, 3668, 3088, 2943, 3669, 3089, 2945}], 
       Line3DBox[{2944, 3565, 3281, 2942, 3564, 3280, 2940, 3563, 3279, 2938, 
        3562, 3278, 2936, 3561, 3277, 2934, 3560, 3276, 2932, 3559, 2194, 
        2930, 3558, 3275, 2928, 3557, 3274, 2926, 3556, 3273, 2924, 3555, 
        3272, 2922, 3554, 3271, 2920, 3553, 3270, 2916, 3552, 3269, 2918}], 
       Line3DBox[{2947, 3282, 3566, 2946, 3670, 3090, 2948, 3671, 3091, 2949, 
        3672, 3092, 2950, 3673, 3093, 2951, 3674, 3094, 2952, 3675, 3095, 
        2953, 3676, 3283, 3567, 2954, 2211, 2955, 3677, 3096, 2956, 3678, 
        3097, 2957, 3679, 3098, 2958, 3680, 3099, 2959, 3681, 3100, 2960}], 
       Line3DBox[{2962, 3284, 3568, 2961, 3285, 3569, 2963, 3682, 3101, 2964, 
        3683, 3102, 2965, 3684, 3103, 2966, 3685, 3104, 2967, 3686, 3105, 
        2968, 3687, 3286, 3570, 2969, 3287, 3571, 2970, 2227, 2971, 3688, 
        3106, 2972, 3689, 3107, 2973, 3690, 3108, 2974, 3691, 3109, 2975}], 
       Line3DBox[{2977, 3288, 3572, 2976, 3289, 3573, 2978, 3290, 3574, 2979, 
        3692, 3110, 2980, 3693, 3111, 2981, 3694, 3112, 2982, 3695, 3113, 
        2983, 3696, 3291, 3575, 2984, 3292, 3576, 2985, 3293, 3577, 2986, 
        2243, 2987, 3697, 3114, 2988, 3698, 3115, 2989, 3699, 3116, 2990}], 
       Line3DBox[{2992, 3294, 3578, 2991, 3295, 3579, 2993, 3296, 3580, 2994, 
        3297, 3581, 2995, 3700, 3117, 2996, 3701, 3118, 2997, 3702, 3119, 
        2998, 3703, 3298, 3582, 2999, 3299, 3583, 3000, 3300, 3584, 3001, 
        3301, 3585, 3002, 2259, 3003, 3704, 3120, 3004, 3705, 3121, 3005}], 
       Line3DBox[{3007, 3302, 3586, 3006, 3303, 3587, 3008, 3304, 3588, 3009, 
        3305, 3589, 3010, 3306, 3590, 3011, 3706, 3122, 3012, 3707, 3123, 
        3013, 3708, 3307, 3591, 3014, 3308, 3592, 3015, 3309, 3593, 3016, 
        3310, 3594, 3017, 3311, 3595, 3018, 2275, 3019, 3709, 3124, 3020}], 
       Line3DBox[{3034, 3131, 2295, 3033, 3607, 3322, 3032, 3606, 3321, 3031, 
        3605, 3320, 3030, 3604, 3319, 3029, 3603, 3318, 3028, 3602, 3317, 
        3711, 3027, 3125, 3710, 3026, 3601, 3316, 3025, 3600, 3315, 3024, 
        3599, 3314, 3023, 3598, 3313, 3022, 3597, 3312, 3021, 3596, 3129, 
        3128, 3130}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1264, 1447, 3324, 1265, 1460, 1291, 3398, 1473, 1304, 3403, 
        1485, 1316, 3410, 1496, 1327, 3418, 1507, 1338, 3427, 1517, 1350, 
        1528, 3357, 1362, 1540, 3366, 1374, 3439, 1550, 1386, 3441, 1562, 
        1400, 3444, 1575, 1413, 3450, 1587, 1425, 3457, 1598, 1436}], 
       Line3DBox[{1266, 1448, 3325, 1267, 1461, 3335, 1292, 1474, 1305, 3404, 
        1486, 1317, 3411, 1497, 1328, 3419, 1508, 1339, 3428, 1518, 1351, 
        1529, 3358, 1363, 1541, 3367, 1375, 1551, 3375, 1387, 3442, 1563, 
        1401, 3445, 1576, 1414, 3451, 1588, 1426, 3458, 1599, 1437}], 
       Line3DBox[{1268, 1449, 3326, 1269, 1462, 3336, 1293, 1475, 3344, 1306, 
        1487, 1318, 3412, 1498, 1329, 3420, 1509, 1340, 3429, 1519, 1352, 
        1530, 3359, 1364, 1542, 3368, 1376, 1552, 3376, 1388, 1564, 3383, 
        1402, 3446, 1577, 1415, 3452, 1589, 1427, 3459, 1817, 1818, 1438}], 
       Line3DBox[{1270, 1450, 3327, 1271, 1463, 3337, 1294, 1476, 3345, 1307, 
        1488, 3350, 1319, 1499, 1330, 3421, 1510, 1341, 3430, 1520, 1353, 
        1531, 3360, 1365, 1543, 3369, 1377, 1553, 3377, 1389, 1565, 3384, 
        1403, 1578, 3389, 1416, 3453, 1735, 1736, 1788, 1820, 3502, 1664, 
        1819, 1665, 1667}], 
       Line3DBox[{1272, 1451, 3328, 1273, 1464, 3338, 1295, 1477, 3346, 1308, 
        1489, 3351, 1320, 1500, 3353, 1331, 1511, 1342, 3431, 1521, 1354, 
        1532, 3361, 1366, 1544, 3370, 1378, 1554, 3378, 1390, 1566, 3385, 
        1404, 1655, 3475, 1656, 1713, 1738, 1739, 3477, 1737, 1659, 1661, 
        3478, 1774, 1789, 1775, 1666, 1783, 1687, 1778, 1686, 1845}], 
       Line3DBox[{1274, 1452, 3329, 1275, 1465, 3339, 1296, 1478, 3347, 1309, 
        1490, 3352, 1321, 1501, 3354, 1332, 1512, 3355, 1343, 1522, 1355, 
        1533, 3362, 1367, 1545, 3371, 1379, 1808, 3498, 1809, 1391, 1652, 
        3474, 1653, 1654, 1616, 3468, 1657, 1707, 1706, 1708, 1684, 1714, 
        3484, 1685, 1660, 1751, 1752, 1843}], 
       Line3DBox[{8, 2306, 23, 2320, 38, 2334, 53, 2347, 68, 2361, 83, 2374, 
        97, 2388, 112, 2403, 127, 2415, 142, 593, 2755, 156, 286, 2603, 171, 
        356, 2641, 291, 958}], 
       Line3DBox[{1276, 3393, 1453, 1277, 3395, 1466, 1297, 3399, 1479, 1310, 
        3405, 1491, 1322, 3413, 1502, 1333, 3422, 1513, 1344, 3432, 1523, 
        1356, 1534, 1368, 1733, 1734, 3488, 1546, 1380, 1785, 1787, 1786, 
        1650, 1781, 3495, 1782, 1555, 1392, 1683, 1838, 1750, 1842, 1749, 
        1857}], Line3DBox[{1278, 1454, 3330, 1279, 3396, 1467, 1298, 3400, 
        1480, 1311, 3406, 1492, 1323, 3414, 1503, 1334, 3423, 1514, 1345, 
        3433, 1524, 1357, 1643, 1644, 1535, 3483, 1369, 1710, 1712, 1711, 
        1648, 1704, 1705, 3482, 1833, 1832, 1844}], 
       Line3DBox[{1280, 1455, 3331, 1281, 1468, 3340, 1299, 3401, 1481, 1312, 
        3407, 1493, 1324, 3415, 1504, 1335, 3424, 1795, 1796, 1515, 1346, 
        3434, 1641, 1642, 1525, 1358, 1690, 1614, 1702, 1677, 1703, 1678, 
        3473, 1837, 1846}], 
       Line3DBox[{1282, 1456, 3332, 1283, 1469, 3341, 1300, 1482, 3348, 1313, 
        3408, 1494, 1325, 3416, 1729, 1730, 1505, 1336, 1784, 3425, 1638, 
        1793, 1779, 1780, 1347, 1681, 3435, 1611, 1688, 1747, 1748, 1700, 
        1840, 1848}], 
       Line3DBox[{1284, 1457, 3333, 1285, 1470, 3342, 1301, 1483, 3349, 1314, 
        1627, 3471, 1628, 1709, 1732, 3487, 1632, 1731, 1633, 1634, 1766, 
        3493, 1609, 1767, 1610, 1829, 1768, 1831, 1859}], 
       Line3DBox[{1286, 1458, 3334, 1287, 1471, 3343, 1302, 1623, 3470, 1624, 
        1626, 1607, 3465, 1629, 1608, 1699, 1698, 1630, 1680, 1836, 1756, 
        3492, 1757, 1830, 1740, 1855}], 
       Line3DBox[{1288, 1618, 1619, 1289, 1620, 3469, 1621, 1622, 1606, 1625, 
        3481, 1694, 1693, 1695, 1834, 1689, 1835, 1841, 1758, 1856}], 
       Line3DBox[{1435, 1597, 1663, 1424, 1586, 3449, 1412, 1574, 3443, 1399, 
        1561, 3440, 1385, 1549, 3438, 1373, 1539, 3437, 1361, 3356, 1527, 
        1349, 1516, 3426, 1337, 1506, 3417, 1326, 1495, 3409, 1315, 1484, 
        3402, 1303, 1472, 3397, 1290, 1459, 3394, 1263, 1446, 1617, 1672}], 
       Line3DBox[{215, 2474, 200, 298, 2713, 524, 186, 853}], 
       Line3DBox[{1439, 1662, 1668, 1745, 1755, 3491, 1744, 1746, 1851}], 
       Line3DBox[{1440, 1600, 1814, 1816, 3501, 1815, 1428, 1590, 1812, 1811, 
        1823, 3500, 1822, 1417, 1579, 1676, 3480, 1692, 1691, 1405, 1567, 
        1743, 1761, 1760, 1853}], 
       Line3DBox[{1441, 1601, 1813, 3460, 1429, 1591, 3499, 1810, 1418, 1580, 
        3476, 1658, 1406, 1568, 1726, 3467, 1722, 1724, 1723, 1393, 1556, 
        1679, 3466, 1651, 1762, 1854}], 
       Line3DBox[{1442, 1602, 3461, 1430, 1592, 3454, 1419, 1581, 3447, 1407, 
        1569, 3485, 1721, 1394, 1557, 1649, 1381, 1770, 3494, 1769, 1771, 
        1773, 1772, 1828, 1858}], 
       Line3DBox[{1443, 1603, 3462, 1431, 1593, 3455, 1420, 1582, 3448, 1408, 
        1570, 1395, 3379, 1558, 1805, 1794, 1807, 1382, 1802, 3497, 1801, 
        1799, 1647, 1821, 1370, 3479, 1536, 1674, 1615, 1701, 1753, 1759, 
        1852}], Line3DBox[{1444, 1604, 3463, 1432, 1594, 3456, 1421, 1583, 
        1409, 3386, 1571, 1396, 3380, 1804, 1806, 1803, 1827, 1826, 3372, 
        1798, 1800, 1797, 1825, 1824, 3363, 1646, 1675, 1645, 1715, 1716, 
        1725, 1613, 1717, 1612, 1742, 3490, 1682, 1640, 1849}], 
       Line3DBox[{1445, 1605, 3464, 1433, 1595, 1422, 3390, 1584, 1410, 3387, 
        1572, 1397, 3381, 1559, 1383, 3373, 1547, 1371, 3364, 1537, 1359, 
        1719, 1720, 1718, 1728, 3486, 1727, 1637, 1639, 1636, 3489, 1741, 
        1673, 1850}], 
       Line3DBox[{1671, 1670, 1669, 1434, 3392, 1596, 1423, 3391, 1585, 1411, 
        3388, 1573, 1398, 3382, 1560, 1384, 3374, 1548, 1372, 3365, 1538, 
        1360, 1526, 3436, 1348, 1791, 3496, 1790, 1792, 1631, 1635, 3472, 
        1764, 1765, 1763, 1777, 1776, 1696, 1839, 1697, 1754, 1847}], 
       Line3DBox[{1861, 2084, 3608, 1862, 2098, 1890, 3508, 2113, 1905, 3513, 
        2128, 1920, 3520, 2143, 1935, 3529, 2158, 1950, 3540, 2173, 1965, 
        3553, 2188, 3657, 1980, 2203, 3670, 1995, 3569, 2218, 2010, 3573, 
        2233, 2025, 3579, 2248, 2040, 3587, 2263, 2055, 3597, 2278, 2070}], 
       Line3DBox[{1863, 2085, 3609, 1864, 2099, 3620, 1891, 2114, 1906, 3514, 
        2129, 1921, 3521, 2144, 1936, 3530, 2159, 1951, 3541, 2174, 1966, 
        3554, 2189, 3658, 1981, 2204, 3671, 1996, 2219, 3682, 2011, 3574, 
        2234, 2026, 3580, 2249, 2041, 3588, 2264, 2056, 3598, 2279, 2071}], 
       Line3DBox[{1865, 2086, 3610, 1866, 2100, 3621, 1892, 2115, 3631, 1907, 
        2130, 1922, 3522, 2145, 1937, 3531, 2160, 1952, 3542, 2175, 1967, 
        3555, 2190, 3659, 1982, 2205, 3672, 1997, 2220, 3683, 2012, 2235, 
        3692, 2027, 3581, 2250, 2042, 3589, 2265, 2057, 3599, 2280, 2072}], 
       Line3DBox[{1867, 2087, 3611, 1868, 2101, 3622, 1893, 2116, 3632, 1908, 
        2131, 3640, 1923, 2146, 1938, 3532, 2161, 1953, 3543, 2176, 1968, 
        3556, 2191, 3660, 1983, 2206, 3673, 1998, 2221, 3684, 2013, 2236, 
        3693, 2028, 2251, 3700, 2043, 3590, 2266, 2058, 3600, 2281, 2073}], 
       Line3DBox[{1869, 2088, 3612, 1870, 2102, 3623, 1894, 2117, 3633, 1909, 
        2132, 3641, 1924, 2147, 3647, 1939, 2162, 1954, 3544, 2177, 1969, 
        3557, 2192, 3661, 1984, 2207, 3674, 1999, 2222, 3685, 2014, 2237, 
        3694, 2029, 2252, 3701, 2044, 2267, 3706, 2059, 3601, 2282, 2074}], 
       Line3DBox[{1871, 2089, 3613, 1872, 2103, 3624, 1895, 2118, 3634, 1910, 
        2133, 3642, 1925, 2148, 3648, 1940, 2163, 3652, 1955, 2178, 1970, 
        3558, 2193, 3662, 1985, 2208, 3675, 2000, 2223, 3686, 2015, 2238, 
        3695, 2030, 2253, 3702, 2045, 2268, 3707, 2060, 2283, 3710, 2075}], 
       Line3DBox[{1873, 2090, 3614, 1875, 2104, 3625, 1896, 2119, 3635, 1911, 
        2134, 3643, 1926, 2149, 3649, 1941, 2164, 3653, 1956, 2179, 3655, 
        1971, 2194, 3663, 1986, 2209, 3676, 2001, 2224, 3687, 2016, 2239, 
        3696, 2031, 2254, 3703, 2046, 2269, 3708, 2061, 2284, 3711, 2076}], 
       Line3DBox[{1877, 2092, 3615, 1878, 3506, 2106, 1898, 3510, 2121, 1913, 
        3516, 2136, 1928, 3524, 2151, 1943, 3534, 2166, 1958, 3546, 2181, 
        1973, 3560, 2196, 3664, 1988, 2211, 2003, 3571, 2226, 2018, 3576, 
        2241, 2033, 3583, 2256, 2048, 3592, 2271, 2063, 3603, 2286, 2078}], 
       Line3DBox[{1879, 2093, 3616, 1880, 2107, 3626, 1899, 3511, 2122, 1914, 
        3517, 2137, 1929, 3525, 2152, 1944, 3535, 2167, 1959, 3547, 2182, 
        1974, 3561, 2197, 3665, 1989, 2212, 3677, 2004, 2227, 2019, 3577, 
        2242, 2034, 3584, 2257, 2049, 3593, 2272, 2064, 3604, 2287, 2079}], 
       Line3DBox[{1881, 2094, 3617, 1882, 2108, 3627, 1900, 2123, 3636, 1915, 
        3518, 2138, 1930, 3526, 2153, 1945, 3536, 2168, 1960, 3548, 2183, 
        1975, 3562, 2198, 3666, 1990, 2213, 3678, 2005, 2228, 3688, 2020, 
        2243, 2035, 3585, 2258, 2050, 3594, 2273, 2065, 3605, 2288, 2080}], 
       Line3DBox[{1883, 2095, 3618, 1884, 2109, 3628, 1901, 2124, 3637, 1916, 
        2139, 3644, 1931, 3527, 2154, 1946, 3537, 2169, 1961, 3549, 2184, 
        1976, 3563, 2199, 3667, 1991, 2214, 3679, 2006, 2229, 3689, 2021, 
        2244, 3697, 2036, 2259, 2051, 3595, 2274, 2066, 3606, 2289, 2081}], 
       Line3DBox[{1885, 2096, 3619, 1886, 2110, 3629, 1902, 2125, 3638, 1917, 
        2140, 3645, 1932, 2155, 3650, 1947, 3538, 2170, 1962, 3550, 2185, 
        1977, 3564, 2200, 3668, 1992, 2215, 3680, 2007, 2230, 3690, 2022, 
        2245, 3698, 2037, 2260, 3704, 2052, 2275, 2067, 3607, 2290, 2082}], 
       Line3DBox[{1887, 2292, 2293, 3712, 1888, 2111, 3630, 1903, 2126, 3639, 
        1918, 2141, 3646, 1933, 2156, 3651, 1948, 2171, 3654, 1963, 3551, 
        2186, 1978, 3565, 2201, 3669, 1993, 2216, 3681, 2008, 2231, 3691, 
        2023, 2246, 3699, 2038, 2261, 3705, 2053, 2276, 3709, 2068, 2295, 
        2296, 2297}], 
       Line3DBox[{2069, 2277, 3596, 2294, 2054, 2262, 3586, 2039, 2247, 3578, 
        2024, 2232, 3572, 2009, 2217, 3568, 1994, 2202, 3566, 1979, 3656, 
        2187, 3552, 1964, 2172, 3539, 1949, 2157, 3528, 1934, 2142, 3519, 
        1919, 2127, 3512, 1904, 2112, 3507, 1889, 2097, 3504, 1860, 2083, 
        2291, 2298}], 
       Line3DBox[{2077, 2285, 3602, 2062, 2270, 3591, 2047, 2255, 3582, 2032, 
        2240, 3575, 2017, 2225, 3570, 2002, 2210, 3567, 1987, 2195, 3559, 
        1972, 2180, 3545, 1957, 2165, 3533, 1942, 2150, 3523, 1927, 2135, 
        3515, 1912, 2120, 3509, 1897, 2105, 3505, 1876, 2091, 3503, 
        1874}]}, {}, {}, {}, {}, {}}},
    VertexNormals->CompressedData["
1:eJztnXt01rUZxwvlUgoUsLRFCqXlKqIoiBOEAiogMoGKoNucQsWK4BhMKei8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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{413.4825088390907, 223.54901461518287`},
  ImageSizeRaw->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {0., 4.999999}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, {}},
  ViewPoint->{1.0772185322439845`, -3.107554366150051, 0.795428246425707},
  ViewVertical->{-0.0769914975869139, 0.22210466801406145`, 
   0.9719783051826248}]], "Output",
 CellChangeTimes->{
  3.9157787467112865`*^9, 3.915779820583807*^9, {3.915852524277321*^9, 
   3.915852526322912*^9}, {3.9258162664015064`*^9, 3.9258162791218643`*^9}, 
   3.9258163401570396`*^9, 3.925816434035614*^9, 3.9258166163385334`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"a6b82433-3d1e-e642-960a-f741df3be737"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"relu", "[", 
     RowBox[{"f", "[", 
      RowBox[{"t", ",", "s"}], "]"}], "]"}], "-", 
    RowBox[{"h", "[", 
     RowBox[{"t", ",", "s"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.915778770132601*^9, 3.9157787895820217`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"5ea85b07-6db7-f24e-bfe3-ce1485bd210d"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJy1fXVYlsvzt93djSDHDvRYWGsnduDx2Nhdx0TF7kLs7sJCxQC94QERRaWU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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1nAn8VcP7x+89595zzpRkT2QJpRXZZYuy/EgoS7RnX5O9KKWiEJEspRSV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            "]], Polygon3DBox[CompressedData["
1:eJwtmwXU5UQShfMk8nB398Hd3Qd3WWxwW2xxd3dncGdxd5ZdYHBbZHF3d9f9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            "]], Polygon3DBox[CompressedData["
1:eJwt2Am8TeUax/GNs8/ZB6XIKRkaJFKGCoVQMiXznCkkSaHSZKxI3eugIiTz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            "]], 
           Polygon3DBox[{{2333, 1696, 1700, 1058, 217, 1895}, {2185, 852, 654,
             1659, 1490, 2053}, {2221, 1690, 1185, 147, 1017, 2230}, {2183, 
            837, 615, 1655, 1523, 2074}, {2283, 1363, 1193, 1192, 1632, 
            2168}, {2332, 1695, 1699, 1023, 203, 1883}}]},
          Annotation[#, "Charting`Private`Tag$15521#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, {}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtkssuw1EQxqf8q87CJS5BEMTehkW3wgvowkoIG0GDhNYOK9tuPEFFBIlL
E5co2q4IRUhXaHkBXsD1N5n/YvJ9Z25nznyna2IuMlsmImGsHPtwIsNBkeOQ
yBCWxXcJxvDdwZ88kVHO9/AsOBkQSWAlzuPkJMF9ciLEcvAMOIY9wHNgkVgA
26kQmeKcx/9XKVKNbw1eA7Zhl/B2MBmwO7T/Kv2L4Dv+AnPecP6mxw/WGzC+
gu+VnDdy+v1ajc3gP8Cfxh+FH8LPPeuhbynAU8xRD+5WWl2fX5vw+2i/kZDN
9kXOdMh2Is5m0DdGwQvOy/T9JSfvz3wLLgVtn9fcMe9sX+fkLzibT/d8RE0t
8T34orNZdYdxRWqviMWd9dJ9xpzFVItBLCXWU+9/gZc8mz3pv+fUmZY6fw95
62J3NXm2n2awwTMdG1UHZztVjcLkbYj9jYGQ7TANnhHr9Oy9GWc66U5afR1V
T/1TdeAmuneBz/i7wSpfd9W/2Z+hBXzEOrBt8k/ouwV+0vMfPcth/g==
           "]], Polygon3DBox[CompressedData["
1:eJwtUssuQ1EU3ZVz3NuhRCQIiRgb8QPiBzBGwow2SGjN8BG+gIFX4lGPSFq9
7aSEItWO0E/gBxDWyjqDnXPWfp211z5DCyvTyx1mNgJzsJPIbAdnF8BVbDYF
fA6c9WbrabNP2Cliu/AdI94CfkSsDZxBbh64hfgz8BxwDrgJ/AQ8C7wIe8d9
EzW3iB12mg0iXoev4dSDvbYRTxBfg93Bn8A3idgB8vsCruGciVTLHpfg84X8
feT0ABcj1ZyRm1cvcqoAb3hxJSf2yntx/YvV7xX1ZWBLiztnIJ8j9B7G/Q2+
Ns6btHgkYT7WvIZ5lyJpM5oyG4PVvfgwlzNcxOrZDHpxdmp878SR2l/D9kya
U/tVWMlpJxOR3uRbOS8uxbCvopMWP5HeJw/uijXc3bxXryrwi2ln1KMSiQs5
5cJsZeB+J+1LiBdMHFifCfkPoX8CXDXNwFn4R/heN3AB9yzi4ylx+qVeYR/c
MffDP9EI/4F/hRp+4L7lpe13LD61oD13PhA48i9Q016nnVPrf/dncts=
           "]], 
          Polygon3DBox[{{1982, 1387, 1211, 177, 1873}, {2302, 1056, 1055, 
           1233, 2493}, {2542, 1211, 176, 1047, 2231}, {2044, 1482, 1236, 207,
            2045}, {2219, 1043, 1042, 1366, 2541}, {1966, 1040, 1039, 134, 
           1838}, {2299, 1397, 1234, 204, 1884}, {2303, 1407, 1247, 219, 
           1897}, {2304, 1408, 1248, 220, 1898}, {1984, 1398, 1223, 192, 
           1886}, {1980, 1377, 1199, 163, 1860}, {1985, 1399, 1224, 193, 
           1887}, {1983, 1388, 1212, 178, 1874}, {1979, 1046, 1045, 162, 
           1859}}], 
          Polygon3DBox[{{1974, 1366, 1701, 1041, 148, 1848}, {2302, 1406, 
           1246, 218, 1057, 2234}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}}, {
      {GrayLevel[0], 
       Line3DBox[{400, 1, 360, 241, 1708, 16, 1722, 31, 1736, 46, 1749, 61, 
        1763, 76, 1776, 90, 1791, 1792, 105, 1817, 120, 1829, 135, 1840, 149, 
        1850, 164, 1862, 179, 1876, 194, 2043, 301, 416, 208, 398, 320, 1237, 
        209, 1238, 210, 1239, 211, 1240, 212, 1480, 304, 417, 213, 822}], 
       Line3DBox[{1061, 2, 1485, 309, 400}], Line3DBox[{1063, 3, 1061}], 
       Line3DBox[{1065, 4, 1063}], Line3DBox[{1067, 5, 1065}], 
       Line3DBox[{1069, 6, 1067}], Line3DBox[{1071, 7, 1069}], 
       Line3DBox[{1075, 8, 1072, 1071}], Line3DBox[{1077, 9, 1075}], 
       Line3DBox[{1079, 10, 1077}], Line3DBox[{1081, 11, 1079}], 
       Line3DBox[{1083, 12, 1081}], Line3DBox[{1085, 13, 1083}], 
       Line3DBox[{1087, 14, 1085}], Line3DBox[{401, 15, 396, 310, 1087}], 
       Line3DBox[{311, 30, 1999, 243, 401}], Line3DBox[{348, 45, 426, 311}], 
       Line3DBox[{1761, 60, 342, 2006, 249, 858}], 
       Line3DBox[{1774, 75, 402, 1761}], Line3DBox[{1788, 89, 579, 1774}], 
       Line3DBox[{1814, 104, 581, 1788}], Line3DBox[{1827, 119, 1815, 1814}], 
       Line3DBox[{1838, 134, 1037, 1038, 1039, 1040, 2229, 1041, 1701, 1042, 
        1043, 2226, 1044, 1045, 1046, 1703, 2231, 1047, 1048, 1049, 2227, 
        1050, 1704, 1051, 1052, 1053, 2228, 1054, 1705, 1055, 1056, 2234, 
        1057, 1059, 1706, 1025, 1245, 218, 1246, 219, 1247, 220, 1248, 221, 
        1484, 308, 418, 222, 399, 321, 1900, 207, 1887, 193, 1874, 178, 1860, 
        163, 1848, 148, 1838}], 
       Line3DBox[{306, 214, 1241, 1242, 215, 1243, 216, 1244, 217, 1058, 1700,
         1035, 1024, 2225, 1036, 1023, 1699, 1034, 2233, 1022, 1032, 1021, 
        1698, 1033, 2232, 1020, 1030, 1019, 2334, 1697, 1031, 1018, 1028, 
        2230, 1017, 1029, 1702, 1016, 2224, 1027, 1015, 1026, 1014, 1827}], 
       Line3DBox[{306, 511, 746}], Line3DBox[{348, 650}]}, {}, 
      {GrayLevel[0.2], 
       Line3DBox[{1708, 1997, 1249, 1707, 2335, 1901, 1709, 2336, 1902, 1710, 
        2337, 1903, 1711, 2338, 1904, 1712, 2339, 1905, 1713, 2340, 2235, 
        2423, 1714, 2341, 1906, 1715, 2342, 1907, 1716, 2343, 1908, 1717, 
        2344, 1909, 1718, 2345, 1910, 1719, 2346, 1911, 1720, 2500, 1998, 
        1912, 1999}], 
       Line3DBox[{1722, 2236, 2424, 1721, 1264, 1723, 2347, 1913, 1724, 2348, 
        1914, 1725, 2349, 1915, 1726, 2350, 1916, 1727, 2351, 2237, 2425, 
        1728, 2238, 2426, 1729, 2352, 1917, 1730, 2353, 1918, 1731, 2354, 
        1919, 1732, 2355, 1920, 1733, 2356, 1921, 1734, 2501, 2000, 2001, 397,
         426}], Line3DBox[{1736, 2239, 2427, 1735, 2240, 2428, 1737, 1279, 
        1738, 2357, 1922, 1739, 2358, 1923, 1740, 2359, 1924, 1741, 2360, 
        2241, 2429, 1742, 2242, 2430, 1743, 2243, 2431, 1744, 1287, 1745, 
        2361, 1925, 1746, 2362, 1926, 1747, 2502, 2002, 2004, 1927, 2003, 
        2503, 2063, 1986, 2064, 2121, 2122, 2210}], 
       Line3DBox[{1749, 2244, 2432, 1748, 2245, 2433, 1750, 2246, 2434, 1751, 
        1293, 1752, 2363, 1928, 1753, 2364, 1929, 1754, 2365, 2247, 2435, 
        1755, 2248, 2436, 1756, 2249, 2437, 1757, 2250, 2438, 1758, 1301, 
        1759, 2504, 2007, 2008, 1760, 2496, 1987, 2005, 1988, 2065, 2059, 
        2060, 2319, 2330}], 
       Line3DBox[{1761, 2080, 1990, 2087, 1989, 2111, 2066, 2192, 2212}], 
       Line3DBox[{1763, 2251, 2439, 1762, 2252, 2440, 1764, 2253, 2441, 1765, 
        2254, 2442, 1766, 1306, 1767, 2366, 1930, 1768, 2367, 2255, 2443, 
        1769, 2256, 2444, 1770, 2257, 2445, 1771, 2258, 2446, 1772, 2316, 
        2447, 2106, 1773, 2107, 1436, 2081, 2011, 2093, 2082, 2083, 2309, 
        2497, 2113, 2126, 2127, 2180, 2218}], 
       Line3DBox[{1774, 2010, 2046, 2009, 2133, 2530, 2134, 2143, 2055, 2135, 
        2136, 2137, 2179, 2199}], 
       Line3DBox[{1776, 2259, 2448, 1775, 2260, 2449, 1777, 2261, 2450, 1778, 
        2262, 2451, 1779, 2263, 2452, 1780, 2368, 1931, 1781, 2369, 2264, 
        2453, 1782, 2265, 2454, 1783, 2266, 2455, 1784, 2161, 2456, 2323, 
        1785, 2162, 2163, 2535, 2146, 2148, 2147, 1786, 2138, 2139, 2531, 
        2012, 2195}], 
       Line3DBox[{1788, 2159, 2160, 2154, 2153, 2534, 1787, 2013, 2047, 2115, 
        2119, 2114, 2527, 2181, 2207}], 
       Line3DBox[{1792, 2370, 1932, 1790, 2371, 1933, 1794, 2372, 1934, 1796, 
        2373, 1935, 1798, 2374, 1936, 1800, 2375, 1937, 1802, 2377, 2378, 
        1938, 1804, 2379, 1939, 1806, 2380, 1940, 1808, 2017, 2019, 2507, 
        1941, 2018, 2067, 2068, 2200}], 
       Line3DBox[{1814, 1945, 2382, 1812, 2094, 2103, 2104, 2523, 2315, 1811, 
        2096, 2097, 2015, 2310, 2506, 2187, 2204}], 
       Line3DBox[{1817, 2276, 2467, 1816, 2384, 1947, 1818, 2385, 1948, 1819, 
        2386, 1949, 1820, 2387, 1950, 1821, 2388, 1951, 1822, 2389, 2277, 
        2468, 1823, 2390, 1952, 1824, 2020, 2085, 2520, 1953, 2021, 2071, 
        2073, 2072, 2022, 2518, 2053, 2185, 2202}], 
       Line3DBox[{1827, 2220, 2394, 1826, 1956, 2393, 1825, 1955, 2173, 2392, 
        2307, 2048, 1954, 2049, 2391, 2070, 2144, 2069, 2186, 2201}], 
       Line3DBox[{1829, 2278, 2469, 1828, 2395, 1957, 1830, 2396, 1958, 1831, 
        2397, 1959, 1832, 2398, 1960, 1833, 2399, 1961, 1834, 2400, 2279, 
        2470, 1835, 2108, 2149, 2280, 2525, 2109, 2023, 2024, 2519, 2074, 
        2183, 2075, 2189, 2206}], 
       Line3DBox[{1840, 2281, 2471, 1839, 2282, 2472, 1841, 2405, 1967, 1842, 
        2406, 1968, 1843, 2407, 1969, 1844, 2408, 1970, 1845, 2538, 2168, 
        2283, 2537, 2169, 2027, 2029, 2145, 2156, 2508, 2321, 2028, 559, 2141,
         537, 2214}], 
       Line3DBox[{1850, 2284, 2473, 1849, 2285, 2474, 1851, 2286, 2475, 1852, 
        2411, 1975, 1853, 2412, 1976, 1854, 2413, 1977, 1855, 2510, 2031, 
        2033, 2287, 2509, 2032, 2076, 1991, 2077, 2123, 2124, 2058, 2193, 
        2215}], Line3DBox[{1862, 2289, 2476, 1861, 2290, 2477, 1863, 2291, 
        2478, 1864, 2292, 2479, 1865, 2417, 1981, 1866, 2511, 2036, 2037, 
        1867, 2499, 1993, 2034, 1994, 2079, 2061, 2512, 2062, 2131, 2191, 
        2132, 2213}], 
       Line3DBox[{1876, 2294, 2481, 1875, 2295, 2482, 1877, 2296, 2483, 1878, 
        2297, 2484, 1879, 2317, 2485, 2110, 1880, 2526, 452, 2086, 414, 415, 
        1531, 339, 2197}], Line3DBox[{2006, 2128, 2190, 2129, 2196}], 
       Line3DBox[{2043, 2042, 1476, 1888, 2300, 2489, 1889, 2301, 2490, 1890, 
        2328, 2491, 2171, 1891, 2172, 2533, 2329, 2150, 2152, 2151, 1892, 
        2320, 2514, 2142, 2040, 2184, 2198}], 
       Line3DBox[{2194, 2050, 2532, 2140, 1962, 2025, 2308, 2401, 2155, 2165, 
        1963, 2164, 2324, 2402, 2174, 1964, 1836, 2403, 1965, 1837, 2404, 
        2224}], Line3DBox[{2203, 2125, 2188, 2084, 1942, 2116, 2089, 2521, 
        2312, 2088, 2100, 1943, 2095, 2313, 2381, 1944, 1813, 2383, 1946, 
        1815}], Line3DBox[{2205, 1810, 2056, 2057, 2014, 2505, 2305, 1809, 
        2306, 2466, 2016, 1807, 2465, 2275, 1805, 2464, 2274, 1803, 2463, 
        2273, 2376, 1801, 2462, 2272, 1799, 2461, 2271, 1797, 2460, 2270, 
        1795, 2459, 2269, 1793, 2458, 2268, 1789, 2457, 2267, 1791}], 
       Line3DBox[{2208, 2182, 2318, 2528, 2120, 2118, 2052, 2041, 2515, 1893, 
        2157, 2158, 2170, 2540, 2327, 1894, 2177, 2178, 2176, 2492, 2326, 
        1895, 2333, 2545, 1896, 2225}], 
       Line3DBox[{2209, 2130, 2035, 2091, 2092, 1992, 2102, 2314, 2498, 2101, 
        2099, 2098, 2288, 2522, 1856, 2414, 1978, 1857, 2415, 2222, 1858, 
        2334}], Line3DBox[{2211, 2112, 1995, 2078, 1996, 2517, 2311, 1868, 
        2038, 2090, 2039, 2513, 1869, 2293, 2480, 1870, 2331, 2543, 1871, 
        2418, 2223, 2232}], 
       Line3DBox[{2216, 475, 2529, 2117, 2054, 2030, 2026, 2105, 2524, 1971, 
        1846, 2322, 2409, 1972, 2167, 2536, 2166, 1973, 1847, 2410, 2221, 
        2230}], 
       Line3DBox[{2217, 340, 1587, 524, 523, 2051, 605, 2539, 1881, 611, 2175,
         2486, 2325, 1882, 2298, 2487, 1883, 2332, 2544, 2233}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1061, 1250, 2335, 1062, 1264, 1090, 2428, 1278, 1104, 2433, 
        1291, 1117, 2440, 1303, 1129, 2449, 1314, 1140, 2458, 1325, 2371, 
        1152, 1337, 2384, 1165, 1348, 2395, 1176, 2472, 1358, 1187, 2474, 
        1368, 1201, 2477, 1379, 1214, 2482, 1390, 1226, 2489, 1401, 1238}], 
       Line3DBox[{1063, 1251, 2336, 1064, 1265, 2347, 1091, 1279, 1105, 2434, 
        1292, 1118, 2441, 1304, 1130, 2450, 1315, 1141, 2459, 1326, 2372, 
        1153, 1338, 2385, 1166, 1349, 2396, 1177, 1359, 2405, 1188, 2475, 
        1369, 1202, 2478, 1380, 1215, 2483, 1391, 1227, 2490, 1402, 1239}], 
       Line3DBox[{1065, 1252, 2337, 1066, 1266, 2348, 1092, 1280, 2357, 1106, 
        1293, 1119, 2442, 1305, 1131, 2451, 1316, 1142, 2460, 1327, 2373, 
        1154, 1339, 2386, 1167, 1350, 2397, 1178, 1360, 2406, 1189, 1370, 
        2411, 1203, 2479, 1381, 1216, 2484, 1392, 1228, 2491, 1641, 1642, 
        1240}], Line3DBox[{1067, 1253, 2338, 1068, 1267, 2349, 1093, 1281, 
        2358, 1107, 1294, 2363, 1120, 1306, 1132, 2452, 1317, 1143, 2461, 
        1328, 2374, 1155, 1340, 2387, 1168, 1351, 2398, 1179, 1361, 2407, 
        1190, 1371, 2412, 1204, 1382, 2417, 1217, 2485, 1554, 1555, 1612, 
        2533, 1644, 1477, 1643, 1478, 1480}], 
       Line3DBox[{1069, 1254, 2339, 1070, 1268, 2350, 1094, 1282, 2359, 1108, 
        1295, 2364, 1121, 1307, 2366, 1133, 1318, 2368, 1144, 2462, 1329, 
        2375, 1156, 1341, 2388, 1169, 1352, 2399, 1180, 1362, 2408, 1191, 
        1372, 2413, 1205, 1465, 2511, 1466, 1530, 1557, 2526, 1558, 1556, 
        1470, 1472, 2514, 1597, 1613, 1598, 1479, 1607, 1501, 1604, 1500, 
        1670}], Line3DBox[{1071, 1255, 2340, 1073, 1269, 2351, 1095, 1283, 
        2360, 1109, 1296, 2365, 1122, 1308, 2367, 1134, 1319, 2369, 1145, 
        1330, 2376, 2377, 1157, 1342, 2389, 1170, 1353, 2400, 1181, 1630, 
        2538, 1632, 1192, 1460, 2510, 1462, 1464, 1421, 2499, 1467, 1525, 
        1524, 1526, 1498, 1531, 1499, 1471, 1573, 1574, 1667}], 
       Line3DBox[{1075, 1257, 2341, 1076, 2426, 1271, 1097, 2430, 1285, 1111, 
        2436, 1298, 1124, 2444, 1310, 1136, 2454, 1321, 1147, 2464, 1332, 
        2379, 1159, 1344, 2390, 1172, 1552, 1553, 2525, 1355, 1183, 1609, 
        1611, 1610, 1459, 2508, 1605, 1606, 1364, 1194, 1496, 1660, 1497, 
        1572, 1671}], 
       Line3DBox[{1077, 1258, 2342, 1078, 1272, 2352, 1098, 2431, 1286, 1112, 
        2437, 1299, 1125, 2445, 1311, 1137, 2455, 1322, 1148, 2465, 1333, 
        2380, 1160, 1450, 1451, 1345, 2520, 1173, 1529, 1456, 1535, 1522, 
        2519, 1523, 1655, 1669}], 
       Line3DBox[{1079, 1259, 2343, 1080, 1273, 2353, 1099, 1287, 1113, 2438, 
        1300, 1126, 2446, 1312, 1138, 2456, 1620, 1621, 1323, 1149, 2466, 
        1447, 1448, 1334, 2507, 1161, 1503, 1416, 1519, 1489, 1521, 2518, 
        1490, 1659, 1672}], 
       Line3DBox[{1081, 1260, 2344, 1082, 1274, 2354, 1100, 1288, 2361, 1114, 
        1301, 1127, 2447, 1548, 1549, 1608, 1623, 2535, 1442, 1622, 1443, 
        1444, 2505, 1412, 1449, 1413, 1516, 1666}], 
       Line3DBox[{1083, 1261, 2345, 1084, 1275, 2355, 1101, 1289, 2362, 1115, 
        1432, 2504, 1433, 1527, 1551, 1436, 1550, 1437, 1439, 1590, 2531, 
        1411, 1591, 531, 1654, 1682}], 
       Line3DBox[{1085, 1262, 2346, 1086, 1276, 2356, 1102, 1428, 2502, 1429, 
        1431, 1410, 2496, 1434, 1514, 1513, 1515, 1493, 1528, 1494, 2497, 
        1438, 1571, 681}], 
       Line3DBox[{1087, 1423, 2500, 1424, 1088, 1425, 2501, 1426, 1427, 1409, 
        1430, 1510, 2503, 1509, 1511, 1657, 1502, 1580, 1579, 1676}], 
       Line3DBox[{1237, 1400, 1476, 1225, 1389, 2481, 1213, 1378, 2476, 1200, 
        1367, 2473, 1186, 1357, 2471, 1175, 1347, 2469, 1164, 1336, 2467, 
        1151, 2370, 1324, 2457, 1139, 1313, 2448, 1128, 1302, 2439, 1116, 
        1290, 2432, 1103, 1277, 2427, 1089, 1263, 2424, 1060, 1249, 1422, 
        1485}], Line3DBox[{1242, 1403, 2515, 1474, 1229, 1393, 1596, 1473, 
        1599, 1600, 1587, 1589, 1588, 1218, 1383, 1673}], 
       Line3DBox[{1243, 1404, 1638, 1640, 1639, 2540, 1230, 1394, 1636, 1635, 
        1646, 2539, 1645, 1219, 1384, 1488, 2517, 1505, 1504, 1207, 1374, 
        1565, 1656, 1665, 1582, 1680}], 
       Line3DBox[{1244, 1405, 1637, 2492, 1231, 1395, 1634, 2486, 1220, 1385, 
        2513, 1469, 1208, 1543, 1544, 1542, 2498, 1539, 1420, 1564, 1540, 
        1195, 1492, 1658, 1491, 2529, 1570, 1652, 1563, 1668}], 
       Line3DBox[{695, 1662, 1568, 1560, 2527, 1577, 1561, 1445, 1441, 1545, 
        2523, 1546, 1547, 1537, 1536, 2381, 1162, 1346, 2393, 1174, 1356, 
        2403, 1185, 1690, 2410, 1685, 1692, 1697}], 
       Line3DBox[{1674, 1446, 2506, 1495, 1562, 1414, 1534, 1415, 1541, 1533, 
        2521, 1532, 1452, 1486, 1453, 2392, 1647, 1648, 1624, 1626, 1625, 
        2402, 1649, 1650, 1627, 1629, 2536, 1628, 1198, 1691, 2415, 1686, 
        1694, 2418, 1698}], 
       Line3DBox[{1675, 1569, 2528, 1566, 1578, 1567, 1481, 1475, 1241}], 
       Line3DBox[{1677, 1581, 1664, 1517, 1559, 1417, 1520, 1418, 2391, 1518, 
        1487, 1586, 1454, 1457, 1455, 2401, 1619, 1617, 1618, 2409, 1197, 
        1376, 2414, 1210, 2543, 1693, 1687, 2544, 1695, 1699}], 
       Line3DBox[{1678, 1583, 1468, 1507, 2512, 1508, 1506, 1206, 1373, 2509, 
        1463, 1461, 1193, 1363, 2537, 1633, 1631, 1182, 1354, 2470, 1171, 
        1343, 2468, 1158, 2378, 1331, 2463, 1146, 1320, 2453, 1135, 1309, 
        2443, 1123, 1297, 2435, 1110, 1284, 2429, 1096, 1270, 2425, 1074, 
        1256, 2423, 1072}], 
       Line3DBox[{1679, 1575, 1663, 1576, 1661, 1512, 1601, 1602, 1603, 1585, 
        2530, 1584, 1440, 1435, 1616, 1614, 2534, 1615, 1150, 1335, 2382, 
        2383, 1163, 1688, 2394, 1683, 1689, 2404, 1684, 1702}], 
       Line3DBox[{1681, 1653, 1595, 1651, 1419, 1594, 1592, 2532, 1593, 1184, 
        1458, 1365, 2524, 1196, 1538, 2522, 1375, 1209, 2480, 1386, 1221, 
        2487, 1396, 1232, 2545, 1696, 1700}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJztXXl0zdf2j0ZRKjWrRlMJMZYqEmquIoaK1PSU11ItD61SUweKtqgxaqwY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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{348.93790844492156`, 150.023941871316},
  ImageSizeRaw->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {-1.3659865511680809`, 0.7397520654621298}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.496385700127685, -3.0117366492210644`, 0.3745292941707733},
  ViewVertical->{-0.04924935211864222, 0.09912289238894145, 
   0.9938557005523209}]], "Output",
 CellChangeTimes->{{3.9157787759750843`*^9, 3.9157787901264477`*^9}, 
   3.915779821366249*^9, 3.915852526417608*^9, 3.9258163298453255`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"32484f48-bd03-fe43-9769-b01e80958662"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"relu", "[", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}], "]"}], "-", 
  RowBox[{"h", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", 
    RowBox[{"-", "1"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9157788061323013`*^9, 3.915778810410204*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"8ad4b02c-55ce-fa47-a71e-b1310624a9a9"],

Cell[BoxData[
 FractionBox["45", "28"]], "Output",
 CellChangeTimes->{3.9157788107864037`*^9, 3.9157798234886446`*^9, 
  3.915852526448868*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"cf5c8b56-19a3-df46-bf5c-4e2639951eb3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"relu", "[", 
    RowBox[{"f", "[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
   RowBox[{"h", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}], "//", "N"}]], "Input",
 CellChangeTimes->{{3.91577881528054*^9, 3.9157788177323666`*^9}, {
  3.9157803123595047`*^9, 3.915780312782395*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"cbd48951-16ee-1b4b-a41e-c27e2acef3f6"],

Cell[BoxData["1.6071428571428572`"], "Output",
 CellChangeTimes->{3.915778818030676*^9, 3.915779824065447*^9, 
  3.915780313015823*^9, 3.915852526448868*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"baa8f63c-299a-0d42-962a-40b8050baca3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "+", 
      RowBox[{"a", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "/", 
   RowBox[{"a", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.915778879676281*^9, 3.9157789367840776`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"3e06cc63-78ea-f44f-b5d6-0f0db24361bd"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", "3"]}]], "Output",
 CellChangeTimes->{{3.915778901789133*^9, 3.915778937084011*^9}, 
   3.91577982456991*^9, 3.915852526480652*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"4d9a9e3b-ca58-1e42-9c9d-b68d092b8300"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"relu", "[", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "x"}], "]"}], "]"}], "-", 
  RowBox[{"h", "[", 
   RowBox[{"1", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9157789039096804`*^9, 3.915778908295208*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"2026dd16-a757-9148-9c5e-9fb06e9ad810"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["45", "28"]}]], "Output",
 CellChangeTimes->{{3.915778908735588*^9, 3.915778937761032*^9}, 
   3.9157798251662827`*^9, 3.9158525264880238`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"39883760-6a4d-e549-a1e3-4883591feccc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"t", ",", "s"}], "]"}], "//", "N"}], "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.915780265431322*^9, 3.915780276548567*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"0e7b4cd0-4bbb-c14f-b1cf-a2ea7c3c87fd"],

Cell[BoxData[
 RowBox[{"0.8928571428571429`", "\[VeryThinSpace]", "+", 
  RowBox[{"1.0714285714285714`", " ", "s"}], "+", 
  RowBox[{"1.4285714285714286`", " ", "t"}]}]], "Output",
 CellChangeTimes->{{3.9157802684771237`*^9, 3.915780277060861*^9}, 
   3.915852526496557*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"58f73d1b-1027-354b-b83f-7eaf82e89f1e"]
}, Open  ]]
},
WindowSize->{1908, 999.75},
WindowMargins->{{-1920, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6dbc9860-cd89-7f47-92ba-fbc5b6fd04bf"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 352, 8, 28, "Input",ExpressionUUID->"cf053ff2-817a-484c-963d-f130e2bd0d68"],
Cell[913, 30, 305, 7, 43, "Input",ExpressionUUID->"5c2e3a53-edda-ea41-a39f-05f00495a98f"],
Cell[1221, 39, 538, 15, 28, "Input",ExpressionUUID->"b4aa38f3-10e8-d540-82c9-a73544e5a8fa"],
Cell[CellGroupData[{
Cell[1784, 58, 648, 18, 43, "Input",ExpressionUUID->"1cce3096-0e19-ae4a-ae3b-a7215f973478"],
Cell[2435, 78, 86207, 1394, 201, "Output",ExpressionUUID->"d1335857-f34e-e248-87c1-7ac8e3c7ede3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88679, 1477, 405, 10, 43, "Input",ExpressionUUID->"c4bcae3e-c77e-e64e-9ed5-895de3c8db23"],
Cell[89087, 1489, 247, 4, 32, "Output",ExpressionUUID->"a3e23f2f-1cac-f84d-864d-b98c3a156d0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89371, 1498, 221, 4, 28, "Input",ExpressionUUID->"8b6b6852-d85d-464d-b4c6-8fbe9d377436"],
Cell[89595, 1504, 239, 4, 32, "Output",ExpressionUUID->"739c232f-167a-3c45-962f-ab5aa06f9b04"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89871, 1513, 282, 6, 28, "Input",ExpressionUUID->"4aa6fa1d-4438-274f-b1cb-2ee4a1d3b761"],
Cell[90156, 1521, 271, 4, 32, "Output",ExpressionUUID->"9ac6e441-e080-e349-b262-4c59b6630ea5"]
}, Open  ]],
Cell[90442, 1528, 506, 11, 28, "Input",ExpressionUUID->"79382ef7-c92f-454d-b758-90c97aa96267"],
Cell[90951, 1541, 525, 15, 28, "Input",ExpressionUUID->"901f65e6-0759-e147-8193-091ccb4b26fd"],
Cell[CellGroupData[{
Cell[91501, 1560, 855, 23, 43, "Input",ExpressionUUID->"9a58861d-cce7-f748-a5a4-2226439acdcc"],
Cell[92359, 1585, 111463, 1800, 277, "Output",ExpressionUUID->"669b1e29-d748-ed4b-ab42-900718c87197"]
}, Open  ]],
Cell[CellGroupData[{
Cell[203859, 3390, 425, 10, 43, "Input",ExpressionUUID->"7c24f9cc-d083-2f4b-82de-a4c415016d24"],
Cell[204287, 3402, 268, 3, 32, "Output",ExpressionUUID->"fb00aae0-b4fc-b94f-86cc-58ecc3872307"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204592, 3410, 415, 12, 28, "Input",ExpressionUUID->"42c7ee89-4eb7-6944-bc2e-fd00928c5ec3"],
Cell[205010, 3424, 189, 4, 48, "Output",ExpressionUUID->"06cb79d7-cad8-6b48-ae75-8b7120d0ca20"]
}, Open  ]],
Cell[CellGroupData[{
Cell[205236, 3433, 333, 8, 28, "Input",ExpressionUUID->"1dcdeaa5-8dc8-3040-be58-64649ed4b1e7"],
Cell[205572, 3443, 171, 3, 71, "Output",ExpressionUUID->"1c6ba8c5-80ea-d942-8f5b-05777e0a8329"]
}, Open  ]],
Cell[205758, 3449, 580, 14, 28, "Input",ExpressionUUID->"f236c92d-2db0-2141-8c4c-61088b4c01be"],
Cell[CellGroupData[{
Cell[206363, 3467, 746, 22, 43, "Input",ExpressionUUID->"eecfdc7a-6878-e147-a03b-368943a8e7f0"],
Cell[207112, 3491, 111035, 1793, 240, "Output",ExpressionUUID->"a6b82433-3d1e-e642-960a-f741df3be737"]
}, Open  ]],
Cell[CellGroupData[{
Cell[318184, 5289, 697, 20, 43, "Input",ExpressionUUID->"5ea85b07-6db7-f24e-bfe3-ce1485bd210d"],
Cell[318884, 5311, 85064, 1386, 167, "Output",ExpressionUUID->"32484f48-bd03-fe43-9769-b01e80958662"]
}, Open  ]],
Cell[CellGroupData[{
Cell[403985, 6702, 415, 12, 28, "Input",ExpressionUUID->"8ad4b02c-55ce-fa47-a71e-b1310624a9a9"],
Cell[404403, 6716, 222, 4, 48, "Output",ExpressionUUID->"cf5c8b56-19a3-df46-bf5c-4e2639951eb3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[404662, 6725, 412, 10, 43, "Input",ExpressionUUID->"cbd48951-16ee-1b4b-a41e-c27e2acef3f6"],
Cell[405077, 6737, 236, 3, 32, "Output",ExpressionUUID->"baa8f63c-299a-0d42-962a-40b8050baca3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[405350, 6745, 473, 13, 28, "Input",ExpressionUUID->"3e06cc63-78ea-f44f-b5d6-0f0db24361bd"],
Cell[405826, 6760, 258, 5, 48, "Output",ExpressionUUID->"4d9a9e3b-ca58-1e42-9c9d-b68d092b8300"]
}, Open  ]],
Cell[CellGroupData[{
Cell[406121, 6770, 333, 8, 28, "Input",ExpressionUUID->"2026dd16-a757-9148-9c5e-9fb06e9ad810"],
Cell[406457, 6780, 265, 5, 48, "Output",ExpressionUUID->"39883760-6a4d-e549-a1e3-4883591feccc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[406759, 6790, 278, 6, 43, "Input",ExpressionUUID->"0e7b4cd0-4bbb-c14f-b1cf-a2ea7c3c87fd"],
Cell[407040, 6798, 353, 6, 32, "Output",ExpressionUUID->"58f73d1b-1027-354b-b83f-7eaf82e89f1e"]
}, Open  ]]
}
]
*)

