# -*- coding:utf-8 -*-

"""
agent calling methods
"""

import requests
import json
import uuid
import time
import numpy as np
import pandas as pd
from agents.service_utils import *
from agents.rody_calling_mock import *
from agents.expert_calling_mock import *

# Initialize the object for API calls
api_calling_object = MockAPIHandler()
expert_calling_object = MockExpertHandler()


def api_calling(model_name, api_name, query, history, parameters):
    if not isinstance(parameters, dict):
        try:
            parameters = eval(parameters)
        except Exception as e:
            parameters = {}
    if model_name == 'expert':
        if api_name == 'tool_summary':
            results = expert_calling_object.call_summary(query, history, parameters)
        else:
            results = 'Tools not found'
    else:
        data = dict()
        data['api_name'] = api_name
        data['parameter'] = parameters
        if model_name == 'rody':
            results = api_calling_object.call_api(query, data)
        elif model_name == 'toolbench':
            results = api_calling_object.call_api_common(data)
        else:
            results = 'Api_calling method not found'
    return results
