import random
import json
import pandas as pd
from agents.service_utils import *

class MockExpertHandler:
    def __init__(self):
        # Defining error types
        self.fail_calling_type = {404: 'Retrievals not found',
                                  500: 'The history format is invalid.',
                                  501: 'Conversation length error!Not calling tool_retrievals!',
                                  400: 'The retrievals format is invalid.',}
        self.rejected_return = "Sorry, I'm still learning and can't answer your question at the moment."

    def split_retrieval_strings(self, text):
        pattern = r'\[([^\]]+)\]\s*(.*)'
        match = re.search(pattern, text, re.DOTALL)
        if match:
            result = [match.group(1), match.group(2)]
            return result
        else:
            return ['Rules of Corporation_A', text]

    def build_retrieval_markdown(self, retrieval):
        if len(retrieval) < 1:
            return 'None'
        retrieval = [self.split_retrieval_strings(i) for i in retrieval]
        retrieval_df = pd.DataFrame(retrieval, columns=['knowledge_areas', 'knowledge_content'])
        unique_fields = retrieval_df['knowledge_areas'].unique()
        markdown = ""
        for field in unique_fields:
            markdown += f"**{field}：**\n\n"
            contents = retrieval_df[retrieval_df['knowledge_areas'] == field]['knowledge_content'].tolist()
            for j, content in enumerate(contents, start=1):
                markdown += f"{j}. {content}\n"
            markdown += "\n"
        return markdown.strip()

    def tool_summary_calling(self, query, retrieval=[], context_history=[], call_max_times=3):
        context = list()
        # make history format
        for i in range(len(context_history)):
            q, a = context_history[i]
            context.append({'role': 'user', 'content': q})
            context.append({'role': 'assistant', 'content': a})

        retrieval_format = self.build_retrieval_markdown(retrieval)
        current_user = USER.replace('{current_query}', query).replace('{retrievals}', retrieval_format)
        times = 0
        while times < call_max_times:
            try:
                response = llm_qwen32b(current_user, SYSTEM)
                return response
            except Exception as e:
                times += 1
                print(e)
                if times < call_max_times:
                    print(f'Calling tool_summary failed!Currnt round is {times}/{call_max_times}.')
                    time.sleep(1.5)
                else:
                    print("Retry limit exceeded, calling tool_summary failed!")
                    return 'Calling tool_summary failed!'

    def call_summary(self, query, history, parameters):
        """
        Main function, simulate call_summary calling
        """
        valid_status_code, retrievals = self._validate_params(history)

        if retrievals is None:
            if valid_status_code != 200:
                return self.fail_calling_type[valid_status_code]
            else:
                response = llm_qwen32b(query)
        else:
           response = self.tool_summary_calling(query, retrievals)

        return response

    def _validate_params(self, history):
        # 1.Check if there are any format problems or insufficient length (at least system, [[usr, assistant-tool_retrievals], [retrievals, assistant-tool_summary]])
        if not isinstance(history, list):
            return 500, None
        if len(history) < 2:
            return 200, None
        # if len(history) < 2:
        #     return 501, None

        # 2.If the length is sufficient, check whether there are retrievals
        if history[-2][1].find('tool_retrievals') >= 0:
            retrievals = history[-1][0].strip('<tool_response>').strip('</tool_response>')
            try:
                ## Check if retrievals is in list format
                retrievals = eval(retrievals)
                if isinstance(retrievals, list):
                    return 200, retrievals
                else:
                    return 200, [retrievals]
            except SyntaxError:
                return 200, [retrievals]
        else:
            return 200, None
