import requests
import json

check_order_report = {
    "name": "check_order_report",
    "description": 'Order reservation tool.',
    "parameters": {
        "type": "object",
        "properties": {
            "order_id": {
                "description": '',
            },
            "order_code": {
                "description": 'Order code, a group of order numbers obtained through order query tool, which are multi-digit numbers.'
            },
        },
        "required": []
    },
    "mock_response":{
        "success_responses": "Your order reporting has been successfully completed.",
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

check_deposit_refund = {
    "name": "check_deposit_refund",
    "description": 'Deposit Refund Tool. Handle the refund process.',
    "parameters": {},
    "mock_response": {
        "success_responses": 'The relevant surrender status has been queried for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

check_shop_expenses = {
    "name": "check_shop_expenses",
    "description": "Handle the problems of the cost structure and the charge proportion of the store operation.",
    "parameters": {
        "type": "object",
        "properties": {
            "keyword": {
                "description": 'Main categories, product names, types and brands of the store.',
            },
            "shop_body": {
                "description": '',
            },
            "shop_type": {
                "description": "",
            }
        },
        "required": ['keyword']
    },
    "mock_response": {
        "success_responses": 'The relevant operating fees have been queried for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

check_shop_qualifications = {
    "name": "check_shop_qualifications",
    "description": 'Handle various certificates, business licenses, industry qualifications, uploading materials and other qualification conditions in the process of opening a store.',
    "parameters": {
        "type": "object",
        "properties": {
            "keyword": {
                "description": 'Main categories, product names, types and brands of the store.',
            },
            "shop_body": {
                "description": '',
            },
            "shop_type": {
                "description": "",
            }
        },
        "required": ['keyword']
    },
    "mock_response": {
        "success_responses": 'The relevant business qualifications have been queried for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

agent_user_growth = {
    "name": "agent_user_growth",
    "description": "Handle the problems related to the growth of store users.",
    "parameters": {
        "type": "object",
        "properties": {
            "query": {
                "description": "Rewrite the questions from the merchants, according to the context of the conversation.",
            }
        },
        "required": ['query']
    },
    "mock_response": {
        "success_responses": 'Relevant user growth information has been retrieved for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

search_order_code = {
    "name": "search_order_code",
    "description": "Query the order details according to the information provided by the userd. The parameter search_keys is the query target, and other parameters are the query conditions.",
    "parameters": {
        "type": "object",
        "properties": {
            "order_id": {
                "description": ""
            },
            "consumer_name": {
                "description": "Customer Name, User Name, Buyer Name, Recipient, Consignee, Customer, Client, etc."
            },
            "user_pin": {
                "description": ""
            },
            "sku_id": {
                "description": ""
            },
            "sku_name": {
                "description": "",
            },
            "consumer_mobile_phone": {
                "description": ""
            },
            "time_context": {
                "description": "Order time, can be a year, month, week or specific to every day of the moment, such as last month, this weekend, yesterday, this afternoon at two o'clock, etc."
            },
            "logi_no": {
                "description": "Logistics number, express waybill."
            },
            "item_num": {
                "description": "Product No."
            },
            "service_id": {
                "description": "After-sales service number."
            },
            "province_name": {
                "description": "The province of the delivery address."
            },
            "order_service_mix_tag": {
                "description": "Order labels and status."
            },
            "payment_type": {
                "description": "Order payment method."
            },
            "service_user_expectation": {
                "description": "Customer's expectation of after-sale service.",
            },
            "search_keys": {
                "description": "The target of user's query."
            }
        },
        "required": ["search_keys"]
    },
    "mock_response": {
        "success_responses": 'We have retrieved the relevant order information for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

search_service_code = {
    "name": "search_service_code",
    "description": "Query the details of after-sale service order.",
    "parameters": {
        "type": "object",
        "properties": {
            "order_id": {
                "description": ""
            },
            "order_code": {
                "description": 'Order code, a group of order numbers obtained through order query tool, which are multi-digit numbers.'
            },
            "service_id": {
                "description": "After-sales service number."
            },
            "search_keys": {
                "description": "The target of user's inquiry.",
            }
        },
        "required": []
    },
    "mock_response": {
        "success_responses": 'We have retrieved the relevant service order information for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

search_promotion = {
    "name": "search_promotion",
    "description": "Query promotion details and the products included in the promotion according to the promotion information provided by users.",
    "parameters": {
        "type": "object",
        "properties": {
            "promotion_id": {
                "description": ""
            },
            "sku_id": {
                "description": ""
            },
            "promotion_name": {
                "description": ""
            },
            "promotion_type": {
                "description": ""
            },
            "promotion_status": {
                "description": ""
            },
            "promotion_start_time": {
                "description": "Promotion start time."
            },
            "promotion_end_time": {
                "description": "Promotion end time."
            },
            "search_keys": {
                "description": "The target of user's query, which can only be one of [commodity, promotion].",
                "enum": ["commodity", "promotion"]
            }
        },
        "required": []
    },
    "mock_response": {
        "success_responses": 'We have found the promotion corresponding to your status.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

search_coupon = {
    "name": "search_coupon",
    "description": "Query coupon details and the products included in the coupon according to the coupon information provided by the user.",
    "parameters": {
        "type": "object",
        "properties": {
            "coupon_id": {
                "description": ""
            },
            "sku_id": {
                "description": ""
            },
            "coupon_name": {
                "description": ""
            },
            "coupon_type": {
                "description": ""
            },
            "coupon_status": {
                "description": ""
            },
            "coupon_start_time": {
                "description": "Coupon effective start time."
            },
            "coupon_end_time": {
                "description": "Coupon expiration time."
            },
            "search_keys": {
                "description": "The target of user's query, which can only be one of [commodity, coupon].",
                "enum": ["commodity", "coupon"]
            }
        },
        "required": []
    },
    "mock_response": {
        "success_responses": 'The coupon corresponding to your status has been queried.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

check_audit_status = {
    "name": "check_audit_status",
    "description": "Query the audit status and reason of the product, and urge to speed up the audit.",
    "parameters": {
        "type": "object",
        "properties": {
            "product_id": {
                "description": "Sku id, sku number, SPU id, SPU number of pending or urged products.",
            },
            "confirm_push": {
                "description": "Whether to urge to speed up the review.",
                "enum": ["yes", "no"]
            }
        },
        "required": []
    },
    "mock_response": {
        "success_responses": 'The product review has been completed for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

search_binding_card_status = {
    "name": "search_binding_card_status",
    "description": "Query the user's bank card verification status and bank card binding status.",
    "parameters": {
    },
    "mock_response": {
        "success_responses": 'Your bank card details have been retrieved for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

search_payment_method = {
    "name": "search_payment_method",
    "description": "Inquire the settlement method of the user's shop.",
    "parameters": {
    },
    "mock_response": {
        "success_responses": "We have retrieved your store's settlement method.",
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

competitive_goods_analysis = {
    "name": "competitive_goods_analysis",
    "description": "Recommend competitive products according to the products in the store.",
    "parameters": {
    },
    "mock_response": {
        "success_responses": 'The competitive product situation of the store has been queried for you.',
        "error_responses": "Sorry, the API platform query failed, proceeding with downgraded processing.",
    }
}

RODY_TOOL_DICT = {
    'check_order_report': check_order_report,
    'check_deposit_refund': check_deposit_refund,
    'search_order_code': search_order_code,
    'check_shop_expenses': check_shop_expenses,
    'check_shop_qualifications': check_shop_qualifications,
    'agent_user_growth': agent_user_growth,
    'search_service_code': search_service_code,
    'search_promotion': search_promotion,
    'search_coupon': search_coupon,
    'check_audit_status':check_audit_status,
    'search_binding_card_status': search_binding_card_status,
    'search_payment_method': search_payment_method,
    'competitive_goods_analysis': competitive_goods_analysis

}

RODY_TOOL_LIST = list(RODY_TOOL_DICT.keys())

