
import dill, os

class empty():
    pass
class config_sl():
    def __init__(self, config):
        if type(config) == dict:
            self.config_dict = config
        else:
            self.config_dict = self.config_class_to_dict(config)
    def config_class_to_dict(self, config):
        var_dict = [var for var in vars(config) if not '__' in var]
        config_dict = {}
        for var in var_dict:
            value = getattr(config, var)
            config_dict[var] = value
        return config_dict
    def config_dict_to_class(self, config_dict):
        config_temp = empty()
        for key, value in config_dict.items():
            setattr(config_temp, key, value)
        return config_temp
    def save_dict_to_txt(self, config_dict, save_path):
        with open(os.path.join(save_path, 'config.txt'), 'w') as f:
            for key, value in config_dict.items():
                f.write(f'{key} : {value}\n')
    def save_dict_to_dill(self, config_dict, save_path):
        with open(os.path.join(save_path, 'config.dill'), 'wb') as f:
            dill.dump(config_dict, f)
    def load_dill_to_dict(self, path):
        with open(os.path.join(path, 'config.dill'), 'rb') as f:
            config_dict = dill.load(f)
        return config_dict
    def save(self, save_path):
        if not os.path.isdir(save_path):
            os.mkdir(save_path)
        self.save_dict_to_txt(self.config_dict, save_path)
        self.save_dict_to_dill(self.config_dict, save_path)

def save_dict_to_txt(config_dict, save_path):
    with open(os.path.join(save_path, 'config.txt'), 'w') as f:
        for key, value in config_dict.items():
            f.write(f'{key} : {value}\n')
def save_dict_to_dill(config_dict, save_path):
    with open(os.path.join(save_path, 'config.dill'), 'wb') as f:
        dill.dump(config_dict, f)

def save_dict(config_dict, save_path):
    if not os.path.isdir(save_path):
        os.mkdir(save_path)
    save_dict_to_txt(config_dict, save_path)
    save_dict_to_dill(config_dict, save_path)