#ifndef BOTTLENECKCALCULATOR_H
#define BOTTLENECKCALCULATOR_H

#include "Graph_Matching.h"

class BottleneckCalculator
{
public:
    BottleneckCalculator() {}

    template<typename graphType,typename treeController>
    static double bottleneck_distance_exact(graphType & g)
    {
        std::vector<double> sd = g.sorted_distances();
        long lower_bound_i = 0;
        long upper_bound_i = sd.size() - 1;
        const double alpha = std::pow(g.size(), 1. / 5.);
        Graph_Matching<graphType, treeController> m(g);
        Graph_Matching<graphType, treeController> biggest_unperfect(g);
        //  std::cout << "Sd size: " << sd.size() << std::endl;
        //    for (int i = 0; i < sd.size(); i++)
        //    {
        //     std::cout << sd[i] << ", ";
        //  }
        //      std::cout << std::endl;

        while (lower_bound_i != upper_bound_i)
        {

            long step = lower_bound_i + static_cast<long> ((upper_bound_i - lower_bound_i - 1) / alpha);
            //  std::cout << "Current step: " << step << std::endl;
            m.set_r(sd.at(step));
            //   std::cout << "Radius set to : " << sd.at(step) << std::endl;
            while (m.multi_augment()) {}  // compute a maximum matching (in the graph corresponding to the current r)
            if (m.perfect())
            {
                m = biggest_unperfect;
                upper_bound_i = step;
                //     std::cout << "Perfect found!" << std::endl;
                //    std::cout << "Upper bound is now " << upper_bound_i << std::endl;
            }
            else
            {
                biggest_unperfect = m;
                lower_bound_i = step + 1;
                //    std::cout << "UNPERFECT RESULT" << std::endl;
                //   std::cout << "Low bound is now: " << lower_bound_i << std::endl;
            }
        }
        return sd.at(lower_bound_i);
    }
    template<typename graphType,typename treeController>
    static double bottleneck_distance_exact_with_matching(graphType & g, std::vector<int> & matching)
    {
        std::vector<double> sd = g.sorted_distances();
        long lower_bound_i = 0;
        long upper_bound_i = sd.size() - 1;
        const double alpha = std::pow(g.size(), 1. / 5.);
        Graph_Matching<graphType, treeController> m(g);
        Graph_Matching<graphType, treeController> biggest_unperfect(g);
        //  std::cout << "Sd size: " << sd.size() << std::endl;
        //    for (int i = 0; i < sd.size(); i++)
        //    {
        //     std::cout << sd[i] << ", ";
        //  }
        //      std::cout << std::endl;

        while (lower_bound_i != upper_bound_i)
        {

            long step = lower_bound_i + static_cast<long> ((upper_bound_i - lower_bound_i - 1) / alpha);
           //   std::cout << "Current step: " << step << std::endl;
            m.set_r(sd.at(step));
            //   std::cout << "Radius set to : " << sd.at(step) << std::endl;
            while (m.multi_augment()) {}  // compute a maximum matching (in the graph corresponding to the current r)
            if (m.perfect())
            {
                m = biggest_unperfect;
                upper_bound_i = step;
            //       std::cout << "Perfect found!" << std::endl;
            //    std::cout << "Upper bound is now " << upper_bound_i << std::endl;
            }
            else
            {
                biggest_unperfect = m;
                lower_bound_i = step + 1;
               //     std::cout << "UNPERFECT RESULT" << std::endl;
               //   std::cout << "Low bound is now: " << lower_bound_i << std::endl;
            }
        }
        Graph_Matching<graphType, treeController> mm(g);
        mm.set_r(sd.at(lower_bound_i));
        while (mm.multi_augment()) {};
        matching = mm.returnMatching();
        double maxxDist = -1;
        for (int i = 0; i < matching.size(); i++)
        {
            maxxDist = std::max(maxxDist,g.distance(i, matching[i]));

        }
        return sd.at(lower_bound_i);
        //!return maxxDist;
    }



protected:

private:
};

#endif // BOTTLENECKCALCULATOR_H
