#ifndef CUBE_QUERY_H
#define CUBE_QUERY_H

#include "Internal_point.h"

struct Cube_query
{
    typedef CGAL::Dimension_tag<constants::Dim> D;
    typedef Internal_point Point_d;
    typedef double FT;

    bool contains(Point_d p) const
    {
        for (int i = 0 ; i < constants::Dim; i++)
        {
            if (std::abs(p.coord(i) - c.coord(i)) > this->sizze)
            {
                return false;
            }

        }
        return true;

        //! return (std::max)(std::abs(p.x()-c.x()), std::abs(p.y()-c.y())) <= size;
    }

    bool inner_range_intersects(CGAL::Kd_tree_rectangle<FT, D> const&r) const
    {

        double s = this->sizze;
        //std::cout << "Radius is set to: " << s << std::endl;
       // std::cout << "Central point: (" << c.coord(0) << " , " << c.coord(1) << ")" << std::endl;
       // std::cout << "Rectangle: [" << r.min_coord(0) << ", " << r.max_coord(0) << "], [" << r.min_coord(1) << ", " << r.max_coord(1) << "]" << std::endl;
        for (int i = 0 ; i < constants::Dim; i++)
        {
            if ((c.coord(i) - s >= r.max_coord(i)) || (c.coord(i) + s <= r.min_coord(i)))
            {
          //    std::cout << "Inner range intersects negative" << std::endl;
            return false;


            }
        }
      //   std::cout << "Inner range intersects positive" << std::endl;
        return true;

//        return
//            r.max_coord(0) >= c.x() - size &&
//            r.min_coord(0) <= c.x() + size &&
//            r.max_coord(1) >= c.y() - size &&
//            r.min_coord(1) <= c.y() + size;
    }
    bool outer_range_contains(CGAL::Kd_tree_rectangle<FT, D> const&r) const
    {
        double s = this->sizze;
        for (int i = 0 ; i < constants::Dim; i++)
        {
            if ((c.coord(i) + s <= r.max_coord(i)) || (c.coord(i) - s >= r.min_coord(i)))
            {
           // std::cout << "Outer range contains negative" << std::endl;
            return false;
            }
        }
     //  std::cout << "Outer range contains positive" << std::endl;
        return true;


    }

    Point_d c;
    FT sizze;
};

#endif // CUBE_QUERY_H
