#ifndef DATASET_GRAPH_H
#define DATASET_GRAPH_H

#include <cstdlib>
#include <iostream>
#include "Internal_point.h"
#include <armadillo>
#include "experiments/vectorTools.h"
//#include "experiments/CrystData.h"

class Dataset_Graph
{
public:

    Dataset_Graph(arma::mat & diag1, arma::mat & diag2, std::string outputpath)
    {
    //:out(outputpath)
        std::vector<std::vector<double>> dg1;
        std::vector<std::vector<double>> dg2;
        vectorTools::mat_to_std_vec(diag1,dg1);
        vectorTools::mat_to_std_vec(diag2,dg2);
      //  this->PrintMatrixToFile("diagram1",dg1);
       // this->PrintMatrixToFile("diagram2",dg2);
        this->Transformator(dg1, this->u, 0);
        this->Transformator(dg2, this->v, 1);
        //Dataset_Graph(dg1, dg2);

    }
    void PrintMatrixToFile(std::string text, std::vector<std::vector<double>> & matrix)
    {
//        out << text << std::endl;
//        for (int i = 0; i < matrix.size(); i++)
//        {
//            for (int j = 0; j < matrix[0].size(); j++)
//            {
//                out << matrix[i][j] << ", ";
//
//            }
//            out << std::endl;
//
//        }
//        out << std::endl;


    }
    Dataset_Graph(std::vector<std::vector<double>> & diag1, std::vector<std::vector<double>> & diag2 )
    {
        this->Transformator(diag1, this->u, 0);
        this->Transformator(diag2, this->v, 1);

    }
    double distance(int i, int j) const
    {
        double maxx = 0;
        // std::cout << "Preparing distance calculation: " << std::endl;
        // std::cout << "Point one: " << i << " : ";
        //    for (int k = 0 ; k < constants::Dim; k++)
        //     {
        //     std::cout << u[i].coord(k) << ", ";
        //      }
        //     std::cout << std::endl;
//        std::cout << "Point two: " << j << " : ";
//       for (int k = 0 ; k < constants::Dim; k++)
        //      {
        //      std::cout << v[j].coord(k) << ", ";
//       }
        //      std::cout << std::endl;
        for (int k = 0 ; k < constants::Dim; k++)
        {
            maxx = std::max(maxx,std::abs(u[i].coord(k)-v[j].coord(k)));

        }
        //     std::cout << "Result: " << maxx << std::endl;
        return maxx;

    }
    Internal_point getVPoint(int indxV) const
    {
        return v[indxV];
    }
    Internal_point getUPoint(int indxU) const
    {
        return u[indxU];
    }
    inline int size() const
    {
        return u.size();
        //  return static_cast<int> (u.size() + v.size());
    }

    std::vector<double> sorted_distances()
    {
      //  out << "Distances: " << std::endl;
      //  out << "U size: " << u.size() << std::endl;
      //  out << "V size: " << v.size() << std::endl;
        std::vector<double> distances;
        distances.push_back(0.);  // for empty diagrams
        for (int u_point_index = 0; u_point_index < u.size(); ++u_point_index)
        {
            //distances.push_back(distance(u_point_index, corresponding_point_in_v(u_point_index)));
            for (int v_point_index = 0; v_point_index < v.size(); ++v_point_index)
            {
                double dtmp = distance(u_point_index, v_point_index);
              //  out << u_point_index << " , " << v_point_index << " : " << dtmp << std::endl;
                distances.push_back(dtmp);
            }
        }
//#ifdef GUDHI_USE_TBB
//       tbb::parallel_sort(distances.begin(), distances.end());
//#else
        std::sort(distances.begin(), distances.end());
//#endif
        return distances;
    }




    virtual ~Dataset_Graph() {
        //out.close();
    }

protected:
    void Transformator(std::vector<std::vector<double>> & diag1, std::vector<Internal_point> & output, int color)
    {
       // out << "Transformator activated with: " << diag1.size() << std::endl;
        for (int i = 0; i < diag1.size() ; i++ )
        {
            //double* a = &diag1[i][0];
            //   std::cout << "*** Adding point " << diag1[i][0] << ", "  << diag1[i][1] << std::endl;
            output.push_back(Internal_point(diag1[i], i, color));
        }

    }



private:
    std::vector<Internal_point> u;
    std::vector<Internal_point> v;
  //  std::ofstream out;
};

#endif // DATASET_GRAPH_H
