#ifndef KDTREECONTROLLER_H
#define KDTREECONTROLLER_H

#include "Internal_point.h"
#include "Construct_coord_iterator.h"
#include "Cube_query.h"

#include <CGAL/Epick_d.h>
#include <CGAL/point_generators_d.h>
#include <CGAL/Kd_tree.h>
#include <CGAL/Fuzzy_sphere.h>
#include <CGAL/Fuzzy_iso_box.h>
#include <CGAL/Search_traits_d.h>
#include <CGAL/Search_traits.h>
#include <header.hpp>
#include "Dataset_Graph.h"
//
//const int D = constants::Dim;
//typedef CGAL::Epick_d<CGAL::Dimension_tag<D> > K;
//typedef K::Vector_d Vector_d;
//typedef K::Point_d Point_d;
//typedef CGAL::Search_traits_d<K,CGAL::Dimension_tag<D> >  Traits;
//typedef CGAL::Random_points_in_cube_d<Point_d>       Random_points_iterator;
//typedef CGAL::Counting_iterator<Random_points_iterator> N_Random_points_iterator;
//typedef CGAL::Kd_tree<Traits> Tree;
//typedef CGAL::Fuzzy_sphere<Traits> Fuzzy_sphere;
//typedef CGAL::Fuzzy_iso_box<Traits> Fuzzy_iso_box;


//CGAL::Search_traits
//CGAL::Search_
typedef CGAL::Dimension_tag<constants::Dim> D;
typedef CGAL::Search_traits<double, Internal_point, const double*, Construct_coord_iterator, D> Traits;
typedef CGAL::Kd_tree<Traits> Kd_tree;


class KDTreeController
{
public:
    KDTreeController(Dataset_Graph& g, double r):graph(g),r(r),kd_t()
    {
   // kd_t.reserve(g.size());
    }
    virtual ~KDTreeController() {}

    void add(int v_point_index)
    {

        auto p = this->graph.getVPoint(v_point_index);
       // std::cout << "Adding point " << v_point_index << std::endl;
    //    std::cout << "Inserted point into KD-tree : " << p.vec[0] << " , " << p.vec[1] << std::endl;
        kd_t.insert(p);
    }
    int pull_near(int u_point_index)
    {
        Internal_point u_point = graph.getUPoint(u_point_index);
      //  std::cout << "Searching for: " << u_point.vec[0] << " , " << u_point.vec[1] << std::endl;
     //   std::cout << "Radius is set to: " << r << std::endl;
      //  kd_t.build();
        Cube_query query{u_point, r};
       // std::cout << kd_t.capacity() << std::endl;
        auto neighbor = kd_t.search_any_point(query);
        if (!neighbor)
        {
          // std::cout << "No neighbors found" << std::endl;
        //    std::cout << "No neighbor found" << std::endl;
            return constants::null_point_index;
        }
        else
        {
    //    std::cout << "Searching u point: " << u_point_index << std::endl;
     //   std::cout << "Radius is set to " << r << std::endl;
     //    std::cout << "Neighbor found " << std::endl;
            int tmp = neighbor->point_index;
            auto point = graph.getVPoint(tmp);
            int idx = point.point_index;
            kd_t.remove(point, [idx](Internal_point const&p)
            {
                return p.returnPointIndx() == idx;
            });
             return tmp;
        }


    }
    std::vector<int> pull_all_near(int u_point_index)
    {
     //   std::cout << "Pull all near : " << u_point_index << std::endl;
        std::vector<int> all_pull;
        int last_pull = pull_near(u_point_index);
        while (last_pull != constants::null_point_index)
        {
            all_pull.emplace_back(last_pull);
            last_pull = pull_near(u_point_index);
        }
        return all_pull;
    }

protected:

private:
        Kd_tree kd_t;
        Dataset_Graph& graph;
        double r;


    };

#endif // KDTREECONTROLLER_H
