#ifndef CRYSTDATA_H
#define CRYSTDATA_H

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <sstream>
#include "KDTreeController.h"
#include "BottleneckCalculator.h"
#include "Dataset_Graph.h"
#include "graph/GraphTreeController.h"
#include "graph/Bipartie_Graph.h"
#include "vectorTools.h"
#include "set"
#include <chrono>
#include <thread>
#include <iostream>


using Clock = std::chrono::steady_clock;
using std::chrono::time_point;
using std::chrono::duration_cast;
using std::chrono::milliseconds;
using namespace std::literals::chrono_literals;
using std::this_thread::sleep_for;
using namespace std;

class CrystData
{
public:
    CrystData() {}


    static void computeBasisMatrix(std::vector<int> & indices,std::vector<std::vector<double>> & cloud, std::vector<std::vector<double>> & basisCollection)
    {
        std::vector<double> c_P(cloud[indices[0]].size());
        // std::vector<std::vector<double>> basisCollection;
        for (int i = 0; i < indices.size(); i++)
        {
            basisCollection.push_back(cloud[indices[i]]);
        }
        vectorTools::multiDcrossProduct(basisCollection, c_P);
        //vectorTools::crossProduct(cloud[indices[0]], cloud[indices[1]], c_P);

        basisCollection.push_back(c_P);




    }


    static void ConstructDistanceMatrix(std::vector<std::vector<double>> & basisCollection, std::vector<std::vector<double>> & matrix)
    {
        //!! Assume that dimension = 3
        matrix = std::vector<std::vector<double>>(constants::Dim, std::vector<double>(constants::Dim));

        for (int i = 0; i < constants::Dim; i++)
        {
            for (int j = 0; j < constants::Dim; j++)
            {
                std::vector<double> vecU = basisCollection[j];
                vectorTools::vectorScalarMultiplication(vecU,-1);
                std::vector<double> vecV = basisCollection[i];
                vectorTools::vectorAddition(vecV, vecU);
                double norm;
                matrix[i][j] = vectorTools::SquaredNorm(vecV);
            }
        }
    }

    static void ConstructSRCloud( std::vector<std::vector<double>> & cloud,std::vector<std::vector<double>> & basis, std::vector<int> & indices,std::vector<std::vector<double>> & SrCloud)
    {
        std::vector<double> c_P(cloud[0].size());
        set<int> s(indices.begin(), indices.end());

        // std::cout << "First: " << cloud[i][0] << ", "<< cloud[i][1] << ", " << cloud[i][2] << std::endl;
        // std::cout << "Second: " << cloud[j][0] << ", "<< cloud[j][1] << ", " << cloud[j][2] << std::endl;
//        vectorTools::crossProduct(cloud[i], cloud[j], c_P);
        // std::cout << "Final: " << c_P[0] << ", "<< c_P[1] << ", " << c_P[2] << std::endl;
        for (int k = 0; k < cloud.size() ; k++)
        {
            if (s.find(k) == s.end())
            {
                std::vector<double> newVector;
                for (int i = 0; i < basis.size(); i++)
                {
                    newVector.push_back(vectorTools::dotProduct(cloud[k],basis[i]));
                }

                SrCloud.push_back(newVector);
            }
        }

        //CrystData::PrintMatrix(SrCloud);

        // std::cout << "SrCloudMat dimensions: " << SrCloud.size() << " , " << SrCloud[i].size() << std::endl;
    }

    // static void listCombos(std::vector<int> & inputArray, int reqLen, int start, int currLen, bool)
    static void find_comb(vector<vector<int>>& res,vector<int> temp, int ind,int st, int end,int k)
    {
        if(ind == k)
        {
            res.push_back(temp);
            return;
        }
        for(int i = st; i<end && end-i+1 >= k-ind; i++)
        {
            temp[ind] = i;
            find_comb(res,temp,ind+1,i+1,end,k);
        }
    }


//    static void dfs(vector<vector<int>>& res,vector<int> temp, int ind,int n, int r)
//    {
//        if(r==0)
//        {
//            res.push_back(temp);
//            return;
//        }
//        for(int i = ind; i<=n; i++)
//        {
//            temp.push_back(i);
//            dfs(res,temp,i+1,n,r-1);
//            temp.pop_back();
//        }
//
//    }

    static void ConstructAllSRCombos(std::vector<std::vector<double>> & cloud, std::vector<std::vector<int>> & combos, std::vector<std::vector<std::vector<double>>> & SrCloudCollection,
                                     std::vector<std::vector<std::vector<double>>> & distMatrix)
    {

        for (int i = 0; i < combos.size(); i++)
        {
            std::vector<std::vector<double>> basisCollection;
            CrystData::computeBasisMatrix(combos[i],cloud,basisCollection);
            std::vector<std::vector<double>> SrCloud;
            std::vector<std::vector<double>> DistMat;
            CrystData::ConstructSRCloud(cloud,basisCollection,combos[i],SrCloud);
            CrystData::ConstructDistanceMatrix(basisCollection,DistMat);

            //CrystData::ConstructSRCloud(i,j,cloud,SrCloud);
            //    CrystData::ConstructDistanceMatrix(indices,cloud,DistMat);

            SrCloudCollection.push_back(SrCloud);
            distMatrix.push_back(DistMat);
//            if (i == 1)
//            {
//                std::cout << "Special prrint" << std::endl;
//
//
//                std::cout << "Anotehrrr" << std::endl;
//
//                PrintMatrix(SrCloudCollection[0]);
//            }




        }
        //  std::cout << "Printing sr cloud first instance" << std::endl;
        //   PrintMatrix(SrCloudCollection[0]);
        //  std::cout << "Printing dist matrix firstinstance" << std::endl;
        // PrintMatrix(distMatrix[0]);



    }
    static double ComputeSDdistance(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB)
    {
        double Maxx = 0;
        for (int i = 0; i < dataA.size(); i++)
        {
            for (int j = 0; j < dataA[i].size(); j++)
            {
                double distt = std::abs(dataA[i][j] - dataB[i][j]);
                Maxx = std::max(distt, Maxx);
            }
        }
        return Maxx;


    }

    static void ReadCloud(std::vector<std::vector<double>> &cloud, std::string fname)
    {

        vector<vector<string>> content;
        vector<string> row;
        string line, word;

        fstream file (fname, ios::in);
        if(file.is_open())
        {
            while(getline(file, line))
            {
                row.clear();

                stringstream str(line);

                while(getline(str, word, ','))
                    row.push_back(word);
                content.push_back(row);
            }
        }
        else
            cout<<"Could not open the file\n";

        for(int i=0; i<content.size(); i++)
        {
            if (i != 0)
            {
                double X = std::stod(content[i][0]);
                double Y = std::stod(content[i][1]);

                cloud.push_back(std::vector<double> {X,Y});

            }
        }
      //  std::cout << "Contents size: " << content.size() << std::endl;




    }




    static double ComputeEuclideanBottleneckDistanceBweteenClouds(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB, std::vector<int> & matching)
    {


     std::vector<std::vector<double>> distances(dataA.size(), std::vector<double>(dataB.size()));
        for (int i =0 ; i < dataA.size(); i++)
        {
            for (int j =  0; j < dataB.size(); j++)
            {
                distances[i][j] = vectorTools::euclideanDistance(dataA[i],dataB[j]);



            }


        }
        Bipartie_Graph g(distances);
        double dist = BottleneckCalculator::bottleneck_distance_exact_with_matching<Bipartie_Graph,GraphTreeController>(g,matching);
       // CrystData::PrintVector<int>(matching);
        return dist;



    }

    static double ComputeEasyBottleneckDistanceBetweenClouds(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB)
    {
        //! form distance matrix
        std::vector<std::vector<double>> distances(dataA.size(), std::vector<double>(dataB.size()));
        for (int i =0 ; i < dataA.size(); i++)
        {
            for (int j =  0; j < dataB.size(); j++)
            {
                distances[i][j] = vectorTools::linfinity(dataA[i],dataB[j]);



            }


        }
        Bipartie_Graph g(distances);
        std::vector<int> matching;
        double dist = BottleneckCalculator::bottleneck_distance_exact_with_matching<Bipartie_Graph,GraphTreeController>(g,matching);
       // CrystData::PrintVector<int>(matching);
        return dist;



    }

    static double ComputeBottleneckDistanceBetweenClouds(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB)
    {
        Dataset_Graph g(dataA, dataB);
        std::vector<int> matching;
        //double dist = BottleneckCalculator::bottleneck_distance_exact<Dataset_Graph,KDTreeController>(g);
        double dist = BottleneckCalculator::bottleneck_distance_exact_with_matching<Dataset_Graph,KDTreeController>(g,matching);
        //CrystData::PrintVector<int>(matching);
        return dist;
    }


    // std::vector<std::vector<std::vector<double>>> & srA, std::vector<std::vector<std::vector<double>>> & srB,
    //                                      std::vector<std::vector<std::vector<double>>> & sdA, std::vector<std::vector<std::vector<double>>> & sdB,

    static void printComposition(std::vector<int> & collection, std::vector<int> & mappingB)
    {
        std::vector<int> composition;
        for (int i = 0; i < collection.size(); i++)
        {
            composition.push_back(mappingB[collection[i]]);
        }
        CrystData::PrintVector(composition);


    }

    static double BottleNeckDistanceMatrix(std::vector<std::vector<double>> & cloudA, std::vector<std::vector<double>> & cloudB,
                                           std::vector<std::vector<double>> & distMatrix, double radA, double radB, vector< vector<int> > & res, std::vector<int> & mappingA, std::vector<int> & mappingB,
                                           std::vector<int> & matching, long & totalTimeForSMI, long & totalTimeForBD)
    {
        //std::cout << "Radius A : " << radA << std::endl;
       // std::cout << "Radius B : " << radB << std::endl;
        //  std::cout << "Reached bottleneck distance matrix method" << std::endl;
        int n = cloudA.size();
        int k = constants::Dim - 1;
        vector<int> temp(k,0);
        CrystData::find_comb(res,temp,0,0,n,k);
        bool activator = false;



        std::vector<std::vector<std::vector<double>>> srA;
        std::vector<std::vector<std::vector<double>>> srB;
        std::vector<std::vector<std::vector<double>>> sdA;
        std::vector<std::vector<std::vector<double>>> sdB;

        //= std::vector<std::vector<std::vector<double>>>(res.size());
        time_point<Clock> start = Clock::now();
        CrystData::ConstructAllSRCombos(cloudA,res,srA,sdA);
        CrystData::ConstructAllSRCombos(cloudB,res,srB,sdB);
        time_point<Clock> endd = Clock::now();
        milliseconds diff = duration_cast<milliseconds>(endd - start);
        totalTimeForSMI = diff.count();



        //  std::cout << "Combos were succesfully constructed" << std::endl;
        //  std::cout << "SrA size:" << srA.size() << std::endl;
        //  std::cout << "SdA size:" << sdA.size() << std::endl;
        //  CrystData::PrintMatrix(srA[0]);

        time_point<Clock> startTwo = Clock::now();




        distMatrix = std::vector<std::vector<double>>(res.size(),std::vector<double>(res.size()));
        // std::cout << "SRA size: " << srA.size()  << std::endl;
        //  std::cout << "SRB size: " << srB.size()  << std::endl;
        //   std::cout << "SdA size: " << sdA.size()  << std::endl;
        //   std::cout << "SdB size: " << sdB.size()  << std::endl;
    //    std::ofstream out("/home/yury/LocalProjects/OutputS/Performance/debugstream.txt");
        for (int i = 0; i < res.size(); i++)
        {
            for (int j = 0; j < res.size(); j++)
            {
                //   std::cout << "Itearting over combination " << i << " , " << j << std::endl;
                std::vector<std::vector<double>> normalizedSrA = srA[i];
                std::vector<std::vector<double>> normalizedSrB = srB[j];
                std::vector<std::vector<double>> normalizedSdA = sdA[i];
                std::vector<std::vector<double>> normalizedSdB = sdB[j];
                double radmultiplierA = (1/radA);
                double radmultiplierB = (1/radB);
                vectorTools::MatrixScalarMultiplicationSpecial(normalizedSrA, radmultiplierA);
                vectorTools::MatrixScalarMultiplication(normalizedSdA, radmultiplierA);
                vectorTools::MatrixScalarMultiplicationSpecial(normalizedSrB, radmultiplierB);
                vectorTools::MatrixScalarMultiplication(normalizedSdB, radmultiplierB);
                std::vector<int> selectB;
                for (int ij = 0; ij < k; ij++ )
                {
                    selectB.push_back(ij);
                }
                double dist = std::numeric_limits<double>::max();
                int perm = 0;
                do
                {

                    std::vector<int> permutation = selectB;

                    //    std::cout << "Proeceding ...." << std::endl;
                    int sign = vectorTools::permutationSign(permutation);
                    permutation.push_back(constants::Dim-1);

                    std::vector<std::vector<double>> normalizedSrBperm;
                    std::vector<std::vector<double>> normalizedSdBperm;
                    //  cout << "other stuff done" << endl;
                    // CrystData::PrintVector<int> (permutation);
                    //  CrystData::PrintMatrix(normalizedSdB);
                    vectorTools::permuteMatrix(normalizedSdB, normalizedSdBperm, permutation);
                    //    std::cout << "matrix permuted" << endl;
                    vectorTools::PermuteRowsAndMultiplyLastColumn(normalizedSrB, normalizedSrBperm, sign, permutation);

                    //     std::cout << "Permutation ready" << std::endl;
                    if ((i == 0) && (j == 0))
                    {
                        //!CrystData::PrintMatrixToFile(normalizedSrA, "/home/yury/LocalProjects/OutputS/Performance/matrixA.csv");
                        //!CrystData::PrintMatrixToFile(normalizedSrBperm, "/home/yury/LocalProjects/OutputS/Performance/matrixB.csv");



                    }
                  //!  double distBDnormalPerm = CrystData::ComputeBottleneckDistanceBetweenClouds(normalizedSrA, normalizedSrBperm);
                    double distBDnormalPerm = ComputeEasyBottleneckDistanceBetweenClouds(normalizedSrA, normalizedSrBperm);
                    //   std::cout << "Bottleneck computed " << std::endl;
                    // std::cout << "Bottleneck distance: " << distBDnormalPerm << std::endl;
                    double distSDnormalPerm = CrystData::ComputeSDdistance(normalizedSdA, normalizedSdBperm);

                    //   std::cout << "SD computed" << std::endl;
                    //   std::cout << "SD distance " << distSDnormalPerm << std::endl;
                    double permute = std::max(distBDnormalPerm, distSDnormalPerm);
                    // double permute = std::max(distBDnormalPerm, distSDnormalPerm);
                    dist = std::min(dist,permute);
                   // out << "Iterating over: " << i << ", " << j << ", " << perm << ": " << " BDDist: " << distBDnormalPerm  << ", SDDist: " << distSDnormalPerm << std::endl;
                 //   out << "Permutation vector: ";
                    for (int kkk = 0; kkk < permutation.size(); kkk++)
                    {
                //       out << permutation[kkk] << ", ";


                    }
                  //  out << std::endl;
                    perm = perm + 1;
                }
                while (next_permutation(selectB.begin(), selectB.end()));
                //    std::cout << "Vector A: " << std::endl;
                //     printComposition(res[i],mappingA);
                //    std::cout << "Vector B: " << std::endl;
                //   printComposition(res[j],mappingB);
                //     std::cout << "==================== So as dist we got " << dist << std::endl;
                distMatrix[i][j] = dist;



            }


        }

        Bipartie_Graph g(distMatrix);

        double dist = BottleneckCalculator::bottleneck_distance_exact_with_matching<Bipartie_Graph,GraphTreeController>(g, matching);

        time_point<Clock> enddTwo = Clock::now();
        milliseconds diffTwo = duration_cast<milliseconds>(enddTwo - startTwo);
        totalTimeForBD = diffTwo.count();


        return dist;

    }


//        for (int i = 0 ; i < srA.size(); i++)
//        {
//            for (int j = 0 ; j < srB.size(); j++)
//            {
//                //!  std::vector<int> permutation = std::vector<int> {1,0,2};
//
//                std::vector<std::vector<double>> normalizedSrA = srA[i];
//                std::vector<std::vector<double>> normalizedSrB = srB[j];
//                std::vector<std::vector<double>> normalizedSdA = sdA[i];
//                std::vector<std::vector<double>> normalizedSdB = sdB[j];
//                double radmultiplierA = (1/radA);
//                double radmultiplierB = (1/radB);
//                vectorTools::MatrixScalarMultiplication(normalizedSrA, radmultiplierA);
//                vectorTools::MatrixScalarMultiplication(normalizedSdA, radmultiplierA);
//                vectorTools::MatrixScalarMultiplication(normalizedSrB, radmultiplierB);
//                vectorTools::MatrixScalarMultiplication(normalizedSdB, radmultiplierB);
//
//                double distBDnormal = CrystData::ComputeBottleneckDistanceBetweenClouds(normalizedSrA, normalizedSrB);
//                double distSDnormal = CrystData::ComputeSDdistance(normalizedSdA, normalizedSdB);
//                double normal = std::max(distBDnormal, distSDnormal);
//
//
//                //! Compute with permutaiton
//                std::vector<std::vector<double>> normalizedSrBperm;
//                std::vector<std::vector<double>> normalizedSdBperm;
//
//                vectorTools::permuteMatrix(normalizedSdB, normalizedSdBperm, permutation);
//                vectorTools::PermuteRowsAndMultiplyLastColumn(normalizedSrB, normalizedSrBperm, -1, permutation);
//                double distBDnormalPerm = CrystData::ComputeBottleneckDistanceBetweenClouds(normalizedSrA, normalizedSrBperm);
//                double distSDnormalPerm = CrystData::ComputeSDdistance(normalizedSdA, normalizedSdBperm);
//                double permute = std::max(distBDnormalPerm, distSDnormalPerm);
//                double dist = std::min(normal,permute);
//
//                distMatrix[i][j] = dist;
//            }
//        }

    static double BottleneckSRFinalMatching(std::vector<int> & matching, std::vector<int> & mappingA, std::vector<int> & mappingB, std::vector<std::vector<int>> & combos,
                                            std::vector<std::string> & outputpairs)
    {

        //   std::cout << "Calculated calculator" << std::endl;
        // PrintVector(mappingA);
        //   PrintVector(mappingB);

        std::cout << "Combos[i] size: " << combos[0].size() << std::endl;

          for (int i = 0; i < combos.size(); i++)
        {

         string line = "";
            for (int j = 0; j < combos[i].size(); j++)
            {
                //   std::cout << "Itearting over (A) " << i << " , " << j << std::endl;
                //  std::cout << combos[i][j] << std::endl;

                line = line + std::to_string(mappingA[combos[i][j]]);

                if (j < combos[i].size() - 1)
                {
                line = line  + ", ";
                }


            }
            line = line + ",";
            for (int j = 0; j < combos[i].size(); j++)
            {
                //      std::cout << "Itearting over (B)" << i << " , " << j << std::endl;
                //   std::cout << combos[i][j] << std::endl;
                if (j < combos.size() - 1)
                {
                    line = line + std::to_string(mappingB[combos[matching[i]][j]]);
                }
                if (j < combos[i].size() - 1)
                {
                    line = line +  ", ";

                }


            }
            line = line;
            outputpairs.push_back(line);
        }
        //  std::cout << "Finnished adding stuff" << std::endl;
        return 0;


//        for (int i = 0; i < combos.size(); i++)
//        {
//            string line = "(";
//            for (int j = 0; j < combos[i].size(); j++)
//            {
//                //   std::cout << "Itearting over (A) " << i << " , " << j << std::endl;
//                //  std::cout << combos[i][j] << std::endl;
//
//                line = line + std::to_string(mappingA[combos[i][j]]) + ", ";
//
//
//            }
//            line = line + ") - (";
//            for (int j = 0; j < combos[i].size(); j++)
//            {
//                //      std::cout << "Itearting over (B)" << i << " , " << j << std::endl;
//                //   std::cout << combos[i][j] << std::endl;
//                if (j < combos.size() - 1)
//                {
//                    line = line + std::to_string(mappingB[combos[matching[i]][j]]) + ", ";
//                }
//
//
//            }
//            line = line + ")";
//            outputpairs.push_back(line);
//        }
//        //  std::cout << "Finnished adding stuff" << std::endl;
//        return 0;

    }

//   std::vector<std::vector<double>> & cloudA, std::vector<std::vector<double>> & cloudB
//   std::vector<std::vector<double>> & distMatrix, double radA, double radB

    static void initilizeTrivialMapping(int s, std::vector<int> & mappingA )
    {
        for (int i = 0; i < s; i++)
        {
            mappingA.push_back(i);
        }

    }

    static void convertArmaToVector(arma::mat & input, std::vector<std::vector<double>> & out)
    {
        for (int i = 0; i < input.n_cols; i++)
        {
            std::vector<double> tmp;
            for (int j = 0; j < input.n_rows; j++)
            {
                tmp.push_back(input.col(i)(j));

            }
            out.push_back(tmp);




        }


    }

    static double computeDistanceBetweenTwoClouds( arma::mat & cloudA, arma::mat & cloudB, long & totalTimeForSMI , long & totalTimeForBD, vector<std::string> & outputpairs)
    {
        std::vector<int> mappingA;
        std::vector<int> mappingB;
        CrystData::initilizeTrivialMapping(cloudA.n_cols, mappingA );
        CrystData::initilizeTrivialMapping(cloudA.n_cols, mappingB );
        std::vector<std::vector<double>> cloudAtmp;
        std::vector<std::vector<double>> cloudBtmp;
        CrystData::convertArmaToVector(cloudA, cloudAtmp);
        CrystData::convertArmaToVector(cloudB, cloudBtmp);


        return computeDistanceBetweenTwoClouds(cloudAtmp, cloudBtmp, mappingA, mappingB, outputpairs, totalTimeForSMI,totalTimeForBD);

    }



    static double computeDistanceBetweenTwoClouds( arma::mat & cloudA, arma::mat & cloudB, long & totalTimeForSMI , long & totalTimeForBD)
    {
        std::vector<int> mappingA;
        std::vector<int> mappingB;
        CrystData::initilizeTrivialMapping(cloudA.n_cols, mappingA );
        CrystData::initilizeTrivialMapping(cloudA.n_cols, mappingB );
        std::vector<std::vector<double>> cloudAtmp;
        std::vector<std::vector<double>> cloudBtmp;
        CrystData::convertArmaToVector(cloudA, cloudAtmp);
        CrystData::convertArmaToVector(cloudB, cloudBtmp);
        vector<std::string> outputpairs;

        return computeDistanceBetweenTwoClouds(cloudAtmp, cloudBtmp, mappingA, mappingB, outputpairs, totalTimeForSMI,totalTimeForBD);

    }



    static double computeEuclideanBottleneckDistanceBC( arma::mat & cloudA, arma::mat & cloudB)
    {
        std::vector<int> matching;
        return computeEuclideanBottleneckDistanceBC( cloudA, cloudB, matching);

    }

    static double computeEuclideanBottleneckDistanceBC( arma::mat & cloudA, arma::mat & cloudB, std::vector<int> & matching)
    {
         std::vector<std::vector<double>> cloudAtmp;
        std::vector<std::vector<double>> cloudBtmp;

        CrystData::convertArmaToVector(cloudA, cloudAtmp);
        CrystData::convertArmaToVector(cloudB, cloudBtmp);

      //  std::cout << "matrix A:" << std::endl;
      //   CrystData::PrintMatrix(cloudAtmp);
       //      std::cout << "matrix B:" << std::endl;
        //  CrystData::PrintMatrix(cloudBtmp);


        double bda = ComputeEuclideanBottleneckDistanceBweteenClouds(cloudAtmp,cloudBtmp, matching);
        return bda;


    }

    static double computeDistanceBetweenTwoClouds( arma::mat & cloudA, arma::mat & cloudB, long & totalTimeForSMI , long & totalTimeForBD, double & bda)
    {
        std::vector<int> mappingA;
        std::vector<int> mappingB;
        CrystData::initilizeTrivialMapping(cloudA.n_cols, mappingA );
        CrystData::initilizeTrivialMapping(cloudA.n_cols, mappingB );
        std::vector<std::vector<double>> cloudAtmp;
        std::vector<std::vector<double>> cloudBtmp;
        CrystData::convertArmaToVector(cloudA, cloudAtmp);
        CrystData::convertArmaToVector(cloudB, cloudBtmp);
        vector<std::string> outputpairs;
       //! bda = ComputeEasyBottleneckDistanceBetweenClouds(cloudAtmp,cloudBtmp);
        std::vector<int> matching;
        bda = ComputeEuclideanBottleneckDistanceBweteenClouds(cloudAtmp,cloudBtmp, matching);

        return computeDistanceBetweenTwoClouds(cloudAtmp, cloudBtmp, mappingA, mappingB, outputpairs, totalTimeForSMI,totalTimeForBD);

    }

    static double computeDistanceBetweenTwoClouds( std::vector<std::vector<double>> & cloudAtmp, std::vector<std::vector<double>> & cloudBtmp,std::vector<int> & mappingA, std::vector<int> & mappingB,
            std::vector<std::string> & outputpairs)
    {
        long totalTimeForSMI = 0;
        long totalTimeForBD = 0;
        return computeDistanceBetweenTwoClouds(cloudAtmp, cloudBtmp, mappingA, mappingB, outputpairs, totalTimeForSMI,totalTimeForBD);

    }

    static double computeDistanceBetweenTwoClouds( std::vector<std::vector<double>> & cloudAtmp, std::vector<std::vector<double>> & cloudBtmp,std::vector<int> & mappingA, std::vector<int> & mappingB,
            std::vector<std::string> & outputpairs, long & totalTimeForSMI, long & totalTimeForBD)
    {
        //   long totalTimeForSMI = 0;
        //   long totalTimeForBD = 0;
        std::vector<std::vector<double>> cloudA;
        std::vector<std::vector<double>> cloudB;
        std::vector<int> matching;


        double radA = centralizeAndComputeRadius(cloudAtmp, cloudA);
        double radB = centralizeAndComputeRadius(cloudBtmp, cloudB);


     //   std::cout << " cloud A :" << std::endl;
     //  PrintMatrix(cloudA);

        //std::cout << " cloud B :" << std::endl;
      // PrintMatrix(cloudB);

       //std::cout << "Radius A: " << radA << std::endl;

       //std::cout << "Radius B: " << radB << std::endl;


        std::vector<std::vector<int>> combos;



        std::vector<std::vector<double>> distMatrix;



        double tt = CrystData::BottleNeckDistanceMatrix(cloudA,cloudB,distMatrix,radA,radB,combos,mappingA, mappingB,matching,totalTimeForSMI, totalTimeForBD);


        CrystData::BottleneckSRFinalMatching(matching,mappingA, mappingB, combos,outputpairs);
        return tt;


    }

    static double computeDistanceBetweenTwoMatching(std::string inA, std::string inB, std::vector<std::string> & outputpairs, int indxAcryst, int indxBcryst, bool addcentroid)
    {
        std::vector<std::vector<double>> cloudAtmp;
        std::vector<std::vector<double>> cloudBtmp;
        std::vector<int> mappingA;
        std::vector<int> mappingB;

        CrystData::ReadData(inA, cloudAtmp, mappingA, indxAcryst, addcentroid);
        CrystData::ReadData(inB, cloudBtmp, mappingB, indxBcryst, addcentroid);
        return CrystData::computeDistanceBetweenTwoClouds(cloudAtmp, cloudBtmp,mappingA,mappingB,outputpairs);

    }



    static double centralizeAndComputeRadius(std::vector<std::vector<double>> & cloudIN, std::vector<std::vector<double>> & cloudOUT)
    {
        double sizeofcloudin = cloudIN.size();
        //std::cout << "Size of cloud in: " << sizeofcloudin << std::endl;
        std::vector<double> centroid(cloudIN[0].size());
        double radius = 0;
        for (int i = 0; i < cloudIN.size(); i++)
        {
            vectorTools::vectorAddition(centroid, cloudIN[i]);
        }
        double division = -1/sizeofcloudin;
        //  std::cout << "Division size: " << division << std::endl;
        // std::cout << "Centroid: "  << centroid[0] << ", " << centroid[1] << ", " << centroid[2] << std::endl;
        vectorTools::vectorScalarMultiplication(centroid,division);
        //   std::cout << "Centroid: "  << centroid[0] << ", " << centroid[1] << ", " << centroid[2] << std::endl;
        cloudOUT = cloudIN;
        for (int i = 0; i < cloudOUT.size(); i++)
        {
            //     std::cout << "cloudOut: "  << cloudOUT[i][0] << ", " << cloudOUT[i][1] << ", " << cloudOUT[i][2] << std::endl;
            vectorTools::vectorAddition(cloudOUT[i], centroid);
            //   std::cout << "cloudOut: (After addition) "  << cloudOUT[i][0] << ", " << cloudOUT[i][1] << ", " << cloudOUT[i][2] << std::endl;
            radius = std::max(radius, sqrt(vectorTools::SquaredNorm(cloudOUT[i])));
        }
        return radius;
    }

    static void PrintMatrixToFile(std::vector<std::vector<double>> & matrix, std::string outputpath)
    {
        std::ofstream out(outputpath);
        out << "X DIMENSION: " << matrix.size() << std::endl;
        for (int i = 0; i < matrix.size(); i++)
        {
            for (int j = 0; j < matrix[0].size(); j++)
            {
                out << matrix[i][j] << ", ";

            }
            out << std::endl;

        }

        out.close();

    }


    static void PrintMatrix(std::vector<std::vector<double>> & matrix)
    {
        std::cout << "X DIMENSION: " << matrix.size() << std::endl;
        for (int i = 0; i < matrix.size(); i++)
        {
            for (int j = 0; j < matrix[0].size(); j++)
            {
                std::cout << matrix[i][j] << ", ";

            }
            std::cout << std::endl;

        }

    }
    template<typename T>
    static void PrintVector(std::vector<T> & vec)
    {
        for (int i = 0; i < vec.size(); i++)
        {
            std::cout << vec[i] << ", ";


        }
        std::cout << std::endl;


    }



    static void ReadData(std::string fname, std::vector<std::vector<double>> & cloud, std::vector<int> & mapping, int origCrystID, bool addcentroid)
    {
        vector<vector<string>> content;
        vector<string> row;
        string line, word;

        fstream file (fname, ios::in);
        if(file.is_open())
        {
            while(getline(file, line))
            {
                row.clear();

                stringstream str(line);

                while(getline(str, word, ','))
                    row.push_back(word);
                content.push_back(row);
            }
        }
        else
            cout<<"Could not open the file\n";

        //! Adding first crystal:
        if (addcentroid)
        {
            cloud.push_back(std::vector<double> {0,0,0});
            mapping.push_back(origCrystID);
        }

        // std::cout << "File opened now lets do stuff" << std::endl;

        //! Adding rest of the crystals:

        for(int i=0; i<content.size(); i++)
        {
            if (i != 0)
            {
                int index = std::stoi(content[i][0]);
                double X = std::stod(content[i][1]);
                double Y = std::stod(content[i][2]);
                double Z = std::stod(content[i][3]);
                cloud.push_back(std::vector<double> {X,Y,Z});
                mapping.push_back(index);

//            for(int j=0; j<content[i].size(); j++)
//            {
//
//                cout<<content[i][j]<<" ";
//            }
                cout<<"\n";
            }
        }
//            std::cout << "Cloud size: " << cloud.size() << std::endl;
//            std::cout << "mapping size: " << mapping.size() << std::endl;
//        io::CSVReader<4> in;
//        in.read_header(io::ignore_extra_column, "Index","X", "Y", "Z");
//        int index;
//        double X;
//        double Y;
//        double Z;
//        while(in.read_row(index, X, Y, Z))
//        {
//            cloud.push_back(std::vector<double> {X,Y,Z});
//            mapping.push_back(index);
//            std::cout << index << " , " << X << " , " << Y << " , " << Z << std::endl;
//        }



    }
    virtual ~CrystData() {}

protected:

private:
};

#endif // CRYSTDATA_H
