#ifndef CRYSTDATAEXPERIMENTS_H
#define CRYSTDATAEXPERIMENTS_H


#include <string>
#include <iostream>
#include <filesystem>
#include <SCD.h>
#include <set>
#include <thread>

namespace fs = std::filesystem;
using namespace std;

class CrystDataExperiments
{
public:

    CrystDataExperiments(int kkkk)
    {



    }

    CrystDataExperiments(std::string xyzFiles)
    {

        std::set<fs::path> sorted_by_name;

        for (auto &entry : fs::directory_iterator(xyzFiles))
            sorted_by_name.insert(entry.path());


        for (auto &filename : sorted_by_name)
        {
            std::string opp = filename.c_str();
            std::cout << filename.c_str() << std::endl;
            // std::vector<std::string> strings;
            // customSplit(opp, '/', strings);
            // std::string finall = strings[strings.size()-1];
            // out << "Finall (standard): " << finall << std::endl;
            // out << "Read path (standard): " << opp<< std::endl;
            //  out << "========" << std::endl;
            //   std::cout << opp << std::endl;
            arma::mat k;
            ReadFileIntoMatrix(opp, k);
            matrices.push_back(k);
            //!epicMap[finall] = k;

        }

    }

    double computeHaudsorff(arma::mat & A,arma::mat & B)
    {
        double maxxOneWayReal = 0;
        for (int i = 0; i < A.n_cols; i++)
        {
            double maxxOneWay = std::numeric_limits<double>::max();
            for (int j = 0; j < B.n_cols; j++)
            {
                double dtmp = arma::norm(A.col(i) - B.col(j), 2);
                maxxOneWay = std::min(maxxOneWay, dtmp);

            }
            maxxOneWayReal  = std::max(maxxOneWayReal,maxxOneWay );

        }
        double maxxTwoWayReal = 0;
        for (int j = 0; j < B.n_cols; j++)
        {
            double maxxTwoWay = std::numeric_limits<double>::max();
            for (int i = 0; i < A.n_cols; i++)
            {
                double dtmp = arma::norm(A.col(i) - B.col(j), 2);
                maxxTwoWay = std::min(maxxTwoWay, dtmp);

            }
            maxxTwoWayReal  = std::max(maxxTwoWayReal,maxxTwoWay);



        }


        return std::max(maxxTwoWayReal,maxxOneWayReal);
    }


    void limitedExperRun(int x, int y,std::vector<std::vector<std::string>> & parsedCsv, std::vector<std::vector<std::string>> & outVector )
    {
        SCD lap(0.43);
        int tt = matrices.size();
        y = std::min(y, tt);


        for (int i = x; i < y; i++)
        {
            std::cout << "Running operation: [" << x << " --- " << i << " --- " << y << "]" << std::endl;
            std::vector<std::string> tmp;
            //   std::cout << "u: " << parsedCsv[i][1] << std::endl;
            int u = stoi(parsedCsv[i][0]);
            // std::cout << "v: " << parsedCsv[i][2] << std::endl;
            int v = stoi(parsedCsv[i][1]);
            //  std::cout << "Starting " << std::endl;
            long totalTimeForSMIstd;
            long totalTimeForBD;
            std::vector<int> matching;
            std::vector<std::vector<int>> res;
            double bd = 0;

            std::vector<std::vector<bool>> graphA(matrices[u].n_cols+1, std::vector<bool>(matrices[u].n_cols+1, true));
            std::vector<std::vector<bool>> graphB = graphA;

            //  double purebd = 0;

            //!         std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, PDD dist, Molecule_A, Molecule_B, NumAtoms, SDV dist";

            //!  double bd = CrystData::computeDistanceBetweenTwoClouds( matrices[u], matrices[v], totalTimeForSMIstd, totalTimeForBD, purebd);
            bd = lap.ComputeDistance(matrices[u], matrices[v], graphA, graphB, matching, res, totalTimeForSMIstd, totalTimeForBD);


            //!  double haussdorff = computeHaudsorff(matrices[u], matrices[v]);
            //!      static double ComputeEasyBottleneckDistanceBetweenClouds(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB)


            for (int j = 0 ; j < parsedCsv[i].size(); j++)
            {
                tmp.push_back(parsedCsv[i][j]);
            }
            tmp.push_back(std::to_string(bd));
            tmp.push_back(std::to_string(totalTimeForSMIstd));
            tmp.push_back(std::to_string(totalTimeForBD));

//            for (int jj = 0; jj < tmp.size(); jj++)
//            {
//                std::cout << tmp[jj] << ", ";
//
//            }
//            std::cout << std::endl;
            outVector.push_back(tmp);
        }

        std::cout << "Outvector size: " << outVector.size() << std::endl;



    }

    void RunSingleSCD(int x, int y)
    {
        SCD lap(0.43);

        int u = x;
        int v = y;
        long totalTimeForSMIstd;
        long totalTimeForBD;
        std::vector<int> matching;
        std::vector<std::vector<int>> res;
        std::vector<std::vector<bool>> graphA(matrices[u].n_cols+1, std::vector<bool>(matrices[u].n_cols+1, true));
        std::vector<std::vector<bool>> graphB = graphA;
        double bd = lap.ComputeDistance(matrices[u], matrices[v], graphA, graphB, matching, res, totalTimeForSMIstd, totalTimeForBD);
        std::cout << bd << std::endl;

    }

    void limitedExperimentsRun(int x, int y, std::vector<std::vector<std::string>> & parsedCsv, std::vector<std::vector<std::string>> & outVector)
    {
        int tt = matrices.size();
        y = std::min(y, tt);

        //   std::cout << "Parsed csv size: " << parsedCsv.size() << std::endl;

        for (int i = x; i < y; i++)
        {
            std::cout << "Running operation: [" << x << " --- " << i << " --- " << y << "]" << std::endl;
            std::vector<std::string> tmp;
            //   std::cout << "u: " << parsedCsv[i][1] << std::endl;
            int u = stoi(parsedCsv[i][1]);
            // std::cout << "v: " << parsedCsv[i][2] << std::endl;
            int v = stoi(parsedCsv[i][2]);
            //  std::cout << "Starting " << std::endl;
            long totalTimeForSMIstd;
            long totalTimeForBD;
            double purebd = 0;

            //!         std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, PDD dist, Molecule_A, Molecule_B, NumAtoms, SDV dist";

            double bd = CrystData::computeDistanceBetweenTwoClouds( matrices[u], matrices[v], totalTimeForSMIstd, totalTimeForBD, purebd);
            double haussdorff = computeHaudsorff(matrices[u], matrices[v]);
            //!      static double ComputeEasyBottleneckDistanceBetweenClouds(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB)

            tmp.push_back(parsedCsv[i][1]);
            tmp.push_back(parsedCsv[i][2]);
            tmp.push_back(parsedCsv[i][3]);
            tmp.push_back(std::to_string(haussdorff));
            tmp.push_back(std::to_string(purebd));
            tmp.push_back(parsedCsv[i][4]);
            tmp.push_back(parsedCsv[i][0]);
            tmp.push_back(std::to_string(bd));
            double ratiod = bd / purebd;
            tmp.push_back(std::to_string(ratiod));
            tmp.push_back(std::to_string(totalTimeForSMIstd));
            tmp.push_back(std::to_string(totalTimeForBD));

//            tmp.push_back(std::to_string(bd));
//            tmp.push_back(std::to_string(totalTimeForSMIstd));
//            tmp.push_back(std::to_string(totalTimeForBD));
//            for (int j = 0 ; j < parsedCsv[i].size(); j++)
//            {
//                tmp.push_back(parsedCsv[i][j]);
//            }

//            for (int jj = 0; jj < tmp.size(); jj++)
//            {
//                std::cout << tmp[jj] << ", ";
//
//            }
//            std::cout << std::endl;
            outVector.push_back(tmp);
        }

        std::cout << "Outvector size: " << outVector.size() << std::endl;

    }

    void limitedExperimentsRunModi(int x, int y, std::vector<std::vector<std::string>> & parsedCsv, std::vector<std::vector<std::string>> & outVector)
    {
        int tt = matrices.size();
        y = std::min(y, tt);

        //   std::cout << "Parsed csv size: " << parsedCsv.size() << std::endl;

        for (int i = x; i < y; i++)
        {
            std::cout << "Running operation: [" << x << " --- " << i << " --- " << y << "]" << std::endl;
            std::vector<std::string> tmp;
            //   std::cout << "u: " << parsedCsv[i][1] << std::endl;
            int u = stoi(parsedCsv[i][1]);
            // std::cout << "v: " << parsedCsv[i][2] << std::endl;
            int v = stoi(parsedCsv[i][2]);
            //  std::cout << "Starting " << std::endl;
            long totalTimeForSMIstd;
            long totalTimeForBD;

            double bd = CrystData::computeDistanceBetweenTwoClouds( matrices[u], matrices[v], totalTimeForSMIstd, totalTimeForBD);
            tmp.push_back(std::to_string(bd));
            tmp.push_back(std::to_string(totalTimeForSMIstd));
            tmp.push_back(std::to_string(totalTimeForBD));
            tmp.push_back(std::to_string(u));
            tmp.push_back(std::to_string(v));

//            for (int jj = 0; jj < tmp.size(); jj++)
//            {
//                std::cout << tmp[jj] << ", ";
//
//            }
//            std::cout << std::endl;
            outVector.push_back(tmp);
        }

        std::cout << "Outvector size: " << outVector.size() << std::endl;

    }

    void RunAfew(int x, int y, std::string inputCSV, std::string outbuddd)
    {
        std::vector<std::vector<std::string>> parsedCsv;
        this->parseCSV(parsedCsv, inputCSV);
        parsedCsv.erase(parsedCsv.begin());


        for (int i = x; i < y; i++)
        {
            int u = stoi(parsedCsv[i][1]);
            int v = stoi(parsedCsv[i][2]);
            long totalTimeForSMIstd;
            long totalTimeForBD;
            double bd = CrystData::computeDistanceBetweenTwoClouds( matrices[u], matrices[v], totalTimeForSMIstd, totalTimeForBD);
            std::cout << "Pair " << u << " --- " << v << " bd: " << bd << std::endl;


        }

        std::vector<std::vector<std::string>> outVector;
        limitedExperimentsRun(x, y,parsedCsv, outVector);
        printExperiments(outVector, "bd, timeSMI, timeBD", outbuddd);



    }

    void RunSpecial(std::string A, std::string B)
    {
        arma::mat kA;
        ReadFileIntoMatrix(A, kA);
        arma::mat kB;
        ReadFileIntoMatrix(B, kB);
        long totalTimeForSMIstd;
        long totalTimeForBD;
        double bd = CrystData::computeDistanceBetweenTwoClouds( kA, kB, totalTimeForSMIstd, totalTimeForBD);
        std::cout << "Time for SMI " << totalTimeForSMIstd << std::endl;
        std::cout << "Time for BD: " << totalTimeForBD << std::endl;
        std::cout << bd << std::endl;

    }


    void RunSingleWithAdditionalInformation(int ii, int jj, std::string outputpath)
    {
        std::ofstream out(outputpath);
        int u = ii;
        int v = jj;
        long totalTimeForSMIstd;
        long totalTimeForBD;
        double bdz;
        vector<std::string> outputpairs;
        double bd = CrystData::computeDistanceBetweenTwoClouds( matrices[u], matrices[v], totalTimeForSMIstd, totalTimeForBD, outputpairs);
        std::cout << "Time for SMI " << totalTimeForSMIstd << std::endl;
        std::cout << "Time for BD: " << totalTimeForBD << std::endl;
        std::cout << bd << std::endl;
        out << "[";
        for (int i = 0; i < outputpairs.size(); i++)
        {
            out << "[";
            out << outputpairs[i] ;
            if (i < outputpairs.size()-1)
            {
                out << "]," << std::endl;
            }
        }
        out << "]]" << std::endl;
        out.close();


    }

    void RunSingle(int ii, int jj)
    {
        int u = ii;
        int v = jj;
        long totalTimeForSMIstd;
        long totalTimeForBD;
        double bd = CrystData::computeDistanceBetweenTwoClouds( matrices[u], matrices[v], totalTimeForSMIstd, totalTimeForBD);
        std::cout << "Time for SMI " << totalTimeForSMIstd << std::endl;
        std::cout << "Time for BD: " << totalTimeForBD << std::endl;
        std::cout << bd << std::endl;



    }

    void computeSingleBD(int ii, int jj)
    {


        int u = ii;
        int v = jj;
        std::vector<int> matching;
        double bd = CrystData::computeEuclideanBottleneckDistanceBC( matrices[u], matrices[v],  matching);

        for (int i = 0; i < matching.size(); i++)
        {
            std::cout << i << " - " << matching[i] << std::endl;



        }

        std::cout << bd << std::endl;

    }

    void SimplifiedRun(std::string inputCsv, std::string outputCsv, std::string outputCsvLimited, int threads, int maxxnumm)
    {
        std::vector<std::thread> vec_thr;
        std::vector<std::vector<std::string>> parsedCSV;
        std::vector<std::vector<std::vector<std::string>>> vectorCollection(threads+1);
        parseCSV(parsedCSV, inputCsv);
        parsedCSV.erase(parsedCSV.begin());
        parsedCSV.resize(maxxnumm);
        double ukk = parsedCSV.size() / (double) threads;
        int be = floor(ukk);

        for (int i = 0; i < threads; i++)
        {
            // std::thread th();
            // limitedExperimentsRun(i*be, (i+1)*be, parsedCSV, vectorCollection[i]);
            vec_thr.emplace_back(&CrystDataExperiments::limitedExperimentsRunModi, this, i*be, (i+1)*be, std::ref(parsedCSV), std::ref(vectorCollection[i]) );

        }
        vec_thr.emplace_back(&CrystDataExperiments::limitedExperimentsRunModi, this, threads*be, parsedCSV.size(), std::ref(parsedCSV), std::ref(vectorCollection[threads]) );
        for(auto& t: vec_thr)
            t.join();

        //! std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, Molecule_A, Molecule_B";
        std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, PDD dist, Molecule_A, Molecule_B, NumAtoms, SDV dist";


        std::vector<std::vector<std::string>> finalString;

        for (int i = 0; i < vectorCollection.size(); i++)
        {
            finalString.insert(finalString.end(), vectorCollection[i].begin(), vectorCollection[i].end());
        }

        std::vector<std::vector<std::string>> finalStringOrig = finalString;

        std::sort(finalString.begin(), finalString.end(),
                  [](const std::vector<std::string> & a, const std::vector<std::string> & b) -> bool
        {
            double aa = stod(a[0]);
            double bb = stod(b[0]);
            return  aa < bb;
        });

        printExperiments(finalString, header, outputCsv);

        printExperiments(finalStringOrig, header, outputCsvLimited);



    }

    void RunThisSCD(std::string inputCsv, std::string outputCsv, std::string outputCsvLimited, int threads)
    {
        std::vector<std::thread> vec_thr;
        std::vector<std::vector<std::string>> parsedCSV;
        std::vector<std::vector<std::vector<std::string>>> vectorCollection(threads+1);
        parseCSV(parsedCSV, inputCsv);
        parsedCSV.erase(parsedCSV.begin());
        //parsedCSV.resize(maxxnumm);
        double ukk = parsedCSV.size() / (double) threads;
        int be = floor(ukk);

        for (int i = 0; i < threads; i++)
        {
            // std::thread th();
            // limitedExperimentsRun(i*be, (i+1)*be, parsedCSV, vectorCollection[i]);
            vec_thr.emplace_back(&CrystDataExperiments::limitedExperRun, this, i*be, (i+1)*be, std::ref(parsedCSV), std::ref(vectorCollection[i]));

        }
        vec_thr.emplace_back(&CrystDataExperiments::limitedExperRun, this, threads*be, parsedCSV.size(), std::ref(parsedCSV), std::ref(vectorCollection[threads]) );
        for(auto& t: vec_thr)
            t.join();

        std::string header ="Molecule_A, Molecule_B, NumAtoms, Hausdorff distance, BD (bottleneck distance), L_inf on SDV, EMD on PDD, SBM [not BD] on SMI, [ratio] SBM / BD, SMI time (ms), SBM time (ms), DBI, Invariant time (ms), Bd time (ms)";
        //! std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, PDD dist, Molecule_A, Molecule_B, NumAtoms, SDV dist";
        std::vector<std::vector<std::string>> finalString;


        for (int i = 0; i < vectorCollection.size(); i++)
        {
            finalString.insert(finalString.end(), vectorCollection[i].begin(), vectorCollection[i].end());

        }

        std::cout << "Total final string size " << finalString.size() << std::endl;

        std::vector<std::vector<std::string>> finalStringLimited = finalString;

        std::sort(finalString.begin(), finalString.end(),
                  [](const std::vector<std::string> & a, const std::vector<std::string> & b) -> bool
        {
            double aa = stod(a[7]);
            double bb = stod(b[7]);
            return  aa < bb;
        });

        long sumsd = 0;
        long sumbd = 0;
        long avgsd =0;
        long avgbd = 0;



        for (int i = 0; i < finalString.size(); i++)
        {
            sumsd = sumsd + stol(finalString[i][1]);
            sumbd = sumbd + stol(finalString[i][2]);
        }

        avgsd = sumsd / (double)finalString.size();
        avgbd = sumbd / (double)finalString.size();

        printExperiments(finalString, header, outputCsv);

        std::cout << "Total time SMI: " << sumsd << "milliseconds" << std::endl;
        std::cout << "Total time BD: " << sumbd << "milliseconds" << std::endl;
        std::cout << "Avg time SMI: " << avgsd<< "milliseconds" << std::endl;
        std::cout << "Avg time BD: " << avgbd << "milliseconds" << std::endl;


        // finalString;
        //finalStringLimited.resize(500);

        printExperiments(finalStringLimited, header, outputCsvLimited);




    }






    void RunThis(std::string inputCsv, std::string outputCsv, std::string outputCsvLimited, int threads, int maxxnumm)
    {
        std::vector<std::thread> vec_thr;
        std::vector<std::vector<std::string>> parsedCSV;
        std::vector<std::vector<std::vector<std::string>>> vectorCollection(threads+1);
        parseCSV(parsedCSV, inputCsv);
        parsedCSV.erase(parsedCSV.begin());
        parsedCSV.resize(maxxnumm);
        double ukk = parsedCSV.size() / (double) threads;
        int be = floor(ukk);
        // for (int i = 0; i < threads+1; i++)
        //   {
        //     std::vector<std::vector<std::string>> k();
        //     vectorCollection.push_back(k);

        //   }


        for (int i = 0; i < threads; i++)
        {
            // std::thread th();
            // limitedExperimentsRun(i*be, (i+1)*be, parsedCSV, vectorCollection[i]);
            vec_thr.emplace_back(&CrystDataExperiments::limitedExperimentsRun, this, i*be, (i+1)*be, std::ref(parsedCSV), std::ref(vectorCollection[i]) );

        }
        vec_thr.emplace_back(&CrystDataExperiments::limitedExperimentsRun, this, threads*be, parsedCSV.size(), std::ref(parsedCSV), std::ref(vectorCollection[threads]) );
        for(auto& t: vec_thr)
            t.join();

        std::string header ="Molecule_A, Molecule_B, NumAtoms, Hausdorff distance, BD (bottleneck distance), L_inf on SDV, EMD on PDD, SBM [not BD] on SMI, [ratio] SBM / BD, SMI time (ms), SBM time (ms)";
        //! std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, PDD dist, Molecule_A, Molecule_B, NumAtoms, SDV dist";
        std::vector<std::vector<std::string>> finalString;


        for (int i = 0; i < vectorCollection.size(); i++)
        {
            finalString.insert(finalString.end(), vectorCollection[i].begin(), vectorCollection[i].end());

        }

        std::cout << "Total final string size " << finalString.size() << std::endl;

        std::vector<std::vector<std::string>> finalStringLimited = finalString;

        std::sort(finalString.begin(), finalString.end(),
                  [](const std::vector<std::string> & a, const std::vector<std::string> & b) -> bool
        {
            double aa = stod(a[7]);
            double bb = stod(b[7]);
            return  aa < bb;
        });

        long sumsd = 0;
        long sumbd = 0;
        long avgsd =0;
        long avgbd = 0;



        for (int i = 0; i < finalString.size(); i++)
        {
            sumsd = sumsd + stol(finalString[i][1]);
            sumbd = sumbd + stol(finalString[i][2]);
        }

        avgsd = sumsd / (double)finalString.size();
        avgbd = sumbd / (double)finalString.size();

        printExperiments(finalString, header, outputCsv);

        std::cout << "Total time SMI: " << sumsd << "milliseconds" << std::endl;
        std::cout << "Total time BD: " << sumbd << "milliseconds" << std::endl;
        std::cout << "Avg time SMI: " << avgsd<< "milliseconds" << std::endl;
        std::cout << "Avg time BD: " << avgbd << "milliseconds" << std::endl;


        // finalString;
        //finalStringLimited.resize(500);

        printExperiments(finalStringLimited, header, outputCsvLimited);




    }

    void printExperiments(std::vector<std::vector<std::string>> & values, std::string header, std::string output)
    {

        std::ofstream out(output);
        out << header << std::endl;
        for (int i = 0; i < values.size(); i++)
        {
            for (int j = 0; j < values[i].size(); j++)
            {
                out << values[i][j];
                if (j  < values[i].size() - 1)
                {
                    out << ",";
                }

            }
            out << std::endl;

        }
        out.close();

    }


    void testRun(std::string inputCsv)
    {
        std::vector<std::vector<std::string>> parsedCsv;
        parseCSV(parsedCsv, inputCsv);
        for (int j = 0; j < parsedCsv[0].size(); j++)
        {
            std::cout << parsedCsv[0][j] << ", ";

        }
        std::cout << std::endl;
        std::cout << "Dimension: " << matrices[1000].n_rows << std::endl;

        std::cout << "Number of elems at 1000th elem: " << matrices[1000].n_cols << std::endl;


        for (int i = 1; i < parsedCsv.size(); i++)
        {
            int u = stoi(parsedCsv[i][1]);
            int v = stoi(parsedCsv[i][2]);
            int countU = matrices[u].n_cols;
            int countV = matrices[v].n_cols;
            if (countU != countV)
            {
                std::cout << "Error fixed at " << i << std::endl;
            }
            else
            {
                //    std::cout << "At " << i << " : " << countU << std::endl;


            }

        }


    }



    void parseCSV(std::vector<std::vector<std::string>> & parsedCsv, std::string input)
    {
        std::ifstream  data(input);
        std::string line;
        while(std::getline(data,line))
        {
            std::stringstream lineStream(line);
            std::string cell;
            std::vector<std::string> parsedRow;
            while(std::getline(lineStream,cell,','))
            {
                parsedRow.push_back(cell);
            }

            parsedCsv.push_back(parsedRow);
        }

    }

    void ReadFileIntoMatrix(std::string fname, arma::mat & matt)
    {


        //  std::cout << "Beggining to read" << std::endl;

        vector<vector<string>> content;
        vector<string> row;
        string line, word;

        fstream file (fname, ios::in);
        if(file.is_open())
        {
            while(getline(file, line))
            {
                row.clear();

                stringstream str(line);

                while(getline(str, word, ','))
                    row.push_back(word);
                content.push_back(row);
            }
        }
        //  std::cout << content.size() << std::endl;
        matt.resize(3,content.size()-1);
        //  std::cout << "Matt cols : " << matt.n_cols << std::endl;
        // std::cout << "Matt rows : " << matt.n_rows << std::endl;

        for(int i=1; i<content.size(); i++)
        {
            for(int j=0; j<content[i].size(); j++)
            {
                matt.col(i-1)(j) = std::stod(content[i][j]);
            }
            // cout<<"\n";
        }
    }




protected:

private:
    std::vector<arma::mat> matrices;
};

#endif // CRYSTDATAEXPERIMENTS_H
