#ifndef SCDCUSTOM_H
#define SCDCUSTOM_H

//#include "VectorSort.h"

class SCDCustom
{
public:
    SCDCustom(double c):constC(c) {}

    double ComputeStrength(std::vector<int> & input, std::vector<std::vector<double>> & graph)
    {

        arma::mat caylerMenger(input.size()+1, input.size()+1);
        caylerMenger(0,0) = 0;
        for (int i = 1; i < caylerMenger.n_cols; i++)
        {
            caylerMenger(caylerMenger.n_rows-1,i) = 1;
            caylerMenger(i,caylerMenger.n_cols-1) = 1;
        }
        double halfsumofdistances = 0;
        for (int i = 0; i < caylerMenger.n_cols-1; i++)
        {
            for (int j = 0; j < caylerMenger.n_rows-1; j++)
            {
                double tmpdist = graph[input[i]][input[j]];
                //!arma::norm(input.col(i)-input.col(j),2);
                caylerMenger(j,i) = tmpdist * tmpdist;
                halfsumofdistances = halfsumofdistances + tmpdist;
            }
        }
        halfsumofdistances  = halfsumofdistances / 4;


        double dt = arma::det(caylerMenger);
        double multiplier = (double) pow(-1, input.size()+1) / ((double) pow(2,input.size()) * (double) pow(tgamma(input.size()+1),2.0));
        double tmpdt = multiplier * dt;



        return tmpdt * tmpdt / (double) pow(halfsumofdistances,2*(input.size()-1)-1);

    }


    void ProduceOCD( arma::mat & selectedPoints, arma::mat & notselectedpoints, arma::mat & ocdCloud,std::vector<std::vector<double>> & graph, std::vector<int> & combos, std::vector<int> & counterCombos, int NumPoints, std::ofstream & off)
    {
        ocdCloud.resize(selectedPoints.n_cols+2,notselectedpoints.n_cols);
        arma::vec origin(selectedPoints.n_rows, arma::fill::zeros);

        for (int j = 0; j < notselectedpoints.n_cols; j++)
        {
            arma::mat finalDeterminant(selectedPoints.n_rows, selectedPoints.n_rows);
            for (int i = 0 ; i < selectedPoints.n_cols; i++)
            {

                double dist = graph[counterCombos[j]][combos[i]];
                finalDeterminant.col(i) = notselectedpoints.col(j)-selectedPoints.col(i);
                ocdCloud(i,j) = dist;
            }
            double tmpdist = graph[graph.size()-1][counterCombos[j]];

            //  arma::norm(origin-notselectedpoints.col(j));

            ocdCloud(selectedPoints.n_cols,j) = tmpdist;
            finalDeterminant.col(selectedPoints.n_rows-1) = notselectedpoints.col(j);

            double dett = arma::det(finalDeterminant);
            double answer = 0;
            if (dett < 0)
            {
                answer = -1;
            }
            if (dett > 0)
            {
                answer = +1;

            }


            std::vector<int> volumeObj;




            // arma::mat volumeObj(selectedPoints.n_rows, selectedPoints.n_cols + 2, arma::fill::zeros);


            for (int a = 0; a < combos.size(); a++)
            {
                //!volumeObj.col(a) = selectedPoints.col(a);
                volumeObj.push_back(combos[a]);
            }

            volumeObj.push_back(counterCombos[j]);
            volumeObj.push_back(graph.size()-1);

            //!volumeObj.col(selectedPoints.n_cols) = notselectedpoints.col(j);


            double strengthh = ComputeStrength(volumeObj, graph);
            off << "Selected points : " << std::endl;
            off <<  selectedPoints << std::endl;
            off << "Strength computed as : " << strengthh << std::endl;

            ocdCloud(selectedPoints.n_cols+1,j)=answer/this->constC * strengthh;

        }
    }



    void generateCombos(int n, int k,std::vector<std::vector<int>> & res)
    {
        //int n = cloudA.size();
        //int k = constants::Dim - 1;
        vector<int> temp(k,0);
        CrystData::find_comb(res,temp,0,0,n,k);

    }



    void ProduceDistanceMat(arma::mat & distMat, std::vector<std::vector<double>> & graph, std::vector<int> & combos, int numPoints)
    {
        distMat.resize(combos.size() + 1, combos.size() + 1);
        // arma::vec origin(dimm, arma::fill::zeros);
        for (int i  = 0; i < combos.size(); i++)
        {
            double dist1 = graph[combos[i]][graph.size()-1];

//            arma::norm(origin-selectedPoints.col(i),2);
//            if (graph[numPoints][combos[i]] == false)
//            {
//                dist1 = dist1 * -1;
//
//
//            }
            distMat(combos.size(),i) = dist1;
            distMat(i,combos.size()) = dist1;
            for (int j = 0; j < combos.size(); j++)
            {
                //  double dist = arma::norm(selectedPoints.col(i)-selectedPoints.col(j));
                //  if (graph[combos[j]][combos[i]] == false)
                //  {
                //    dist = dist* -1;
                //   }
                distMat(j,i) = graph[combos[j]][combos[i]];
            }
        }

    }


    void selectMatrix(std::vector<int> & indices, arma::mat & input, arma::mat & output)
    {
        output.resize(input.n_rows, indices.size());
        for (int i = 0; i < indices.size(); i++)
        {
            output.col(i) = input.col(indices[i]);
        }

    }
    void theOthetMatrix(std::vector<int> & indices, std::vector<int> & counterCombos, arma::mat & input, arma::mat & output)
    {
        set<int> s(indices.begin(), indices.end());
        output.resize(input.n_rows, input.n_cols - indices.size());
        int j = 0;
        for (int i = 0 ; i < input.n_cols ; i++)
        {
            if (s.find(i) == s.end())
            {
                counterCombos.push_back(i);
                output.col(j) = input.col(i);
                j++;
            }
        }


    }





    void ConstructAllSRCombos(arma::mat & cloud, std::vector<std::vector<int>> & combos, std::vector<arma::mat> & OCDCloudCollection,
                              std::vector<arma::mat> & distMatrixCollection, std::vector<std::vector<double>> & graph, std::ofstream & off )
    {

        for (int i = 0; i < combos.size(); i++)
        {
            //  std::cout << "Staritng combo " << i << std::endl;


            arma::mat selectedPoints;
            arma::mat notSelectedpoints;



            //!std::vector<int> notSelectedpoints;

            //CrystData::ConstructSRCloud(cloud,basisCollection,combos[i],SrCloud);
            // CrystData::ConstructDistanceMatrix(basisCollection,DistMat);
            std::vector<int> counterCombos;
            // std::cout << "Selecting matrices" << std::endl;
            this->selectMatrix(combos[i],cloud,selectedPoints);
            this->theOthetMatrix(combos[i],counterCombos,cloud,notSelectedpoints);
            arma::mat ocdCloud;
            arma::mat distMat;
            // std::cout << "Matrix selection succesful" << std::endl;
            off << "Combo: " << i << std::endl;
            this->ProduceOCD(selectedPoints,notSelectedpoints,ocdCloud, graph, combos[i], counterCombos, cloud.n_cols, off);
            // std::cout << "Produce OCD succeful" << std::endl;
            this->ProduceDistanceMat(distMat, graph, combos[i], cloud.n_cols);
            //std::cout << "Produce distMat succesful" << std::endl;


            OCDCloudCollection.push_back(ocdCloud);
            distMatrixCollection.push_back(distMat);

        }



    }

    void centralizeAndComputeRadius(arma::mat & cloudIN, arma::mat & cloudOUT)
    {
        double sizeofcloudin = cloudIN.n_cols;
        //std::cout << "Size of cloud in: " << sizeofcloudin << std::endl;
//!        std::vector<double> centroid(cloudIN[0].size());
        arma::vec centroid(cloudIN.n_rows);
        double radius = 0;
        for (int i = 0; i < cloudIN.n_cols; i++)
        {
            arma::vec tmpZ =  cloudIN.col(i);
            centroid = centroid + tmpZ;
        }
        double division = -1/sizeofcloudin;
        //  std::cout << "Division size: " << division << std::endl;
        // std::cout << "Centroid: "  << centroid[0] << ", " << centroid[1] << ", " << centroid[2] << std::endl;
        centroid = division * centroid;
        //vectorTools::vectorScalarMultiplication(centroid,division);
        //   std::cout << "Centroid: "  << centroid[0] << ", " << centroid[1] << ", " << centroid[2] << std::endl;
        cloudOUT = cloudIN;
        for (int i = 0; i < cloudOUT.n_cols; i++)
        {
            //     std::cout << "cloudOut: "  << cloudOUT[i][0] << ", " << cloudOUT[i][1] << ", " << cloudOUT[i][2] << std::endl;
            //vectorTools::vectorAddition(cloudOUT[i], centroid);
            arma::vec blablaz = cloudIN.col(i);
            arma::vec tmpd = blablaz + centroid;
            cloudOUT.col(i) = tmpd;
            //   std::cout << "cloudOut: (After addition) "  << cloudOUT[i][0] << ", " << cloudOUT[i][1] << ", " << cloudOUT[i][2] << std::endl;
            // radius = std::max(radius, sqrt(vectorTools::SquaredNorm(cloudOUT[i])));
        }
        //!return radius;
    }

    void permuteMatrix(arma::mat & input, arma::mat & output, std::vector<int> & permutation)
    {


        output.resize(input.n_rows,input.n_cols);


//        for (int i = 0; i < permutation.size(); i++)
//        {
//            output.row(permutation[i]) = input.row(i);
//
//
//        }

        for (int i = 0; i < input.n_rows; i++)
        {
            for (int j = 0; j < input.n_cols; j++)
            {
                output(permutation[i],permutation[j]) = input(i,j);
            }

        }
    }
    void PermuteRowAndReorder(arma::mat & input, arma::mat & output, std::vector<int> & permutation, int sign)
    {

        arma::mat tmpStep;
        tmpStep.resize(input.n_rows,input.n_cols);
        for (int i = 0; i < permutation.size(); i++)
        {
            tmpStep.row(permutation[i]) = input.row(i);
        }
        // for (int i = 0; i < tmpStep.n_cols; i++)
        //  {
        //      tmpStep(tmpStep.n_rows-1, i) = sign * tmpStep(tmpStep.n_rows-1, i);
        //   }
        //  this->LexiographicOrdering(tmpStep, output);
    }

    static double ComputeEasyBottleneckDistanceBetweenClouds(arma::mat & dataA, arma::mat & dataB)
    {
        //! form distance matrix
        std::vector<std::vector<double>> distances(dataA.n_cols, std::vector<double>(dataB.n_cols));
        for (int i =0 ; i < dataA.n_cols; i++)
        {
            for (int j =  0; j < dataB.n_cols; j++)
            {
                //distances[i][j] = vectorTools::linfinity(dataA[i],dataB[j]);
                arma::vec X = dataA.col(i);
                arma::vec Y = dataB.col(j);
                arma::vec zzz = X - Y;
                double y = arma::norm(zzz, "inf");
                distances[i][j] = y;



            }


        }
        Bipartie_Graph g(distances);
        std::vector<int> matching;
        double dist = BottleneckCalculator::bottleneck_distance_exact_with_matching<Bipartie_Graph,GraphTreeController>(g,matching);
        // CrystData::PrintVector<int>(matching);
        return dist;



    }

    double computeLInftyDistance(arma::mat & dataA, arma::mat & dataB)
    {
        double Maxx = 0;
        for (int i = 0; i < dataA.n_rows; i++)
        {
            for (int j = 0; j < dataA.n_cols; j++)
            {

                double distt = std::abs(dataA(i,j) - dataB(i,j));
                Maxx = std::max(distt, Maxx);
            }
        }
        return Maxx;

    }

    double ComputeDistance(arma::mat & cloudAunc, arma::mat & cloudBunc, std::vector<std::vector<double>> & graphA, std::vector<std::vector<double>> & graphB, std::vector<int> & matching,
                           std::vector<std::vector<int>> & res, long & totalTimeForSMI, long & totalTimeForBD, std::string debugPath)
    {


        //!std::string outputpath = "/home/yury/debug/dbg_special_three.txt";
        //   std::string outputpathSpecial = "/home/yury/debug/dbgSpecial.txt";

        std::ofstream out(debugPath);

        out << "First cloud before centering: " << std::endl;
        out << cloudAunc << std::endl;
        out << "Second cloud before centering: " << std::endl;
        out << cloudBunc << std::endl;

        arma::mat cloudA;

        arma::mat cloudB;
        //! Center the point cloud

        centralizeAndComputeRadius(cloudAunc, cloudA);

        centralizeAndComputeRadius(cloudBunc, cloudB);




        out << "Starting to write" << std::endl;
        // std::ofstream outSpecial(outputpathSpecial);
        out << "X DIMENSION: " << cloudA.n_cols << std::endl;
        //  std::cout << "Computation started " << std::endl;
        int n = cloudA.n_cols;
        int k = cloudA.n_rows - 1;
        vector<int> temp(k,0);
        CrystData::find_comb(res,temp,0,0,n,k);
        std::vector<arma::mat> distA;
        std::vector<arma::mat> distB;
        std::vector<arma::mat> ocdA;
        std::vector<arma::mat> ocdB;
        out << "First cloud: " << std::endl;
        out << cloudA << std::endl;
        out << "Second cloud: " << std::endl;
        out << cloudB << std::endl;
        out << "Graph A dimensions: (" << graphA.size() << ", " << graphA[0].size() << ")" << std::endl;
        out << "Graph B dimensions: (" << graphB.size() << ", " << graphB[0].size() << ")" << std::endl;
        ///  std::cout << "Starting CloudA:" << std::endl;
        time_point<Clock> start = Clock::now();
        out << "Construct all for A ======================================" << std::endl;
        ConstructAllSRCombos(cloudA, res, ocdA, distA, graphA, out);
        //   std::cout << "Starting CloudB:" << std::endl;
        out << "Construct all for B ======================================" << std::endl;
        ConstructAllSRCombos(cloudB, res, ocdB, distB, graphB, out);
        time_point<Clock> endd = Clock::now();
        milliseconds diff = duration_cast<milliseconds>(endd - start);
        totalTimeForSMI = diff.count();
        //   std::cout << "Block A,B passed" << std::endl;
        // std::cout << ocdA.size
        std::string path = "/home/yury/debug/";
        time_point<Clock> startTwo = Clock::now();
        std::vector<std::vector<double>> distMatrix(res.size(),std::vector<double>(res.size()));
        for (int i = 0; i < res.size(); i++)
        {
            for (int j = 0; j < res.size(); j++)
            {

                out << "Itearting over combination " << i << " , " << j << std::endl;
                out << "( ";
                for (int ii = 0; ii < res[i].size(); ii++)
                {
                    out << res[i][ii] << ", ";
                }
                out << " ) - ( ";
                for (int jj = 0; jj < res[j].size(); jj++)
                {
                    out << res[j][jj] << ", ";


                }
                out << " )" << std::endl;
                out << "original matrices: " << std::endl;
                arma::mat normalizeddistA = distA[i];
                arma::mat normalizeddistB = distB[j];
                arma::mat normalizedocdA = ocdA[i];
                arma::mat normalizedocdB = ocdB[j];

                out << "Normalized dist A: " << std::endl;
                out << normalizeddistA << std::endl;
                out << "Normalized doc A: " << std::endl;
                out << normalizedocdA << std::endl;


                out << "Normalized dist B: " << std::endl;
                out << normalizeddistB << std::endl;
                out << "Normalized doc B: " << std::endl;
                out << normalizedocdB << std::endl;


                //double radmultiplierA = (1/radA);
                //double radmultiplierB = (1/radB);
                //  vectorTools::MatrixScalarMultiplicationSpecial(normalizedSrA, radmultiplierA);
                // vectorTools::MatrixScalarMultiplication(normalizedSdA, radmultiplierA);
                // vectorTools::MatrixScalarMultiplicationSpecial(normalizedSrB, radmultiplierB);
                // vectorTools::MatrixScalarMultiplication(normalizedSdB, radmultiplierB);
                std::vector<int> selectB;
                //  std::cout << "Mid point" << std::endl;
                for (int ij = 0; ij < k; ij++ )
                {
                    selectB.push_back(ij);
                }
                // std::cout << "HALF WAY THERE" << std::endl;
                //  std::cout << "Size of selectB:" << selectB.size() << std::endl;
                double dist = std::numeric_limits<double>::max();
                int perm = 0;
                do
                {
                    std::vector<int> permuteTmp = selectB;
                    int sign = vectorTools::permutationSign(permuteTmp);
                    out   << "Pemurtation: " << perm << std::endl;

                    //  std::vector<int> permutation = selectB;

                    //    std::cout << "Proeceding ...." << std::endl;
                    //  int sign = vectorTools::permutationSign(permutation);
                    // permutation.push_back(constants::Dim-1);

                    arma::mat normalizeddistBperm;
                    arma::mat normalizeddocdBperm;

                    permuteTmp.push_back(selectB.size());



                    permuteMatrix(normalizeddistB, normalizeddistBperm, permuteTmp);




//                       if ((i == 3) && (j == 3))
//                    {
//                    outSpecial << "Before" << std::endl;
//                    outSpecial << normalizeddistB << std::endl;
//                    outSpecial << "After" << std::endl;
//                    outSpecial << normalizeddistBperm << std::endl;
//                    outSpecial << "Result" << std::endl;
//                    for (int aaa = 0; aaa < permuteTmp.size(); aaa++)
//                    {
//                        outSpecial << permuteTmp[aaa] << ", ";
//
//
//                    }
//                    outSpecial << std::endl;
//
//                    }

                    permuteTmp.push_back(selectB.size()+1);
                    PermuteRowAndReorder(normalizedocdB, normalizeddocdBperm, permuteTmp, sign);

                    //selectB.push_back()
                    //
                    //  cout << "other stuff done" << endl;
                    // CrystData::PrintVector<int> (permutation);
                    //  CrystData::PrintMatrix(normalizedSdB);
                    //!  vectorTools::permuteMatrix(normalizedSdB, normalizedSdBperm, permutation);
                    //    std::cout << "matrix permuted" << endl;
                    //!  vectorTools::PermuteRowsAndMultiplyLastColumn(normalizedSrB, normalizedSrBperm, sign, permutation);

                    //     std::cout << "Permutation ready" << std::endl;
                    //   if ((i == 0) && (j == 0))
                    //  {
                    //!CrystData::PrintMatrixToFile(normalizedSrA, "/home/yury/LocalProjects/OutputS/Performance/matrixA.csv");
                    //!CrystData::PrintMatrixToFile(normalizedSrBperm, "/home/yury/LocalProjects/OutputS/Performance/matrixB.csv");



                    // }


                    out << "Normalized doc B " << std::endl;
                    out << normalizeddocdBperm << std::endl;
                    out << "Normalized dist B: " << std::endl;
                    out << normalizeddistBperm << std::endl;

                    std::string Afn = path + "A" + std::to_string(i) + std::to_string(j) + std::to_string(perm) + ".txt";
                    // std::string Bfn = path + "B" + std::to_string(i) + std::to_string(j) + std::to_string(perm) + ".txt";
                    //!double distBDnormalPerm = ComputeBottleNeckdistance(normalizedocdA, normalizeddocdBperm, Afn);
                    double distBDnormalPerm = ComputeEasyBottleneckDistanceBetweenClouds(normalizedocdA, normalizeddocdBperm);

                    //   std::cout << "Bottleneck computed " << std::endl;
//                    if ((i == 3) && (j == 3))
//                    {
//                        outSpecial << "Permutation: " << perm << std::endl;
//                        outSpecial << "Matrices for bottleneck" << std::endl;
//                        outSpecial << normalizedocdA << std::endl;
//                        outSpecial << normalizeddocdBperm << std::endl;
//                        outSpecial << "Bottleneck distance: " << distBDnormalPerm << std::endl;
//                    }

                    out << "Bottleneck distance: " << distBDnormalPerm << std::endl;

                    double distSDnormalPerm = computeLInftyDistance(normalizeddistA, normalizeddistBperm);

                    //   std::cout << "SD computed" << std::endl;
                    out << normalizeddistBperm << std::endl;
//                    if ((i == 3) && (j == 3))
//                    {
//                        outSpecial << "Matrices for LInfty" << std::endl;
//                        outSpecial << normalizeddistA << std::endl;
//                        outSpecial << normalizeddistBperm << std::endl;
//                        outSpecial << "SD distance " << distSDnormalPerm << std::endl;
//                    }

                    out << "SD distance " << distSDnormalPerm << std::endl;
                    double permute = std::max(distBDnormalPerm, distSDnormalPerm);
                    // double permute = std::max(distBDnormalPerm, distSDnormalPerm);
                    dist = std::min(dist,permute);
                    out << "Iterating over: " << i << ", " << j << ", " << perm << ": " << " BDDist: " << distBDnormalPerm  << ", SDDist: " << distSDnormalPerm << std::endl;
                    out << "Permutation vector: ";
                    for (int kkk = 0; kkk < permuteTmp.size(); kkk++)
                    {
                        out <<permuteTmp[kkk] << ", ";


                    }
                    out << std::endl;
                    perm = perm + 1;
                }
                while (next_permutation(selectB.begin(), selectB.end()));
                out << "----------" << std::endl;
                //    std::cout << "Vector A: " << std::endl;
                //     printComposition(res[i],mappingA);
                //    std::cout << "Vector B: " << std::endl;
                //   printComposition(res[j],mappingB);
                //     std::cout << "==================== So as dist we got " << dist << std::endl;
                distMatrix[i][j] = dist;


            }
        }
        for (int i = 0; i < distMatrix.size(); i++)
        {
            for (int j = 0; j < distMatrix[0].size(); j++)
            {
                out << "Combination (" << i << " , " << j << ") --- ";
                out << "( ";
                for (int ii = 0; ii < res[i].size(); ii++)
                {
                    out << res[i][ii] << ", ";
                }
                out << " ) - ( ";
                for (int jj = 0; jj < res[j].size(); jj++)
                {
                    out << res[j][jj] << ", ";


                }
                out << " ): " << distMatrix[i][j] << std::endl;



            }
        }
        Bipartie_Graph g(distMatrix);

        double dist = BottleneckCalculator::bottleneck_distance_exact_with_matching<Bipartie_Graph,GraphTreeController>(g, matching);



        time_point<Clock> enddTwo = Clock::now();
        milliseconds diffTwo = duration_cast<milliseconds>(enddTwo - startTwo);
        totalTimeForBD = diffTwo.count();

        std::vector<std::string> outputpairs;

        std::vector<std::vector<int>> combos = res;


        for (int i = 0; i < combos.size(); i++)
        {

            string line = "";
            for (int j = 0; j < combos[i].size(); j++)
            {
                //   std::cout << "Itearting over (A) " << i << " , " << j << std::endl;
                //  std::cout << combos[i][j] << std::endl;

                line = line + std::to_string(combos[i][j]);

                if (j < combos[i].size() - 1)
                {
                    line = line  + ", ";
                }


            }
            line = line + ",";
            for (int j = 0; j < combos[i].size(); j++)
            {
                //      std::cout << "Itearting over (B)" << i << " , " << j << std::endl;
                //   std::cout << combos[i][j] << std::endl;
                if (j < combos.size() - 1)
                {
                    line = line + std::to_string(combos[matching[i]][j]);
                }
                if (j < combos[i].size() - 1)
                {
                    line = line +  ", ";

                }


            }
            line = line;

            outputpairs.push_back(line);
        }

        out << "========================" << std::endl;
        for (int i = 0; i < outputpairs.size(); i++)
        {

            out << outputpairs[i] << std::endl;

        }
        out.close();



        // outSpecial.close();
        return dist;






    }

protected:

private:
    double constC;
};

#endif // SCDCUSTOM_H
