#ifndef SCDEXPERIMENTSRUNNER_H
#define SCDEXPERIMENTSRUNNER_H


//! THIS IS experimental code

#include <string>
#include <iostream>
#include <filesystem>
#include <SCD.h>
namespace fs = std::filesystem;
using namespace std;


class SCDExperimentsRunner
{
public:

    SCDExperimentsRunner(int i)
    {

    }





    SCDExperimentsRunner(std::string xyzFiles, std::string graphFiles)
    {

        std::set<fs::path> sorted_by_name;

        for (auto &entry : fs::directory_iterator(xyzFiles))
            sorted_by_name.insert(entry.path());


        for (auto &filename : sorted_by_name)
        {
            std::string opp = filename.c_str();
            std::cout << filename.c_str() << std::endl;
            // std::vector<std::string> strings;
            // customSplit(opp, '/', strings);
            // std::string finall = strings[strings.size()-1];
            // out << "Finall (standard): " << finall << std::endl;
            // out << "Read path (standard): " << opp<< std::endl;
            //  out << "========" << std::endl;
            //   std::cout << opp << std::endl;
            arma::mat k;
            ReadFileIntoMatrix(opp, k);
            matrices.push_back(k);
            //!epicMap[finall] = k;

        }

        std::cout << "Finnished u pwith matrices " << std::endl;

        sorted_by_name = std::set<fs::path>();

        //  std::set<fs::path> sorted_by_name_graph;

        for (auto &entry : fs::directory_iterator(graphFiles))
            sorted_by_name.insert(entry.path());
        bool bam = true;



        std::cout << "Starting graphgs " << std::endl;

        for (auto &filename : sorted_by_name)
        {
            if (bam)
            {
                std::string opp = filename.c_str();
                std::cout << filename.c_str() << std::endl;
                std::vector<std::vector<bool>> graph;
                std::vector<std::vector<bool>> graphTmp;
                //!arma::mat k;
                //!ReadFileIntoMatrix(opp, k);
                ReadGraphFileIntoMatrix(opp, graphTmp);
                tableExpansion(graphTmp, graph);


                graphs.push_back(graph);

                //!epicMap[finall] = k;
            }

        }
//
//        std::cout << "Finnished up everything" << std::endl;

    }

//    SCDExperimentsRunner(std::string xyzFiles, std::string graphFiles)
//    {
//        std::ofstream out("/home/yury/LocalProjects/XYZProject/FINALOUTPUTS/debug.txt");
//
//
//
//
//
//        for (const auto & entry : fs::directory_iterator(xyzFiles))
//        {
//            std::string opp = entry.path();
//            std::cout << entry.path() << std::endl;
//            arma::mat k;
//            std::vector<std::string> strings;
//            customSplit(opp, '/', strings);
//            std::string finall = strings[strings.size()-1];
//            // out << "Finall (standard): " << finall << std::endl;
//            // out << "Read path (standard): " << opp<< std::endl;
//            //  out << "========" << std::endl;
//            ReadFileIntoMatrix(opp, k);
//            epicMap[finall] = k;
//
//
//
//        }
//
//        std::cout << "Switching to graphs " << std::endl;
//
//        for (const auto & entry : fs::directory_iterator(graphFiles))
//        {
//            std::string opp = entry.path();
//            std::cout << entry.path() << std::endl;
//            std::vector<std::vector<bool>> k;
//            std::vector<std::string> strings;
//            customSplit(opp, '/', strings);
//            std::string finall = strings[strings.size()-1];
//            out << "Finall (Graph files) : " << finall << std::endl;
//            out << "Read path (Graph files): " << opp<< std::endl;
//
//            ReadGraphFileIntoMatrix(opp, k);
//            out << "Dimensions: " << k.size() << " , " << k[0].size() << std::endl;
//            out << "========" << std::endl;
//
//            graphMap[finall] = k;
//            //epicMap[finall] = k;
//
//
//
//        }
//        std::cout << "Read succeseful" << std::endl;
//        out.close();
//
//
//    }

    void customSplit(string str, char separator, std::vector<std::string> & strings)
    {
        int startIndex = 0, endIndex = 0;
        for (int i = 0; i <= str.size(); i++)
        {

            // If we reached the end of the word or the end of the input.
            if (str[i] == separator || i == str.size())
            {
                endIndex = i;
                string temp;
                temp.append(str, startIndex, endIndex - startIndex);
                strings.push_back(temp);
                startIndex = endIndex + 1;
            }
        }
    }

    void ReadFileIntoMatrix(std::string fname, arma::mat & matt)
    {


        //  std::cout << "Beggining to read" << std::endl;

        vector<vector<string>> content;
        vector<string> row;
        string line, word;

        fstream file (fname, ios::in);
        if(file.is_open())
        {
            while(getline(file, line))
            {
                row.clear();

                stringstream str(line);

                while(getline(str, word, ','))
                    row.push_back(word);
                content.push_back(row);
            }
        }
        //  std::cout << content.size() << std::endl;
        matt.resize(3,content.size()-1);
        //  std::cout << "Matt cols : " << matt.n_cols << std::endl;
        // std::cout << "Matt rows : " << matt.n_rows << std::endl;

        for(int i=1; i<content.size(); i++)
        {
            for(int j=0; j<content[i].size(); j++)
            {
                matt.col(i-1)(j) = std::stod(content[i][j]);
            }
            // cout<<"\n";
        }
    }

    void ReadGraphFileIntoMatrix(std::string fname, std::vector<std::vector<bool>> & matt)
    {



        vector<vector<string>> content;
        vector<string> row;
        string line, word;
        bool skipfirstt = true;
        fstream file (fname, ios::in);
        if(file.is_open())
        {
            while(getline(file, line))
            {
                if (skipfirstt == true)
                {
                    skipfirstt = false;
                    continue;

                }
                row.clear();

                stringstream str(line);

                while(getline(str, word, ','))
                    row.push_back(word);
                content.push_back(row);
            }
        }
        matt = std::vector<std::vector<bool>>(content.size(),std::vector<bool>(content[0].size() - 1, false));
        //  std::cout << "Content size: " << content.size() << ", " <<content[0].size() << std::endl;
        // std::cout << "matt size " << matt.size() << std::endl;

        //    std::cout << "Matt cols : " << matt.n_cols << std::endl;
//       std::cout << "Matt rows : " << matt.n_rows << std::endl;

        for(int i=0; i<content.size(); i++)
        {
            for(int j=1; j<content[i].size(); j++)
            {
                // std::cout << content[i][j] << ", ";
                // std::cout << "(i,j)" << i << ", " << j << std::endl;
                if (std::stoi(content[i][j]) == 1)
                {
                    matt[i][j-1] = true;
                }
                else
                {
                    matt[i][j-1] = false;

                }
            }
            //std::cout << std::endl;
            // std::cout << " ========================= " << std::endl;
            // cout<<"\n";
        }
        //  std::cout << "Saved up succesfully" << std::endl;
    }

    void readPairs(std::vector<std::vector<std::string>> & stringPairs, std::string fname)
    {

        vector<vector<string>> content;
        vector<string> row;
        string line, word;

        fstream file (fname, ios::in);
        if(file.is_open())
        {
            while(getline(file, line))
            {
                row.clear();

                stringstream str(line);

                while(getline(str, word, ','))
                    row.push_back(word);
                content.push_back(row);
            }
        }
        stringPairs = std::vector<std::vector<std::string>>(content.size() - 1,std::vector<std::string>(2));

        // std::cout << "Matt cols : " << matt.n_cols << std::endl;
        // std::cout << "Matt rows : " << matt.n_rows << std::endl;

        for(int i=1; i<content.size(); i++)
        {
            for(int j=1; j<content[i].size(); j++)
            {

                stringPairs[i-1][j-1] = content[i][j];
            }
            // cout<<"\n";
        }



    }

    void tableExpansion(std::vector<std::vector<bool>> & graphA, std::vector<std::vector<bool>> & graphOut)
    {
        // std::cout << "Table expansion started " << std::endl;
        // std::cout << "GraphA[0,0] " << graphA[0][0] << std::endl;
        // std::cout << "Graph A size: " << graphA.size() << std::endl;
        //std::cout << "Graph A size: " << graphA[0].size() << std::endl;
        //     for (int i = 0; i < graphA.size(); i++)
        //   {
        //       for (int j = 0; j < graphA[0].size(); j++)
        //      {
        // std::cout << i  << " , " << j << std::endl;
        //          std::cout << graphA[i][j] << ", ";
        //      }
        //     std::cout << std::endl;



        //  }
        graphOut = std::vector<std::vector<bool>>(graphA.size()+1, std::vector<bool>(graphA[0].size()+1, true));
        for (int i = 0; i < graphA.size(); i++)
        {
            for (int j = 0; j < graphA[0].size(); j++)
            {
                // std::cout << i  << " , " << j << std::endl;
                graphOut[i][j] = graphA[i][j];
            }



        }
        //  std::cout << "Table expansion ended " << std::endl;

    }

    double runFirst(std::string inputCsv, int i)
    {
        SCD lap(0.43);

        std::vector<std::vector<std::string>> parsedCsv;
        parseCSV(parsedCsv, inputCsv);
        parsedCsv.erase(parsedCsv.begin());

        int u = stoi(parsedCsv[i][1])-1;
            // std::cout << "v: " << parsedCsv[i][2] << std::endl;
        int v = stoi(parsedCsv[i][2])-1;

        std::cout << "A : " << u << std::endl;
        std::cout << "B : " << v << std::endl;

        long totalTimeForSMIstd;
        long totalTimeForBD;
        std::vector<int> matching;
        std::vector<std::vector<int>> res;
        double bd = 0;

        std::cout << "A: Num: " << matrices[u].n_cols << std::endl;
        std::cout << "B: Num: " << matrices[v].n_cols << std::endl;
        std::cout << "Graph A : " << graphs[u].size() << ", " << graphs[u][0].size() << std::endl;
        std::cout << "Graph B : " << graphs[v].size() << ", " << graphs[v][0].size() << std::endl;


        std::cout << "Graph A " << std::endl;
        for (int ii = 0; ii < graphs[u].size(); ii++)
        {
            for (int j = 0; j < graphs[u][0].size(); j++)
            {
                std::cout << graphs[u][ii][j] << ", ";
            }
            std::cout << std::endl;
        }
                std::cout << "Graph B " << std::endl;
        for (int ii = 0; ii < graphs[v].size(); ii++)
        {
            for (int j = 0; j < graphs[v][0].size(); j++)
            {
                std::cout << graphs[v][ii][j] << ", ";
            }
            std::cout << std::endl;
        }



        bd = lap.ComputeDistance(matrices[u], matrices[v], graphs[u], graphs[v], matching, res, totalTimeForSMIstd, totalTimeForBD);

        std::cout << "Bottleneck computed as : " << bd << std::endl;

        std::vector<std::vector<bool>> graphA(matrices[u].n_cols+1, std::vector<bool>(matrices[u].n_cols+1, true));
        std::vector<std::vector<bool>> graphB = graphA;

        double bda = lap.ComputeDistance(matrices[u], matrices[v], graphA, graphB, matching, res, totalTimeForSMIstd, totalTimeForBD);

        std::cout << "Complete graph bottleneck distance computed as : " << bda << std::endl;

        return bd;


    }

    double SingleRun(std::string cloudpathA, std::string cloudpathB, std::string graphpathA, std::string graphpathB )
    {

        arma::mat A;
        arma::mat B;
        ReadFileIntoMatrix(cloudpathA, A);
        ReadFileIntoMatrix(cloudpathB, B);

        std::vector<std::vector<bool>> graphA;
        std::vector<std::vector<bool>> graphTmpA;
        ReadGraphFileIntoMatrix(graphpathA, graphTmpA);
        tableExpansion(graphTmpA, graphA);


        std::vector<std::vector<bool>> graphB;
        std::vector<std::vector<bool>> graphTmpB;
        ReadGraphFileIntoMatrix(graphpathB, graphTmpB);
        tableExpansion(graphTmpB, graphB);

        long totalTimeForSMIstd;
        long totalTimeForBD;
        std::vector<int> matching;
        std::vector<std::vector<int>> res;
        double bd = 0;


     //!   bd = lap.ComputeDistance(matrices[u], matrices[v], graphs[u], graphs[v], matching, res, totalTimeForSMIstd, totalTimeForBD);
        return bd;

    }



    void limitedExperRun(int x, int y,std::vector<std::vector<std::string>> & parsedCsv, std::vector<std::vector<std::string>> & outVector )
    {
        SCD lap(0.43);
        int tt = matrices.size();
        y = std::min(y, tt);
        std::string debugStream = "/home/yury/LocalProjects/XYZProject/DistanceBasedInavriance/GraphTypeInvariants/EMDPDD/debug.txt";



        for (int i = x; i < y; i++)
        {
            std::cout << "Running operation: [" << x << " --- " << i << " --- " << y << "]" << std::endl;
            std::vector<std::string> tmp;
            //   std::cout << "u: " << parsedCsv[i][1] << std::endl;
            int u = stoi(parsedCsv[i][1]);
            // std::cout << "v: " << parsedCsv[i][2] << std::endl;
            int v = stoi(parsedCsv[i][2]);
            //  std::cout << "Starting " << std::endl;
            long totalTimeForSMIstd;
            long totalTimeForBD;
            std::vector<int> matching;
            std::vector<std::vector<int>> res;
            double bd = 0;

            //!std::vector<std::vector<bool>> graphA(matrices[u].n_cols+1, std::vector<bool>(matrices[u].n_cols+1, true));
            //!std::vector<std::vector<bool>> graphB = graphA;

            //  double purebd = 0;

            //!         std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, PDD dist, Molecule_A, Molecule_B, NumAtoms, SDV dist";

            //!  double bd = CrystData::computeDistanceBetweenTwoClouds( matrices[u], matrices[v], totalTimeForSMIstd, totalTimeForBD, purebd);
            bd = lap.ComputeDistance(matrices[u], matrices[v], graphs[u], graphs[v], matching, res, totalTimeForSMIstd, totalTimeForBD);

            std::vector<std::vector<bool>> graphA(matrices[u].n_cols+1, std::vector<bool>(matrices[u].n_cols+1, true));
            std::vector<std::vector<bool>> graphB = graphA;

            long totalTimeForSMIstdfake;
            long totalTimeForBDfake;

            double bdz = lap.ComputeDistance(matrices[u], matrices[v], graphA, graphB, matching, res, totalTimeForSMIstdfake, totalTimeForBDfake);


            //!  double haussdorff = computeHaudsorff(matrices[u], matrices[v]);
            //!      static double ComputeEasyBottleneckDistanceBetweenClouds(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB)
            //!  computeEuclideanBottleneckDistanceBC( arma::mat & cloudA, arma::mat & cloudB)

            double purebd = CrystData::computeEuclideanBottleneckDistanceBC(matrices[u], matrices[v]);
            double haussdorff = computeHaudsorff(matrices[u], matrices[v]);
            //!      static double ComputeEasyBottleneckDistanceBetweenClouds(std::vector<std::vector<double>> & dataA,std::vector<std::vector<double>> & dataB)

            tmp.push_back(parsedCsv[i][1]);
            tmp.push_back(parsedCsv[i][2]);
            tmp.push_back(parsedCsv[i][3]);
            tmp.push_back(std::to_string(haussdorff));
            tmp.push_back(std::to_string(purebd));
            tmp.push_back(parsedCsv[i][4]);
            tmp.push_back(parsedCsv[i][0]);
            tmp.push_back(std::to_string(bd));
            double ratiod = bd / purebd;
            tmp.push_back(std::to_string(ratiod));
            tmp.push_back(std::to_string(totalTimeForSMIstd));
            tmp.push_back(std::to_string(totalTimeForBD));
            tmp.push_back(std::to_string(bdz));


//            for (int jj = 0; jj < tmp.size(); jj++)
//            {
//                std::cout << tmp[jj] << ", ";
//
//            }
//            std::cout << std::endl;
            outVector.push_back(tmp);
        }

        std::cout << "Outvector size: " << outVector.size() << std::endl;


    }

    void parseCSV(std::vector<std::vector<std::string>> & parsedCsv, std::string input)
    {
        std::ifstream  data(input);
        std::string line;
        while(std::getline(data,line))
        {
            std::stringstream lineStream(line);
            std::string cell;
            std::vector<std::string> parsedRow;
            while(std::getline(lineStream,cell,','))
            {
                parsedRow.push_back(cell);
            }

            parsedCsv.push_back(parsedRow);
        }

    }

    void printExperiments(std::vector<std::vector<std::string>> & values, std::string header, std::string output)
    {

        std::ofstream out(output);
        out << header << std::endl;
        for (int i = 0; i < values.size(); i++)
        {
            for (int j = 0; j < values[i].size(); j++)
            {
                out << values[i][j];
                if (j  < values[i].size() - 1)
                {
                    out << ",";
                }

            }
            out << std::endl;

        }
        out.close();

    }

    void RunThisSCD(std::string inputCsv, std::string outputCsv, std::string outputCsvLimited, int threads, int maxxnumm)
    {
        std::vector<std::thread> vec_thr;
        std::vector<std::vector<std::string>> parsedCSV;
        std::vector<std::vector<std::vector<std::string>>> vectorCollection(threads+1);
        parseCSV(parsedCSV, inputCsv);
        parsedCSV.erase(parsedCSV.begin());
        parsedCSV.resize(maxxnumm);
        double ukk = parsedCSV.size() / (double) threads;
        int be = floor(ukk);
        int iblan = 0;
      //!  limitedExperRun( iblan*be, (iblan+1)*be, std::ref(parsedCSV), std::ref(vectorCollection[iblan]));

        for (int i = 0; i < threads; i++)
        {
            // std::thread th();
            // limitedExperimentsRun(i*be, (i+1)*be, parsedCSV, vectorCollection[i]);
            vec_thr.emplace_back(&SCDExperimentsRunner::limitedExperRun, this, i*be, (i+1)*be, std::ref(parsedCSV), std::ref(vectorCollection[i]));

        }
        vec_thr.emplace_back(&SCDExperimentsRunner::limitedExperRun, this, threads*be, parsedCSV.size(), std::ref(parsedCSV), std::ref(vectorCollection[threads]) );
        for(auto& t: vec_thr)
            t.join();

        std::string header ="Molecule_A, Molecule_B, NumAtoms, Hausdorff distance, BD, L_inf on SDV, EMD on PDD, BD on SCD,  BD_SCD / BD, SCD time (ms), BD time (ms), BD on SCD (Complete graph)";
        //! std::string header ="Bottleneck dist, Time SMI, Time Bottleneck, PDD dist, Molecule_A, Molecule_B, NumAtoms, SDV dist";
        std::vector<std::vector<std::string>> finalString;


        for (int i = 0; i < vectorCollection.size(); i++)
        {
            finalString.insert(finalString.end(), vectorCollection[i].begin(), vectorCollection[i].end());

        }

        std::cout << "Total final string size " << finalString.size() << std::endl;

        std::vector<std::vector<std::string>> finalStringLimited = finalString;

        std::sort(finalString.begin(), finalString.end(),
                  [](const std::vector<std::string> & a, const std::vector<std::string> & b) -> bool
        {
            double aa = stod(a[7]);
            double bb = stod(b[7]);
            return  aa < bb;
        });

        long sumsd = 0;
        long sumbd = 0;
        long avgsd =0;
        long avgbd = 0;



        for (int i = 0; i < finalString.size(); i++)
        {
            sumsd = sumsd + stol(finalString[i][1]);
            sumbd = sumbd + stol(finalString[i][2]);
        }

        avgsd = sumsd / (double)finalString.size();
        avgbd = sumbd / (double)finalString.size();

        printExperiments(finalString, header, outputCsv);

        std::cout << "Total time SMI: " << sumsd << "milliseconds" << std::endl;
        std::cout << "Total time BD: " << sumbd << "milliseconds" << std::endl;
        std::cout << "Avg time SMI: " << avgsd<< "milliseconds" << std::endl;
        std::cout << "Avg time BD: " << avgbd << "milliseconds" << std::endl;


        // finalString;
        //finalStringLimited.resize(500);

        printExperiments(finalStringLimited, header, outputCsvLimited);




    }




//    void concreteExperimentRunner(std::vector<std::vector<std::string>> & stringPairs, std::string saveUp )
//    {
//        SCD scd(1.0);
//        //outputs.push_back()
//        std::vector<std::string> outputs;
//        outputs.push_back("distance, mol1, mol2, time1, time2");
//        for (int i = 0; i < stringPairs.size(); i++)
//        {
//            std::cout << "Iterating over i: " << i << std::endl;
//            std::cout << "Attemping to load cloud a : " << stringPairs[i][0] << std::endl;
//            arma::mat cloudA = epicMap.at(stringPairs[i][0]);
//            std::cout << "cloud a loaded" << std::endl;
//            std::cout << "Attemping to load cloud b : " << stringPairs[i][1] << std::endl;
//            arma::mat cloudB = epicMap.at(stringPairs[i][1]);
//            std::cout << "cloud b laoded " << std::endl;
//            std::cout << "Attemping to load graph A : " << stringPairs[i][0] << std::endl;
//            std::vector<std::vector<bool>> graphAtmp =graphMap[stringPairs[i][0]];
//
//            //!  std::vector<std::vector<bool>>(cloudA.n_cols + 1,std::vector<bool>(cloudA.n_cols+1, false));
//
//            std::cout << "Attemping to load graph B : " << stringPairs[i][1] << std::endl;
//
//            std::vector<std::vector<bool>> graphBtmp = graphMap[stringPairs[i][1]];
//
//            //!std::vector<std::vector<bool>>(cloudB.n_cols + 1,std::vector<bool>(cloudB.n_cols+1, false));
//            std::cout << "Everything loaded with great success" << std::endl;
//            std::cout << "Cloud A: (temp) " << cloudA.n_cols << " , " << cloudA.n_rows << std::endl;
//            std::cout << "Cloud B: (temp) " << cloudB.n_cols << " , " << cloudB.n_rows << std::endl;
//            std::cout << "Graph A: (temp) " << graphAtmp.size() << " , " << graphAtmp[0].size() << std::endl;
//            std::cout << "Graph B: (temp) " << graphBtmp.size() << " , " << graphBtmp[0].size() << std::endl;
//            std::vector<std::vector<bool>> graphA;
//            std::vector<std::vector<bool>> graphB;
//
//            tableExpansion(graphBtmp, graphB);
//            tableExpansion(graphAtmp, graphA);
//            //
//            std::cout << "finnisehd A expansion" << std::endl;
//            //     tableExpansion(graphBtmp, graphB);
//            std::cout << "finnisehd expansions" << std::endl;
//            long t1 = 0;
//            long t2 = 0;
//            vector< vector<int> > res;
//            std::vector<int> matching;
//            std::cout << "Cloud A: " << cloudA.n_cols << " , " << cloudA.n_rows << std::endl;
//            std::cout << "Cloud B: " << cloudB.n_cols << " , " << cloudB.n_rows << std::endl;
//            std::cout << "Graph A: " << graphA.size() << " , " << graphA[0].size() << std::endl;
//            std::cout << "Graph B: " << graphB.size() << " , " << graphB[0].size() << std::endl;
//            double answer = scd.ComputeDistance(cloudA, cloudB, graphA, graphB, matching, res,t1,t2);
//            string line = to_string(answer) + ", " + stringPairs[i][0] + ", " + stringPairs[i][1] + ", " + to_string(t1) + ", " + std::to_string(t2);
//            outputs.push_back(line);
//        }
//
//        //! SAVING
//        std::cout << "STARTING TO SAVE EVERYTGING XD" << std::endl;
//
//        std::ofstream out(saveUp);
//        for (int i = 0; i < outputs.size(); i++)
//        {
//            out << outputs[i] << std::endl;
//
//        }
//
//        out.close();
//
//
//
//
//    }

    double computeHaudsorff(arma::mat & A,arma::mat & B)
    {
        double maxxOneWayReal = 0;
        for (int i = 0; i < A.n_cols; i++)
        {
            double maxxOneWay = std::numeric_limits<double>::max();
            for (int j = 0; j < B.n_cols; j++)
            {
                double dtmp = arma::norm(A.col(i) - B.col(j), 2);
                maxxOneWay = std::min(maxxOneWay, dtmp);

            }
            maxxOneWayReal  = std::max(maxxOneWayReal,maxxOneWay );

        }
        double maxxTwoWayReal = 0;
        for (int j = 0; j < B.n_cols; j++)
        {
            double maxxTwoWay = std::numeric_limits<double>::max();
            for (int i = 0; i < A.n_cols; i++)
            {
                double dtmp = arma::norm(A.col(i) - B.col(j), 2);
                maxxTwoWay = std::min(maxxTwoWay, dtmp);

            }
            maxxTwoWayReal  = std::max(maxxTwoWayReal,maxxTwoWay);



        }


        return std::max(maxxTwoWayReal,maxxOneWayReal);
    }

    void ExperimentRunner(std::string input)
    {




    }

protected:

private:
    //!  std::unordered_map<std::string, arma::mat> epicMap;
    std::vector<arma::mat> matrices;
    std::vector<std::vector<std::vector<bool>>> graphs;
   //! std::vector<std::vector<std::vector<double>>> graphdists;

    //! std::unordered_map<std::string>;
};

#endif // SCDEXPERIMENTSRUNNER_H
