#ifndef CLOUDGENERATOR_H
#define CLOUDGENERATOR_H

#include "vectorTools.h"
#include <thread>

class cloudGenerator
{
public:
    cloudGenerator() {}


    static double fRand(double fMin, double fMax)
    {
        double f = (double)rand() / RAND_MAX;
        return fMin + f * (fMax - fMin);
    }

//
//    static double ComputeBottleneckDistanceBetweenClouds(arma::mat & dataA, arma::mat & dataB)
//    {
//        std::string A = "";
//
//        Dataset_Graph g(dataA, dataB);
//        std::vector<int> matching;
//        //double dist = BottleneckCalculator::bottleneck_distance_exact<Dataset_Graph,KDTreeController>(g);
//        double dist = BottleneckCalculator::bottleneck_distance_exact_with_matching<Dataset_Graph,KDTreeController>(g,matching);
//        //!CrystData::PrintVector<int>(matching);
//        return dist;
//    }


    static void PerturbExperimentsSingle(std::vector<std::vector<double>> & baseCloud, std::vector<int> & matchingA, std::vector<int> & matchingB, double curEpsion,
                                         int repeat, int numEpsilon, double & res)
    {
        //std::cout << "Epsilon: " << numEpsilon << " repeat: " << repeat << " started" << std::endl;
        std::vector<std::string> simpleStringVector;
        std::vector<std::vector<double>> perturbedCloud;
        cloudGenerator::perturbCloud(baseCloud,perturbedCloud, curEpsion);
        res = CrystData::computeDistanceBetweenTwoClouds(baseCloud,perturbedCloud,matchingA,matchingB,simpleStringVector);
        //std::cout << "Epsilon: " << numEpsilon << " repeat: " << repeat << " ended" << std::endl;
    }

    static void PerturbationExperiments(int numPoints, double maxEpsilon, int numEpsilon, int repeat, std::string outputPath)
    {
        std::vector<std::vector<double>> baseCloud;
        std::vector<double> finalResults;
        std::vector<double> epsilons;
        std::vector<int> matchingA;
        std::vector<int> matchingB;
        std::vector<std::string> simpleStringVector;
        generateSimpleMatching(matchingA, numPoints);
        generateSimpleMatching(matchingB, numPoints);
        cloudGenerator::generateRandomCloudInBoxNd(baseCloud, numPoints, 1.0);
        double epsilonstep = maxEpsilon / (double) (numEpsilon);
        std::vector<std::vector<double>> resultsMassive(numEpsilon, std::vector<double>(repeat));
        std::vector<std::thread> vec_thr;

        for (int i = 0; i < numEpsilon; i++)
        {
            double curEpsilon = epsilonstep * (i+1);
            epsilons.push_back(curEpsilon);
            for (int j = 0; j < repeat; j++)
            {
                std::cout << "Combo: " << i << ", " << j << std::endl;

                vec_thr.emplace_back(cloudGenerator::PerturbExperimentsSingle, std::ref(baseCloud),std::ref(matchingA), std::ref(matchingB), curEpsilon, j, i, std::ref(resultsMassive[i][j]));

            }

        }
        for(auto& t: vec_thr)
            t.join();

        for (int i = 0; i < numEpsilon; i++)
        {

            double sumdistance = 0;
            for (int j = 0; j < repeat; j++)
            {
                sumdistance = sumdistance + resultsMassive[i][j];
            }
            sumdistance = sumdistance / (double) repeat;
            finalResults.push_back(sumdistance);
        }

        cloudGenerator::PrintExperiments(finalResults, epsilons, outputPath);
    }

    static void TimeExperiments(int MaxNumPoints, int repeat, double curEpsilon, std::string outputPath)
    {

        std::vector<double> tSMI;
        std::vector<double> tSBM;
        std::vector<int> numPointsVector;






        for (int i = 5; i < MaxNumPoints; i++)
        {
            std::vector<std::vector<double>> baseCloud;
            cloudGenerator::generateRandomCloudInBoxNd(baseCloud, i, 1.0);
            std::vector<std::string> simpleStringVector;
            std::vector<int> matchingA;
            std::vector<int> matchingB;
            generateSimpleMatching(matchingA, i);
            generateSimpleMatching(matchingB, i);
            numPointsVector.push_back(i);

            long avgSMI = 0;
            long avgSBM = 0;
            for (int j = 0; j < repeat; j++)
            {
                std::cout << "Currently: " << i << " , " << j << std::endl;
                long curSMI = 0;
                long curSBM = 0;

                std::vector<std::vector<double>> perturbedCloud;
                cloudGenerator::perturbCloud(baseCloud,perturbedCloud, curEpsilon);

                double res = CrystData::computeDistanceBetweenTwoClouds(baseCloud,perturbedCloud,matchingA,matchingB,simpleStringVector,curSMI,curSBM);

                avgSMI = avgSMI + curSMI;
                avgSBM = avgSBM + curSBM;


            }
            avgSMI = (long) avgSMI / repeat;
            avgSBM = (long) avgSBM / repeat;
            tSMI.push_back(avgSMI);
            tSBM.push_back(avgSBM);

        }


        cloudGenerator::PrintExperimentsTime(numPointsVector, tSMI, tSBM, outputPath);
    }


    static void PrintExperiments(std::vector<double> & finalResult, std::vector<double> & epsilons, std::string outputpath )
    {
        std::ofstream out(outputpath);
        out << "e, f" << std::endl;
        for (int i = 0; i < finalResult.size(); i++)
        {
            out << epsilons[i] << ", " << finalResult[i] << std::endl;
        }
        out.close();


    }


    static void PrintExperimentsTime(std::vector<int> & finalResult, std::vector<double> & tSMI, std::vector<double> & tSBM, std::string outputpath )
    {
        std::ofstream out(outputpath);
        out << "p, tSMI, tSBM " << std::endl;
        for (int i = 0; i < finalResult.size(); i++)
        {
            out << finalResult[i] << ", " << tSMI[i] << ", " << tSBM[i] << std::endl;
        }
        out.close();


    }

    static void generateSimpleMatching(std::vector<int> & matching, int n)
    {
        for (int i = 0; i < n ; i++)
        {
            matching.push_back(i);

        }


    }




    static void generateRandomCloudInBoxNd(std::vector<std::vector<double>> & cloud, int n, double boxSize)
    {
        for (int j = 0; j < n; j++)
        {
            std::vector<double> elem;
            for (int i = 0; i < constants::Dim; i++)
            {
                elem.push_back(fRand(0, boxSize));
            }
            cloud.push_back(elem);
        }
    }

    static void shiftSingle(std::vector<double> & vv, double epsilon)
    {
        double dist = std::numeric_limits<double>::max();
        std::vector<double> perturbVector(vv.size());
        while(dist > epsilon)
        {
            perturbVector = std::vector<double>(vv.size());
            for (int i = 0; i < vv.size(); i++)
            {
                perturbVector[i] = perturbVector[i] + fRand(-1*epsilon,epsilon);
            }
            dist = sqrt(vectorTools::SquaredNorm(perturbVector));
        }
        vectorTools::vectorAddition(vv,perturbVector);
    }

    static void perturbCloud(std::vector<std::vector<double>> & cloudIN, std::vector<std::vector<double>> & cloudOUT, double epsilon)
    {
        for (int i  = 0; i < cloudIN.size(); i++)
        {
            std::vector<double> tmpElem = cloudIN[i];
            shiftSingle(tmpElem, epsilon);
            cloudOUT.push_back(tmpElem);
        }
    }

    static void CgenerateClouds(double a, double b, double c, double d,std::vector<std::vector<double>> & cloud,std::vector<std::vector<double>> & cloudPair)
    {
        cloud.push_back(std::vector<double> {4*a,0});
        cloud.push_back(std::vector<double> {b,c});
        cloud.push_back(std::vector<double> {-b,-c});
        cloud.push_back(std::vector<double> {0,4*d});

        cloudPair.push_back(std::vector<double> {4*a,0});
        cloudPair.push_back(std::vector<double> {b,c});
        cloudPair.push_back(std::vector<double> {-b,-c});
        cloudPair.push_back(std::vector<double> {0,-4*d});

    }

    static void CgenerateCloudsArray(std::vector<double> & inbuds,std::vector<std::vector<double>> & cloud,std::vector<std::vector<double>> & cloudPair)
    {
        double a = inbuds[0];
        double b = inbuds[1];
        double c = inbuds[2];
        double d = inbuds[3];
        cloud.push_back(std::vector<double> {4*a,0});
        cloud.push_back(std::vector<double> {b,c});
        cloud.push_back(std::vector<double> {-b,-c});
        cloud.push_back(std::vector<double> {0,4*d});

        cloudPair.push_back(std::vector<double> {4*a,0});
        cloudPair.push_back(std::vector<double> {b,c});
        cloudPair.push_back(std::vector<double> {-b,-c});
        cloudPair.push_back(std::vector<double> {0,-4*d});

    }

    static void printExperiments(std::vector<std::vector<double>> & values, std::vector<double> & results, std::string output)
    {

        std::ofstream out(output);
        out << "a,b,c,d,r" << std::endl;
        for (int i = 0; i < values.size(); i++)
        {
            for (int j = 0; j < values[i].size(); j++)
            {
                out << values[i][j] << ",";
            }
            out << results[i] << std::endl;
        }
        out.close();

    }
    static void printMatrix(std::vector<std::vector<double>> & values, std::vector<double> & xCoord, std::vector<double> & yCoord, std::string output)
    {
        std::cout << "xcoordsize" << xCoord.size() << std::endl;
        std::cout << "ycoordsize" << yCoord.size() << std::endl;
        std::ofstream out(output);
        out << "0,";
        for (int i = 0; i < xCoord.size(); i++)
        {
            out << xCoord[i];
            if (i < xCoord.size()-1)
            {
                out << ",";
            }

        }
        out << std::endl;
        for (int i = 0; i < values.size(); i++)
        {
            out << yCoord[i] << ",";

            for (int j = 0; j < values[i].size(); j++)
            {

                out << values[i][j];
                if (j < values[i].size()-1)
                {
                    out << ",";
                }
            }
            out << std::endl;
        }



    }

    static void experimentsConducting(int n, std::string folder)
    {
        std::vector<int> mappingA = std::vector<int> {0,1,2,3};
        std::vector<int> mappingB = std::vector<int> {0,1,2,3};
        std::vector<int> one = std::vector<int> {0,1};
        std::vector<int> two = std::vector<int> {0,2};
        std::vector<int> three = std::vector<int> {0,3};
        std::vector<int> four = std::vector<int> {1,2};
        std::vector<int> five = std::vector<int> {1,3};
        std::vector<int> six = std::vector<int> {2,3};
        std::vector<std::vector<int>> inclusion;
        std::vector<std::vector<int>> exclusion;
        inclusion.push_back(one);
        inclusion.push_back(two);
        inclusion.push_back(three);
        inclusion.push_back(four);
        inclusion.push_back(five);
        inclusion.push_back(six);
        exclusion.push_back(six);
        exclusion.push_back(five);
        exclusion.push_back(four);
        exclusion.push_back(three);
        exclusion.push_back(two);
        exclusion.push_back(one);
        double divider = (double) n;
        double stepsizeA = 1.0 / divider;
        double stepsizeB = 4.0 / divider;
        double stepsizeC = 4.0 / divider;
        double stepsizeD = 1.0 / divider;
        std::vector<double> dividers = std::vector<double> {stepsizeA,stepsizeB,stepsizeC,stepsizeD};
        std::vector<double> constants = std::vector<double> {0.5,2.0,2.0,0.5};
        std::vector<std::string> names{"a","b","c","d"};
        for (int i = 0; i < inclusion.size(); i++)
        {
            std::vector<double> valuesX;
            std::vector<double> valuesY;
            std::vector<std::vector<double>> matrix(n, std::vector<double>(n));
            std::string fileoutput = folder + "(" + names[inclusion[i][0]] + ", " + names[inclusion[i][1]] + ")" + "(" + names[exclusion[i][0]] + ":" + std::to_string(constants[exclusion[i][0]]) + ")"
                                     + "(" + names[exclusion[i][1]] + ":" + std::to_string(constants[exclusion[i][1]]) + ")"   + ".csv";
            for (int j = 1; j <= n; j++)
            {
                valuesX.push_back(j*dividers[inclusion[i][0]]);
                valuesY.push_back(j*dividers[inclusion[i][1]]);
                for (int k = 1; k <= n; k++)
                {
                    std::cout << "Begginig " << i << " , " << j << ", " << k << std::endl;
                    std::vector<std::vector<double>> twoDcloudA;
                    std::vector<std::vector<double>> twoDcloudB;
                    std::vector<double> inpudd(4);
                    inpudd[inclusion[i][0]] = j*dividers[inclusion[i][0]];
                    inpudd[inclusion[i][1]] = k*dividers[inclusion[i][1]];
                    inpudd[exclusion[i][0]] = constants[exclusion[i][0]];
                    inpudd[exclusion[i][1]] = constants[exclusion[i][1]];
                    cloudGenerator::CgenerateCloudsArray(inpudd,twoDcloudA,twoDcloudB);
                    //   std::cout << "Cloud generated" << std::endl;
                    //    CrystData::PrintVector<double>(inpudd);
                    // //   CrystData::PrintMatrix(twoDcloudA);
                    //    CrystData::PrintMatrix(twoDcloudB);
                    std::vector<std::string> outputpairs;
                    double answer = CrystData::computeDistanceBetweenTwoClouds(twoDcloudA,twoDcloudB,mappingA,mappingB,outputpairs);
                    matrix[j-1][k-1] = answer;
                }
            }
            cloudGenerator::printMatrix(matrix,valuesX,valuesY,fileoutput);
        }



    }

    static void conductExperiments(int n, std::string file)
    {
        std::vector<int> mappingA = std::vector<int> {0,1,2,3};
        std::vector<int> mappingB = std::vector<int> {0,1,2,3};
        double divider = (double) (n-1);
        double stepsizeA = 1.0 / divider;
        double stepsizeB = 4.0 / divider;
        double stepsizeC = 4.0 / divider;
        double stepsizeD = 1.0 / divider;
        //std::cout << "Stepsizes " << stepsizeA << " , " <<
        std::vector<std::vector<double>> values;
        std::vector<double> results;
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < n; j++)
            {
                for (int k = 0; k < n; k++)
                {
                    for (int w = 0; w < n; w++)
                    {

                        double a = stepsizeA* (double) i;
                        double b = stepsizeB* (double) j;
                        double c = stepsizeC* (double) k;
                        double d = stepsizeD* (double) w;
                        std::cout << "Running " << a << " , " << b << " , " << c << " , " << d << std::endl;
                        std::vector<double> tmpValues = std::vector<double> {a,b,c,d};
                        values.push_back(tmpValues);
                        std::vector<std::string> outputpairs;
                        std::vector<std::vector<double>> twoDcloudA;
                        std::vector<std::vector<double>> twoDcloudB;
                        cloudGenerator::CgenerateClouds(a,b,c,d,twoDcloudA, twoDcloudB);
                        double answer = CrystData::computeDistanceBetweenTwoClouds(twoDcloudA,twoDcloudB,mappingA,mappingB,outputpairs);
                        results.push_back(answer);

//                        if ((i % 2 == 0)&&(j % 2 == 0)&&(w % 2 == 0)&&(k % 2 == 0))
//                        {
//                            cloudGenerator::cloudToCSV()
//
//
//
//                        }
                    }
                }
            }
        }
        printExperiments(values,results,file);



    }


    static void cloudToCSV(std::vector<std::vector<double>> & temp_matrix, std::string output)
    {
        std::ofstream out(output);

        for (int i = 0; i < temp_matrix.size(); i++)
        {
            for (int j = 0; j < temp_matrix[i].size(); j++)
            {
                out << temp_matrix[i][j];
                if (j < temp_matrix[i].size()-1)
                {
                    out <<',';


                }
                out << '\n';


            }


        }


//
//        for (auto& row : temp_matrix)
//        {
//            for (auto col : row)
//                out << col <<',';
//            out << '\n';
//        }
//


    }



protected:

private:
};

#endif // CLOUDGENERATOR_H
