#ifndef GRAPHTREECONTROLLER_H
#define GRAPHTREECONTROLLER_H

#include <list>
#include "Bipartie_Graph.h"


class GraphTreeController
{
public:
    GraphTreeController(Bipartie_Graph & g, double r):graph(g),r(r) {}
    virtual ~GraphTreeController() {}

    void add(int v_point_index)
    {
        NodesInLayer.push_back(v_point_index);
    }
    int pull_near(int u_point_index)
    {

        for (auto it = NodesInLayer.begin(); it != NodesInLayer.end(); it++)
        {
            if (graph.distance(*it, u_point_index) <= this->r)
            {
                int ii = *it;
                NodesInLayer.erase(it);
                return ii;


            }
        }
        return constants::null_point_index;
    }


    std::vector<int> pull_all_near(int u_point_index)
    {
        std::vector<int> all_pull;
        int last_pull = pull_near(u_point_index);
        while (last_pull != constants::null_point_index)
        {
            all_pull.emplace_back(last_pull);
            last_pull = pull_near(u_point_index);
        }
        return all_pull;
    }


protected:


private:
    std::list<int> NodesInLayer;
    Bipartie_Graph & graph;
    double r;
};

#endif // GRAPHTREECONTROLLER_H
