# Soft Kernel Interpolation

We provide an implementation of a scalable and high-dimensional Gaussian Process (GP) with *Soft Kernel Interpolation* (SoftKI) [[https://arxiv.org/abs/2410.21419]](https://arxiv.org/abs/2410.21419).


## Quick Start

1. Create environment

```
conda create --name softki python=3.12
pip install -e .
```

2. Get data

```
./download_data.sh
```

3. Run `softki` on `pol` dataset (from UCI).

```
python run.py \
    model=softki \
    gp.softki.model.num_inducing=512 \
    gp.softki.model.device=cuda:0 \
    gp.softki.model.use_qr=true \
    gp.softki.model.use_scale=true \
    gp.softki.model.mll_approx=hutchinson_fallback \
    gp.softki.training.seed=6535 \
    gp.softki.training.epochs=50 \
    gp.softki.training.learning_rate=0.01 \
    data_dir=data/uci_datasets/uci_datasets \
    dataset.name=pol
```

### Variables / Arguments Explanation

| Name | Description |
| :------------ |  :----------- |
| `name` | Specifies which model `softki`, `svgp`, `sgpr`, `exact`. |
| `gp.softki.model.num_inducing` | Number of inducing points to use. |
| `gp.softki.model.device` |  Which GPU device to use (e.g., `cuda:0`). |
| `gp.softki.model.use_qr` |  Flag to use qr solver for SoftKI. |
| `gp.softki.model.use_scale` | Flag to use scale kernel. |
| `gp.softki.model.mll_approx` | Set to `hutchinson_fallback` to use stabilized MLL. |
| `data_dir` |  Path to data (e.g., `data/uci_datasets/uci_datasets`). |
| `dataset.name ` |  Name of dataset (see scripts for names) |
| `gp.softki.training.seed` |  Set random seed to use. |
| `gp.softki.training.epochs` | Number of epochs to train for. |
| `gp.softki.training.learning_rate` |  Hyper-parameter optimization learning rate. |



### Manual Install

```
conda create --name softki python=3.12

pip install torch
pip install tqdm requests wandb
pip install scipy scikit-learn pandas matplotlib omegaconf
pip install gpytorch 
pip install seaborn
pip install -e .
```


## Methods

This repository contains implementations of a few GP methods.

1. `gp/exact` contains an Exact GP trained with conjugate gradient descent.
2. `gp/softki` contains SoftKI (our method).
3. `gp/sgpr` contains a [Sparse GP (often abbreviated SGPR)](https://proceedings.mlr.press/v5/titsias09a/titsias09a.pdf).
4. `gp/svgp` containst a [Stochastic Variational Inference GP (often abbreviated SVGP)](https://arxiv.org/pdf/1309.6835).


## Benchmark

Run
```
./benchmark.sh
```
to test our method.


## Experiments

See [exp/README.md](scripts/README.md) for how to replicate experiments.


## Licence

This repository is released under the [Apache 2.0 license](LICENSE) file.
