#!/bin/bash

DEBUG=false

DATA_DIR=data/uci_datasets/uci_datasets
# DATASETS=(pol elevators bike kin40k protein keggdirected slice keggundirected 3droad song buzz houseelectric)
DATASETS=(pol elevators bike kin40k protein keggdirected keggundirected)

PROJECT=softki4
GROUP=benchmark-exact-zero-mean
EPOCHS=50
DEVICE="cuda:0"
SEEDS=(6535 8830 92357)

if $DEBUG; then
    EPOCHS=1
    SEEDS=(6535)
    GROUP=test
    DATASETS=(pol)
fi

pushd ..
    for dataset in "${DATASETS[@]}"
    do
        for seed in "${SEEDS[@]}"
        do
            python run.py \
                model=exact \
                gp.exact.model.device=$DEVICE \
                gp.exact.model.use_keops=true \
                gp.exact.model.use_ard=true \
                gp.exact.model.use_scale=true \
                gp.exact.training.seed=$seed \
                gp.exact.training.epochs=$EPOCHS \
                gp.exact.model.kernel._target_=MaternKernel \
                gp.exact.model.kernel.nu=1.5 \
                gp.exact.training.learning_rate=0.1 \
                data_dir=$DATA_DIR \
                dataset.name=$dataset \
                dataset.train_frac=0.9 \
                dataset.val_frac=0 \
                dataset.num_workers=$NUM_WORKERS \
                wandb.project=$PROJECT \
                wandb.group=$GROUP \
                wandb.watch=true
        done
    done
popd