#!/bin/bash

DEBUG=false

DATA_DIR=data/
DATASETS=(Ac-Ala3-NHMe AT-AT-CG-CG AT-AT stachyose DHA buckyball-catcher double-walled-nanotube)

PROJECT=softki4
GROUP=benchmark-exact-md22-2
EPOCHS=50
DEVICE="cuda:1"
SEEDS=(6535 8830 92357)
NUM_WORKERS=0

if $DEBUG; then
    EPOCHS=1
    SEEDS=(6535)
    GROUP=test
    DATASETS=(double-walled-nanotube)
fi

pushd ..
    for seed in "${SEEDS[@]}"
    do
        for dataset in "${DATASETS[@]}"
        do
            python run.py \
                model=exact \
                gp.exact.model.device=$DEVICE \
                gp.exact.model.use_keops=true \
                gp.exact.model.keops_kernel_type=matern \
                gp.exact.model.use_ard=true \
                gp.exact.model.use_scale=true \
                gp.exact.training.seed=$seed \
                gp.exact.training.epochs=$EPOCHS \
                gp.exact.model.kernel._target_=MaternKernel \
                gp.exact.model.kernel.nu=1.5 \
                gp.exact.training.learning_rate=0.1 \
                data_dir=$DATA_DIR \
                dataset.name=$dataset \
                dataset.train_frac=0.9 \
                dataset.val_frac=0 \
                dataset.num_workers=$NUM_WORKERS \
                wandb.project=$PROJECT \
                wandb.group=$GROUP \
                wandb.watch=true
        done
    done
popd