#!/bin/bash

DEBUG=true

DATA_DIR=data/uci_datasets/uci_datasets
DATASETS=(pol elevators bike kin40k protein keggdirected slice keggundirected 3droad song buzz houseelectric)

PROJECT=softki3
GROUP=benchmark-noT-noard
EPOCHS=50
DEVICE="cuda:0"
NUM_WORKERS=8
SEEDS=(6535 8830 92357)

if $DEBUG; then
    GROUP=test
    EPOCHS=1
    SEEDS=(6535)
    DATASETS=(pol)
fi

pushd ..
    for seed in "${SEEDS[@]}"
        do
        for dataset in "${DATASETS[@]}"
        do
            python run.py \
                model=softki \
                gp.softki.model.num_inducing=512 \
                gp.softki.model.device=$DEVICE \
                gp.softki.model.use_qr=true \
                gp.softki.model.use_scale=true \
                gp.softki.model.T=1 \
                gp.softki.model.use_T=false \
                gp.softki.model.learn_T=true \
                gp.softki.model.learn_noise=true \
                gp.softki.model.use_ard=false \
                gp.softki.model.mll_approx=hutchinson \
                gp.softki.training.seed=$seed \
                gp.softki.training.epochs=$EPOCHS \
                gp.softki.training.learning_rate=0.01 \
                data_dir=$DATA_DIR \
                dataset.name=$dataset \
                dataset.train_frac=0.9 \
                dataset.val_frac=0 \
                dataset.num_workers=$NUM_WORKERS \
                wandb.project=$PROJECT \
                wandb.group=$GROUP \
                wandb.watch=true

            python run.py \
                model=svgp \
                gp.svgp.model.num_inducing=1024 \
                gp.svgp.model.device=$DEVICE \
                gp.svgp.model.learn_noise=true \
                gp.svgp.model.use_scale=true \
                gp.svgp.model.use_ard=false \
                gp.svgp.training.seed=$seed \
                gp.svgp.training.epochs=$EPOCHS \
                gp.svgp.training.learning_rate=0.01 \
                data_dir=$DATA_DIR \
                dataset.name=$dataset \
                dataset.train_frac=0.9 \
                dataset.val_frac=0 \
                dataset.num_workers=$NUM_WORKERS \
                wandb.project=$PROJECT \
                wandb.group=$GROUP \
                wandb.watch=true

            python run.py \
                model=sgpr \
                gp.sgpr.model.num_inducing=512 \
                gp.sgpr.model.device=$DEVICE \
                gp.sgpr.model.learn_noise=true \
                gp.sgpr.model.use_ard=false \
                gp.sgpr.model.use_scale=true \
                gp.sgpr.training.seed=$seed \
                gp.sgpr.training.epochs=$EPOCHS \
                gp.sgpr.training.learning_rate=.1 \
                data_dir=$DATA_DIR \
                dataset.name=$dataset \
                dataset.train_frac=0.9 \
                dataset.val_frac=0 \
                dataset.num_workers=$NUM_WORKERS \
                wandb.project=$PROJECT \
                wandb.group=$GROUP \
                wandb.watch=true
        done
    done
popd