#!/bin/bash

DEBUG=false

DATA_DIR=data/uci_datasets/uci_datasets
# DATASETS=(pol elevators bike kin40k protein keggdirected slice keggundirected 3droad song buzz houseelectric)
DATASETS=(pol elevators bike kin40k protein keggdirected slice keggundirected)

PROJECT=softki4
# GROUP=uci-hybrid-mat-cg
GROUP_VAR=uci-sgpr-qr
EPOCHS=50
DEVICE="cuda:0"
NUM_WORKERS=8
# SEEDS=(6535 8830 92357)
SEEDS=(92357)

if $DEBUG; then
    GROUP=test
    EPOCHS=1
    SEEDS=(6535)
    DATASETS=(pol)
fi

pushd ..
    for seed in "${SEEDS[@]}"
        do
        for dataset in "${DATASETS[@]}"
        do
            python run.py \
                model=sgpr \
                gp.sgpr.model.num_inducing=512 \
                gp.sgpr.model.device=$DEVICE \
                gp.sgpr.model.learn_noise=true \
                gp.sgpr.model.use_ard=true \
                gp.sgpr.model.use_scale=true \
                gp.sgpr.model.kernel._target_=MaternKernel \
                gp.sgpr.model.kernel.nu=1.5 \
                gp.sgpr.training.seed=$seed \
                gp.sgpr.training.epochs=$EPOCHS \
                gp.sgpr.training.learning_rate=.1 \
                data_dir=$DATA_DIR \
                dataset.name=$dataset \
                dataset.train_frac=0.9 \
                dataset.val_frac=0 \
                dataset.num_workers=$NUM_WORKERS \
                wandb.project=$PROJECT \
                wandb.group=$GROUP_VAR \
                wandb.watch=true
        done
    done
popd