#!/bin/bash

DEBUG=false

DATA_DIR=data/uci_datasets/uci_datasets
DATASETS=(elevators protein keggdirected)

PROJECT=softki4
GROUP=benchmark-simplexski
EPOCHS=50
DEVICE="cuda:1"
NUM_WORKERS=8
SEEDS=(6535 8830 92357)

if $DEBUG; then
    EPOCHS=5
    SEEDS=(6535)
fi

pushd ..
    for seed in "${SEEDS[@]}"
        do
        for dataset in "${DATASETS[@]}"
        do
            python run_ski.py \
                --model.name simplex-ski \
                --model.device $DEVICE \
                --model.use_ard \
                --model.use_scale \
                --data_dir $DATA_DIR \
                --dataset.name $dataset \
                --training.seed $seed \
                --training.epochs $EPOCHS \
                --dataset.train_frac 0.1 \
                --dataset.val_frac 0.8 \
                --dataset.num_workers $NUM_WORKERS \
                --wandb.project $PROJECT \
                --wandb.group $GROUP \
                --wandb.watch        
        done
    done
popd