#!/bin/bash

DEBUG=false

DATA_DIR=data/uci_datasets/uci_datasets
DATASETS=(elevators keggdirected protein)
# DATASETS=(3droad)

PROJECT=softki3
GROUP=benchmark-ski
EPOCHS=50
DEVICE="cuda:1"
NUM_WORKERS=8
SEEDS=(6535 8830 92357)

if $DEBUG; then
    EPOCHS=5
    SEEDS=(6535)
    DATASETS=(elevators)
fi

pushd ..
    for seed in "${SEEDS[@]}"
        do
        for dataset in "${DATASETS[@]}"
        do
            python run.py \
                model=skip \
                gp.skip.model.grid_size=100 \
                gp.skip.model.use_scale=True \
                gp.skip.model.device=$DEVICE \
                gp.skip.training.seed=$seed \
                gp.skip.training.epochs=$EPOCHS \
                data_dir=$DATA_DIR \
                dataset.name=$dataset \
                dataset.train_frac=0.9 \
                dataset.val_frac=0 \
                dataset.num_workers=$NUM_WORKERS \
                wandb.project=$PROJECT \
                wandb.group=$GROUP \
                wandb.watch=true
        done
    done
popd