permute(L1, O, L2) :-
    is_list(L1),
    length(L1, N),
    length(L2, N),
    findall(S, between(1,N,S), O1),
    catch(permutation(O1, O), _, fail),
    permute1(L1, O, L2).
permute1([], [], _).
permute1([S|List], [O|Os], List2) :-
    nth1(O,List2,S),
    permute1(List, Os, List2).

head([H|_],H).
tail([_|T],T).
empty([]).

f(A,B):-permute(A,B,C),s(C).
s(A):-s_1(A,B),s(B).
s(A):-tail(A,B),empty(B).
s_1(A,B):-nn_pred(A),tail(A,B).

nn_pred([A,B|_]) :-
    id(I1,A),
    id(I2,B),
    nn_order(I1,I2).

nn_order(A,B) :-
    nn(A,B,C), C >= 0.5.
nn_order(A,B) :-
    nn(B,A,C), C < 0.5.
