:- use_module('meta_abd').

metagol:min_clauses(1).
metagol:max_clauses(3).
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 primitives and metarules
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
term_gt(A, B) :-
    is_list(A),
    is_list(B),
    length(A, L1),
    length(B, L2),
    L1 > L2.

% body predicates
body_pred(nn_pred/1).
body_pred(head/2).
body_pred(tail/2).
body_pred(empty/1).

%% abducible predicates
:- dynamic
    nn_pred/1.
abducible(nn_pred/1).

%% list-related predicates
head([H|_],H).
tail([_|T],T).
empty([]).

%% metarules
metarule([P,Q], [P,A], [[Q,A]]).
metarule([P,Q,R], [P,A], [[Q,A,B],[R,B]]).
metarule([P,Q], [P,A], [[Q,A,B],@term_gt(A,B),[P,B]]).
metarule([P,Q,R], [P,A,B], [[Q,A],[R,A,B]]).
metarule([P,Q], [P,A,B], [[Q,A,B]]).
metarule([P,Q,R], [P,A,B], [[Q,A,B],[R,A,B]]).
metarule([P,Q,R], [P,A,B], [[Q,A,B,C],[R,C]]).
metarule([P,Q,R], [P,A,B], [[Q,A,B],[R,B]]).
metarule([P,Q,R], [P,A,B], [[Q,A,C],[R,C,B]]).

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 Abduction
- - - - - - - - - - - n- - - - - - - - - - - - - - - - - - - - - - - - - - */
abduce(Atom, Abd, Abd, Score, Score) :-
    ground(Abd),
    member(Atom, Abd).
abduce(Atom, Abd, [Abduced|Abd], Score1, Score2) :-
    abduce_atom(Atom, Abduced, Score),
    Abduced \= nothing,
    Score2 is Score1 * Score.
abduce(Atom, Abd, Abd, Score, Score) :-
    abduce_atom(Atom, nothing, _Score).
abduce_atom(Atom, Abduced, Score) :-
    Atom =.. [nn_pred, X], % arity 1
    abduce_nn_pred(X, Abduced, Score).
abduce_nn_pred([X,Y|_], nothing, _Score) :-
    number(X), number(Y),
    X > Y.
% call nn_pred nn
abduce_nn_pred([X,Y|_], [I1,I2], Score) :-
    (   \+number(X); \+number(Y)),
    nn1(X,Y,Score),
    id(X,I1),
    id(Y,I2).

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 perceived facts
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
% symmetry rule
nn1(X,Y,Z) :-
    nn(X,Y,Z); (nn(Y,X,Z1), Z is 1.0-Z1).
