/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.L2R_ErmFunction;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SparseOperator;

class L2R_L2_SvcFunction
extends L2R_ErmFunction {
    protected final int[] I;
    protected int sizeI;

    public L2R_L2_SvcFunction(Problem prob, Parameter param, double[] C) {
        super(prob, param, C);
        this.I = new int[prob.l];
    }

    @Override
    protected double C_times_loss(int i, double wx_i) {
        double d = 1.0 - this.prob.y[i] * wx_i;
        if (d > 0.0) {
            return this.C[i] * d * d;
        }
        return 0.0;
    }

    @Override
    public void grad(double[] w, double[] g) {
        int i;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.sizeI = 0;
        for (i = 0; i < l; ++i) {
            this.tmp[i] = this.wx[i] * y[i];
            if (!(this.tmp[i] < 1.0)) continue;
            this.tmp[this.sizeI] = this.C[i] * y[i] * (this.tmp[i] - 1.0);
            this.I[this.sizeI] = i;
            ++this.sizeI;
        }
        this.subXTv(this.tmp, g);
        for (i = 0; i < w_size; ++i) {
            g[i] = w[i] + 2.0 * g[i];
        }
        if (!this.regularize_bias) {
            int n = w_size - 1;
            g[n] = g[n] - w[w_size - 1];
        }
    }

    @Override
    public void get_diag_preconditioner(double[] M) {
        int i;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            M[i] = 1.0;
        }
        if (!this.regularize_bias) {
            M[w_size - 1] = 0.0;
        }
        for (i = 0; i < this.sizeI; ++i) {
            int idx = this.I[i];
            for (Feature s : x[idx]) {
                int n = s.getIndex() - 1;
                M[n] = M[n] + s.getValue() * s.getValue() * this.C[idx] * 2.0;
            }
        }
    }

    @Override
    public void Hv(double[] s, double[] Hs) {
        int i;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            Hs[i] = 0.0;
        }
        for (i = 0; i < this.sizeI; ++i) {
            Feature[] xi = x[this.I[i]];
            double xTs = SparseOperator.dot(s, xi);
            xTs = this.C[this.I[i]] * xTs;
            SparseOperator.axpy(xTs, xi, Hs);
        }
        for (i = 0; i < w_size; ++i) {
            Hs[i] = s[i] + 2.0 * Hs[i];
        }
        if (!this.regularize_bias) {
            int n = w_size - 1;
            Hs[n] = Hs[n] - s[w_size - 1];
        }
    }

    protected void subXTv(double[] v, double[] XTv) {
        int i;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            XTv[i] = 0.0;
        }
        for (i = 0; i < this.sizeI; ++i) {
            SparseOperator.axpy(v[i], x[this.I[i]], XTv);
        }
    }
}

