/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Linear;
import de.bwaldvogel.liblinear.SolverType;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;

public final class Model
implements Serializable {
    private static final long serialVersionUID = -6456047576741854834L;
    double bias;
    int[] label;
    int nr_class;
    int nr_feature;
    SolverType solverType;
    double[] w;
    double rho;

    public int getNrClass() {
        return this.nr_class;
    }

    public int getNrFeature() {
        return this.nr_feature;
    }

    public int[] getLabels() {
        return Arrays.copyOf(this.label, this.nr_class);
    }

    public SolverType getSolverType() {
        return this.solverType;
    }

    public double[] getFeatureWeights() {
        return Arrays.copyOf(this.w, this.w.length);
    }

    public boolean isProbabilityModel() {
        return this.solverType.isLogisticRegressionSolver();
    }

    public double getBias() {
        return this.bias;
    }

    private double get_w_value(int idx, int label_idx) {
        if (idx < 0 || idx > this.nr_feature) {
            return 0.0;
        }
        if (this.solverType.isSupportVectorRegression() || this.solverType.isOneClass()) {
            return this.w[idx];
        }
        if (label_idx < 0 || label_idx >= this.nr_class) {
            return 0.0;
        }
        if (this.nr_class == 2 && this.solverType != SolverType.MCSVM_CS) {
            if (label_idx == 0) {
                return this.w[idx];
            }
            return -this.w[idx];
        }
        return this.w[idx * this.nr_class + label_idx];
    }

    public double getDecfunCoef(int featIdx, int labelIdx) {
        if (featIdx > this.nr_feature) {
            return 0.0;
        }
        return this.get_w_value(featIdx - 1, labelIdx);
    }

    public double getDecfunBias(int labelIdx) {
        if (this.solverType.isOneClass()) {
            throw new IllegalArgumentException("Can not be called for a one-class SVM model");
        }
        int biasIdx = this.nr_feature;
        if (this.bias <= 0.0) {
            return 0.0;
        }
        return this.bias * this.get_w_value(biasIdx, labelIdx);
    }

    public double getDecfunRho() {
        if (!this.solverType.isOneClass()) {
            throw new IllegalArgumentException("Can be called only for a one-class SVM model");
        }
        return this.rho;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model");
        sb.append(" bias=").append(this.bias);
        sb.append(" nr_class=").append(this.nr_class);
        sb.append(" nr_feature=").append(this.nr_feature);
        sb.append(" solverType=").append((Object)this.solverType);
        return sb.toString();
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.getBias(), this.nr_class, this.nr_feature, this.getSolverType(), this.rho});
        result = 31 * result + Arrays.hashCode(this.label);
        result = 31 * result + Model.arrayHashCode(this.w);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model model = (Model)o;
        return Double.compare(model.getBias(), this.getBias()) == 0 && this.nr_class == model.nr_class && this.nr_feature == model.nr_feature && Double.compare(model.rho, this.rho) == 0 && Arrays.equals(this.label, model.label) && this.getSolverType() == model.getSolverType() && Model.arrayEquals(this.w, model.w);
    }

    private static boolean arrayEquals(double[] a, double[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static int arrayHashCode(double[] w) {
        if (w == null) {
            return 0;
        }
        int result = 1;
        for (double element : w) {
            if (element == -0.0) {
                element = 0.0;
            }
            long bits = Double.doubleToLongBits(element);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public void save(File modelFile) throws IOException {
        this.save(modelFile.toPath());
    }

    public void save(Path modelPath) throws IOException {
        Linear.saveModel(modelPath, this);
    }

    public void save(Writer writer) throws IOException {
        Linear.saveModel(writer, this);
    }

    public static Model load(File modelFile) throws IOException {
        return Model.load(modelFile.toPath());
    }

    public static Model load(Path modelPath) throws IOException {
        return Linear.loadModel(modelPath);
    }

    public static Model load(Reader inputReader) throws IOException {
        return Linear.loadModel(inputReader);
    }
}

