/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.SingleGraphAlg;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.TakesExternalGraph;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgorithmAnnotations;
import edu.cmu.tetrad.graph.Graph;

public class AlgorithmFactory {
    private AlgorithmFactory() {
    }

    public static Algorithm create(Class<? extends Algorithm> algoClass, IndependenceWrapper test, ScoreWrapper score) throws IllegalAccessException, InstantiationException {
        if (algoClass == null) {
            throw new IllegalArgumentException("Algorithm class cannot be null.");
        }
        AlgorithmAnnotations algoAnno = AlgorithmAnnotations.getInstance();
        boolean testRequired = algoAnno.requiresIndependenceTest(algoClass);
        if (testRequired && test == null) {
            throw new IllegalArgumentException("Test of independence is required.");
        }
        boolean scoreRequired = algoAnno.requiresScore(algoClass);
        if (scoreRequired && score == null) {
            throw new IllegalArgumentException("Score is required.");
        }
        Algorithm algorithm = algoClass.newInstance();
        if (testRequired) {
            ((TakesIndependenceWrapper)((Object)algorithm)).setIndependenceWrapper(test);
        }
        if (scoreRequired) {
            ((UsesScoreWrapper)((Object)algorithm)).setScoreWrapper(score);
        }
        return algorithm;
    }

    public static Algorithm create(Class<? extends Algorithm> algoClass, IndependenceWrapper test, ScoreWrapper score, Graph externalGraph) throws IllegalAccessException, InstantiationException {
        Algorithm algorithm = AlgorithmFactory.create(algoClass, test, score);
        if (externalGraph != null && algorithm instanceof TakesExternalGraph) {
            ((TakesExternalGraph)((Object)algorithm)).setExternalGraph(new SingleGraphAlg(externalGraph));
        }
        return algorithm;
    }

    public static Algorithm create(Class<? extends Algorithm> algoClass, Class<? extends IndependenceWrapper> indTestClass, Class<? extends ScoreWrapper> scoreClass) throws IllegalAccessException, InstantiationException {
        if (algoClass == null) {
            throw new IllegalArgumentException("Algorithm class cannot be null.");
        }
        IndependenceWrapper test = indTestClass == null ? null : indTestClass.newInstance();
        ScoreWrapper score = scoreClass == null ? null : scoreClass.newInstance();
        return AlgorithmFactory.create(algoClass, test, score);
    }

    public static Algorithm create(Class<? extends Algorithm> algoClass, Class<? extends IndependenceWrapper> indTestClass, Class<? extends ScoreWrapper> scoreClass, Graph externalGraph) throws IllegalAccessException, InstantiationException {
        Algorithm algorithm = AlgorithmFactory.create(algoClass, indTestClass, scoreClass);
        if (externalGraph != null && algorithm instanceof TakesExternalGraph) {
            ((TakesExternalGraph)((Object)algorithm)).setExternalGraph(new SingleGraphAlg(externalGraph));
        }
        return algorithm;
    }
}

