/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.cluster;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.cluster.ClusterAlgorithm;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ClusterSignificance;
import edu.cmu.tetrad.search.ClusterUtils;
import edu.cmu.tetrad.search.FindOneFactorClusters;
import edu.cmu.tetrad.search.Mimbuild;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@edu.cmu.tetrad.annotation.Algorithm(name="FOFC", command="fofc", algoType=AlgType.search_for_structure_over_latents)
@Bootstrapping
public class FOFC
implements Algorithm,
HasKnowledge,
ClusterAlgorithm {
    static final long serialVersionUID = 23L;
    private Knowledge knowledge = new Knowledge();

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            ICovarianceMatrix cov = SimpleDataLoader.getCovarianceMatrix(dataSet);
            double alpha = parameters.getDouble("alpha");
            boolean wishart = parameters.getBoolean("useWishart", true);
            TestType testType = wishart ? TestType.TETRAD_WISHART : TestType.TETRAD_DELTA;
            boolean gap = parameters.getBoolean("useGap", true);
            FindOneFactorClusters.Algorithm algorithm = gap ? FindOneFactorClusters.Algorithm.GAP : FindOneFactorClusters.Algorithm.SAG;
            FindOneFactorClusters search = new FindOneFactorClusters(cov, testType, algorithm, alpha);
            search.setSignificanceChecked(parameters.getBoolean("significanceChecked"));
            search.setVerbose(parameters.getBoolean("verbose"));
            if (parameters.getInt("checkType") == 1) {
                search.setCheckType(ClusterSignificance.CheckType.Significance);
            } else if (parameters.getInt("checkType") == 2) {
                search.setCheckType(ClusterSignificance.CheckType.Clique);
            } else if (parameters.getInt("checkType") == 3) {
                search.setCheckType(ClusterSignificance.CheckType.None);
            } else {
                throw new IllegalArgumentException("Unexpected check type");
            }
            Graph graph = search.search();
            if (!parameters.getBoolean("include_structure_model")) {
                return graph;
            }
            Clusters clusters = ClusterUtils.mimClusters(graph);
            Mimbuild mimbuild = new Mimbuild();
            mimbuild.setPenaltyDiscount(parameters.getDouble("penaltyDiscount"));
            mimbuild.setKnowledge((Knowledge)parameters.get("knowledge", new Knowledge()));
            if (parameters.getBoolean("includeThreeClusters", true)) {
                mimbuild.setMinClusterSize(3);
            } else {
                mimbuild.setMinClusterSize(4);
            }
            List<List<Node>> partition = ClusterUtils.clustersToPartition(clusters, dataSet.getVariables());
            ArrayList<String> latentNames = new ArrayList<String>();
            for (int i = 0; i < clusters.getNumClusters(); ++i) {
                latentNames.add(clusters.getClusterName(i));
            }
            Graph structureGraph = mimbuild.search(partition, latentNames, cov);
            LayoutUtil.circleLayout(structureGraph, 200, 200, 150);
            LayoutUtil.fruchtermanReingoldLayout(structureGraph);
            ICovarianceMatrix latentsCov = mimbuild.getLatentsCov();
            TetradLogger.getInstance().log("details", "Latent covs = \n" + latentsCov);
            Graph fullGraph = mimbuild.getFullGraph();
            LayoutUtil.circleLayout(fullGraph, 200, 200, 150);
            LayoutUtil.fruchtermanReingoldLayout(fullGraph);
            return fullGraph;
        }
        FOFC algorithm = new FOFC();
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.cpdagForDag(graph);
    }

    @Override
    public String getDescription() {
        return "FOFC (Find One Factor Clusters)";
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("alpha");
        parameters.add("penaltyDiscount");
        parameters.add("useWishart");
        parameters.add("significanceChecked");
        parameters.add("useGap");
        parameters.add("include_structure_model");
        parameters.add("checkType");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

