/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.external;

import edu.cmu.tetrad.algcomparison.algorithm.ExternalAlgorithm;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.data.reader.Delimiter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ExternalAlgorithmBNTPc
extends ExternalAlgorithm {
    static final long serialVersionUID = 23L;
    private final String extDir;
    private final String shortDescription;

    public ExternalAlgorithmBNTPc(String extDir) {
        this.extDir = extDir;
        this.shortDescription = new File(extDir).getName().replace("_", " ");
    }

    public ExternalAlgorithmBNTPc(String extDir, String shortDecription) {
        this.extDir = extDir;
        this.shortDescription = shortDecription;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        int index = this.getIndex(dataSet);
        File file = new File(this.path, "/results/" + this.extDir + "/" + (this.simIndex + 1) + "/graph." + index + ".txt");
        System.out.println(file.getAbsolutePath());
        try {
            DataSet dataSet2 = SimpleDataLoader.loadContinuousData(file, "//", '\"', "*", true, Delimiter.TAB);
            System.out.println("Loading graph from " + file.getAbsolutePath());
            Graph graph = GraphPersistence.loadGraphBNTPcMatrix(dataSet.getVariables(), dataSet2);
            LayoutUtil.circleLayout(graph, 225, 200, 150);
            return graph;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't parse graph.", e);
        }
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        if (this.shortDescription == null) {
            return "Load data from " + this.path + "/" + this.extDir;
        }
        return this.shortDescription;
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public long getElapsedTime(DataModel dataSet, Parameters parameters) {
        int index = this.getIndex(dataSet);
        File file = new File(this.path, "/elapsed/" + this.extDir + "/" + (this.simIndex + 1) + "/graph." + index + ".txt");
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            String l = r.readLine();
            return (long)Double.parseDouble(l);
        }
        catch (IOException e) {
            return -99L;
        }
    }
}

