/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.external;

import edu.cmu.tetrad.algcomparison.algorithm.ExternalAlgorithm;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ExternalAlgorithmBnlearnMmhc
extends ExternalAlgorithm {
    static final long serialVersionUID = 23L;
    private final String extDir;
    private final String shortDescription;

    public ExternalAlgorithmBnlearnMmhc(String extDir) {
        this.extDir = extDir;
        this.shortDescription = new File(extDir).getName().replace("_", " ");
    }

    public ExternalAlgorithmBnlearnMmhc(String extDir, String shortDecription) {
        this.extDir = extDir;
        this.shortDescription = shortDecription;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        int index = this.getIndex(dataSet);
        File file = new File(this.path, "/results/" + this.extDir + "/" + (this.simIndex + 1) + "/graph." + index + ".txt");
        System.out.println(file.getAbsolutePath());
        try {
            String line;
            BufferedReader r = new BufferedReader(new FileReader(file));
            r.readLine();
            EdgeListGraph graph = new EdgeListGraph();
            while ((line = r.readLine()) != null) {
                Node node2;
                Node node1;
                if (line.isEmpty()) continue;
                String[] tokens = line.split("\t");
                String name1 = tokens[0].replace(" ", "").replace("\"", "");
                String name2 = tokens[1].replace(" ", "").replace("\"", "");
                if (graph.getNode(name1) == null) {
                    graph.addNode(new GraphNode(name1));
                }
                if (graph.getNode(name2) == null) {
                    graph.addNode(new GraphNode(name2));
                }
                if (!graph.isAdjacentTo(node1 = graph.getNode(name1), node2 = graph.getNode(name2))) {
                    graph.addDirectedEdge(node1, node2);
                    continue;
                }
                graph.removeEdge(node1, node2);
                graph.addUndirectedEdge(node1, node2);
            }
            LayoutUtil.circleLayout(graph, 225, 200, 150);
            return graph;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't parse graph.");
        }
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        if (this.shortDescription == null) {
            return "Load data from " + this.path + "/" + this.extDir;
        }
        return this.shortDescription;
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public long getElapsedTime(DataModel dataSet, Parameters parameters) {
        int index = this.getIndex(dataSet);
        File file = new File(this.path, "/elapsed/" + this.extDir + "/" + (this.simIndex + 1) + "/graph." + index + ".txt");
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            String l = r.readLine();
            return Long.parseLong(l);
        }
        catch (IOException e) {
            return -99L;
        }
    }
}

