/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.external;

import edu.cmu.tetrad.algcomparison.algorithm.ExternalAlgorithm;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.Parameters;
import java.util.Set;

public class ExternalAlgorithmIntersection
extends ExternalAlgorithm {
    static final long serialVersionUID = 23L;
    private final ExternalAlgorithm[] algorithms;
    private final String shortDescription;
    private long elapsed = -99L;

    public ExternalAlgorithmIntersection(String shortDescription, ExternalAlgorithm ... algorithms) {
        this.algorithms = algorithms;
        this.shortDescription = shortDescription;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        this.elapsed = 0L;
        for (ExternalAlgorithm algorithm : this.algorithms) {
            algorithm.setPath(this.path);
            algorithm.setSimIndex(this.simIndex);
            algorithm.setSimulation(this.simulation);
            this.elapsed += algorithm.getElapsedTime(dataSet, parameters);
        }
        Graph graph0 = this.algorithms[0].search(dataSet, parameters);
        Set<Edge> edges = graph0.getEdges();
        for (int i = 1; i < this.algorithms.length; ++i) {
            edges.retainAll(this.algorithms[i].search(dataSet, parameters).getEdges());
        }
        EdgeListGraph intersection = new EdgeListGraph(graph0.getNodes());
        for (Edge edge : edges) {
            intersection.addEdge(edge);
        }
        return intersection;
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return this.algorithms[0].getComparisonGraph(graph);
    }

    @Override
    public String getDescription() {
        return this.shortDescription;
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public long getElapsedTime(DataModel dataSet, Parameters parameters) {
        return this.elapsed;
    }
}

