/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.mixed.cpdag;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Discretizer;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.List;

@Bootstrapping
public class MixedFgesDiscretingContinuousVariables
implements Algorithm {
    static final long serialVersionUID = 23L;
    private final ScoreWrapper score;

    public MixedFgesDiscretingContinuousVariables(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        if (parameters.getInt("numberResampling") < 1) {
            Discretizer discretizer = new Discretizer(SimpleDataLoader.getContinuousDataSet(dataSet));
            List<Node> nodes = dataSet.getVariables();
            for (Node node : nodes) {
                if (!(node instanceof ContinuousVariable)) continue;
                discretizer.equalIntervals(node, parameters.getInt("numCategories"));
            }
            dataSet = discretizer.discretize();
            DataSet _dataSet = SimpleDataLoader.getDiscreteDataSet(dataSet);
            Fges fges = new Fges(this.score.getScore(_dataSet, parameters));
            fges.setVerbose(parameters.getBoolean("verbose"));
            Graph p = fges.search();
            return this.convertBack(_dataSet, p);
        }
        MixedFgesDiscretingContinuousVariables algorithm = new MixedFgesDiscretingContinuousVariables(this.score);
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, algorithm, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return SearchGraphUtils.cpdagForDag(new EdgeListGraph(graph));
    }

    @Override
    public String getDescription() {
        return "FGES after discretizing the continuous variables in the data set using " + this.score.getDescription();
    }

    private Graph convertBack(DataSet Dk, Graph p) {
        EdgeListGraph p2 = new EdgeListGraph(Dk.getVariables());
        for (int i = 0; i < p.getNodes().size(); ++i) {
            for (int j = i + 1; j < p.getNodes().size(); ++j) {
                Node v2;
                Node v1 = p.getNodes().get(i);
                Edge e = p.getEdge(v1, v2 = p.getNodes().get(j));
                if (e == null) continue;
                Node w1 = Dk.getVariable(e.getNode1().getName());
                Node w2 = Dk.getVariable(e.getNode2().getName());
                Edge e2 = new Edge(w1, w2, e.getEndpoint1(), e.getEndpoint2());
                p2.addEdge(e2);
            }
        }
        return p2;
    }

    @Override
    public DataType getDataType() {
        return DataType.Mixed;
    }

    @Override
    public List<String> getParameters() {
        List<String> parameters = this.score.getParameters();
        parameters.add("numCategories");
        parameters.add("verbose");
        return parameters;
    }
}

