/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.algcomparison.algorithm.multi;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesExternalGraph;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.Bootstrapping;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fask;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.dbmi.algo.resampling.GeneralResamplingTest;
import java.util.ArrayList;
import java.util.List;

@Bootstrapping
@edu.cmu.tetrad.annotation.Algorithm(name="FASK", command="fask", algoType=AlgType.forbid_latent_common_causes, dataType={DataType.Continuous})
public class FASK
implements Algorithm,
HasKnowledge,
UsesScoreWrapper,
TakesIndependenceWrapper,
TakesExternalGraph {
    static final long serialVersionUID = 23L;
    private IndependenceWrapper test;
    private ScoreWrapper score;
    private Graph externalGraph;
    private Knowledge knowledge = new Knowledge();
    private Algorithm algorithm;

    public FASK() {
    }

    public FASK(IndependenceWrapper test, ScoreWrapper score) {
        this.test = test;
        this.score = score;
    }

    private Graph getGraph(Fask search) {
        return search.search();
    }

    @Override
    public Graph search(DataModel dataSet, Parameters parameters) {
        DataSet _data = (DataSet)dataSet;
        for (int j = 0; j < _data.getNumColumns(); ++j) {
            for (int i = 0; i < _data.getNumRows(); ++i) {
                if (!Double.isNaN(_data.getDouble(i, j))) continue;
                throw new IllegalArgumentException("Please remove or impute missing values.");
            }
        }
        if (parameters.getInt("numberResampling") < 1) {
            int lrRule;
            Fask search = new Fask((DataSet)dataSet, this.score.getScore(dataSet, parameters), this.test.getTest(dataSet, parameters));
            search.setDepth(parameters.getInt("depth"));
            search.setSkewEdgeThreshold(parameters.getDouble("skewEdgeThreshold"));
            search.setOrientationAlpha(parameters.getDouble("orientationAlpha"));
            search.setTwoCycleScreeningCutoff(parameters.getDouble("twoCycleScreeningThreshold"));
            search.setDelta(parameters.getDouble("faskDelta"));
            search.setEmpirical(!parameters.getBoolean("faskNonempirical"));
            if (this.externalGraph != null) {
                this.externalGraph = this.algorithm.search(dataSet, parameters);
            }
            if (this.externalGraph != null) {
                search.setExternalGraph(this.externalGraph);
            }
            if ((lrRule = parameters.getInt("faskLeftRightRule")) == 1) {
                search.setLeftRight(Fask.LeftRight.FASK1);
            } else if (lrRule == 2) {
                search.setLeftRight(Fask.LeftRight.FASK2);
            } else if (lrRule == 3) {
                search.setLeftRight(Fask.LeftRight.RSKEW);
            } else if (lrRule == 4) {
                search.setLeftRight(Fask.LeftRight.SKEW);
            } else if (lrRule == 5) {
                search.setLeftRight(Fask.LeftRight.TANH);
            } else {
                throw new IllegalStateException("Unconfigured left right rule index: " + lrRule);
            }
            int adjacencyMethod = parameters.getInt("faskAdjacencyMethod");
            if (adjacencyMethod == 1) {
                search.setAdjacencyMethod(Fask.AdjacencyMethod.FAS_STABLE);
            } else if (adjacencyMethod == 2) {
                search.setAdjacencyMethod(Fask.AdjacencyMethod.FGES);
            } else if (adjacencyMethod == 3) {
                search.setAdjacencyMethod(Fask.AdjacencyMethod.EXTERNAL_GRAPH);
            } else if (adjacencyMethod == 4) {
                search.setAdjacencyMethod(Fask.AdjacencyMethod.NONE);
            } else {
                throw new IllegalStateException("Unconfigured left right rule index: " + lrRule);
            }
            search.setKnowledge(this.knowledge);
            return this.getGraph(search);
        }
        FASK fask = new FASK(this.test, this.score);
        DataSet data = (DataSet)dataSet;
        GeneralResamplingTest search = new GeneralResamplingTest(data, fask, parameters.getInt("numberResampling"), parameters.getDouble("percentResampleSize"), parameters.getBoolean("resamplingWithReplacement"), parameters.getInt("resamplingEnsemble"), parameters.getBoolean("addOriginalDataset"));
        search.setKnowledge(this.knowledge);
        search.setParameters(parameters);
        search.setVerbose(parameters.getBoolean("verbose"));
        return search.search();
    }

    @Override
    public Graph getComparisonGraph(Graph graph) {
        return new EdgeListGraph(graph);
    }

    @Override
    public String getDescription() {
        if (this.test != null) {
            return "FASK using " + this.test.getDescription();
        }
        if (this.algorithm != null) {
            return "FASK using " + this.algorithm.getDescription();
        }
        throw new IllegalStateException("Need to initialize with either a test or an algorithm.");
    }

    @Override
    public DataType getDataType() {
        return DataType.Continuous;
    }

    @Override
    public List<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.algorithm != null) {
            parameters.addAll(this.algorithm.getParameters());
        }
        parameters.add("depth");
        parameters.add("skewEdgeThreshold");
        parameters.add("twoCycleScreeningThreshold");
        parameters.add("orientationAlpha");
        parameters.add("faskDelta");
        parameters.add("faskLeftRightRule");
        parameters.add("faskAdjacencyMethod");
        parameters.add("faskNonempirical");
        parameters.add("verbose");
        return parameters;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public void setIndependenceWrapper(IndependenceWrapper independenceWrapper) {
        this.test = independenceWrapper;
    }

    @Override
    public IndependenceWrapper getIndependenceWrapper() {
        return this.test;
    }

    @Override
    public void setExternalGraph(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void setScoreWrapper(ScoreWrapper score) {
        this.score = score;
    }

    @Override
    public ScoreWrapper getScoreWrapper() {
        return this.score;
    }
}

